/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.config;

import java.util.Arrays;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.optifine.util.StrUtils;
import org.apache.commons.lang3.StringEscapeUtils;

public class NbtTagValue {
    private String[] parents = null;
    private String name = null;
    private boolean negative = false;
    private int type = 0;
    private String value = null;
    private int valueFormat = 0;
    private static final int TYPE_TEXT = 0;
    private static final int TYPE_PATTERN = 1;
    private static final int TYPE_IPATTERN = 2;
    private static final int TYPE_REGEX = 3;
    private static final int TYPE_IREGEX = 4;
    private static final String PREFIX_PATTERN = "pattern:";
    private static final String PREFIX_IPATTERN = "ipattern:";
    private static final String PREFIX_REGEX = "regex:";
    private static final String PREFIX_IREGEX = "iregex:";
    private static final int FORMAT_DEFAULT = 0;
    private static final int FORMAT_HEX_COLOR = 1;
    private static final String PREFIX_HEX_COLOR = "#";
    private static final Pattern PATTERN_HEX_COLOR = Pattern.compile("^#[0-9a-f]{6}+$");
    private static final Pattern PATTERN_NBT_TEXT = Pattern.compile(".*\"text\":\"([^\"]+)\".*");

    public NbtTagValue(String tag, String value) {
        String[] names = Config.tokenize(tag, ".");
        this.parents = Arrays.copyOfRange(names, 0, names.length - 1);
        this.name = names[names.length - 1];
        if (value.startsWith("!")) {
            this.negative = true;
            value = value.substring(1);
        }
        if (value.startsWith(PREFIX_PATTERN)) {
            this.type = 1;
            value = value.substring(PREFIX_PATTERN.length());
        } else if (value.startsWith(PREFIX_IPATTERN)) {
            this.type = 2;
            value = value.substring(PREFIX_IPATTERN.length()).toLowerCase();
        } else if (value.startsWith(PREFIX_REGEX)) {
            this.type = 3;
            value = value.substring(PREFIX_REGEX.length());
        } else if (value.startsWith(PREFIX_IREGEX)) {
            this.type = 4;
            value = value.substring(PREFIX_IREGEX.length()).toLowerCase();
        } else {
            this.type = 0;
        }
        value = StringEscapeUtils.unescapeJava((String)value);
        if (this.type == 0 && PATTERN_HEX_COLOR.matcher(value).matches()) {
            this.valueFormat = 1;
        }
        this.value = value;
    }

    public boolean matches(gy nbt) {
        if (this.negative) {
            return !this.matchesCompound(nbt);
        }
        return this.matchesCompound(nbt);
    }

    public boolean matchesCompound(gy nbt) {
        if (nbt == null) {
            return false;
        }
        gy tagBase = nbt;
        for (int i2 = 0; i2 < this.parents.length; ++i2) {
            String tag = this.parents[i2];
            if ((tagBase = NbtTagValue.getChildTag((ho)tagBase, tag)) != null) continue;
            return false;
        }
        if (this.name.equals("*")) {
            return this.matchesAnyChild((ho)tagBase);
        }
        if ((tagBase = NbtTagValue.getChildTag((ho)tagBase, this.name)) == null) {
            return false;
        }
        return this.matchesBase((ho)tagBase);
    }

    private boolean matchesAnyChild(ho tagBase) {
        if (tagBase instanceof gy) {
            gy tagCompound = (gy)tagBase;
            Set nbtKeySet = tagCompound.c();
            for (String key : nbtKeySet) {
                ho nbtBase = tagCompound.c(key);
                if (!this.matchesBase(nbtBase)) continue;
                return true;
            }
        }
        if (tagBase instanceof he) {
            he tagList = (he)tagBase;
            int count = tagList.size();
            for (int i2 = 0; i2 < count; ++i2) {
                ho nbtBase = tagList.d(i2);
                if (!this.matchesBase(nbtBase)) continue;
                return true;
            }
        }
        return false;
    }

    private static ho getChildTag(ho tagBase, String tag) {
        if (tagBase instanceof gy) {
            gy tagCompound = (gy)tagBase;
            return tagCompound.c(tag);
        }
        if (tagBase instanceof he) {
            he tagList = (he)tagBase;
            if (tag.equals("count")) {
                return new hd(tagList.size());
            }
            int index = Config.parseInt(tag, -1);
            if (index < 0) {
                return null;
            }
            return tagList.d(index);
        }
        return null;
    }

    public boolean matchesBase(ho nbtBase) {
        if (nbtBase == null) {
            return false;
        }
        String nbtValue = NbtTagValue.getNbtString(nbtBase, this.valueFormat);
        return this.matchesValue(nbtValue);
    }

    public boolean matchesValue(String nbtValue) {
        if (nbtValue == null) {
            return false;
        }
        switch (this.type) {
            case 0: {
                return nbtValue.equals(this.value);
            }
            case 1: {
                return this.matchesPattern(nbtValue, this.value);
            }
            case 2: {
                return this.matchesPattern(nbtValue.toLowerCase(), this.value);
            }
            case 3: {
                return this.matchesRegex(nbtValue, this.value);
            }
            case 4: {
                return this.matchesRegex(nbtValue.toLowerCase(), this.value);
            }
        }
        throw new IllegalArgumentException("Unknown NbtTagValue type: " + this.type);
    }

    private boolean matchesPattern(String str, String pattern) {
        return StrUtils.equalsMask(str, pattern, '*', '?');
    }

    private boolean matchesRegex(String str, String regex) {
        return str.matches(regex);
    }

    private static String getNbtString(ho nbtBase, int format) {
        if (nbtBase == null) {
            return null;
        }
        if (nbtBase instanceof hn) {
            Matcher matcher;
            hn nbtString = (hn)nbtBase;
            String text = nbtString.b_();
            if (text.startsWith("{") && (matcher = PATTERN_NBT_TEXT.matcher(text)).matches()) {
                return matcher.group(1);
            }
            return text;
        }
        if (nbtBase instanceof hd) {
            hd i2 = (hd)nbtBase;
            if (format == 1) {
                return PREFIX_HEX_COLOR + StrUtils.fillLeft(Integer.toHexString(i2.e()), 6, '0');
            }
            return Integer.toString(i2.e());
        }
        if (nbtBase instanceof gw) {
            gw b2 = (gw)nbtBase;
            return Byte.toString(b2.g());
        }
        if (nbtBase instanceof hm) {
            hm s2 = (hm)nbtBase;
            return Short.toString(s2.f());
        }
        if (nbtBase instanceof hg) {
            hg l2 = (hg)nbtBase;
            return Long.toString(l2.d());
        }
        if (nbtBase instanceof hb) {
            hb f2 = (hb)nbtBase;
            return Float.toString(f2.i());
        }
        if (nbtBase instanceof gz) {
            gz d2 = (gz)nbtBase;
            return Double.toString(d2.h());
        }
        return nbtBase.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < this.parents.length; ++i2) {
            String parent = this.parents[i2];
            if (i2 > 0) {
                sb.append(".");
            }
            sb.append(parent);
        }
        if (sb.length() > 0) {
            sb.append(".");
        }
        sb.append(this.name);
        sb.append(" = ");
        sb.append(this.value);
        return sb.toString();
    }
}

