/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.function.LongSupplier;

public class NativeMemory {
    private static long imageAllocated = 0L;
    private static LongSupplier bufferAllocatedSupplier = NativeMemory.makeLongSupplier(new String[][]{{"sun.misc.SharedSecrets", "getJavaNioAccess", "getDirectBufferPool", "getMemoryUsed"}, {"jdk.internal.misc.SharedSecrets", "getJavaNioAccess", "getDirectBufferPool", "getMemoryUsed"}});
    private static LongSupplier bufferMaximumSupplier = NativeMemory.makeLongSupplier(new String[][]{{"sun.misc.VM", "maxDirectMemory"}, {"jdk.internal.misc.VM", "maxDirectMemory"}});

    public static long getBufferAllocated() {
        if (bufferAllocatedSupplier == null) {
            return -1L;
        }
        return bufferAllocatedSupplier.getAsLong();
    }

    public static long getBufferMaximum() {
        if (bufferMaximumSupplier == null) {
            return -1L;
        }
        return bufferMaximumSupplier.getAsLong();
    }

    public static void imageAllocated(ddg nativeImage) {
        imageAllocated += (long)nativeImage.getSize();
    }

    public static void imageFreed(ddg nativeImage) {
        imageAllocated -= (long)nativeImage.getSize();
    }

    public static long getImageAllocated() {
        return imageAllocated;
    }

    private static LongSupplier makeLongSupplier(String[][] paths) {
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        for (int i2 = 0; i2 < paths.length; ++i2) {
            String[] path = paths[i2];
            try {
                LongSupplier supplier = NativeMemory.makeLongSupplier(path);
                return supplier;
            }
            catch (Throwable e2) {
                exceptions.add(e2);
                continue;
            }
        }
        for (Throwable t2 : exceptions) {
            Config.warn("" + t2.getClass().getName() + ": " + t2.getMessage());
        }
        return null;
    }

    private static LongSupplier makeLongSupplier(String[] path) throws Exception {
        if (path.length < 2) {
            return null;
        }
        Class<?> cls2 = Class.forName(path[0]);
        Method method = cls2.getMethod(path[1], new Class[0]);
        method.setAccessible(true);
        Object object = null;
        for (int i2 = 2; i2 < path.length; ++i2) {
            String name = path[i2];
            object = method.invoke(object, new Object[0]);
            method = object.getClass().getMethod(name, new Class[0]);
            method.setAccessible(true);
        }
        final Object objectF = object;
        final Method methodF = method;
        LongSupplier ls = new LongSupplier(){
            private boolean disabled = false;

            @Override
            public long getAsLong() {
                if (this.disabled) {
                    return -1L;
                }
                try {
                    return (Long)methodF.invoke(objectF, new Object[0]);
                }
                catch (Throwable e2) {
                    Config.warn("" + e2.getClass().getName() + ": " + e2.getMessage());
                    this.disabled = true;
                    return -1L;
                }
            }
        };
        return ls;
    }
}

