/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.IntBuffer;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.optifine.BetterGrass;
import net.optifine.BetterSnow;
import net.optifine.CustomBlockLayers;
import net.optifine.CustomColors;
import net.optifine.CustomGuis;
import net.optifine.CustomItems;
import net.optifine.CustomLoadingScreens;
import net.optifine.CustomPanorama;
import net.optifine.CustomSky;
import net.optifine.Lang;
import net.optifine.NaturalTextures;
import net.optifine.RandomEntities;
import net.optifine.SmartLeaves;
import net.optifine.TextureAnimations;
import net.optifine.entity.model.CustomEntityModels;
import net.optifine.shaders.MultiTexID;
import net.optifine.shaders.Shaders;
import org.apache.commons.io.IOUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;

public class TextureUtils {
    public static final String texGrassTop = "grass_top";
    public static final String texStone = "stone";
    public static final String texDirt = "dirt";
    public static final String texCoarseDirt = "coarse_dirt";
    public static final String texGrassSide = "grass_side";
    public static final String texStoneslabSide = "stone_slab_side";
    public static final String texStoneslabTop = "stone_slab_top";
    public static final String texBedrock = "bedrock";
    public static final String texSand = "sand";
    public static final String texGravel = "gravel";
    public static final String texLogOak = "log_oak";
    public static final String texLogBigOak = "log_big_oak";
    public static final String texLogAcacia = "log_acacia";
    public static final String texLogSpruce = "log_spruce";
    public static final String texLogBirch = "log_birch";
    public static final String texLogJungle = "log_jungle";
    public static final String texLogOakTop = "log_oak_top";
    public static final String texLogBigOakTop = "log_big_oak_top";
    public static final String texLogAcaciaTop = "log_acacia_top";
    public static final String texLogSpruceTop = "log_spruce_top";
    public static final String texLogBirchTop = "log_birch_top";
    public static final String texLogJungleTop = "log_jungle_top";
    public static final String texLeavesOak = "leaves_oak";
    public static final String texLeavesBigOak = "leaves_big_oak";
    public static final String texLeavesAcacia = "leaves_acacia";
    public static final String texLeavesBirch = "leaves_birch";
    public static final String texLeavesSpuce = "leaves_spruce";
    public static final String texLeavesJungle = "leaves_jungle";
    public static final String texGoldOre = "gold_ore";
    public static final String texIronOre = "iron_ore";
    public static final String texCoalOre = "coal_ore";
    public static final String texObsidian = "obsidian";
    public static final String texGrassSideOverlay = "grass_side_overlay";
    public static final String texSnow = "snow";
    public static final String texGrassSideSnowed = "grass_side_snowed";
    public static final String texMyceliumSide = "mycelium_side";
    public static final String texMyceliumTop = "mycelium_top";
    public static final String texDiamondOre = "diamond_ore";
    public static final String texRedstoneOre = "redstone_ore";
    public static final String texLapisOre = "lapis_ore";
    public static final String texCactusSide = "cactus_side";
    public static final String texClay = "clay";
    public static final String texFarmlandWet = "farmland_wet";
    public static final String texFarmlandDry = "farmland_dry";
    public static final String texNetherrack = "netherrack";
    public static final String texSoulSand = "soul_sand";
    public static final String texGlowstone = "glowstone";
    public static final String texLeavesSpruce = "leaves_spruce";
    public static final String texLeavesSpruceOpaque = "leaves_spruce_opaque";
    public static final String texEndStone = "end_stone";
    public static final String texSandstoneTop = "sandstone_top";
    public static final String texSandstoneBottom = "sandstone_bottom";
    public static final String texRedstoneLampOff = "redstone_lamp_off";
    public static final String texRedstoneLampOn = "redstone_lamp_on";
    public static final String texWaterStill = "water_still";
    public static final String texWaterFlow = "water_flow";
    public static final String texLavaStill = "lava_still";
    public static final String texLavaFlow = "lava_flow";
    public static final String texFireLayer0 = "fire_0";
    public static final String texFireLayer1 = "fire_1";
    public static final String texPortal = "portal";
    public static final String texGlass = "glass";
    public static final String texGlassPaneTop = "glass_pane_top";
    public static final String texCompass = "compass";
    public static final String texClock = "clock";
    public static ddm iconGrassTop;
    public static ddm iconGrassSide;
    public static ddm iconGrassSideOverlay;
    public static ddm iconSnow;
    public static ddm iconGrassSideSnowed;
    public static ddm iconMyceliumSide;
    public static ddm iconMyceliumTop;
    public static ddm iconWaterStill;
    public static ddm iconWaterFlow;
    public static ddm iconLavaStill;
    public static ddm iconLavaFlow;
    public static ddm iconPortal;
    public static ddm iconFireLayer0;
    public static ddm iconFireLayer1;
    public static ddm iconGlass;
    public static ddm iconGlassPaneTop;
    public static ddm iconCompass;
    public static ddm iconClock;
    public static final String SPRITE_PREFIX_BLOCKS = "minecraft:block/";
    public static final String SPRITE_PREFIX_ITEMS = "minecraft:item/";
    private static IntBuffer staticBuffer;
    private static int glMaximumTextureSize;

    public static void update() {
        ddl mapBlocks = TextureUtils.getTextureMapBlocks();
        if (mapBlocks == null) {
            return;
        }
        String prefix = SPRITE_PREFIX_BLOCKS;
        iconGrassTop = mapBlocks.getSpriteSafe(prefix + texGrassTop);
        iconGrassSide = mapBlocks.getSpriteSafe(prefix + texGrassSide);
        iconGrassSideOverlay = mapBlocks.getSpriteSafe(prefix + texGrassSideOverlay);
        iconSnow = mapBlocks.getSpriteSafe(prefix + texSnow);
        iconGrassSideSnowed = mapBlocks.getSpriteSafe(prefix + texGrassSideSnowed);
        iconMyceliumSide = mapBlocks.getSpriteSafe(prefix + texMyceliumSide);
        iconMyceliumTop = mapBlocks.getSpriteSafe(prefix + texMyceliumTop);
        iconWaterStill = mapBlocks.getSpriteSafe(prefix + texWaterStill);
        iconWaterFlow = mapBlocks.getSpriteSafe(prefix + texWaterFlow);
        iconLavaStill = mapBlocks.getSpriteSafe(prefix + texLavaStill);
        iconLavaFlow = mapBlocks.getSpriteSafe(prefix + texLavaFlow);
        iconFireLayer0 = mapBlocks.getSpriteSafe(prefix + texFireLayer0);
        iconFireLayer1 = mapBlocks.getSpriteSafe(prefix + texFireLayer1);
        iconPortal = mapBlocks.getSpriteSafe(prefix + texPortal);
        iconGlass = mapBlocks.getSpriteSafe(prefix + texGlass);
        iconGlassPaneTop = mapBlocks.getSpriteSafe(prefix + texGlassPaneTop);
        String prefixItems = SPRITE_PREFIX_ITEMS;
        iconCompass = mapBlocks.getSpriteSafe(prefixItems + texCompass);
        iconClock = mapBlocks.getSpriteSafe(prefixItems + texClock);
    }

    public static BufferedImage fixTextureDimensions(String name, BufferedImage bi) {
        int height;
        int width;
        if ((name.startsWith("/mob/zombie") || name.startsWith("/mob/pigzombie")) && (width = bi.getWidth()) == (height = bi.getHeight()) * 2) {
            BufferedImage scaledImage = new BufferedImage(width, height * 2, 2);
            Graphics2D gr = scaledImage.createGraphics();
            gr.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            gr.drawImage(bi, 0, 0, width, height, null);
            return scaledImage;
        }
        return bi;
    }

    public static int ceilPowerOfTwo(int val) {
        int i2;
        for (i2 = 1; i2 < val; i2 *= 2) {
        }
        return i2;
    }

    public static int getPowerOfTwo(int val) {
        int i2 = 1;
        int po2 = 0;
        while (i2 < val) {
            i2 *= 2;
            ++po2;
        }
        return po2;
    }

    public static int twoToPower(int power) {
        int val = 1;
        for (int i2 = 0; i2 < power; ++i2) {
            val *= 2;
        }
        return val;
    }

    public static ddo getTexture(pc loc) {
        ddo tex = Config.getTextureManager().b(loc);
        if (tex != null) {
            return tex;
        }
        if (!Config.hasResource(loc)) {
            return null;
        }
        tex = new ddi(loc);
        Config.getTextureManager().a(loc, tex);
        return tex;
    }

    public static void resourcesReloaded(vf rm) {
        if (TextureUtils.getTextureMapBlocks() == null) {
            return;
        }
        Config.dbg("*** Reloading custom textures ***");
        CustomSky.reset();
        TextureAnimations.reset();
        TextureUtils.update();
        NaturalTextures.update();
        BetterGrass.update();
        BetterSnow.update();
        TextureAnimations.update();
        CustomColors.update();
        CustomSky.update();
        RandomEntities.update();
        CustomItems.updateModels();
        CustomEntityModels.update();
        Shaders.resourcesReloaded();
        Lang.resourcesReloaded();
        Config.updateTexturePackClouds();
        SmartLeaves.updateLeavesModels();
        CustomPanorama.update();
        CustomGuis.update();
        dbx.update();
        CustomLoadingScreens.update();
        CustomBlockLayers.update();
        Config.getTextureManager().e();
    }

    public static ddl getTextureMapBlocks() {
        return cft.s().K();
    }

    public static void registerResourceListener() {
        vf rm = Config.getResourceManager();
        if (rm instanceof vd) {
            vd rrm = (vd)rm;
            vg rl = new vg(){

                public void a(vf var1) {
                    TextureUtils.resourcesReloaded(var1);
                }
            };
            rrm.a(rl);
        }
        ddr tto = new ddr(){

            public void e() {
                TextureAnimations.updateAnimations();
            }

            public void a(vf var1) throws IOException {
            }

            public int c() {
                return 0;
            }

            public void b(boolean p_174936_1, boolean p_174936_2) {
            }

            public void b() {
            }

            public MultiTexID getMultiTexID() {
                return null;
            }
        };
        pc ttol = new pc("optifine/tickable_textures");
        Config.getTextureManager().a(ttol, tto);
    }

    public static pc fixResourceLocation(pc loc, String basePath) {
        if (!loc.b().equals("minecraft")) {
            return loc;
        }
        String path = loc.a();
        String pathFixed = TextureUtils.fixResourcePath(path, basePath);
        if (pathFixed != path) {
            loc = new pc(loc.b(), pathFixed);
        }
        return loc;
    }

    public static String fixResourcePath(String path, String basePath) {
        String strAssMc = "assets/minecraft/";
        if (path.startsWith(strAssMc)) {
            path = path.substring(strAssMc.length());
            return path;
        }
        if (path.startsWith("./")) {
            path = path.substring(2);
            if (!basePath.endsWith("/")) {
                basePath = basePath + "/";
            }
            path = basePath + path;
            return path;
        }
        if (path.startsWith("/~")) {
            path = path.substring(1);
        }
        String strOptifine = "optifine/";
        if (path.startsWith("~/")) {
            path = path.substring(2);
            path = strOptifine + path;
            return path;
        }
        if (path.startsWith("/")) {
            path = strOptifine + path.substring(1);
            return path;
        }
        return path;
    }

    public static String getBasePath(String path) {
        int pos = path.lastIndexOf(47);
        if (pos < 0) {
            return "";
        }
        return path.substring(0, pos);
    }

    public static void applyAnisotropicLevel() {
        if (GL.getCapabilities().GL_EXT_texture_filter_anisotropic) {
            float maxLevel = GL11.glGetFloat((int)34047);
            float level = Config.getAnisotropicFilterLevel();
            level = Math.min(level, maxLevel);
            GL11.glTexParameterf((int)3553, (int)34046, (float)level);
        }
    }

    public static void bindTexture(int glTexId) {
        cua.i(glTexId);
    }

    public static boolean isPowerOfTwo(int x2) {
        int x22 = xq.c(x2);
        return x22 == x2;
    }

    public static ddg scaleImage(ddg ni, int w2) {
        BufferedImage bi = TextureUtils.toBufferedImage(ni);
        BufferedImage bi2 = TextureUtils.scaleImage(bi, w2);
        ddg ni2 = TextureUtils.toNativeImage(bi2);
        return ni2;
    }

    public static BufferedImage toBufferedImage(ddg ni) {
        int width = ni.a();
        int height = ni.b();
        int[] data = new int[width * height];
        ni.getBufferRGBA().get(data);
        BufferedImage bi = new BufferedImage(width, height, 2);
        bi.setRGB(0, 0, width, height, data, 0, width);
        return bi;
    }

    private static ddg toNativeImage(BufferedImage bi) {
        int width = bi.getWidth();
        int height = bi.getHeight();
        int[] data = new int[width * height];
        bi.getRGB(0, 0, width, height, data, 0, width);
        ddg ni = new ddg(width, height, false);
        ni.getBufferRGBA().put(data);
        return ni;
    }

    public static BufferedImage scaleImage(BufferedImage bi, int w2) {
        int w3 = bi.getWidth();
        int h2 = bi.getHeight();
        int h22 = h2 * w2 / w3;
        BufferedImage bi2 = new BufferedImage(w2, h22, 2);
        Graphics2D g2 = bi2.createGraphics();
        Object method = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
        if (w2 < w3 || w2 % w3 != 0) {
            method = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
        }
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, method);
        g2.drawImage(bi, 0, 0, w2, h22, null);
        return bi2;
    }

    public static int scaleToGrid(int size, int sizeGrid) {
        int sizeNew;
        if (size == sizeGrid) {
            return size;
        }
        for (sizeNew = size / sizeGrid * sizeGrid; sizeNew < size; sizeNew += sizeGrid) {
        }
        return sizeNew;
    }

    public static int scaleToMin(int size, int sizeMin) {
        int sizeNew;
        if (size >= sizeMin) {
            return size;
        }
        for (sizeNew = sizeMin / size * size; sizeNew < sizeMin; sizeNew += size) {
        }
        return sizeNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dimension getImageSize(InputStream in, String suffix) {
        Iterator<ImageReader> iter = ImageIO.getImageReadersBySuffix(suffix);
        while (iter.hasNext()) {
            ImageReader reader = iter.next();
            try {
                ImageInputStream iis = ImageIO.createImageInputStream(in);
                reader.setInput(iis);
                int width = reader.getWidth(reader.getMinIndex());
                int height = reader.getHeight(reader.getMinIndex());
                Dimension dimension = new Dimension(width, height);
                return dimension;
            }
            catch (IOException e2) {}
            continue;
            finally {
                reader.dispose();
            }
        }
        return null;
    }

    public static void dbgMipmaps(ddm textureatlassprite) {
        ddg[] mipmapImages = textureatlassprite.getMipmapImages();
        for (int l2 = 0; l2 < mipmapImages.length; ++l2) {
            ddg image = mipmapImages[l2];
            if (image == null) {
                Config.dbg("" + l2 + ": " + image);
                continue;
            }
            Config.dbg("" + l2 + ": " + image.a() * image.b());
        }
    }

    public static void saveGlTexture(String name, int textureId, int mipmapLevels, int width, int height) {
        File filePng;
        TextureUtils.bindTexture(textureId);
        GL11.glPixelStorei((int)3333, (int)1);
        GL11.glPixelStorei((int)3317, (int)1);
        File fileBase = new File(name);
        File dir = fileBase.getParentFile();
        if (dir != null) {
            dir.mkdirs();
        }
        for (int i2 = 0; i2 < 16; ++i2) {
            filePng = new File(name + "_" + i2 + ".png");
            filePng.delete();
        }
        for (int level = 0; level <= mipmapLevels; ++level) {
            filePng = new File(name + "_" + level + ".png");
            int widthLevel = width >> level;
            int heightLevel = height >> level;
            int sizeLevel = widthLevel * heightLevel;
            IntBuffer buf = BufferUtils.createIntBuffer((int)sizeLevel);
            int[] data = new int[sizeLevel];
            GL11.glGetTexImage((int)3553, (int)level, (int)32993, (int)33639, (IntBuffer)buf);
            buf.get(data);
            BufferedImage image = new BufferedImage(widthLevel, heightLevel, 2);
            image.setRGB(0, 0, widthLevel, heightLevel, data, 0, widthLevel);
            try {
                ImageIO.write((RenderedImage)image, "png", filePng);
                Config.dbg("Exported: " + filePng);
                continue;
            }
            catch (Exception e2) {
                Config.warn("Error writing: " + filePng);
                Config.warn("" + e2.getClass().getName() + ": " + e2.getMessage());
            }
        }
    }

    public static int getGLMaximumTextureSize() {
        if (glMaximumTextureSize < 0) {
            glMaximumTextureSize = TextureUtils.detectGLMaximumTextureSize();
        }
        return glMaximumTextureSize;
    }

    private static int detectGLMaximumTextureSize() {
        for (int i2 = 65536; i2 > 0; i2 >>= 1) {
            cua.a(32868, 0, 6408, i2, i2, 0, 6408, 5121, null);
            int err = GL11.glGetError();
            int width = cua.c(32868, 0, 4096);
            if (width == 0) continue;
            return i2;
        }
        return 0;
    }

    public static BufferedImage readBufferedImage(InputStream imageStream) throws IOException {
        if (imageStream == null) {
            return null;
        }
        try {
            BufferedImage bufferedimage;
            BufferedImage bufferedImage = bufferedimage = ImageIO.read(imageStream);
            return bufferedImage;
        }
        finally {
            IOUtils.closeQuietly((InputStream)imageStream);
        }
    }

    public static int toAbgr(int argb) {
        int a2 = argb >> 24 & 0xFF;
        int r2 = argb >> 16 & 0xFF;
        int g2 = argb >> 8 & 0xFF;
        int b2 = argb >> 0 & 0xFF;
        int abgr = a2 << 24 | b2 << 16 | g2 << 8 | r2;
        return abgr;
    }

    public static void resetDataUnpacking() {
        cua.g(3314, 0);
        cua.g(3316, 0);
        cua.g(3315, 0);
        cua.g(3317, 4);
    }

    static {
        staticBuffer = Config.createDirectIntBuffer(256);
        glMaximumTextureSize = -1;
    }
}

