/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class POINTL
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;

    POINTL(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public POINTL(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), POINTL.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="LONG")
    public int x() {
        return POINTL.nx(this.address());
    }

    @NativeType(value="LONG")
    public int y() {
        return POINTL.ny(this.address());
    }

    public POINTL x(@NativeType(value="LONG") int value) {
        POINTL.nx(this.address(), value);
        return this;
    }

    public POINTL y(@NativeType(value="LONG") int value) {
        POINTL.ny(this.address(), value);
        return this;
    }

    public POINTL set(int x, int y) {
        this.x(x);
        this.y(y);
        return this;
    }

    public POINTL set(POINTL src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static POINTL malloc() {
        return POINTL.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static POINTL calloc() {
        return POINTL.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static POINTL create() {
        return new POINTL(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static POINTL create(long address) {
        return new POINTL(address, null);
    }

    @Nullable
    public static POINTL createSafe(long address) {
        return address == 0L ? null : POINTL.create(address);
    }

    public static Buffer malloc(int capacity) {
        return POINTL.create(POINTL.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return POINTL.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(POINTL.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : POINTL.create(address, capacity);
    }

    public static POINTL mallocStack() {
        return POINTL.mallocStack(MemoryStack.stackGet());
    }

    public static POINTL callocStack() {
        return POINTL.callocStack(MemoryStack.stackGet());
    }

    public static POINTL mallocStack(MemoryStack stack) {
        return POINTL.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static POINTL callocStack(MemoryStack stack) {
        return POINTL.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return POINTL.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return POINTL.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return POINTL.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return POINTL.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nx(long struct) {
        return MemoryUtil.memGetInt(struct + (long)X);
    }

    public static int ny(long struct) {
        return MemoryUtil.memGetInt(struct + (long)Y);
    }

    public static void nx(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)X, value);
    }

    public static void ny(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)Y, value);
    }

    static {
        Struct.Layout layout = POINTL.__struct(POINTL.__member(4), POINTL.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<POINTL, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected POINTL newInstance(long address) {
            return new POINTL(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="LONG")
        public int x() {
            return POINTL.nx(this.address());
        }

        @NativeType(value="LONG")
        public int y() {
            return POINTL.ny(this.address());
        }

        public Buffer x(@NativeType(value="LONG") int value) {
            POINTL.nx(this.address(), value);
            return this;
        }

        public Buffer y(@NativeType(value="LONG") int value) {
            POINTL.ny(this.address(), value);
            return this;
        }
    }
}

