/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.datafixers.types;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.Type;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public interface DynamicOps<T> {
    public T empty();

    default public T emptyMap() {
        return this.createMap((Map<T, T>)ImmutableMap.of());
    }

    default public T emptyList() {
        return this.createList(Stream.empty());
    }

    public Type<?> getType(T var1);

    default public <R> Optional<R> cast(T input, Type<R> type) {
        if (type == this.getType(input)) {
            return Optional.of(type.readTyped(new Dynamic<T>(this, input)).getSecond().orElseThrow(() -> new IllegalStateException("Parse error during dynamic cast")).getValue());
        }
        return Optional.empty();
    }

    public Optional<Number> getNumberValue(T var1);

    default public Number getNumberValue(T input, Number defaultValue) {
        return this.getNumberValue(input).orElse(defaultValue);
    }

    public T createNumeric(Number var1);

    default public T createByte(byte value) {
        return this.createNumeric(value);
    }

    default public T createShort(short value) {
        return this.createNumeric(value);
    }

    default public T createInt(int value) {
        return this.createNumeric(value);
    }

    default public T createLong(long value) {
        return this.createNumeric(value);
    }

    default public T createFloat(float value) {
        return this.createNumeric(Float.valueOf(value));
    }

    default public T createDouble(double value) {
        return this.createNumeric(value);
    }

    default public T createBoolean(boolean value) {
        return this.createByte((byte)(value ? 1 : 0));
    }

    public Optional<String> getStringValue(T var1);

    public T createString(String var1);

    public T mergeInto(T var1, T var2);

    public T mergeInto(T var1, T var2, T var3);

    public T merge(T var1, T var2);

    public Optional<Map<T, T>> getMapValues(T var1);

    public T createMap(Map<T, T> var1);

    public Optional<Stream<T>> getStream(T var1);

    public T createList(Stream<T> var1);

    default public Optional<ByteBuffer> getByteBuffer(T input) {
        return this.getStream(input).flatMap(stream -> {
            List list = stream.collect(Collectors.toList());
            if (list.stream().allMatch(element -> this.getNumberValue(element).isPresent())) {
                ByteBuffer buffer = ByteBuffer.wrap(new byte[list.size()]);
                for (int i = 0; i < list.size(); ++i) {
                    buffer.put(i, this.getNumberValue(list.get(i)).get().byteValue());
                }
                return Optional.of(buffer);
            }
            return Optional.empty();
        });
    }

    default public T createByteList(ByteBuffer input) {
        int[] i = new int[]{0};
        return (T)this.createList(Stream.generate(() -> {
            int n = i[0];
            i[0] = n + 1;
            return this.createByte(input.get(n));
        }).limit(input.capacity()));
    }

    default public Optional<IntStream> getIntStream(T input) {
        return this.getStream(input).flatMap(stream -> {
            List list = stream.collect(Collectors.toList());
            if (list.stream().allMatch(element -> this.getNumberValue(element).isPresent())) {
                return Optional.of(list.stream().mapToInt(element -> this.getNumberValue(element).get().intValue()));
            }
            return Optional.empty();
        });
    }

    default public T createIntList(IntStream input) {
        return (T)this.createList(input.mapToObj(this::createInt));
    }

    default public Optional<LongStream> getLongStream(T input) {
        return this.getStream(input).flatMap(stream -> {
            List list = stream.collect(Collectors.toList());
            if (list.stream().allMatch(element -> this.getNumberValue(element).isPresent())) {
                return Optional.of(list.stream().mapToLong(element -> this.getNumberValue(element).get().longValue()));
            }
            return Optional.empty();
        });
    }

    default public T createLongList(LongStream input) {
        return (T)this.createList(input.mapToObj(this::createLong));
    }

    public T remove(T var1, String var2);

    default public Optional<T> get(T input, String key) {
        return this.getGeneric(input, this.createString(key));
    }

    default public Optional<T> getGeneric(T input, T key) {
        return this.getMapValues(input).flatMap(map -> {
            if (map.containsKey(key)) {
                return Optional.of(map.get(key));
            }
            return Optional.empty();
        });
    }

    default public T set(T input, String key, T value) {
        return this.mergeInto(input, this.createString(key), value);
    }

    default public T update(T input, String key, Function<T, T> function) {
        return (T)this.get(input, key).map(value -> this.set(input, key, function.apply(value))).orElse(input);
    }

    default public T updateGeneric(T input, T key, Function<T, T> function) {
        return (T)this.getGeneric(input, key).map(value -> this.mergeInto(input, key, function.apply(value))).orElse(input);
    }
}

