/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.stb.LibSTB;
import org.lwjgl.stb.STBIIOCallbacks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class STBImage {
    public static final int STBI_default = 0;
    public static final int STBI_grey = 1;
    public static final int STBI_grey_alpha = 2;
    public static final int STBI_rgb = 3;
    public static final int STBI_rgb_alpha = 4;

    protected STBImage() {
        throw new UnsupportedOperationException();
    }

    public static native long nstbi_load(long var0, long var2, long var4, long var6, int var8);

    @Nullable
    @NativeType(value="stbi_uc *")
    public static ByteBuffer stbi_load(@NativeType(value="const char *") ByteBuffer filename, @NativeType(value="int *") IntBuffer x, @NativeType(value="int *") IntBuffer y, @NativeType(value="int *") IntBuffer channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)filename);
            Checks.check((Buffer)x, (int)1);
            Checks.check((Buffer)y, (int)1);
            Checks.check((Buffer)channels_in_file, (int)1);
        }
        long __result = STBImage.nstbi_load(MemoryUtil.memAddress((ByteBuffer)filename), MemoryUtil.memAddress((IntBuffer)x), MemoryUtil.memAddress((IntBuffer)y), MemoryUtil.memAddress((IntBuffer)channels_in_file), desired_channels);
        return MemoryUtil.memByteBufferSafe((long)__result, (int)(x.get(x.position()) * y.get(y.position()) * (desired_channels != 0 ? desired_channels : channels_in_file.get(channels_in_file.position()))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="stbi_uc *")
    public static ByteBuffer stbi_load(@NativeType(value="const char *") CharSequence filename, @NativeType(value="int *") IntBuffer x, @NativeType(value="int *") IntBuffer y, @NativeType(value="int *") IntBuffer channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)x, (int)1);
            Checks.check((Buffer)y, (int)1);
            Checks.check((Buffer)channels_in_file, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            long __result = STBImage.nstbi_load(MemoryUtil.memAddress((ByteBuffer)filenameEncoded), MemoryUtil.memAddress((IntBuffer)x), MemoryUtil.memAddress((IntBuffer)y), MemoryUtil.memAddress((IntBuffer)channels_in_file), desired_channels);
            ByteBuffer byteBuffer = MemoryUtil.memByteBufferSafe((long)__result, (int)(x.get(x.position()) * y.get(y.position()) * (desired_channels != 0 ? desired_channels : channels_in_file.get(channels_in_file.position()))));
            return byteBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long nstbi_load_from_memory(long var0, int var2, long var3, long var5, long var7, int var9);

    @Nullable
    @NativeType(value="stbi_uc *")
    public static ByteBuffer stbi_load_from_memory(@NativeType(value="const stbi_uc *") ByteBuffer buffer, @NativeType(value="int *") IntBuffer x, @NativeType(value="int *") IntBuffer y, @NativeType(value="int *") IntBuffer channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)x, (int)1);
            Checks.check((Buffer)y, (int)1);
            Checks.check((Buffer)channels_in_file, (int)1);
        }
        long __result = STBImage.nstbi_load_from_memory(MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining(), MemoryUtil.memAddress((IntBuffer)x), MemoryUtil.memAddress((IntBuffer)y), MemoryUtil.memAddress((IntBuffer)channels_in_file), desired_channels);
        return MemoryUtil.memByteBufferSafe((long)__result, (int)(x.get(x.position()) * y.get(y.position()) * (desired_channels != 0 ? desired_channels : channels_in_file.get(channels_in_file.position()))));
    }

    public static native long nstbi_load_from_callbacks(long var0, long var2, long var4, long var6, long var8, int var10);

    @Nullable
    @NativeType(value="stbi_uc *")
    public static ByteBuffer stbi_load_from_callbacks(@NativeType(value="const stbi_io_callbacks *") STBIIOCallbacks clbk, @NativeType(value="void *") long user, @NativeType(value="int *") IntBuffer x, @NativeType(value="int *") IntBuffer y, @NativeType(value="int *") IntBuffer channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)x, (int)1);
            Checks.check((Buffer)y, (int)1);
            Checks.check((Buffer)channels_in_file, (int)1);
            STBIIOCallbacks.validate(clbk.address());
        }
        long __result = STBImage.nstbi_load_from_callbacks(clbk.address(), user, MemoryUtil.memAddress((IntBuffer)x), MemoryUtil.memAddress((IntBuffer)y), MemoryUtil.memAddress((IntBuffer)channels_in_file), desired_channels);
        return MemoryUtil.memByteBufferSafe((long)__result, (int)(x.get(x.position()) * y.get(y.position()) * (desired_channels != 0 ? desired_channels : channels_in_file.get(channels_in_file.position()))));
    }

    public static native long nstbi_load_gif_from_memory(long var0, int var2, long var3, long var5, long var7, long var9, long var11, int var13);

    @Nullable
    @NativeType(value="stbi_uc *")
    public static ByteBuffer stbi_load_gif_from_memory(@NativeType(value="const stbi_uc *") ByteBuffer buffer, @NativeType(value="int **") PointerBuffer delays, @NativeType(value="int *") IntBuffer x, @NativeType(value="int *") IntBuffer y, @NativeType(value="int *") IntBuffer z, @NativeType(value="int *") IntBuffer channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)delays, (int)1);
            Checks.check((Buffer)x, (int)1);
            Checks.check((Buffer)y, (int)1);
            Checks.check((Buffer)z, (int)1);
            Checks.check((Buffer)channels_in_file, (int)1);
        }
        long __result = STBImage.nstbi_load_gif_from_memory(MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining(), MemoryUtil.memAddress((CustomBuffer)delays), MemoryUtil.memAddress((IntBuffer)x), MemoryUtil.memAddress((IntBuffer)y), MemoryUtil.memAddress((IntBuffer)z), MemoryUtil.memAddress((IntBuffer)channels_in_file), desired_channels);
        return MemoryUtil.memByteBufferSafe((long)__result, (int)(x.get(x.position()) * y.get(y.position()) * z.get(z.position()) * (desired_channels != 0 ? desired_channels : channels_in_file.get(channels_in_file.position()))));
    }

    public static native long nstbi_load_16(long var0, long var2, long var4, long var6, int var8);

    @Nullable
    @NativeType(value="stbi_us *")
    public static ShortBuffer stbi_load_16(@NativeType(value="const char *") ByteBuffer filename, @NativeType(value="int *") IntBuffer x, @NativeType(value="int *") IntBuffer y, @NativeType(value="int *") IntBuffer channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)filename);
            Checks.check((Buffer)x, (int)1);
            Checks.check((Buffer)y, (int)1);
            Checks.check((Buffer)channels_in_file, (int)1);
        }
        long __result = STBImage.nstbi_load_16(MemoryUtil.memAddress((ByteBuffer)filename), MemoryUtil.memAddress((IntBuffer)x), MemoryUtil.memAddress((IntBuffer)y), MemoryUtil.memAddress((IntBuffer)channels_in_file), desired_channels);
        return MemoryUtil.memShortBufferSafe((long)__result, (int)(x.get(x.position()) * y.get(y.position()) * (desired_channels != 0 ? desired_channels : channels_in_file.get(channels_in_file.position()))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="stbi_us *")
    public static ShortBuffer stbi_load_16(@NativeType(value="const char *") CharSequence filename, @NativeType(value="int *") IntBuffer x, @NativeType(value="int *") IntBuffer y, @NativeType(value="int *") IntBuffer channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)x, (int)1);
            Checks.check((Buffer)y, (int)1);
            Checks.check((Buffer)channels_in_file, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            long __result = STBImage.nstbi_load_16(MemoryUtil.memAddress((ByteBuffer)filenameEncoded), MemoryUtil.memAddress((IntBuffer)x), MemoryUtil.memAddress((IntBuffer)y), MemoryUtil.memAddress((IntBuffer)channels_in_file), desired_channels);
            ShortBuffer shortBuffer = MemoryUtil.memShortBufferSafe((long)__result, (int)(x.get(x.position()) * y.get(y.position()) * (desired_channels != 0 ? desired_channels : channels_in_file.get(channels_in_file.position()))));
            return shortBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long nstbi_load_16_from_memory(long var0, int var2, long var3, long var5, long var7, int var9);

    @Nullable
    @NativeType(value="stbi_us *")
    public static ShortBuffer stbi_load_16_from_memory(@NativeType(value="const stbi_uc *") ByteBuffer buffer, @NativeType(value="int *") IntBuffer x, @NativeType(value="int *") IntBuffer y, @NativeType(value="int *") IntBuffer channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)x, (int)1);
            Checks.check((Buffer)y, (int)1);
            Checks.check((Buffer)channels_in_file, (int)1);
        }
        long __result = STBImage.nstbi_load_16_from_memory(MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining(), MemoryUtil.memAddress((IntBuffer)x), MemoryUtil.memAddress((IntBuffer)y), MemoryUtil.memAddress((IntBuffer)channels_in_file), desired_channels);
        return MemoryUtil.memShortBufferSafe((long)__result, (int)(x.get(x.position()) * y.get(y.position()) * (desired_channels != 0 ? desired_channels : channels_in_file.get(channels_in_file.position()))));
    }

    public static native long nstbi_load_16_from_callbacks(long var0, long var2, long var4, long var6, long var8, int var10);

    @Nullable
    @NativeType(value="stbi_us *")
    public static ShortBuffer stbi_load_16_from_callbacks(@NativeType(value="const stbi_io_callbacks *") STBIIOCallbacks clbk, @NativeType(value="void *") long user, @NativeType(value="int *") IntBuffer x, @NativeType(value="int *") IntBuffer y, @NativeType(value="int *") IntBuffer channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)x, (int)1);
            Checks.check((Buffer)y, (int)1);
            Checks.check((Buffer)channels_in_file, (int)1);
            STBIIOCallbacks.validate(clbk.address());
        }
        long __result = STBImage.nstbi_load_16_from_callbacks(clbk.address(), user, MemoryUtil.memAddress((IntBuffer)x), MemoryUtil.memAddress((IntBuffer)y), MemoryUtil.memAddress((IntBuffer)channels_in_file), desired_channels);
        return MemoryUtil.memShortBufferSafe((long)__result, (int)(x.get(x.position()) * y.get(y.position()) * (desired_channels != 0 ? desired_channels : channels_in_file.get(channels_in_file.position()))));
    }

    public static native long nstbi_loadf(long var0, long var2, long var4, long var6, int var8);

    @Nullable
    @NativeType(value="float *")
    public static FloatBuffer stbi_loadf(@NativeType(value="const char *") ByteBuffer filename, @NativeType(value="int *") IntBuffer x, @NativeType(value="int *") IntBuffer y, @NativeType(value="int *") IntBuffer channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)filename);
            Checks.check((Buffer)x, (int)1);
            Checks.check((Buffer)y, (int)1);
            Checks.check((Buffer)channels_in_file, (int)1);
        }
        long __result = STBImage.nstbi_loadf(MemoryUtil.memAddress((ByteBuffer)filename), MemoryUtil.memAddress((IntBuffer)x), MemoryUtil.memAddress((IntBuffer)y), MemoryUtil.memAddress((IntBuffer)channels_in_file), desired_channels);
        return MemoryUtil.memFloatBufferSafe((long)__result, (int)(x.get(x.position()) * y.get(y.position()) * (desired_channels != 0 ? desired_channels : channels_in_file.get(channels_in_file.position()))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="float *")
    public static FloatBuffer stbi_loadf(@NativeType(value="const char *") CharSequence filename, @NativeType(value="int *") IntBuffer x, @NativeType(value="int *") IntBuffer y, @NativeType(value="int *") IntBuffer channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)x, (int)1);
            Checks.check((Buffer)y, (int)1);
            Checks.check((Buffer)channels_in_file, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            long __result = STBImage.nstbi_loadf(MemoryUtil.memAddress((ByteBuffer)filenameEncoded), MemoryUtil.memAddress((IntBuffer)x), MemoryUtil.memAddress((IntBuffer)y), MemoryUtil.memAddress((IntBuffer)channels_in_file), desired_channels);
            FloatBuffer floatBuffer = MemoryUtil.memFloatBufferSafe((long)__result, (int)(x.get(x.position()) * y.get(y.position()) * (desired_channels != 0 ? desired_channels : channels_in_file.get(channels_in_file.position()))));
            return floatBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long nstbi_loadf_from_memory(long var0, int var2, long var3, long var5, long var7, int var9);

    @Nullable
    @NativeType(value="float *")
    public static FloatBuffer stbi_loadf_from_memory(@NativeType(value="const stbi_uc *") ByteBuffer buffer, @NativeType(value="int *") IntBuffer x, @NativeType(value="int *") IntBuffer y, @NativeType(value="int *") IntBuffer channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)x, (int)1);
            Checks.check((Buffer)y, (int)1);
            Checks.check((Buffer)channels_in_file, (int)1);
        }
        long __result = STBImage.nstbi_loadf_from_memory(MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining(), MemoryUtil.memAddress((IntBuffer)x), MemoryUtil.memAddress((IntBuffer)y), MemoryUtil.memAddress((IntBuffer)channels_in_file), desired_channels);
        return MemoryUtil.memFloatBufferSafe((long)__result, (int)(x.get(x.position()) * y.get(y.position()) * (desired_channels != 0 ? desired_channels : channels_in_file.get(channels_in_file.position()))));
    }

    public static native long nstbi_loadf_from_callbacks(long var0, long var2, long var4, long var6, long var8, int var10);

    @Nullable
    @NativeType(value="float *")
    public static FloatBuffer stbi_loadf_from_callbacks(@NativeType(value="const stbi_io_callbacks *") STBIIOCallbacks clbk, @NativeType(value="void *") long user, @NativeType(value="int *") IntBuffer x, @NativeType(value="int *") IntBuffer y, @NativeType(value="int *") IntBuffer channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)x, (int)1);
            Checks.check((Buffer)y, (int)1);
            Checks.check((Buffer)channels_in_file, (int)1);
            STBIIOCallbacks.validate(clbk.address());
        }
        long __result = STBImage.nstbi_loadf_from_callbacks(clbk.address(), user, MemoryUtil.memAddress((IntBuffer)x), MemoryUtil.memAddress((IntBuffer)y), MemoryUtil.memAddress((IntBuffer)channels_in_file), desired_channels);
        return MemoryUtil.memFloatBufferSafe((long)__result, (int)(x.get(x.position()) * y.get(y.position()) * (desired_channels != 0 ? desired_channels : channels_in_file.get(channels_in_file.position()))));
    }

    public static native void stbi_hdr_to_ldr_gamma(float var0);

    public static native void stbi_hdr_to_ldr_scale(float var0);

    public static native void stbi_ldr_to_hdr_gamma(float var0);

    public static native void stbi_ldr_to_hdr_scale(float var0);

    public static native int nstbi_is_hdr(long var0);

    @NativeType(value="int")
    public static boolean stbi_is_hdr(@NativeType(value="const char *") ByteBuffer filename) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)filename);
        }
        return STBImage.nstbi_is_hdr(MemoryUtil.memAddress((ByteBuffer)filename)) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="int")
    public static boolean stbi_is_hdr(@NativeType(value="const char *") CharSequence filename) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            boolean bl = STBImage.nstbi_is_hdr(MemoryUtil.memAddress((ByteBuffer)filenameEncoded)) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nstbi_is_hdr_from_memory(long var0, int var2);

    @NativeType(value="int")
    public static boolean stbi_is_hdr_from_memory(@NativeType(value="const stbi_uc *") ByteBuffer buffer) {
        return STBImage.nstbi_is_hdr_from_memory(MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining()) != 0;
    }

    public static native int nstbi_is_hdr_from_callbacks(long var0, long var2);

    @NativeType(value="int")
    public static boolean stbi_is_hdr_from_callbacks(@NativeType(value="const stbi_io_callbacks *") STBIIOCallbacks clbk, @NativeType(value="void *") long user) {
        if (Checks.CHECKS) {
            STBIIOCallbacks.validate(clbk.address());
        }
        return STBImage.nstbi_is_hdr_from_callbacks(clbk.address(), user) != 0;
    }

    public static native long nstbi_failure_reason();

    @Nullable
    @NativeType(value="const char *")
    public static String stbi_failure_reason() {
        long __result = STBImage.nstbi_failure_reason();
        return MemoryUtil.memASCIISafe((long)__result);
    }

    public static native void nstbi_image_free(long var0);

    public static void stbi_image_free(@NativeType(value="void *") ByteBuffer retval_from_stbi_load) {
        STBImage.nstbi_image_free(MemoryUtil.memAddress((ByteBuffer)retval_from_stbi_load));
    }

    public static void stbi_image_free(@NativeType(value="void *") ShortBuffer retval_from_stbi_load) {
        STBImage.nstbi_image_free(MemoryUtil.memAddress((ShortBuffer)retval_from_stbi_load));
    }

    public static void stbi_image_free(@NativeType(value="void *") FloatBuffer retval_from_stbi_load) {
        STBImage.nstbi_image_free(MemoryUtil.memAddress((FloatBuffer)retval_from_stbi_load));
    }

    public static native int nstbi_info(long var0, long var2, long var4, long var6);

    @NativeType(value="int")
    public static boolean stbi_info(@NativeType(value="const char *") ByteBuffer filename, @NativeType(value="int *") IntBuffer x, @NativeType(value="int *") IntBuffer y, @NativeType(value="int *") IntBuffer comp) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)filename);
            Checks.check((Buffer)x, (int)1);
            Checks.check((Buffer)y, (int)1);
            Checks.check((Buffer)comp, (int)1);
        }
        return STBImage.nstbi_info(MemoryUtil.memAddress((ByteBuffer)filename), MemoryUtil.memAddress((IntBuffer)x), MemoryUtil.memAddress((IntBuffer)y), MemoryUtil.memAddress((IntBuffer)comp)) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="int")
    public static boolean stbi_info(@NativeType(value="const char *") CharSequence filename, @NativeType(value="int *") IntBuffer x, @NativeType(value="int *") IntBuffer y, @NativeType(value="int *") IntBuffer comp) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)x, (int)1);
            Checks.check((Buffer)y, (int)1);
            Checks.check((Buffer)comp, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            boolean bl = STBImage.nstbi_info(MemoryUtil.memAddress((ByteBuffer)filenameEncoded), MemoryUtil.memAddress((IntBuffer)x), MemoryUtil.memAddress((IntBuffer)y), MemoryUtil.memAddress((IntBuffer)comp)) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nstbi_info_from_memory(long var0, int var2, long var3, long var5, long var7);

    @NativeType(value="int")
    public static boolean stbi_info_from_memory(@NativeType(value="const stbi_uc *") ByteBuffer buffer, @NativeType(value="int *") IntBuffer x, @NativeType(value="int *") IntBuffer y, @NativeType(value="int *") IntBuffer comp) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)x, (int)1);
            Checks.check((Buffer)y, (int)1);
            Checks.check((Buffer)comp, (int)1);
        }
        return STBImage.nstbi_info_from_memory(MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining(), MemoryUtil.memAddress((IntBuffer)x), MemoryUtil.memAddress((IntBuffer)y), MemoryUtil.memAddress((IntBuffer)comp)) != 0;
    }

    public static native int nstbi_info_from_callbacks(long var0, long var2, long var4, long var6, long var8);

    @NativeType(value="int")
    public static boolean stbi_info_from_callbacks(@NativeType(value="const stbi_io_callbacks *") STBIIOCallbacks clbk, @NativeType(value="void *") long user, @NativeType(value="int *") IntBuffer x, @NativeType(value="int *") IntBuffer y, @NativeType(value="int *") IntBuffer comp) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)x, (int)1);
            Checks.check((Buffer)y, (int)1);
            Checks.check((Buffer)comp, (int)1);
            STBIIOCallbacks.validate(clbk.address());
        }
        return STBImage.nstbi_info_from_callbacks(clbk.address(), user, MemoryUtil.memAddress((IntBuffer)x), MemoryUtil.memAddress((IntBuffer)y), MemoryUtil.memAddress((IntBuffer)comp)) != 0;
    }

    public static native int nstbi_is_16_bit(long var0);

    @NativeType(value="int")
    public static boolean stbi_is_16_bit(@NativeType(value="const char *") ByteBuffer filename) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)filename);
        }
        return STBImage.nstbi_is_16_bit(MemoryUtil.memAddress((ByteBuffer)filename)) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="int")
    public static boolean stbi_is_16_bit(@NativeType(value="const char *") CharSequence filename) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            boolean bl = STBImage.nstbi_is_16_bit(MemoryUtil.memAddress((ByteBuffer)filenameEncoded)) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nstbi_is_16_bit_from_memory(long var0, int var2);

    @NativeType(value="int")
    public static boolean stbi_is_16_bit_from_memory(@NativeType(value="const stbi_uc *") ByteBuffer buffer) {
        return STBImage.nstbi_is_16_bit_from_memory(MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining()) != 0;
    }

    public static native int nstbi_is_16_bit_from_callbacks(long var0, long var2);

    @NativeType(value="int")
    public static boolean stbi_is_16_bit_from_callbacks(@NativeType(value="const stbi_io_callbacks *") STBIIOCallbacks clbk, @NativeType(value="void *") long user) {
        if (Checks.CHECKS) {
            STBIIOCallbacks.validate(clbk.address());
        }
        return STBImage.nstbi_is_16_bit_from_callbacks(clbk.address(), user) != 0;
    }

    public static native void nstbi_set_unpremultiply_on_load(int var0);

    public static void stbi_set_unpremultiply_on_load(@NativeType(value="int") boolean flag_true_if_should_unpremultiply) {
        STBImage.nstbi_set_unpremultiply_on_load(flag_true_if_should_unpremultiply ? 1 : 0);
    }

    public static native void nstbi_convert_iphone_png_to_rgb(int var0);

    public static void stbi_convert_iphone_png_to_rgb(@NativeType(value="int") boolean flag_true_if_should_convert) {
        STBImage.nstbi_convert_iphone_png_to_rgb(flag_true_if_should_convert ? 1 : 0);
    }

    public static native void nstbi_set_flip_vertically_on_load(int var0);

    public static void stbi_set_flip_vertically_on_load(@NativeType(value="int") boolean flag_true_if_should_flip) {
        STBImage.nstbi_set_flip_vertically_on_load(flag_true_if_should_flip ? 1 : 0);
    }

    public static native long nstbi_zlib_decode_malloc_guesssize(long var0, int var2, int var3, long var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="char *")
    public static ByteBuffer stbi_zlib_decode_malloc_guesssize(@NativeType(value="const char *") ByteBuffer buffer, int initial_size) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer outlen = stack.callocInt(1);
            long __result = STBImage.nstbi_zlib_decode_malloc_guesssize(MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining(), initial_size, MemoryUtil.memAddress((IntBuffer)outlen));
            ByteBuffer byteBuffer = MemoryUtil.memByteBufferSafe((long)__result, (int)outlen.get(0));
            return byteBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long nstbi_zlib_decode_malloc_guesssize_headerflag(long var0, int var2, int var3, long var4, int var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="char *")
    public static ByteBuffer stbi_zlib_decode_malloc_guesssize_headerflag(@NativeType(value="const char *") ByteBuffer buffer, int initial_size, @NativeType(value="int") boolean parse_header) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer outlen = stack.callocInt(1);
            long __result = STBImage.nstbi_zlib_decode_malloc_guesssize_headerflag(MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining(), initial_size, MemoryUtil.memAddress((IntBuffer)outlen), parse_header ? 1 : 0);
            ByteBuffer byteBuffer = MemoryUtil.memByteBufferSafe((long)__result, (int)outlen.get(0));
            return byteBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long nstbi_zlib_decode_malloc(long var0, int var2, long var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="char *")
    public static ByteBuffer stbi_zlib_decode_malloc(@NativeType(value="const char *") ByteBuffer buffer) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer outlen = stack.callocInt(1);
            long __result = STBImage.nstbi_zlib_decode_malloc(MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining(), MemoryUtil.memAddress((IntBuffer)outlen));
            ByteBuffer byteBuffer = MemoryUtil.memByteBufferSafe((long)__result, (int)outlen.get(0));
            return byteBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nstbi_zlib_decode_buffer(long var0, int var2, long var3, int var5);

    public static int stbi_zlib_decode_buffer(@NativeType(value="char *") ByteBuffer obuffer, @NativeType(value="const char *") ByteBuffer ibuffer) {
        return STBImage.nstbi_zlib_decode_buffer(MemoryUtil.memAddress((ByteBuffer)obuffer), obuffer.remaining(), MemoryUtil.memAddress((ByteBuffer)ibuffer), ibuffer.remaining());
    }

    public static native long nstbi_zlib_decode_noheader_malloc(long var0, int var2, long var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="char *")
    public static ByteBuffer stbi_zlib_decode_noheader_malloc(@NativeType(value="const char *") ByteBuffer buffer) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer outlen = stack.callocInt(1);
            long __result = STBImage.nstbi_zlib_decode_noheader_malloc(MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining(), MemoryUtil.memAddress((IntBuffer)outlen));
            ByteBuffer byteBuffer = MemoryUtil.memByteBufferSafe((long)__result, (int)outlen.get(0));
            return byteBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nstbi_zlib_decode_noheader_buffer(long var0, int var2, long var3, int var5);

    public static int stbi_zlib_decode_noheader_buffer(@NativeType(value="char *") ByteBuffer obuffer, @NativeType(value="const char *") ByteBuffer ibuffer) {
        return STBImage.nstbi_zlib_decode_noheader_buffer(MemoryUtil.memAddress((ByteBuffer)obuffer), obuffer.remaining(), MemoryUtil.memAddress((ByteBuffer)ibuffer), ibuffer.remaining());
    }

    public static native long nstbi_load(long var0, int[] var2, int[] var3, int[] var4, int var5);

    @Nullable
    @NativeType(value="stbi_uc *")
    public static ByteBuffer stbi_load(@NativeType(value="const char *") ByteBuffer filename, @NativeType(value="int *") int[] x, @NativeType(value="int *") int[] y, @NativeType(value="int *") int[] channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)filename);
            Checks.check((int[])x, (int)1);
            Checks.check((int[])y, (int)1);
            Checks.check((int[])channels_in_file, (int)1);
        }
        long __result = STBImage.nstbi_load(MemoryUtil.memAddress((ByteBuffer)filename), x, y, channels_in_file, desired_channels);
        return MemoryUtil.memByteBufferSafe((long)__result, (int)(x[0] * y[0] * (desired_channels != 0 ? desired_channels : channels_in_file[0])));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="stbi_uc *")
    public static ByteBuffer stbi_load(@NativeType(value="const char *") CharSequence filename, @NativeType(value="int *") int[] x, @NativeType(value="int *") int[] y, @NativeType(value="int *") int[] channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.check((int[])x, (int)1);
            Checks.check((int[])y, (int)1);
            Checks.check((int[])channels_in_file, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            long __result = STBImage.nstbi_load(MemoryUtil.memAddress((ByteBuffer)filenameEncoded), x, y, channels_in_file, desired_channels);
            ByteBuffer byteBuffer = MemoryUtil.memByteBufferSafe((long)__result, (int)(x[0] * y[0] * (desired_channels != 0 ? desired_channels : channels_in_file[0])));
            return byteBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long nstbi_load_from_memory(long var0, int var2, int[] var3, int[] var4, int[] var5, int var6);

    @Nullable
    @NativeType(value="stbi_uc *")
    public static ByteBuffer stbi_load_from_memory(@NativeType(value="const stbi_uc *") ByteBuffer buffer, @NativeType(value="int *") int[] x, @NativeType(value="int *") int[] y, @NativeType(value="int *") int[] channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.check((int[])x, (int)1);
            Checks.check((int[])y, (int)1);
            Checks.check((int[])channels_in_file, (int)1);
        }
        long __result = STBImage.nstbi_load_from_memory(MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining(), x, y, channels_in_file, desired_channels);
        return MemoryUtil.memByteBufferSafe((long)__result, (int)(x[0] * y[0] * (desired_channels != 0 ? desired_channels : channels_in_file[0])));
    }

    public static native long nstbi_load_from_callbacks(long var0, long var2, int[] var4, int[] var5, int[] var6, int var7);

    @Nullable
    @NativeType(value="stbi_uc *")
    public static ByteBuffer stbi_load_from_callbacks(@NativeType(value="const stbi_io_callbacks *") STBIIOCallbacks clbk, @NativeType(value="void *") long user, @NativeType(value="int *") int[] x, @NativeType(value="int *") int[] y, @NativeType(value="int *") int[] channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.check((int[])x, (int)1);
            Checks.check((int[])y, (int)1);
            Checks.check((int[])channels_in_file, (int)1);
            STBIIOCallbacks.validate(clbk.address());
        }
        long __result = STBImage.nstbi_load_from_callbacks(clbk.address(), user, x, y, channels_in_file, desired_channels);
        return MemoryUtil.memByteBufferSafe((long)__result, (int)(x[0] * y[0] * (desired_channels != 0 ? desired_channels : channels_in_file[0])));
    }

    public static native long nstbi_load_gif_from_memory(long var0, int var2, long var3, int[] var5, int[] var6, int[] var7, int[] var8, int var9);

    @Nullable
    @NativeType(value="stbi_uc *")
    public static ByteBuffer stbi_load_gif_from_memory(@NativeType(value="const stbi_uc *") ByteBuffer buffer, @NativeType(value="int **") PointerBuffer delays, @NativeType(value="int *") int[] x, @NativeType(value="int *") int[] y, @NativeType(value="int *") int[] z, @NativeType(value="int *") int[] channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)delays, (int)1);
            Checks.check((int[])x, (int)1);
            Checks.check((int[])y, (int)1);
            Checks.check((int[])z, (int)1);
            Checks.check((int[])channels_in_file, (int)1);
        }
        long __result = STBImage.nstbi_load_gif_from_memory(MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining(), MemoryUtil.memAddress((CustomBuffer)delays), x, y, z, channels_in_file, desired_channels);
        return MemoryUtil.memByteBufferSafe((long)__result, (int)(x[0] * y[0] * z[0] * (desired_channels != 0 ? desired_channels : channels_in_file[0])));
    }

    public static native long nstbi_load_16(long var0, int[] var2, int[] var3, int[] var4, int var5);

    @Nullable
    @NativeType(value="stbi_us *")
    public static ShortBuffer stbi_load_16(@NativeType(value="const char *") ByteBuffer filename, @NativeType(value="int *") int[] x, @NativeType(value="int *") int[] y, @NativeType(value="int *") int[] channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)filename);
            Checks.check((int[])x, (int)1);
            Checks.check((int[])y, (int)1);
            Checks.check((int[])channels_in_file, (int)1);
        }
        long __result = STBImage.nstbi_load_16(MemoryUtil.memAddress((ByteBuffer)filename), x, y, channels_in_file, desired_channels);
        return MemoryUtil.memShortBufferSafe((long)__result, (int)(x[0] * y[0] * (desired_channels != 0 ? desired_channels : channels_in_file[0])));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="stbi_us *")
    public static ShortBuffer stbi_load_16(@NativeType(value="const char *") CharSequence filename, @NativeType(value="int *") int[] x, @NativeType(value="int *") int[] y, @NativeType(value="int *") int[] channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.check((int[])x, (int)1);
            Checks.check((int[])y, (int)1);
            Checks.check((int[])channels_in_file, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            long __result = STBImage.nstbi_load_16(MemoryUtil.memAddress((ByteBuffer)filenameEncoded), x, y, channels_in_file, desired_channels);
            ShortBuffer shortBuffer = MemoryUtil.memShortBufferSafe((long)__result, (int)(x[0] * y[0] * (desired_channels != 0 ? desired_channels : channels_in_file[0])));
            return shortBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long nstbi_load_16_from_memory(long var0, int var2, int[] var3, int[] var4, int[] var5, int var6);

    @Nullable
    @NativeType(value="stbi_us *")
    public static ShortBuffer stbi_load_16_from_memory(@NativeType(value="const stbi_uc *") ByteBuffer buffer, @NativeType(value="int *") int[] x, @NativeType(value="int *") int[] y, @NativeType(value="int *") int[] channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.check((int[])x, (int)1);
            Checks.check((int[])y, (int)1);
            Checks.check((int[])channels_in_file, (int)1);
        }
        long __result = STBImage.nstbi_load_16_from_memory(MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining(), x, y, channels_in_file, desired_channels);
        return MemoryUtil.memShortBufferSafe((long)__result, (int)(x[0] * y[0] * (desired_channels != 0 ? desired_channels : channels_in_file[0])));
    }

    public static native long nstbi_load_16_from_callbacks(long var0, long var2, int[] var4, int[] var5, int[] var6, int var7);

    @Nullable
    @NativeType(value="stbi_us *")
    public static ShortBuffer stbi_load_16_from_callbacks(@NativeType(value="const stbi_io_callbacks *") STBIIOCallbacks clbk, @NativeType(value="void *") long user, @NativeType(value="int *") int[] x, @NativeType(value="int *") int[] y, @NativeType(value="int *") int[] channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.check((int[])x, (int)1);
            Checks.check((int[])y, (int)1);
            Checks.check((int[])channels_in_file, (int)1);
            STBIIOCallbacks.validate(clbk.address());
        }
        long __result = STBImage.nstbi_load_16_from_callbacks(clbk.address(), user, x, y, channels_in_file, desired_channels);
        return MemoryUtil.memShortBufferSafe((long)__result, (int)(x[0] * y[0] * (desired_channels != 0 ? desired_channels : channels_in_file[0])));
    }

    public static native long nstbi_loadf(long var0, int[] var2, int[] var3, int[] var4, int var5);

    @Nullable
    @NativeType(value="float *")
    public static FloatBuffer stbi_loadf(@NativeType(value="const char *") ByteBuffer filename, @NativeType(value="int *") int[] x, @NativeType(value="int *") int[] y, @NativeType(value="int *") int[] channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)filename);
            Checks.check((int[])x, (int)1);
            Checks.check((int[])y, (int)1);
            Checks.check((int[])channels_in_file, (int)1);
        }
        long __result = STBImage.nstbi_loadf(MemoryUtil.memAddress((ByteBuffer)filename), x, y, channels_in_file, desired_channels);
        return MemoryUtil.memFloatBufferSafe((long)__result, (int)(x[0] * y[0] * (desired_channels != 0 ? desired_channels : channels_in_file[0])));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="float *")
    public static FloatBuffer stbi_loadf(@NativeType(value="const char *") CharSequence filename, @NativeType(value="int *") int[] x, @NativeType(value="int *") int[] y, @NativeType(value="int *") int[] channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.check((int[])x, (int)1);
            Checks.check((int[])y, (int)1);
            Checks.check((int[])channels_in_file, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            long __result = STBImage.nstbi_loadf(MemoryUtil.memAddress((ByteBuffer)filenameEncoded), x, y, channels_in_file, desired_channels);
            FloatBuffer floatBuffer = MemoryUtil.memFloatBufferSafe((long)__result, (int)(x[0] * y[0] * (desired_channels != 0 ? desired_channels : channels_in_file[0])));
            return floatBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long nstbi_loadf_from_memory(long var0, int var2, int[] var3, int[] var4, int[] var5, int var6);

    @Nullable
    @NativeType(value="float *")
    public static FloatBuffer stbi_loadf_from_memory(@NativeType(value="const stbi_uc *") ByteBuffer buffer, @NativeType(value="int *") int[] x, @NativeType(value="int *") int[] y, @NativeType(value="int *") int[] channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.check((int[])x, (int)1);
            Checks.check((int[])y, (int)1);
            Checks.check((int[])channels_in_file, (int)1);
        }
        long __result = STBImage.nstbi_loadf_from_memory(MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining(), x, y, channels_in_file, desired_channels);
        return MemoryUtil.memFloatBufferSafe((long)__result, (int)(x[0] * y[0] * (desired_channels != 0 ? desired_channels : channels_in_file[0])));
    }

    public static native long nstbi_loadf_from_callbacks(long var0, long var2, int[] var4, int[] var5, int[] var6, int var7);

    @Nullable
    @NativeType(value="float *")
    public static FloatBuffer stbi_loadf_from_callbacks(@NativeType(value="const stbi_io_callbacks *") STBIIOCallbacks clbk, @NativeType(value="void *") long user, @NativeType(value="int *") int[] x, @NativeType(value="int *") int[] y, @NativeType(value="int *") int[] channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.check((int[])x, (int)1);
            Checks.check((int[])y, (int)1);
            Checks.check((int[])channels_in_file, (int)1);
            STBIIOCallbacks.validate(clbk.address());
        }
        long __result = STBImage.nstbi_loadf_from_callbacks(clbk.address(), user, x, y, channels_in_file, desired_channels);
        return MemoryUtil.memFloatBufferSafe((long)__result, (int)(x[0] * y[0] * (desired_channels != 0 ? desired_channels : channels_in_file[0])));
    }

    public static native int nstbi_info(long var0, int[] var2, int[] var3, int[] var4);

    @NativeType(value="int")
    public static boolean stbi_info(@NativeType(value="const char *") ByteBuffer filename, @NativeType(value="int *") int[] x, @NativeType(value="int *") int[] y, @NativeType(value="int *") int[] comp) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)filename);
            Checks.check((int[])x, (int)1);
            Checks.check((int[])y, (int)1);
            Checks.check((int[])comp, (int)1);
        }
        return STBImage.nstbi_info(MemoryUtil.memAddress((ByteBuffer)filename), x, y, comp) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="int")
    public static boolean stbi_info(@NativeType(value="const char *") CharSequence filename, @NativeType(value="int *") int[] x, @NativeType(value="int *") int[] y, @NativeType(value="int *") int[] comp) {
        if (Checks.CHECKS) {
            Checks.check((int[])x, (int)1);
            Checks.check((int[])y, (int)1);
            Checks.check((int[])comp, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            boolean bl = STBImage.nstbi_info(MemoryUtil.memAddress((ByteBuffer)filenameEncoded), x, y, comp) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nstbi_info_from_memory(long var0, int var2, int[] var3, int[] var4, int[] var5);

    @NativeType(value="int")
    public static boolean stbi_info_from_memory(@NativeType(value="const stbi_uc *") ByteBuffer buffer, @NativeType(value="int *") int[] x, @NativeType(value="int *") int[] y, @NativeType(value="int *") int[] comp) {
        if (Checks.CHECKS) {
            Checks.check((int[])x, (int)1);
            Checks.check((int[])y, (int)1);
            Checks.check((int[])comp, (int)1);
        }
        return STBImage.nstbi_info_from_memory(MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining(), x, y, comp) != 0;
    }

    public static native int nstbi_info_from_callbacks(long var0, long var2, int[] var4, int[] var5, int[] var6);

    @NativeType(value="int")
    public static boolean stbi_info_from_callbacks(@NativeType(value="const stbi_io_callbacks *") STBIIOCallbacks clbk, @NativeType(value="void *") long user, @NativeType(value="int *") int[] x, @NativeType(value="int *") int[] y, @NativeType(value="int *") int[] comp) {
        if (Checks.CHECKS) {
            Checks.check((int[])x, (int)1);
            Checks.check((int[])y, (int)1);
            Checks.check((int[])comp, (int)1);
            STBIIOCallbacks.validate(clbk.address());
        }
        return STBImage.nstbi_info_from_callbacks(clbk.address(), user, x, y, comp) != 0;
    }

    static {
        LibSTB.initialize();
    }
}

