/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.datafixers;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class Dynamic<T> {
    private final DynamicOps<T> ops;
    private final T value;

    public Dynamic(DynamicOps<T> ops) {
        this(ops, ops.empty());
    }

    public Dynamic(DynamicOps<T> ops, @Nullable T value) {
        this.ops = ops;
        this.value = value == null ? ops.empty() : value;
    }

    public DynamicOps<T> getOps() {
        return this.ops;
    }

    public T getValue() {
        return this.value;
    }

    public Dynamic<T> map(Function<? super T, ? extends T> function) {
        return new Dynamic<T>(this.ops, function.apply(this.value));
    }

    public Optional<Number> getNumberValue() {
        return this.ops.getNumberValue(this.value);
    }

    public Number getNumberValue(Number defaultValue) {
        return this.getNumberValue().orElse(defaultValue);
    }

    public Optional<String> getStringValue() {
        return this.ops.getStringValue(this.value);
    }

    public <U> Dynamic<U> castTyped(DynamicOps<U> ops) {
        if (!Objects.equals(this.ops, ops)) {
            throw new IllegalStateException("Dynamic type doesn't match");
        }
        return this;
    }

    public <U> U cast(DynamicOps<U> ops) {
        return this.castTyped(ops).getValue();
    }

    public Dynamic<T> merge(Dynamic<?> value) {
        return this.map(v -> this.ops.mergeInto(v, value.cast(this.ops)));
    }

    public Dynamic<T> merge(Dynamic<?> key, Dynamic<?> value) {
        return this.map(v -> this.ops.mergeInto(v, key.cast(this.ops), value.cast(this.ops)));
    }

    public Optional<Map<Dynamic<T>, Dynamic<T>>> getMapValues() {
        return this.ops.getMapValues(this.value).map((? super T map) -> {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry entry : map.entrySet()) {
                builder.put(new Dynamic<T>(this.ops, entry.getKey()), new Dynamic<T>(this.ops, entry.getValue()));
            }
            return builder.build();
        });
    }

    public Dynamic<T> createMap(Map<? extends Dynamic<?>, ? extends Dynamic<?>> map) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<Dynamic<?>, Dynamic<?>> entry : map.entrySet()) {
            builder.put(entry.getKey().cast(this.ops), entry.getValue().cast(this.ops));
        }
        return new Dynamic<T>(this.ops, this.ops.createMap((Map<T, T>)builder.build()));
    }

    public Dynamic<T> updateMapValues(Function<Pair<Dynamic<?>, Dynamic<?>>, Pair<Dynamic<?>, Dynamic<?>>> updater) {
        return DataFixUtils.orElse(this.getMapValues().map((? super T map) -> map.entrySet().stream().map((? super T e) -> {
            Pair pair = (Pair)updater.apply(Pair.of(e.getKey(), e.getValue()));
            return Pair.of(((Dynamic)pair.getFirst()).castTyped(this.ops), ((Dynamic)pair.getSecond()).castTyped(this.ops));
        }).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond))).map(this::createMap), this);
    }

    public Optional<Stream<Dynamic<T>>> getStream() {
        return this.ops.getStream(this.value).map((? super T s) -> s.map((? super T e) -> new Dynamic<Object>(this.ops, e)));
    }

    public Dynamic<T> createList(Stream<? extends Dynamic<?>> input) {
        return new Dynamic<Object>(this.ops, this.ops.createList(input.map((? super T element) -> element.cast(this.ops))));
    }

    public Optional<ByteBuffer> getByteBuffer() {
        return this.ops.getByteBuffer(this.value);
    }

    public Dynamic<?> createByteList(ByteBuffer input) {
        return new Dynamic<T>(this.ops, this.ops.createByteList(input));
    }

    public Optional<IntStream> getIntStream() {
        return this.ops.getIntStream(this.value);
    }

    public Dynamic<?> createIntList(IntStream input) {
        return new Dynamic<T>(this.ops, this.ops.createIntList(input));
    }

    public Optional<LongStream> getLongStream() {
        return this.ops.getLongStream(this.value);
    }

    public Dynamic<?> createLongList(LongStream input) {
        return new Dynamic<T>(this.ops, this.ops.createLongList(input));
    }

    public Dynamic<T> remove(String key) {
        return this.map(v -> this.ops.remove(v, key));
    }

    public Optional<Dynamic<T>> get(String key) {
        return this.ops.get(this.value, key).map((? super T v) -> new Dynamic<Object>(this.ops, v));
    }

    public Optional<T> getGeneric(T key) {
        return this.ops.getGeneric(this.value, key);
    }

    public Dynamic<T> set(String key, Dynamic<?> value) {
        return this.map(v -> this.ops.set(v, key, value.cast(this.ops)));
    }

    public Dynamic<T> update(String key, Function<Dynamic<?>, Dynamic<?>> function) {
        return this.map(v -> this.ops.update(v, key, value -> ((Dynamic)function.apply(new Dynamic<Object>(this.ops, value))).cast(this.ops)));
    }

    public Dynamic<T> updateGeneric(T key, Function<T, T> function) {
        return this.map(v -> this.ops.updateGeneric(v, key, function));
    }

    public Dynamic<T> createNumeric(Number i) {
        return new Dynamic<T>(this.ops, this.ops.createNumeric(i));
    }

    public Dynamic<T> createByte(byte value) {
        return new Dynamic<T>(this.ops, this.ops.createByte(value));
    }

    public Dynamic<T> createShort(short value) {
        return new Dynamic<T>(this.ops, this.ops.createShort(value));
    }

    public Dynamic<T> createInt(int value) {
        return new Dynamic<T>(this.ops, this.ops.createInt(value));
    }

    public Dynamic<T> createLong(long value) {
        return new Dynamic<T>(this.ops, this.ops.createLong(value));
    }

    public Dynamic<T> createFloat(float value) {
        return new Dynamic<T>(this.ops, this.ops.createFloat(value));
    }

    public Dynamic<T> createDouble(double value) {
        return new Dynamic<T>(this.ops, this.ops.createDouble(value));
    }

    public Dynamic<T> createBoolean(boolean value) {
        return new Dynamic<T>(this.ops, this.ops.createBoolean(value));
    }

    public Dynamic<T> createString(String value) {
        return new Dynamic<T>(this.ops, this.ops.createString(value));
    }

    public int getInt(String key) {
        return this.getNumber(key, 0).intValue();
    }

    public long getLong(String key) {
        return this.getNumber(key, 0).longValue();
    }

    public float getFloat(String key) {
        return this.getNumber(key, 0).floatValue();
    }

    public double getDouble(String key) {
        return this.getNumber(key, 0).doubleValue();
    }

    public byte getByte(String key) {
        return this.getNumber(key, 0).byteValue();
    }

    public short getShort(String key) {
        return this.getNumber(key, 0).shortValue();
    }

    public boolean getBoolean(String key) {
        return this.getNumber(key, 0).intValue() != 0;
    }

    public String getString(String key) {
        return this.getElement(key).flatMap(this.ops::getStringValue).orElse("");
    }

    public int getInt(String key, int defaultValue) {
        return this.getNumber(key, defaultValue).intValue();
    }

    public long getLong(String key, long defaultValue) {
        return this.getNumber(key, defaultValue).longValue();
    }

    public float getFloat(String key, float defaultValue) {
        return this.getNumber(key, Float.valueOf(defaultValue)).floatValue();
    }

    public double getDouble(String key, double defaultValue) {
        return this.getNumber(key, defaultValue).doubleValue();
    }

    public byte getByte(String key, byte defaultValue) {
        return this.getNumber(key, defaultValue).byteValue();
    }

    public short getShort(String key, short defaultValue) {
        return this.getNumber(key, defaultValue).shortValue();
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.getNumber(key, defaultValue ? 1 : 0).intValue() != 0;
    }

    public String getString(String key, String defaultValue) {
        return this.getElement(key).flatMap(this.ops::getStringValue).orElse(defaultValue);
    }

    public Number getNumber(String key, Number defaultValue) {
        return this.getNumber(key).orElse(defaultValue);
    }

    public Optional<Number> getNumber(String key) {
        return this.getElement(key).flatMap(this.ops::getNumberValue);
    }

    public T getElement(String key, T defaultValue) {
        return this.getElement(key).orElse(defaultValue);
    }

    public Optional<T> getElement(String key) {
        return this.getElementGeneric(this.ops.createString(key));
    }

    public T getElementGeneric(T key, T defaultValue) {
        return this.getElementGeneric(key).orElse(defaultValue);
    }

    public Optional<T> getElementGeneric(T key) {
        return this.ops.getMapValues(this.value).flatMap(m -> Optional.ofNullable(m.get(key)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dynamic dynamic = (Dynamic)o;
        return Objects.equals(this.ops, dynamic.ops) && Objects.equals(this.value, dynamic.value);
    }

    public int hashCode() {
        return Objects.hash(this.ops, this.value);
    }

    public String toString() {
        return String.format("%s[%s]", this.ops, this.value);
    }

    public <R> Dynamic<R> convert(DynamicOps<R> outOps) {
        return new Dynamic<R>(outOps, Dynamic.convert(this.ops, outOps, this.value));
    }

    public static <S, T> T convert(DynamicOps<S> inOps, DynamicOps<T> outOps, S input) {
        if (Objects.equals(inOps, outOps)) {
            return (T)input;
        }
        Type<?> type = inOps.getType(input);
        if (Objects.equals(type, DSL.nilType())) {
            return outOps.empty();
        }
        if (Objects.equals(type, DSL.byteType())) {
            return outOps.createByte(inOps.getNumberValue(input, 0).byteValue());
        }
        if (Objects.equals(type, DSL.shortType())) {
            return outOps.createShort(inOps.getNumberValue(input, 0).shortValue());
        }
        if (Objects.equals(type, DSL.intType())) {
            return outOps.createInt(inOps.getNumberValue(input, 0).intValue());
        }
        if (Objects.equals(type, DSL.longType())) {
            return outOps.createLong(inOps.getNumberValue(input, 0).longValue());
        }
        if (Objects.equals(type, DSL.floatType())) {
            return outOps.createFloat(inOps.getNumberValue(input, 0).floatValue());
        }
        if (Objects.equals(type, DSL.doubleType())) {
            return outOps.createDouble(inOps.getNumberValue(input, 0).doubleValue());
        }
        if (Objects.equals(type, DSL.bool())) {
            return outOps.createBoolean(inOps.getNumberValue(input, 0).byteValue() != 0);
        }
        if (Objects.equals(type, DSL.string())) {
            return outOps.createString(inOps.getStringValue(input).orElse(""));
        }
        if (Objects.equals(type, DSL.list(DSL.byteType()))) {
            return outOps.createByteList(inOps.getByteBuffer(input).orElse(ByteBuffer.wrap(new byte[0])));
        }
        if (Objects.equals(type, DSL.list(DSL.intType()))) {
            return outOps.createIntList(inOps.getIntStream(input).orElse(IntStream.empty()));
        }
        if (Objects.equals(type, DSL.list(DSL.longType()))) {
            return outOps.createLongList(inOps.getLongStream(input).orElse(LongStream.empty()));
        }
        if (Objects.equals(type, DSL.list(DSL.remainderType()))) {
            return (T)outOps.createList(inOps.getStream(input).orElse(Stream.empty()).map((? super T e) -> Dynamic.convert(inOps, outOps, e)));
        }
        if (Objects.equals(type, DSL.compoundList(DSL.remainderType(), DSL.remainderType()))) {
            return (T)outOps.createMap(((Map)inOps.getMapValues(input).orElse((Map<S, S>)ImmutableMap.of())).entrySet().stream().map((? super T e) -> Pair.of(Dynamic.convert(inOps, outOps, e.getKey()), Dynamic.convert(inOps, outOps, e.getValue()))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond)));
        }
        throw new IllegalStateException("Could not convert value of type " + type);
    }

    public Dynamic<T> emptyList() {
        return new Dynamic<T>(this.ops, this.ops.emptyList());
    }

    public Dynamic<T> emptyMap() {
        return new Dynamic<T>(this.ops, this.ops.emptyMap());
    }
}

