/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens;

import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.gui.RealmsConstants;
import com.mojang.realmsclient.gui.screens.RealmsConfigureWorldScreen;
import com.mojang.realmsclient.gui.screens.RealmsPlayerScreen;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsButton;
import net.minecraft.realms.RealmsEditBox;
import net.minecraft.realms.RealmsGuiEventListener;
import net.minecraft.realms.RealmsScreen;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RealmsInviteScreen
extends RealmsScreen {
    private static final Logger LOGGER = LogManager.getLogger();
    private RealmsEditBox profileName;
    private final RealmsServer serverData;
    private final RealmsConfigureWorldScreen configureScreen;
    private final RealmsScreen lastScreen;
    private final int BUTTON_INVITE_ID = 0;
    private final int BUTTON_CANCEL_ID = 1;
    private RealmsButton inviteButton;
    private final int PROFILENAME_EDIT_BOX = 2;
    private String errorMsg;
    private boolean showError;

    public RealmsInviteScreen(RealmsConfigureWorldScreen configureScreen, RealmsScreen lastScreen, RealmsServer serverData) {
        this.configureScreen = configureScreen;
        this.lastScreen = lastScreen;
        this.serverData = serverData;
    }

    public void tick() {
        this.profileName.tick();
    }

    public void init() {
        this.setKeyboardHandlerSendRepeatsToGui(true);
        this.inviteButton = new RealmsButton(0, this.width() / 2 - 100, RealmsConstants.row(10), RealmsInviteScreen.getLocalizedString((String)"mco.configure.world.buttons.invite")){

            public void onClick(double mouseX, double mouseY) {
                RealmsInviteScreen.this.onInvite();
            }
        };
        this.buttonsAdd(this.inviteButton);
        this.buttonsAdd(new RealmsButton(1, this.width() / 2 - 100, RealmsConstants.row(12), RealmsInviteScreen.getLocalizedString((String)"gui.cancel")){

            public void onClick(double mouseX, double mouseY) {
                Realms.setScreen((RealmsScreen)RealmsInviteScreen.this.lastScreen);
            }
        });
        this.profileName = this.newEditBox(2, this.width() / 2 - 100, RealmsConstants.row(2), 200, 20);
        this.focusOn((RealmsGuiEventListener)this.profileName);
        this.addWidget((RealmsGuiEventListener)this.profileName);
    }

    public void removed() {
        this.setKeyboardHandlerSendRepeatsToGui(false);
    }

    private void onInvite() {
        RealmsClient client = RealmsClient.createRealmsClient();
        if (this.profileName.getValue() == null || this.profileName.getValue().isEmpty()) {
            return;
        }
        try {
            RealmsServer realmsServer = client.invite(this.serverData.id, this.profileName.getValue().trim());
            if (realmsServer != null) {
                this.serverData.players = realmsServer.players;
                Realms.setScreen((RealmsScreen)new RealmsPlayerScreen(this.configureScreen, this.serverData));
            } else {
                this.showError(RealmsInviteScreen.getLocalizedString((String)"mco.configure.world.players.error"));
            }
        }
        catch (Exception ignored) {
            LOGGER.error("Couldn't invite user");
            this.showError(RealmsInviteScreen.getLocalizedString((String)"mco.configure.world.players.error"));
        }
    }

    private void showError(String errorMsg) {
        this.showError = true;
        this.errorMsg = errorMsg;
    }

    public boolean keyPressed(int eventKey, int scancode, int mods) {
        if (eventKey == 258) {
            this.focusNext();
            return true;
        }
        if (eventKey == 257 || eventKey == 335) {
            this.onInvite();
            return true;
        }
        if (eventKey == 256) {
            Realms.setScreen((RealmsScreen)this.lastScreen);
            return true;
        }
        return super.keyPressed(eventKey, scancode, mods);
    }

    public void render(int xm, int ym, float a) {
        this.renderBackground();
        this.drawString(RealmsInviteScreen.getLocalizedString((String)"mco.configure.world.invite.profile.name"), this.width() / 2 - 100, RealmsConstants.row(1), 0xA0A0A0);
        if (this.showError) {
            this.drawCenteredString(this.errorMsg, this.width() / 2, RealmsConstants.row(5), 0xFF0000);
        }
        this.profileName.render(xm, ym, a);
        super.render(xm, ym, a);
    }
}

