/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.systems;

import com.google.common.collect.Queues;
import com.mojang.blaze3d.platform.GLX;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallbackI;

public class RenderSystem {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ConcurrentLinkedQueue<cwz> recordingQueue = Queues.newConcurrentLinkedQueue();
    private static final cyj RENDER_THREAD_TESSELATOR = new cyj();
    public static final float DEFAULTALPHACUTOFF = 0.1f;
    private static final int MINIMUM_ATLAS_TEXTURE_SIZE = 1024;
    private static boolean isReplayingQueue;
    private static Thread gameThread;
    private static Thread renderThread;
    private static int MAX_SUPPORTED_TEXTURE_SIZE;
    private static boolean isInInit;
    private static double lastDrawTime;

    public static void initRenderThread() {
        if (renderThread != null || gameThread == Thread.currentThread()) {
            throw new IllegalStateException("Could not initialize render thread");
        }
        renderThread = Thread.currentThread();
    }

    public static boolean isOnRenderThread() {
        return Thread.currentThread() == renderThread;
    }

    public static boolean isOnRenderThreadOrInit() {
        return isInInit || RenderSystem.isOnRenderThread();
    }

    public static void initGameThread(boolean bl2) {
        boolean bl3 = \u2603 = renderThread == Thread.currentThread();
        if (gameThread != null || renderThread == null || \u2603 == bl2) {
            throw new IllegalStateException("Could not initialize tick thread");
        }
        gameThread = Thread.currentThread();
    }

    public static boolean isOnGameThread() {
        return true;
    }

    public static boolean isOnGameThreadOrInit() {
        return isInInit || RenderSystem.isOnGameThread();
    }

    public static void assertThread(Supplier<Boolean> supplier) {
        if (!supplier.get().booleanValue()) {
            throw new IllegalStateException("Rendersystem called from wrong thread");
        }
    }

    public static boolean isInInitPhase() {
        return true;
    }

    public static void recordRenderCall(cwz cwz2) {
        recordingQueue.add(cwz2);
    }

    public static void flipFrame(long l2) {
        GLFW.glfwPollEvents();
        RenderSystem.replayQueue();
        cyj.a().c().g();
        GLFW.glfwSwapBuffers((long)l2);
        GLFW.glfwPollEvents();
    }

    public static void replayQueue() {
        isReplayingQueue = true;
        while (!recordingQueue.isEmpty()) {
            cwz cwz2 = recordingQueue.poll();
            cwz2.execute();
        }
        isReplayingQueue = false;
    }

    public static void limitDisplayFPS(int n2) {
        double d2 = lastDrawTime + 1.0 / (double)n2;
        \u2603 = GLFW.glfwGetTime();
        while (\u2603 < d2) {
            GLFW.glfwWaitEventsTimeout((double)(d2 - \u2603));
            \u2603 = GLFW.glfwGetTime();
        }
        lastDrawTime = \u2603;
    }

    public static void pushLightingAttributes() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.a();
    }

    public static void pushTextureAttributes() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.b();
    }

    public static void popAttributes() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.c();
    }

    public static void disableAlphaTest() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.d();
    }

    public static void enableAlphaTest() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.e();
    }

    public static void alphaFunc(int n2, float f2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.a(n2, f2);
    }

    public static void enableLighting() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.f();
    }

    public static void disableLighting() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.g();
    }

    public static void enableColorMaterial() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.h();
    }

    public static void disableColorMaterial() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.i();
    }

    public static void colorMaterial(int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.a(n2, n3);
    }

    public static void normal3f(float f2, float f3, float f4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.a(f2, f3, f4);
    }

    public static void disableDepthTest() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.j();
    }

    public static void enableDepthTest() {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        cxh.k();
    }

    public static void depthFunc(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.b(n2);
    }

    public static void depthMask(boolean bl2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.a(bl2);
    }

    public static void enableBlend() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.m();
    }

    public static void disableBlend() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.l();
    }

    public static void blendFunc(cxh.q q2, cxh.k k2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.b(q2.p, k2.o);
    }

    public static void blendFunc(int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.b(n2, n3);
    }

    public static void blendFuncSeparate(cxh.q q2, cxh.k k2, cxh.q q3, cxh.k k3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.a(q2.p, k2.o, q3.p, k3.o);
    }

    public static void blendFuncSeparate(int n2, int n3, int n4, int n5) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.a(n2, n3, n4, n5);
    }

    public static void blendEquation(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.c(n2);
    }

    public static void blendColor(float f2, float f3, float f4, float f5) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.a(f2, f3, f4, f5);
    }

    public static void enableFog() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.z();
    }

    public static void disableFog() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.A();
    }

    public static void fogMode(cxh.m m2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.p(m2.d);
    }

    public static void fogMode(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.p(n2);
    }

    public static void fogDensity(float f2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.a(f2);
    }

    public static void fogStart(float f2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.b(f2);
    }

    public static void fogEnd(float f2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.c(f2);
    }

    public static void fog(int n2, float f2, float f3, float f4, float f5) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.a(n2, new float[]{f2, f3, f4, f5});
    }

    public static void fogi(int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.m(n2, n3);
    }

    public static void enableCull() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.B();
    }

    public static void disableCull() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.C();
    }

    public static void polygonMode(int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.n(n2, n3);
    }

    public static void enablePolygonOffset() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.D();
    }

    public static void disablePolygonOffset() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.E();
    }

    public static void enableLineOffset() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.F();
    }

    public static void disableLineOffset() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.G();
    }

    public static void polygonOffset(float f2, float f3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.a(f2, f3);
    }

    public static void enableColorLogicOp() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.H();
    }

    public static void disableColorLogicOp() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.I();
    }

    public static void logicOp(cxh.o o2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.q(o2.q);
    }

    public static void activeTexture(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.r(n2);
    }

    public static void enableTexture() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.J();
    }

    public static void disableTexture() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.K();
    }

    public static void texParameter(int n2, int n3, int n4) {
        cxh.b(n2, n3, n4);
    }

    public static void deleteTexture(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        cxh.s(n2);
    }

    public static void bindTexture(int n2) {
        cxh.t(n2);
    }

    public static void shadeModel(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.u(n2);
    }

    public static void enableRescaleNormal() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.M();
    }

    public static void disableRescaleNormal() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.N();
    }

    public static void viewport(int n2, int n3, int n4, int n5) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        cxh.e(n2, n3, n4, n5);
    }

    public static void colorMask(boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.a(bl2, bl3, bl4, bl5);
    }

    public static void stencilFunc(int n2, int n3, int n4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.d(n2, n3, n4);
    }

    public static void stencilMask(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.v(n2);
    }

    public static void stencilOp(int n2, int n3, int n4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.e(n2, n3, n4);
    }

    public static void clearDepth(double d2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        cxh.a(d2);
    }

    public static void clearColor(float f2, float f3, float f4, float f5) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        cxh.b(f2, f3, f4, f5);
    }

    public static void clearStencil(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.w(n2);
    }

    public static void clear(int n2, boolean bl2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        cxh.a(n2, bl2);
    }

    public static void matrixMode(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.x(n2);
    }

    public static void loadIdentity() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.O();
    }

    public static void pushMatrix() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.P();
    }

    public static void popMatrix() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.Q();
    }

    public static void ortho(double d2, double d3, double d4, double d5, double d6, double d7) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.a(d2, d3, d4, d5, d6, d7);
    }

    public static void rotatef(float f2, float f3, float f4, float f5) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.c(f2, f3, f4, f5);
    }

    public static void scalef(float f2, float f3, float f4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.b(f2, f3, f4);
    }

    public static void scaled(double d2, double d3, double d4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.a(d2, d3, d4);
    }

    public static void translatef(float f2, float f3, float f4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.c(f2, f3, f4);
    }

    public static void translated(double d2, double d3, double d4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.b(d2, d3, d4);
    }

    public static void multMatrix(b b2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.b(b2);
    }

    public static void color4f(float f2, float f3, float f4, float f5) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.d(f2, f3, f4, f5);
    }

    public static void color3f(float f2, float f3, float f4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.d(f2, f3, f4, 1.0f);
    }

    public static void clearCurrentColor() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.R();
    }

    public static void drawArrays(int n2, int n3, int n4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.f(n2, n3, n4);
    }

    public static void lineWidth(float f2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.d(f2);
    }

    public static void pixelStore(int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        cxh.o(n2, n3);
    }

    public static void pixelTransfer(int n2, float f2) {
        cxh.b(n2, f2);
    }

    public static void readPixels(int n2, int n3, int n4, int n5, int n6, int n7, ByteBuffer byteBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.a(n2, n3, n4, n5, n6, n7, byteBuffer);
    }

    public static void getString(int n2, Consumer<String> consumer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        consumer.accept(cxh.C(n2));
    }

    public static String getBackendDescription() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        return String.format("LWJGL version %s", GLX._getLWJGLVersion());
    }

    public static String getApiDescription() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        return GLX.getOpenGLVersionString();
    }

    public static LongSupplier initBackendSystem() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        return GLX._initGlfw();
    }

    public static void initRenderer(int n2, boolean bl2) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        GLX._init(n2, bl2);
    }

    public static void setErrorCallback(GLFWErrorCallbackI gLFWErrorCallbackI) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        GLX._setGlfwErrorCallback(gLFWErrorCallbackI);
    }

    public static void renderCrosshair(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GLX._renderCrosshair(n2, true, true, true);
    }

    public static void setupNvFogDistance() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GLX._setupNvFogDistance();
    }

    public static void glMultiTexCoord2f(int n2, float f2, float f3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.a(n2, f2, f3);
    }

    public static String getCapsString() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        return GLX._getCapsString();
    }

    public static void setupDefaultState(int n2, int n3, int n4, int n5) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        cxh.J();
        cxh.u(7425);
        cxh.a(1.0);
        cxh.k();
        cxh.b(515);
        cxh.e();
        cxh.a(516, 0.1f);
        cxh.x(5889);
        cxh.O();
        cxh.x(5888);
        cxh.e(n2, n3, n4, n5);
    }

    public static int maxSupportedTextureSize() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        if (MAX_SUPPORTED_TEXTURE_SIZE == -1) {
            int n2 = cxh.D(3379);
            for (\u2603 = Math.max(32768, n2); \u2603 >= 1024; \u2603 >>= 1) {
                cxh.a(32868, 0, 6408, \u2603, \u2603, 0, 6408, 5121, null);
                \u2603 = cxh.c(32868, 0, 4096);
                if (\u2603 == 0) continue;
                MAX_SUPPORTED_TEXTURE_SIZE = \u2603;
                return \u2603;
            }
            MAX_SUPPORTED_TEXTURE_SIZE = Math.max(n2, 1024);
            LOGGER.info("Failed to determine maximum texture size by probing, trying GL_MAX_TEXTURE_SIZE = {}", (Object)MAX_SUPPORTED_TEXTURE_SIZE);
        }
        return MAX_SUPPORTED_TEXTURE_SIZE;
    }

    public static void glBindBuffer(int n2, Supplier<Integer> supplier) {
        cxh.g(n2, supplier.get());
    }

    public static void glBufferData(int n2, ByteBuffer byteBuffer, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        cxh.a(n2, byteBuffer, n3);
    }

    public static void glDeleteBuffers(int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.j(n2);
    }

    public static void glUniform1i(int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.f(n2, n3);
    }

    public static void glUniform1(int n2, IntBuffer intBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.a(n2, intBuffer);
    }

    public static void glUniform2(int n2, IntBuffer intBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.b(n2, intBuffer);
    }

    public static void glUniform3(int n2, IntBuffer intBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.c(n2, intBuffer);
    }

    public static void glUniform4(int n2, IntBuffer intBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.d(n2, intBuffer);
    }

    public static void glUniform1(int n2, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.b(n2, floatBuffer);
    }

    public static void glUniform2(int n2, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.c(n2, floatBuffer);
    }

    public static void glUniform3(int n2, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.d(n2, floatBuffer);
    }

    public static void glUniform4(int n2, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.e(n2, floatBuffer);
    }

    public static void glUniformMatrix2(int n2, boolean bl2, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.a(n2, bl2, floatBuffer);
    }

    public static void glUniformMatrix3(int n2, boolean bl2, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.b(n2, bl2, floatBuffer);
    }

    public static void glUniformMatrix4(int n2, boolean bl2, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.c(n2, bl2, floatBuffer);
    }

    public static void setupOutline() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.r();
    }

    public static void teardownOutline() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.s();
    }

    public static void setupOverlayColor(IntSupplier intSupplier, int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.l(intSupplier.getAsInt(), n2);
    }

    public static void teardownOverlayColor() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.t();
    }

    public static void setupLevelDiffuseLighting(b b2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.a(b2);
    }

    public static void setupGuiFlatDiffuseLighting() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.u();
    }

    public static void setupGui3DDiffuseLighting() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.v();
    }

    public static void mulTextureByProjModelView() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.y();
    }

    public static void setupEndPortalTexGen() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.w();
    }

    public static void clearTexGen() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        cxh.x();
    }

    public static void beginInitialization() {
        isInInit = true;
    }

    public static void finishInitialization() {
        isInInit = false;
        if (!recordingQueue.isEmpty()) {
            RenderSystem.replayQueue();
        }
        if (!recordingQueue.isEmpty()) {
            throw new IllegalStateException("Recorded to render queue during initialization");
        }
    }

    public static void glGenBuffers(Consumer<Integer> consumer) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> consumer.accept(cxh.o()));
        } else {
            consumer.accept(cxh.o());
        }
    }

    public static cyj renderThreadTesselator() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return RENDER_THREAD_TESSELATOR;
    }

    public static void defaultBlendFunc() {
        RenderSystem.blendFuncSeparate(cxh.q.l, cxh.k.j, cxh.q.e, cxh.k.n);
    }

    public static void defaultAlphaFunc() {
        RenderSystem.alphaFunc(516, 0.1f);
    }

    private static /* synthetic */ void lambda$setupLevelDiffuseLighting$68(b b2) {
        cxh.a(b2);
    }

    private static /* synthetic */ void lambda$setupOverlayColor$67(IntSupplier intSupplier, int n2) {
        cxh.l(intSupplier.getAsInt(), n2);
    }

    private static /* synthetic */ void lambda$glUniformMatrix4$66(int n2, boolean bl2, FloatBuffer floatBuffer) {
        cxh.c(n2, bl2, floatBuffer);
    }

    private static /* synthetic */ void lambda$glUniformMatrix3$65(int n2, boolean bl2, FloatBuffer floatBuffer) {
        cxh.b(n2, bl2, floatBuffer);
    }

    private static /* synthetic */ void lambda$glUniformMatrix2$64(int n2, boolean bl2, FloatBuffer floatBuffer) {
        cxh.a(n2, bl2, floatBuffer);
    }

    private static /* synthetic */ void lambda$glUniform4$63(int n2, FloatBuffer floatBuffer) {
        cxh.e(n2, floatBuffer);
    }

    private static /* synthetic */ void lambda$glUniform3$62(int n2, FloatBuffer floatBuffer) {
        cxh.d(n2, floatBuffer);
    }

    private static /* synthetic */ void lambda$glUniform2$61(int n2, FloatBuffer floatBuffer) {
        cxh.c(n2, floatBuffer);
    }

    private static /* synthetic */ void lambda$glUniform1$60(int n2, FloatBuffer floatBuffer) {
        cxh.b(n2, floatBuffer);
    }

    private static /* synthetic */ void lambda$glUniform4$59(int n2, IntBuffer intBuffer) {
        cxh.d(n2, intBuffer);
    }

    private static /* synthetic */ void lambda$glUniform3$58(int n2, IntBuffer intBuffer) {
        cxh.c(n2, intBuffer);
    }

    private static /* synthetic */ void lambda$glUniform2$57(int n2, IntBuffer intBuffer) {
        cxh.b(n2, intBuffer);
    }

    private static /* synthetic */ void lambda$glUniform1$56(int n2, IntBuffer intBuffer) {
        cxh.a(n2, intBuffer);
    }

    private static /* synthetic */ void lambda$glUniform1i$55(int n2, int n3) {
        cxh.f(n2, n3);
    }

    private static /* synthetic */ void lambda$glDeleteBuffers$54(int n2) {
        cxh.j(n2);
    }

    private static /* synthetic */ void lambda$glBindBuffer$53(int n2, Supplier supplier) {
        cxh.g(n2, (Integer)supplier.get());
    }

    private static /* synthetic */ void lambda$glMultiTexCoord2f$52(int n2, float f2, float f3) {
        cxh.a(n2, f2, f3);
    }

    private static /* synthetic */ void lambda$renderCrosshair$51(int n2) {
        GLX._renderCrosshair(n2, true, true, true);
    }

    private static /* synthetic */ void lambda$getString$50(int n2, Consumer consumer) {
        String string = cxh.C(n2);
        consumer.accept(string);
    }

    private static /* synthetic */ void lambda$readPixels$49(int n2, int n3, int n4, int n5, int n6, int n7, ByteBuffer byteBuffer) {
        cxh.a(n2, n3, n4, n5, n6, n7, byteBuffer);
    }

    private static /* synthetic */ void lambda$pixelTransfer$48(int n2, float f2) {
        cxh.b(n2, f2);
    }

    private static /* synthetic */ void lambda$pixelStore$47(int n2, int n3) {
        cxh.o(n2, n3);
    }

    private static /* synthetic */ void lambda$lineWidth$46(float f2) {
        cxh.d(f2);
    }

    private static /* synthetic */ void lambda$drawArrays$45(int n2, int n3, int n4) {
        cxh.f(n2, n3, n4);
    }

    private static /* synthetic */ void lambda$color3f$44(float f2, float f3, float f4) {
        cxh.d(f2, f3, f4, 1.0f);
    }

    private static /* synthetic */ void lambda$color4f$43(float f2, float f3, float f4, float f5) {
        cxh.d(f2, f3, f4, f5);
    }

    private static /* synthetic */ void lambda$multMatrix$42(b b2) {
        cxh.b(b2);
    }

    private static /* synthetic */ void lambda$translated$41(double d2, double d3, double d4) {
        cxh.b(d2, d3, d4);
    }

    private static /* synthetic */ void lambda$translatef$40(float f2, float f3, float f4) {
        cxh.c(f2, f3, f4);
    }

    private static /* synthetic */ void lambda$scaled$39(double d2, double d3, double d4) {
        cxh.a(d2, d3, d4);
    }

    private static /* synthetic */ void lambda$scalef$38(float f2, float f3, float f4) {
        cxh.b(f2, f3, f4);
    }

    private static /* synthetic */ void lambda$rotatef$37(float f2, float f3, float f4, float f5) {
        cxh.c(f2, f3, f4, f5);
    }

    private static /* synthetic */ void lambda$ortho$36(double d2, double d3, double d4, double d5, double d6, double d7) {
        cxh.a(d2, d3, d4, d5, d6, d7);
    }

    private static /* synthetic */ void lambda$matrixMode$35(int n2) {
        cxh.x(n2);
    }

    private static /* synthetic */ void lambda$clear$34(int n2, boolean bl2) {
        cxh.a(n2, bl2);
    }

    private static /* synthetic */ void lambda$clearStencil$33(int n2) {
        cxh.w(n2);
    }

    private static /* synthetic */ void lambda$clearColor$32(float f2, float f3, float f4, float f5) {
        cxh.b(f2, f3, f4, f5);
    }

    private static /* synthetic */ void lambda$clearDepth$31(double d2) {
        cxh.a(d2);
    }

    private static /* synthetic */ void lambda$stencilOp$30(int n2, int n3, int n4) {
        cxh.e(n2, n3, n4);
    }

    private static /* synthetic */ void lambda$stencilMask$29(int n2) {
        cxh.v(n2);
    }

    private static /* synthetic */ void lambda$stencilFunc$28(int n2, int n3, int n4) {
        cxh.d(n2, n3, n4);
    }

    private static /* synthetic */ void lambda$colorMask$27(boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        cxh.a(bl2, bl3, bl4, bl5);
    }

    private static /* synthetic */ void lambda$viewport$26(int n2, int n3, int n4, int n5) {
        cxh.e(n2, n3, n4, n5);
    }

    private static /* synthetic */ void lambda$shadeModel$25(int n2) {
        cxh.u(n2);
    }

    private static /* synthetic */ void lambda$bindTexture$24(int n2) {
        cxh.t(n2);
    }

    private static /* synthetic */ void lambda$deleteTexture$23(int n2) {
        cxh.s(n2);
    }

    private static /* synthetic */ void lambda$texParameter$22(int n2, int n3, int n4) {
        cxh.b(n2, n3, n4);
    }

    private static /* synthetic */ void lambda$activeTexture$21(int n2) {
        cxh.r(n2);
    }

    private static /* synthetic */ void lambda$logicOp$20(cxh.o o2) {
        cxh.q(o2.q);
    }

    private static /* synthetic */ void lambda$polygonOffset$19(float f2, float f3) {
        cxh.a(f2, f3);
    }

    private static /* synthetic */ void lambda$polygonMode$18(int n2, int n3) {
        cxh.n(n2, n3);
    }

    private static /* synthetic */ void lambda$fogi$17(int n2, int n3) {
        cxh.m(n2, n3);
    }

    private static /* synthetic */ void lambda$fog$16(int n2, float f2, float f3, float f4, float f5) {
        cxh.a(n2, new float[]{f2, f3, f4, f5});
    }

    private static /* synthetic */ void lambda$fogEnd$15(float f2) {
        cxh.c(f2);
    }

    private static /* synthetic */ void lambda$fogStart$14(float f2) {
        cxh.b(f2);
    }

    private static /* synthetic */ void lambda$fogDensity$13(float f2) {
        cxh.a(f2);
    }

    private static /* synthetic */ void lambda$fogMode$12(int n2) {
        cxh.p(n2);
    }

    private static /* synthetic */ void lambda$fogMode$11(cxh.m m2) {
        cxh.p(m2.d);
    }

    private static /* synthetic */ void lambda$blendColor$10(float f2, float f3, float f4, float f5) {
        cxh.a(f2, f3, f4, f5);
    }

    private static /* synthetic */ void lambda$blendEquation$9(int n2) {
        cxh.c(n2);
    }

    private static /* synthetic */ void lambda$blendFuncSeparate$8(int n2, int n3, int n4, int n5) {
        cxh.a(n2, n3, n4, n5);
    }

    private static /* synthetic */ void lambda$blendFuncSeparate$7(cxh.q q2, cxh.k k2, cxh.q q3, cxh.k k3) {
        cxh.a(q2.p, k2.o, q3.p, k3.o);
    }

    private static /* synthetic */ void lambda$blendFunc$6(int n2, int n3) {
        cxh.b(n2, n3);
    }

    private static /* synthetic */ void lambda$blendFunc$5(cxh.q q2, cxh.k k2) {
        cxh.b(q2.p, k2.o);
    }

    private static /* synthetic */ void lambda$depthMask$4(boolean bl2) {
        cxh.a(bl2);
    }

    private static /* synthetic */ void lambda$depthFunc$3(int n2) {
        cxh.b(n2);
    }

    private static /* synthetic */ void lambda$normal3f$2(float f2, float f3, float f4) {
        cxh.a(f2, f3, f4);
    }

    private static /* synthetic */ void lambda$colorMaterial$1(int n2, int n3) {
        cxh.a(n2, n3);
    }

    private static /* synthetic */ void lambda$alphaFunc$0(int n2, float f2) {
        cxh.a(n2, f2);
    }

    static {
        MAX_SUPPORTED_TEXTURE_SIZE = -1;
        lastDrawTime = Double.MIN_VALUE;
    }
}

