/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.datafixers.types.constant;

import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.types.templates.Const;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;

public final class FloatType
extends Const.ConstType<Float> {
    @Override
    public <T> Pair<T, Optional<Float>> read(DynamicOps<T> ops, T input) {
        return ops.getNumberValue(input).map(v -> Pair.of(ops.empty(), Optional.of(Float.valueOf(v.floatValue())))).orElseGet(() -> Pair.of(input, Optional.empty()));
    }

    @Override
    public <T> T write(DynamicOps<T> ops, T rest, Float value) {
        return ops.createFloat(value.floatValue());
    }

    public String toString() {
        return "Float";
    }
}

