/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiScreenEvent
extends Event {
    private final bho gui;

    public GuiScreenEvent(bho gui) {
        this.gui = gui;
    }

    public bho getGui() {
        return this.gui;
    }

    public static class KeyboardInputEvent
    extends GuiScreenEvent {
        public KeyboardInputEvent(bho gui) {
            super(gui);
        }

        @Cancelable
        public static class Post
        extends KeyboardInputEvent {
            public Post(bho gui) {
                super(gui);
            }
        }

        @Cancelable
        public static class Pre
        extends KeyboardInputEvent {
            public Pre(bho gui) {
                super(gui);
            }
        }
    }

    public static class MouseInputEvent
    extends GuiScreenEvent {
        public MouseInputEvent(bho gui) {
            super(gui);
        }

        @Cancelable
        public static class Post
        extends MouseInputEvent {
            public Post(bho gui) {
                super(gui);
            }
        }

        @Cancelable
        public static class Pre
        extends MouseInputEvent {
            public Pre(bho gui) {
                super(gui);
            }
        }
    }

    public static class ActionPerformedEvent
    extends GuiScreenEvent {
        private bfm button;
        private List<bfm> buttonList;

        public ActionPerformedEvent(bho gui, bfm button, List<bfm> buttonList) {
            super(gui);
            this.setButton(button);
            this.setButtonList(new ArrayList<bfm>(buttonList));
        }

        public bfm getButton() {
            return this.button;
        }

        public void setButton(bfm button) {
            this.button = button;
        }

        public List<bfm> getButtonList() {
            return this.buttonList;
        }

        public void setButtonList(List<bfm> buttonList) {
            this.buttonList = buttonList;
        }

        public static class Post
        extends ActionPerformedEvent {
            public Post(bho gui, bfm button, List<bfm> buttonList) {
                super(gui, button, buttonList);
            }
        }

        @Cancelable
        public static class Pre
        extends ActionPerformedEvent {
            public Pre(bho gui, bfm button, List<bfm> buttonList) {
                super(gui, button, buttonList);
            }
        }
    }

    @Cancelable
    public static class PotionShiftEvent
    extends GuiScreenEvent {
        public PotionShiftEvent(bho gui) {
            super(gui);
        }
    }

    public static class BackgroundDrawnEvent
    extends GuiScreenEvent {
        private final int mouseX;
        private final int mouseY;

        public BackgroundDrawnEvent(bho gui) {
            super(gui);
            bfk scaledresolution = new bfk(gui.j);
            int scaledWidth = scaledresolution.a();
            int scaledHeight = scaledresolution.b();
            this.mouseX = Mouse.getX() * scaledWidth / gui.j.d;
            this.mouseY = scaledHeight - Mouse.getY() * scaledHeight / gui.j.e - 1;
        }

        public int getMouseX() {
            return this.mouseX;
        }

        public int getMouseY() {
            return this.mouseY;
        }
    }

    public static class DrawScreenEvent
    extends GuiScreenEvent {
        private final int mouseX;
        private final int mouseY;
        private final float renderPartialTicks;

        public DrawScreenEvent(bho gui, int mouseX, int mouseY, float renderPartialTicks) {
            super(gui);
            this.mouseX = mouseX;
            this.mouseY = mouseY;
            this.renderPartialTicks = renderPartialTicks;
        }

        public int getMouseX() {
            return this.mouseX;
        }

        public int getMouseY() {
            return this.mouseY;
        }

        public float getRenderPartialTicks() {
            return this.renderPartialTicks;
        }

        public static class Post
        extends DrawScreenEvent {
            public Post(bho gui, int mouseX, int mouseY, float renderPartialTicks) {
                super(gui, mouseX, mouseY, renderPartialTicks);
            }
        }

        @Cancelable
        public static class Pre
        extends DrawScreenEvent {
            public Pre(bho gui, int mouseX, int mouseY, float renderPartialTicks) {
                super(gui, mouseX, mouseY, renderPartialTicks);
            }
        }
    }

    public static class InitGuiEvent
    extends GuiScreenEvent {
        private List<bfm> buttonList;

        public InitGuiEvent(bho gui, List<bfm> buttonList) {
            super(gui);
            this.setButtonList(buttonList);
        }

        public List<bfm> getButtonList() {
            return this.buttonList;
        }

        public void setButtonList(List<bfm> buttonList) {
            this.buttonList = buttonList;
        }

        public static class Post
        extends InitGuiEvent {
            public Post(bho gui, List<bfm> buttonList) {
                super(gui, buttonList);
            }
        }

        @Cancelable
        public static class Pre
        extends InitGuiEvent {
            public Pre(bho gui, List<bfm> buttonList) {
                super(gui, buttonList);
            }
        }
    }
}

