/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

public class ModelStateComposition
implements IModelState {
    private final IModelState first;
    private final IModelState second;

    public ModelStateComposition(IModelState first, IModelState second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public Optional<TRSRTransformation> apply(Optional<? extends IModelPart> part) {
        Optional<TRSRTransformation> f = this.first.apply(part);
        Optional<TRSRTransformation> s = this.second.apply(part);
        if (f.isPresent() && s.isPresent()) {
            return Optional.of((Object)((TRSRTransformation)f.get()).compose((TRSRTransformation)s.get()));
        }
        return f.or(s);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelStateComposition that = (ModelStateComposition)o;
        return Objects.equal((Object)this.first, (Object)that.first) && Objects.equal((Object)this.second, (Object)that.second);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.first, this.second});
    }
}

