/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Multiset;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLLog;

public class DimensionManager {
    private static Hashtable<Integer, lw> worlds = new Hashtable();
    private static boolean hasInit = false;
    private static Hashtable<Integer, Dimension> dimensions = new Hashtable();
    private static IntArrayList unloadQueue = new IntArrayList();
    private static BitSet dimensionMap = new BitSet(1024);
    private static ConcurrentMap<ajs, ajs> weakWorldMap = new MapMaker().weakKeys().weakValues().makeMap();
    private static Multiset<Integer> leakedWorlds = HashMultiset.create();

    public static int[] getDimensions(avg type) {
        int[] ret = new int[dimensions.size()];
        int x = 0;
        for (Map.Entry<Integer, Dimension> ent : dimensions.entrySet()) {
            if (ent.getValue().type != type) continue;
            ret[x++] = ent.getKey();
        }
        return Arrays.copyOf(ret, x);
    }

    public static void init() {
        if (hasInit) {
            return;
        }
        hasInit = true;
        DimensionManager.registerDimension(0, avg.a);
        DimensionManager.registerDimension(-1, avg.b);
        DimensionManager.registerDimension(1, avg.c);
    }

    public static void registerDimension(int id, avg type) {
        avg.a((int)type.a());
        if (dimensions.containsKey(id)) {
            throw new IllegalArgumentException(String.format("Failed to register dimension for id %d, One is already registered", id));
        }
        dimensions.put(id, new Dimension(type));
        if (id >= 0) {
            dimensionMap.set(id);
        }
    }

    public static void unregisterDimension(int id) {
        if (!dimensions.containsKey(id)) {
            throw new IllegalArgumentException(String.format("Failed to unregister dimension for id %d; No provider registered", id));
        }
        dimensions.remove(id);
    }

    public static boolean isDimensionRegistered(int dim) {
        return dimensions.containsKey(dim);
    }

    public static avg getProviderType(int dim) {
        if (!dimensions.containsKey(dim)) {
            throw new IllegalArgumentException(String.format("Could not get provider type for dimension %d, does not exist", dim));
        }
        return dimensions.get(dim).type;
    }

    public static avf getProvider(int dim) {
        return DimensionManager.getWorld((int)dim).s;
    }

    public static Integer[] getIDs(boolean check) {
        if (check) {
            ArrayList allWorlds = Lists.newArrayList(weakWorldMap.keySet());
            allWorlds.removeAll(worlds.values());
            ListIterator li = allWorlds.listIterator();
            while (li.hasNext()) {
                ajs w = (ajs)li.next();
                leakedWorlds.add((Object)System.identityHashCode(w));
            }
            for (ajs w : allWorlds) {
                int leakCount = leakedWorlds.count((Object)System.identityHashCode(w));
                if (leakCount == 5) {
                    FMLLog.log.debug("The world {} ({}) may have leaked: first encounter (5 occurrences).\n", new Object[]{Integer.toHexString(System.identityHashCode(w)), w.T().j()});
                    continue;
                }
                if (leakCount % 5 != 0) continue;
                FMLLog.log.debug("The world {} ({}) may have leaked: seen {} times.\n", new Object[]{Integer.toHexString(System.identityHashCode(w)), w.T().j(), leakCount});
            }
        }
        return DimensionManager.getIDs();
    }

    public static Integer[] getIDs() {
        return worlds.keySet().toArray(new Integer[worlds.size()]);
    }

    public static void setWorld(int id, @Nullable lw world, MinecraftServer server) {
        if (world != null) {
            worlds.put(id, world);
            weakWorldMap.put((ajs)world, (ajs)world);
            server.worldTickTimes.put(id, new long[100]);
            FMLLog.log.info("Loading dimension {} ({}) ({})", new Object[]{id, world.T().j(), world.u()});
        } else {
            worlds.remove(id);
            server.worldTickTimes.remove(id);
            FMLLog.log.info("Unloading dimension {}", new Object[]{id});
        }
        ArrayList<lw> tmp = new ArrayList<lw>();
        if (worlds.get(0) != null) {
            tmp.add(worlds.get(0));
        }
        if (worlds.get(-1) != null) {
            tmp.add(worlds.get(-1));
        }
        if (worlds.get(1) != null) {
            tmp.add(worlds.get(1));
        }
        for (Map.Entry<Integer, lw> entry : worlds.entrySet()) {
            int dim = entry.getKey();
            if (dim >= -1 && dim <= 1) continue;
            tmp.add(entry.getValue());
        }
        server.d = tmp.toArray(new lw[tmp.size()]);
    }

    public static void initDimension(int dim) {
        lw overworld = DimensionManager.getWorld(0);
        if (overworld == null) {
            throw new RuntimeException("Cannot Hotload Dim: Overworld is not Loaded!");
        }
        try {
            DimensionManager.getProviderType(dim);
        }
        catch (Exception e) {
            System.err.println("Cannot Hotload Dim: " + e.getMessage());
            return;
        }
        MinecraftServer mcServer = overworld.u();
        bbw savehandler = overworld.S();
        lw world = dim == 0 ? overworld : (lw)new ls(mcServer, savehandler, dim, overworld, mcServer.c).b();
        world.a((aju)new lx(mcServer, world));
        MinecraftForge.EVENT_BUS.post(new WorldEvent.Load((ajs)world));
        if (!mcServer.R()) {
            world.T().a(mcServer.n());
        }
        mcServer.a(mcServer.o());
    }

    public static lw getWorld(int id) {
        return worlds.get(id);
    }

    public static lw[] getWorlds() {
        return worlds.values().toArray(new lw[worlds.size()]);
    }

    public static Integer[] getStaticDimensionIDs() {
        return dimensions.keySet().toArray(new Integer[dimensions.keySet().size()]);
    }

    public static avf createProviderFor(int dim) {
        try {
            if (dimensions.containsKey(dim)) {
                avf ret = DimensionManager.getProviderType(dim).d();
                ret.setDimension(dim);
                return ret;
            }
            throw new RuntimeException(String.format("No WorldProvider bound for dimension %d", dim));
        }
        catch (Exception e) {
            FMLLog.log.error("An error occurred trying to create an instance of WorldProvider {} ({})", new Object[]{dim, DimensionManager.getProviderType(dim), e});
            throw new RuntimeException(e);
        }
    }

    public static void unloadWorld(int id) {
        if (!unloadQueue.contains(id)) {
            FMLLog.log.debug("Queueing dimension {} to unload", new Object[]{id});
            unloadQueue.add(id);
        } else {
            dimensions.get(id).ticksWaited = 0;
        }
    }

    public static boolean isWorldQueuedToUnload(int id) {
        return unloadQueue.contains(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unloadWorlds(Hashtable<Integer, long[]> worldTickTimes) {
        IntListIterator queueIterator = unloadQueue.iterator();
        while (queueIterator.hasNext()) {
            int id = (Integer)queueIterator.next();
            Dimension dimension = dimensions.get(id);
            if (dimension.ticksWaited < ForgeModContainer.dimensionUnloadQueueDelay) {
                dimension.ticksWaited++;
                continue;
            }
            lw w = worlds.get(id);
            queueIterator.remove();
            dimension.ticksWaited = 0;
            if (w == null || !ForgeChunkManager.getPersistentChunksFor((ajs)w).isEmpty() || !w.i.isEmpty() || dimension.type.shouldLoadSpawn()) {
                FMLLog.log.debug("Aborting unload for dimension {} as status changed", new Object[]{id});
                continue;
            }
            try {
                w.a(true, null);
            }
            catch (ajt e) {
                e.printStackTrace();
            }
            finally {
                MinecraftForge.EVENT_BUS.post(new WorldEvent.Unload((ajs)w));
                w.s();
                DimensionManager.setWorld(id, null, w.u());
            }
        }
    }

    public static int getNextFreeDimId() {
        int next = 0;
        while (dimensions.containsKey(next = dimensionMap.nextClearBit(next))) {
            dimensionMap.set(next);
        }
        return next;
    }

    public static du saveDimensionDataMap() {
        int[] data = new int[(dimensionMap.length() + 32 - 1) / 32];
        du dimMap = new du();
        for (int i = 0; i < data.length; ++i) {
            int val = 0;
            for (int j = 0; j < 32; ++j) {
                val |= dimensionMap.get(i * 32 + j) ? 1 << j : 0;
            }
            data[i] = val;
        }
        dimMap.a("DimensionArray", data);
        return dimMap;
    }

    public static void loadDimensionDataMap(@Nullable du compoundTag) {
        dimensionMap.clear();
        if (compoundTag == null) {
            for (Integer id : dimensions.keySet()) {
                if (id < 0) continue;
                dimensionMap.set(id);
            }
        } else {
            int[] intArray = compoundTag.n("DimensionArray");
            for (int i = 0; i < intArray.length; ++i) {
                for (int j = 0; j < 32; ++j) {
                    dimensionMap.set(i * 32 + j, (intArray[i] & 1 << j) != 0);
                }
            }
        }
    }

    @Nullable
    public static File getCurrentSaveRootDirectory() {
        if (DimensionManager.getWorld(0) != null) {
            return DimensionManager.getWorld(0).S().b();
        }
        return null;
    }

    static {
        DimensionManager.init();
    }

    private static class Dimension {
        private final avg type;
        private int ticksWaited;

        private Dimension(avg type) {
            this.type = type;
            this.ticksWaited = 0;
        }
    }
}

