/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.base.Throwables;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ExistingSubstitutionException;
import net.minecraftforge.fml.common.registry.FMLControlledNamespacedRegistry;
import net.minecraftforge.fml.common.registry.FinalFieldHelper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.common.registry.LegacyNamespacedRegistry;
import net.minecraftforge.fml.common.registry.PersistentRegistryManager;
import net.minecraftforge.fml.common.registry.RegistryBuilder;
import net.minecraftforge.fml.common.registry.RegistryDelegate;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class GameData {
    private static final int MIN_BLOCK_ID = 0;
    private static final int MAX_BLOCK_ID = 4095;
    private static final int MIN_ITEM_ID = 4096;
    private static final int MAX_ITEM_ID = 31999;
    private static final int MIN_POTION_ID = 0;
    private static final int MAX_POTION_ID = 255;
    private static final int MIN_BIOME_ID = 0;
    private static final int MAX_BIOME_ID = 255;
    private static final int MIN_SOUND_ID = 0;
    private static final int MAX_SOUND_ID = 0x3FFFFFF;
    private static final int MIN_POTIONTYPE_ID = 0;
    private static final int MAX_POTIONTYPE_ID = 0x3FFFFFF;
    private static final int MIN_ENCHANTMENT_ID = 0;
    private static final int MAX_ENCHANTMENT_ID = 32766;
    private static final int MIN_ENTITY_ID = 0;
    private static final int MAX_ENTITY_ID = 0x3FFFFFF;
    private static final kq BLOCK_TO_ITEM = new kq("minecraft:blocktoitemmap");
    private static final kq BLOCKSTATE_TO_ID = new kq("minecraft:blockstatetoid");
    private static final GameData mainData = new GameData();
    private static Field blockField;
    private final FMLControlledNamespacedRegistry<alu> iBlockRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.BLOCKS, alu.class, new kq("minecraft:air"), 0, 4095, true, BlockCallbacks.INSTANCE, BlockCallbacks.INSTANCE, BlockCallbacks.INSTANCE, BlockCallbacks.INSTANCE);
    private final FMLControlledNamespacedRegistry<afh> iItemRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.ITEMS, afh.class, null, 4096, 31999, true, ItemCallbacks.INSTANCE, ItemCallbacks.INSTANCE, ItemCallbacks.INSTANCE, ItemCallbacks.INSTANCE);
    private final FMLControlledNamespacedRegistry<sg> iPotionRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.POTIONS, sg.class, null, 0, 255, false, PotionCallbacks.INSTANCE, PotionCallbacks.INSTANCE, PotionCallbacks.INSTANCE, null);
    private final FMLControlledNamespacedRegistry<akf> iBiomeRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.BIOMES, akf.class, null, 0, 255, false, BiomeCallbacks.INSTANCE, BiomeCallbacks.INSTANCE, BiomeCallbacks.INSTANCE, null);
    private final FMLControlledNamespacedRegistry<nm> iSoundEventRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.SOUNDEVENTS, nm.class, null, 0, 0x3FFFFFF, false, null, null, null, null);
    private final FMLControlledNamespacedRegistry<agy> iPotionTypeRegistry;
    private final FMLControlledNamespacedRegistry<aii> iEnchantmentRegistry;
    private final FMLControlledNamespacedRegistry<EntityEntry> iEntityRegistry;
    private final LegacyNamespacedRegistry<Class<? extends asc>> iTileEntityRegistry;

    public GameData() {
        kq WATER = new kq("water");
        this.iPotionTypeRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.POTIONTYPES, agy.class, WATER, 0, 0x3FFFFFF, false, null, null, null, null);
        this.iEnchantmentRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.ENCHANTMENTS, aii.class, null, 0, 32766, false, null, null, null, null);
        this.iEntityRegistry = (FMLControlledNamespacedRegistry)new RegistryBuilder().setName(PersistentRegistryManager.ENTITIES).setType(EntityEntry.class).setIDRange(0, 0x3FFFFFF).addCallback(EntityCallbacks.INSTANCE).create();
        try {
            blockField = FinalFieldHelper.makeWritable(ReflectionHelper.findField(adv.class, "block", "field_150939_a"));
        }
        catch (Exception e2) {
            FMLLog.log.fatal("Cannot access the 'block' field from ItemBlock, this is fatal!", (Throwable)e2);
            throw Throwables.propagate((Throwable)e2);
        }
        this.iTileEntityRegistry = new LegacyNamespacedRegistry();
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<alu> getBlockRegistry() {
        return GameData.getMain().iBlockRegistry;
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<afh> getItemRegistry() {
        return GameData.getMain().iItemRegistry;
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<sg> getPotionRegistry() {
        return GameData.getMain().iPotionRegistry;
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<akf> getBiomeRegistry() {
        return GameData.getMain().iBiomeRegistry;
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<nm> getSoundEventRegistry() {
        return GameData.getMain().iSoundEventRegistry;
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<agy> getPotionTypesRegistry() {
        return GameData.getMain().iPotionTypeRegistry;
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<aii> getEnchantmentRegistry() {
        return GameData.getMain().iEnchantmentRegistry;
    }

    @Deprecated
    public static LegacyNamespacedRegistry<Class<? extends asc>> getTileEntityRegistry() {
        return GameData.getMain().iTileEntityRegistry;
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<EntityEntry> getEntityRegistry() {
        return GameData.getMain().iEntityRegistry;
    }

    @Deprecated
    static afh findItem(String modId, String name) {
        return GameData.getMain().iItemRegistry.getObject(new kq(modId, name));
    }

    @Deprecated
    static alu findBlock(String modId, String name) {
        return GameData.getMain().iBlockRegistry.getObject(new kq(modId, name));
    }

    protected static GameData getMain() {
        return mainData;
    }

    void registerSubstitutionAlias(String name, GameRegistry.Type type, Object toReplace) throws ExistingSubstitutionException {
        kq nameToSubstitute = new kq(name);
        BiMap<alu, afh> blockItemMap = GameData.getBlockItemMap();
        if (type == GameRegistry.Type.BLOCK) {
            this.iBlockRegistry.addSubstitutionAlias(Loader.instance().activeModContainer().getModId(), nameToSubstitute, (alu)toReplace);
            this.iBlockRegistry.activateSubstitution(nameToSubstitute);
        } else if (type == GameRegistry.Type.ITEM) {
            this.iItemRegistry.addSubstitutionAlias(Loader.instance().activeModContainer().getModId(), nameToSubstitute, (afh)toReplace);
            this.iItemRegistry.activateSubstitution(nameToSubstitute);
        }
    }

    public static BiMap<alu, afh> getBlockItemMap() {
        return GameData.getMain().iItemRegistry.getSlaveMap(BLOCK_TO_ITEM, BiMap.class);
    }

    static <K extends IForgeRegistryEntry<K>> K register_impl(Object object, kq location) {
        if (object == null) {
            FMLLog.log.error("Attempt to register a null object");
            throw new NullPointerException("Attempt to register a null object");
        }
        ((IForgeRegistryEntry)object).setRegistryName(location);
        return GameData.register_impl(object);
    }

    static <K extends IForgeRegistryEntry<K>> K register_impl(Object object) {
        IForgeRegistryEntry castedObj = (IForgeRegistryEntry)object;
        if (object == null) {
            FMLLog.log.error("Attempt to register a null object");
            throw new NullPointerException("Attempt to register a null object");
        }
        if (castedObj.getRegistryName() == null) {
            FMLLog.log.error("Attempt to register object without having set a registry name {} (type {})", new Object[]{object, object.getClass().getName()});
            throw new IllegalArgumentException(String.format("No registry name set for object %s (%s)", object, object.getClass().getName()));
        }
        IForgeRegistry<IForgeRegistryEntry> registry = PersistentRegistryManager.findRegistry(castedObj);
        registry.register(castedObj);
        return (K)castedObj;
    }

    public static cy<atl> getBlockStateIDMap() {
        return GameData.getMain().iBlockRegistry.getSlaveMap(BLOCKSTATE_TO_ID, cy.class);
    }

    public static void vanillaSnapshot() {
        PersistentRegistryManager.freezeVanilla();
    }

    public <T extends IForgeRegistryEntry<T>> RegistryDelegate<T> makeDelegate(T obj, Class<T> rootClass) {
        return PersistentRegistryManager.makeDelegate(obj, rootClass);
    }

    private static class EntityCallbacks
    implements IForgeRegistry.AddCallback<EntityEntry>,
    IForgeRegistry.ClearCallback<EntityEntry>,
    IForgeRegistry.CreateCallback<EntityEntry> {
        static final EntityCallbacks INSTANCE = new EntityCallbacks();

        private EntityCallbacks() {
        }

        @Override
        public void onAdd(EntityEntry entry, int id, Map<kq, ?> slaves) {
            if (entry.getEgg() != null) {
                sp.c.put(entry.getRegistryName(), entry.getEgg());
            }
        }

        @Override
        public void onClear(IForgeRegistry<EntityEntry> registry, Map<kq, ?> slaveset) {
        }

        @Override
        public void onCreate(Map<kq, ?> slaveset, BiMap<kq, ? extends IForgeRegistry<?>> registries) {
        }
    }

    private static class BiomeCallbacks
    implements IForgeRegistry.AddCallback<akf>,
    IForgeRegistry.ClearCallback<akf>,
    IForgeRegistry.CreateCallback<akf> {
        static final BiomeCallbacks INSTANCE = new BiomeCallbacks();

        private BiomeCallbacks() {
        }

        @Override
        public void onAdd(akf biome, int id, Map<kq, ?> slaves) {
        }

        @Override
        public void onClear(IForgeRegistry<akf> registry, Map<kq, ?> slaveset) {
        }

        @Override
        public void onCreate(Map<kq, ?> slaveset, BiMap<kq, ? extends IForgeRegistry<?>> registries) {
        }
    }

    private static class PotionCallbacks
    implements IForgeRegistry.AddCallback<sg>,
    IForgeRegistry.ClearCallback<sg>,
    IForgeRegistry.CreateCallback<sg> {
        static final PotionCallbacks INSTANCE = new PotionCallbacks();

        private PotionCallbacks() {
        }

        @Override
        public void onAdd(sg potion, int id, Map<kq, ?> slaves) {
        }

        @Override
        public void onClear(IForgeRegistry<sg> registry, Map<kq, ?> slaveset) {
        }

        @Override
        public void onCreate(Map<kq, ?> slaveset, BiMap<kq, ? extends IForgeRegistry<?>> registries) {
        }
    }

    private static class ItemCallbacks
    implements IForgeRegistry.AddCallback<afh>,
    IForgeRegistry.ClearCallback<afh>,
    IForgeRegistry.CreateCallback<afh>,
    IForgeRegistry.SubstitutionCallback<afh> {
        static final ItemCallbacks INSTANCE = new ItemCallbacks();

        private ItemCallbacks() {
        }

        @Override
        public void onAdd(afh item, int blockId, Map<kq, ?> slaves) {
            if (item instanceof adv) {
                adv itemBlock = (adv)item;
                BiMap blockToItem = (BiMap)slaves.get(BLOCK_TO_ITEM);
                alu block = (alu)itemBlock.d().delegate.get();
                blockToItem.forcePut((Object)block, (Object)item);
            }
        }

        @Override
        public void onClear(IForgeRegistry<afh> registry, Map<kq, ?> slaveset) {
            Map map = (Map)slaveset.get(BLOCK_TO_ITEM);
            map.clear();
        }

        @Override
        public void onCreate(Map<kq, ?> slaveset, BiMap<kq, ? extends IForgeRegistry<?>> registries) {
            BiMap blockItemMap = ((IForgeRegistry)registries.get((Object)PersistentRegistryManager.BLOCKS)).getSlaveMap(BLOCK_TO_ITEM, BiMap.class);
            slaveset.put(BLOCK_TO_ITEM, blockItemMap);
        }

        @Override
        public void onSubstituteActivated(Map<kq, ?> slaveset, afh original, afh replacement, kq name) {
            BiMap blockItemMap = (BiMap)slaveset.get(BLOCK_TO_ITEM);
        }
    }

    private static class BlockCallbacks
    implements IForgeRegistry.AddCallback<alu>,
    IForgeRegistry.ClearCallback<alu>,
    IForgeRegistry.CreateCallback<alu>,
    IForgeRegistry.SubstitutionCallback<alu> {
        static final BlockCallbacks INSTANCE = new BlockCallbacks();

        private BlockCallbacks() {
        }

        @Override
        public void onAdd(alu block, int blockId, Map<kq, ?> slaves) {
            ClearableObjectIntIdentityMap blockstateMap = (ClearableObjectIntIdentityMap)((Object)slaves.get(BLOCKSTATE_TO_ID));
            boolean[] usedMeta = new boolean[16];
            for (atl state : block.s().a()) {
                int meta = block.e(state);
                blockstateMap.a(state, blockId << 4 | meta);
                usedMeta[meta] = true;
            }
            for (int meta = 0; meta < 16; ++meta) {
                if (!usedMeta[meta]) continue;
                blockstateMap.a(block.a(meta), blockId << 4 | meta);
            }
        }

        @Override
        public void onClear(IForgeRegistry<alu> registry, Map<kq, ?> slaveset) {
            ClearableObjectIntIdentityMap blockstateMap = (ClearableObjectIntIdentityMap)((Object)slaveset.get(BLOCKSTATE_TO_ID));
            blockstateMap.clear();
            Map originals = (Map)slaveset.get(PersistentRegistryManager.SUBSTITUTION_ORIGINALS);
            BiMap blockItemMap = (BiMap)slaveset.get(BLOCK_TO_ITEM);
            for (afh it : blockItemMap.values()) {
                if (!(it instanceof adv)) continue;
                adv itemBlock = (adv)it;
                kq registryKey = registry.getKey(itemBlock.a);
                if (!originals.containsKey(registryKey)) continue;
                try {
                    FinalFieldHelper.setField(blockField, itemBlock, originals.get(registryKey));
                }
                catch (Exception e2) {
                    throw Throwables.propagate((Throwable)e2);
                }
            }
        }

        @Override
        public void onCreate(Map<kq, ?> slaveset, BiMap<kq, ? extends IForgeRegistry<?>> registries) {
            ClearableObjectIntIdentityMap<atl> idMap = new ClearableObjectIntIdentityMap<atl>(){

                public int get(atl key) {
                    Integer integer = (Integer)this.a.get(key);
                    if (integer == null && key != null) {
                        integer = (Integer)this.a.get(key.v().a(key.v().e(key)));
                    }
                    return integer == null ? -1 : integer;
                }
            };
            slaveset.put(BLOCKSTATE_TO_ID, idMap);
            HashBiMap map = HashBiMap.create();
            slaveset.put(BLOCK_TO_ITEM, map);
        }

        @Override
        public void onSubstituteActivated(Map<kq, ?> slaveset, alu original, alu replacement, kq name) {
            BiMap blockItemMap = (BiMap)slaveset.get(BLOCK_TO_ITEM);
            if (blockItemMap.containsKey((Object)original)) {
                afh i = (afh)blockItemMap.get((Object)original);
                if (i instanceof adv) {
                    try {
                        FinalFieldHelper.setField(blockField, i, replacement);
                    }
                    catch (Exception e2) {
                        throw Throwables.propagate((Throwable)e2);
                    }
                }
                blockItemMap.forcePut((Object)replacement, (Object)i);
            }
        }
    }

    static class ClearableObjectIntIdentityMap<I>
    extends cy<I> {
        ClearableObjectIntIdentityMap() {
        }

        void clear() {
            this.a.clear();
            this.b.clear();
        }
    }
}

