/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.FMLModContainer;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.relauncher.Side;

public interface ILanguageAdapter {
    public Object getNewInstance(FMLModContainer var1, Class<?> var2, ClassLoader var3, Method var4) throws Exception;

    public boolean supportsStatics();

    public void setProxy(Field var1, Class<?> var2, Object var3) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException;

    public void setInternalProxies(ModContainer var1, Side var2, ClassLoader var3);

    public static class JavaAdapter
    implements ILanguageAdapter {
        @Override
        public Object getNewInstance(FMLModContainer container, Class<?> objectClass, ClassLoader classLoader, Method factoryMarkedMethod) throws Exception {
            if (factoryMarkedMethod != null) {
                return factoryMarkedMethod.invoke(null, new Object[0]);
            }
            return objectClass.newInstance();
        }

        @Override
        public boolean supportsStatics() {
            return true;
        }

        @Override
        public void setProxy(Field target, Class<?> proxyTarget, Object proxy) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
            target.set(null, proxy);
        }

        @Override
        public void setInternalProxies(ModContainer mod, Side side, ClassLoader loader) {
        }
    }

    public static class ScalaAdapter
    implements ILanguageAdapter {
        @Override
        public Object getNewInstance(FMLModContainer container, Class<?> scalaObjectClass, ClassLoader classLoader, Method factoryMarkedAnnotation) throws Exception {
            Class<?> sObjectClass = Class.forName(scalaObjectClass.getName() + "$", true, classLoader);
            return sObjectClass.getField("MODULE$").get(null);
        }

        @Override
        public boolean supportsStatics() {
            return false;
        }

        @Override
        public void setProxy(Field target, Class<?> proxyTarget, Object proxy) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
            try {
                if (!proxyTarget.getName().endsWith("$")) {
                    proxyTarget = Class.forName(proxyTarget.getName() + "$", true, proxyTarget.getClassLoader());
                }
            }
            catch (ClassNotFoundException e) {
                FMLLog.log.info("An error occurred trying to load a proxy into {}.{}. Did you declare your mod as 'class' instead of 'object'?", (Object)proxyTarget.getSimpleName(), (Object)target.getName(), (Object)e);
                return;
            }
            Object targetInstance = proxyTarget.getField("MODULE$").get(null);
            try {
                String setterName = target.getName() + "_$eq";
                for (Method setter : proxyTarget.getMethods()) {
                    Class<?>[] setterParameters = setter.getParameterTypes();
                    if (!setterName.equals(setter.getName()) || setterParameters.length != 1 || !setterParameters[0].isAssignableFrom(proxy.getClass())) continue;
                    setter.invoke(targetInstance, proxy);
                    return;
                }
            }
            catch (InvocationTargetException e) {
                FMLLog.log.error("An error occurred trying to load a proxy into {}.{}", (Object)target.getName(), (Object)e);
                throw new LoaderException(e);
            }
            FMLLog.log.fatal("Failed loading proxy into {}.{}, could not find setter function. Did you declare the field with 'val' instead of 'var'?", (Object)proxyTarget.getSimpleName(), (Object)target.getName());
            throw new LoaderException(String.format("Failed loading proxy into %s.%s, could not find setter function. Did you declare the field with 'val' instead of 'var'?", proxyTarget.getSimpleName(), target.getName()));
        }

        @Override
        public void setInternalProxies(ModContainer mod, Side side, ClassLoader loader) {
            Class<?> proxyTarget = mod.getMod().getClass();
            if (proxyTarget.getName().endsWith("$")) {
                for (Field target : proxyTarget.getDeclaredFields()) {
                    if (target.getAnnotation(SidedProxy.class) == null) continue;
                    String targetType = side.isClient() ? target.getAnnotation(SidedProxy.class).clientSide() : target.getAnnotation(SidedProxy.class).serverSide();
                    try {
                        Object proxy = Class.forName(targetType, true, loader).newInstance();
                        if (!target.getType().isAssignableFrom(proxy.getClass())) {
                            FMLLog.log.fatal("Attempted to load a proxy type {} into {}.{}, but the types don't match", (Object)targetType, (Object)proxyTarget.getSimpleName(), (Object)target.getName());
                            throw new LoaderException(String.format("Attempted to load a proxy type %s into %s.%s, but the types don't match", targetType, proxyTarget.getSimpleName(), target.getName()));
                        }
                        this.setProxy(target, proxyTarget, proxy);
                    }
                    catch (Exception e) {
                        FMLLog.log.error("An error occurred trying to load a proxy into {}.{}", (Object)target.getName(), (Object)e);
                        throw new LoaderException(e);
                    }
                }
            } else {
                FMLLog.log.trace("Mod does not appear to be a singleton.");
            }
        }
    }
}

