/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.datafixers.types;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class JsonOps
implements DynamicOps<JsonElement> {
    public static final JsonOps INSTANCE = new JsonOps();

    protected JsonOps() {
    }

    @Override
    public JsonElement empty() {
        return JsonNull.INSTANCE;
    }

    @Override
    public Type<?> getType(JsonElement input) {
        if (input.isJsonObject()) {
            return DSL.compoundList(DSL.remainderType(), DSL.remainderType());
        }
        if (input.isJsonArray()) {
            return DSL.list(DSL.remainderType());
        }
        if (input.isJsonNull()) {
            return DSL.nilType();
        }
        JsonPrimitive primitive = input.getAsJsonPrimitive();
        if (primitive.isString()) {
            return DSL.string();
        }
        if (primitive.isBoolean()) {
            return DSL.bool();
        }
        BigDecimal value = primitive.getAsBigDecimal();
        try {
            long l = value.longValueExact();
            if ((long)((byte)l) == l) {
                return DSL.byteType();
            }
            if ((long)((short)l) == l) {
                return DSL.shortType();
            }
            if ((long)((int)l) == l) {
                return DSL.intType();
            }
            return DSL.longType();
        }
        catch (ArithmeticException e) {
            double d = value.doubleValue();
            if ((double)((float)d) == d) {
                return DSL.floatType();
            }
            return DSL.doubleType();
        }
    }

    @Override
    public Optional<Number> getNumberValue(JsonElement input) {
        if (input.isJsonPrimitive() && input.getAsJsonPrimitive().isNumber()) {
            return Optional.of(input.getAsNumber());
        }
        return Optional.empty();
    }

    @Override
    public JsonElement createNumeric(Number i) {
        return new JsonPrimitive(i);
    }

    @Override
    public JsonElement createBoolean(boolean value) {
        return new JsonPrimitive(Boolean.valueOf(value));
    }

    @Override
    public Optional<String> getStringValue(JsonElement input) {
        if (input.isJsonPrimitive() && input.getAsJsonPrimitive().isString()) {
            return Optional.of(input.getAsString());
        }
        return Optional.empty();
    }

    @Override
    public JsonElement createString(String value) {
        return new JsonPrimitive(value);
    }

    @Override
    public JsonElement mergeInto(JsonElement input, JsonElement value) {
        if (value.isJsonNull()) {
            return input;
        }
        if (input.isJsonObject()) {
            if (value.isJsonObject()) {
                JsonObject resultObject = new JsonObject();
                JsonObject first = input.getAsJsonObject();
                for (Map.Entry entry : first.entrySet()) {
                    resultObject.add((String)entry.getKey(), (JsonElement)entry.getValue());
                }
                JsonObject second = value.getAsJsonObject();
                for (Map.Entry entry : second.entrySet()) {
                    resultObject.add((String)entry.getKey(), (JsonElement)entry.getValue());
                }
                return resultObject;
            }
            return input;
        }
        if (input.isJsonNull()) {
            throw new IllegalArgumentException("mergeInto called with null input.");
        }
        if (!input.isJsonArray()) {
            return input;
        }
        JsonArray result = new JsonArray();
        StreamSupport.stream(input.getAsJsonArray().spliterator(), false).forEach(arg_0 -> ((JsonArray)result).add(arg_0));
        result.add(value);
        return result;
    }

    @Override
    public JsonElement mergeInto(JsonElement input, JsonElement key, JsonElement value) {
        JsonObject output;
        if (input.isJsonNull()) {
            output = new JsonObject();
        } else if (input.isJsonObject()) {
            output = new JsonObject();
            input.getAsJsonObject().entrySet().forEach(entry -> output.add((String)entry.getKey(), (JsonElement)entry.getValue()));
        } else {
            return input;
        }
        output.add(key.getAsString(), value);
        return output;
    }

    @Override
    public JsonElement merge(JsonElement first, JsonElement second) {
        if (first.isJsonNull()) {
            return second;
        }
        if (second.isJsonNull()) {
            return first;
        }
        if (first.isJsonObject() && second.isJsonObject()) {
            JsonObject result = new JsonObject();
            first.getAsJsonObject().entrySet().forEach(entry -> result.add((String)entry.getKey(), (JsonElement)entry.getValue()));
            second.getAsJsonObject().entrySet().forEach(entry -> result.add((String)entry.getKey(), (JsonElement)entry.getValue()));
            return result;
        }
        if (first.isJsonArray() && second.isJsonArray()) {
            JsonArray result = new JsonArray();
            first.getAsJsonArray().forEach(arg_0 -> ((JsonArray)result).add(arg_0));
            second.getAsJsonArray().forEach(arg_0 -> ((JsonArray)result).add(arg_0));
            return result;
        }
        throw new IllegalArgumentException("Could not merge " + first + " and " + second);
    }

    @Override
    public Optional<Map<JsonElement, JsonElement>> getMapValues(JsonElement input) {
        if (input.isJsonObject()) {
            return Optional.of(input.getAsJsonObject().entrySet().stream().map(entry -> Pair.of(new JsonPrimitive((String)entry.getKey()), entry.getValue())).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond)));
        }
        return Optional.empty();
    }

    @Override
    public JsonElement createMap(Map<JsonElement, JsonElement> map) {
        JsonObject result = new JsonObject();
        for (Map.Entry<JsonElement, JsonElement> entry : map.entrySet()) {
            result.add(entry.getKey().getAsString(), entry.getValue());
        }
        return result;
    }

    @Override
    public Optional<Stream<JsonElement>> getStream(JsonElement input) {
        if (input.isJsonArray()) {
            return Optional.of(StreamSupport.stream(input.getAsJsonArray().spliterator(), false));
        }
        return Optional.empty();
    }

    @Override
    public JsonElement createList(Stream<JsonElement> input) {
        JsonArray result = new JsonArray();
        input.forEach(arg_0 -> ((JsonArray)result).add(arg_0));
        return result;
    }

    @Override
    public JsonElement remove(JsonElement input, String key) {
        if (input.isJsonObject()) {
            JsonObject result = new JsonObject();
            input.getAsJsonObject().entrySet().stream().filter(entry -> !Objects.equals(entry.getKey(), key)).forEach(entry -> result.add((String)entry.getKey(), (JsonElement)entry.getValue()));
            return result;
        }
        return input;
    }

    public String toString() {
        return "JSON";
    }
}

