/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import cpw.mods.modlauncher.LogMarkers;
import cpw.mods.modlauncher.ServiceLoaderStreamUtils;
import cpw.mods.modlauncher.TransformerAuditTrail;
import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;

public class LaunchPluginHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<String, ILaunchPluginService> plugins;

    public LaunchPluginHandler() {
        ServiceLoader<ILaunchPluginService> services = ServiceLoaderStreamUtils.errorHandlingServiceLoader(ILaunchPluginService.class, e -> LOGGER.fatal(LogMarkers.MODLAUNCHER, "Encountered serious error loading launch plugin service. Things will not work well", (Throwable)e));
        this.plugins = ServiceLoaderStreamUtils.toMap(services, ILaunchPluginService::name);
        LOGGER.debug(LogMarkers.MODLAUNCHER, "Found launch plugins: [{}]", new Supplier[]{() -> String.join((CharSequence)",", this.plugins.keySet())});
    }

    public Optional<ILaunchPluginService> get(String name) {
        return Optional.ofNullable(this.plugins.get(name));
    }

    public EnumMap<ILaunchPluginService.Phase, List<ILaunchPluginService>> computeLaunchPluginTransformerSet(Type className, boolean isEmpty) {
        EnumMap<ILaunchPluginService.Phase, List<ILaunchPluginService>> phaseObjectEnumMap = new EnumMap<ILaunchPluginService.Phase, List<ILaunchPluginService>>(ILaunchPluginService.Phase.class);
        this.plugins.forEach((n, pl) -> pl.handlesClass(className, isEmpty).forEach(ph -> phaseObjectEnumMap.computeIfAbsent((ILaunchPluginService.Phase)((Object)ph), e -> new ArrayList()).add(pl)));
        LOGGER.debug(LogMarkers.LAUNCHPLUGIN, "LaunchPluginService {}", new Supplier[]{() -> phaseObjectEnumMap});
        return phaseObjectEnumMap;
    }

    public boolean offerClassNodeToPlugins(ILaunchPluginService.Phase phase, List<ILaunchPluginService> plugins, @Nullable ClassNode node, Type className, TransformerAuditTrail auditTrail) {
        return plugins.stream().peek(iLaunchPluginService -> LOGGER.debug(LogMarkers.LAUNCHPLUGIN, "LauncherPluginService {} transforming {}", (Object)iLaunchPluginService.name(), (Object)className)).peek(iLaunchPluginService -> auditTrail.addPluginAuditTrail(className.getClassName(), (ILaunchPluginService)iLaunchPluginService, phase)).map(iLaunchPluginService -> iLaunchPluginService.processClass(phase, node, className)).reduce(Boolean.FALSE, Boolean::logicalOr);
    }
}

