/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.FancyMissingModel;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ModelDynBucket;
import net.minecraftforge.client.model.ModelFluid;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.MultiLayerModel;
import net.minecraftforge.client.model.b3d.B3DLoader;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.common.animation.ITimeValue;
import net.minecraftforge.common.model.animation.AnimationStateMachine;
import net.minecraftforge.common.model.animation.IAnimationStateMachine;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModelLoaderRegistry {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<ICustomModelLoader> loaders = Sets.newHashSet();
    private static final Map<ResourceLocation, IUnbakedModel> cache = Maps.newHashMap();
    private static final Deque<ResourceLocation> loadingModels = Queues.newArrayDeque();
    private static final Set<ResourceLocation> textures = Sets.newHashSet();
    private static final Map<ResourceLocation, ResourceLocation> aliases = Maps.newHashMap();
    private static IResourceManager manager;

    public static void registerLoader(ICustomModelLoader loader) {
        loaders.add(loader);
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_199006_a((IResourceManagerReloadListener)loader);
    }

    public static boolean loaded(ResourceLocation location) {
        return cache.containsKey(location);
    }

    public static ResourceLocation getActualLocation(ResourceLocation location) {
        if (location instanceof ModelResourceLocation) {
            return location;
        }
        if (location.func_110623_a().startsWith("builtin/")) {
            return location;
        }
        return new ResourceLocation(location.func_110624_b(), "models/" + location.func_110623_a());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IUnbakedModel getModel(ResourceLocation location) throws Exception {
        IUnbakedModel model;
        IUnbakedModel cached = cache.get(location);
        if (cached != null) {
            return cached;
        }
        for (ResourceLocation loading : loadingModels) {
            if (location.getClass() != loading.getClass() || !location.equals((Object)loading)) continue;
            throw new LoaderException("circular model dependencies, stack: [" + Joiner.on((String)", ").join(loadingModels) + "]");
        }
        loadingModels.addLast(location);
        try {
            ResourceLocation aliased = aliases.get(location);
            if (aliased != null) {
                ResourceLocation loading;
                loading = ModelLoaderRegistry.getModel(aliased);
                return loading;
            }
            ResourceLocation actual = ModelLoaderRegistry.getActualLocation(location);
            ICustomModelLoader accepted = null;
            for (ICustomModelLoader loader : loaders) {
                try {
                    if (!loader.accepts(actual)) continue;
                    if (accepted != null) {
                        throw new LoaderException(String.format("2 loaders (%s and %s) want to load the same model %s", accepted, loader, location));
                    }
                    accepted = loader;
                }
                catch (Exception e) {
                    throw new LoaderException(String.format("Exception checking if model %s can be loaded with loader %s, skipping", location, loader), e);
                }
            }
            if (accepted == null) {
                if (ModelLoader.VariantLoader.INSTANCE.accepts(actual)) {
                    accepted = ModelLoader.VariantLoader.INSTANCE;
                } else if (ModelLoader.VanillaLoader.INSTANCE.accepts(actual)) {
                    accepted = ModelLoader.VanillaLoader.INSTANCE;
                }
            }
            if (accepted == null) {
                throw new LoaderException("no suitable loader found for the model " + location + ", skipping");
            }
            try {
                model = accepted.loadModel(actual);
            }
            catch (Exception e) {
                throw new LoaderException(String.format("Exception loading model %s with loader %s, skipping", location, accepted), e);
            }
            if (model == ModelLoaderRegistry.getMissingModel()) {
                throw new LoaderException(String.format("Loader %s returned missing model while loading model %s", accepted, location));
            }
            if (model == null) {
                throw new LoaderException(String.format("Loader %s returned null while loading model %s", accepted, location));
            }
            textures.addAll(model.func_209559_a(ModelLoader.defaultModelGetter(), new HashSet()));
        }
        finally {
            ResourceLocation popLoc = loadingModels.removeLast();
            if (popLoc != location) {
                throw new IllegalStateException("Corrupted loading model stack: " + popLoc + " != " + location);
            }
        }
        cache.put(location, model);
        for (ResourceLocation dep : model.func_187965_e()) {
            ModelLoaderRegistry.getModelOrMissing(dep);
        }
        return model;
    }

    public static IUnbakedModel getModelOrMissing(ResourceLocation location) {
        try {
            return ModelLoaderRegistry.getModel(location);
        }
        catch (Exception e) {
            return ModelLoaderRegistry.getMissingModel(location, e);
        }
    }

    public static IUnbakedModel getModelOrLogError(ResourceLocation location, String error) {
        try {
            return ModelLoaderRegistry.getModel(location);
        }
        catch (Exception e) {
            LOGGER.error(error, (Throwable)e);
            return ModelLoaderRegistry.getMissingModel(location, e);
        }
    }

    public static IUnbakedModel getMissingModel() {
        ModelLoader loader = ModelLoader.VanillaLoader.INSTANCE.getLoader();
        if (loader == null) {
            throw new IllegalStateException("Using ModelLoaderRegistry too early.");
        }
        return loader.getMissingModel();
    }

    static IUnbakedModel getMissingModel(ResourceLocation location, Throwable cause) {
        FancyMissingModel model = new FancyMissingModel(ModelLoaderRegistry.getMissingModel(), location.toString());
        textures.addAll(model.func_209559_a(null, null));
        return model;
    }

    static void addAlias(ResourceLocation from, ResourceLocation to) {
        aliases.put(from, to);
    }

    public static void clearModelCache(IResourceManager manager) {
        ModelLoaderRegistry.manager = manager;
        aliases.clear();
        textures.clear();
        cache.clear();
        cache.put(new ResourceLocation("minecraft:builtin/generated"), ItemLayerModel.INSTANCE);
        cache.put(new ResourceLocation("minecraft:block/builtin/generated"), ItemLayerModel.INSTANCE);
        cache.put(new ResourceLocation("minecraft:item/builtin/generated"), ItemLayerModel.INSTANCE);
    }

    static Iterable<ResourceLocation> getTextures() {
        return textures;
    }

    public static IAnimationStateMachine loadASM(ResourceLocation location, ImmutableMap<String, ITimeValue> customParameters) {
        return AnimationStateMachine.load(manager, location, customParameters);
    }

    static {
        ModelLoaderRegistry.registerLoader(B3DLoader.INSTANCE);
        ModelLoaderRegistry.registerLoader(OBJLoader.INSTANCE);
        ModelLoaderRegistry.registerLoader(ModelFluid.FluidLoader.INSTANCE);
        ModelLoaderRegistry.registerLoader(ItemLayerModel.Loader.INSTANCE);
        ModelLoaderRegistry.registerLoader(MultiLayerModel.Loader.INSTANCE);
        ModelLoaderRegistry.registerLoader(ModelDynBucket.LoaderDynBucket.INSTANCE);
    }

    public static class LoaderException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public LoaderException(String message) {
            super(message);
        }

        public LoaderException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

