/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.extensions;

import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.IMinecartCollisionHandler;

public interface IForgeEntityMinecart {
    public static final float DEFAULT_MAX_SPEED_AIR_LATERAL = 0.4f;
    public static final float DEFAULT_MAX_SPEED_AIR_VERTICAL = -1.0f;
    public static final double DEFAULT_AIR_DRAG = (double)0.95f;
    public static final IMinecartCollisionHandler COLLISIONS = null;

    default public EntityMinecart getMinecart() {
        return (EntityMinecart)this;
    }

    default public IMinecartCollisionHandler getCollisionHandler() {
        return COLLISIONS;
    }

    default public BlockPos getCurrentRailPosition() {
        int z;
        int y;
        int x = MathHelper.func_76128_c((double)this.getMinecart().field_70165_t);
        BlockPos pos = new BlockPos(x, (y = MathHelper.func_76128_c((double)this.getMinecart().field_70163_u)) - 1, z = MathHelper.func_76128_c((double)this.getMinecart().field_70161_v));
        if (this.getMinecart().field_70170_p.func_180495_p(pos).func_203425_a(BlockTags.field_203437_y)) {
            pos = pos.func_177977_b();
        }
        return pos;
    }

    public double getMaxSpeed();

    default public void moveMinecartOnRail(BlockPos pos) {
        EntityMinecart mc = this.getMinecart();
        double mX = mc.field_70159_w;
        double mZ = mc.field_70179_y;
        if (mc.func_184207_aI()) {
            mX *= 0.75;
            mZ *= 0.75;
        }
        double max = this.getMaxSpeed();
        mX = MathHelper.func_151237_a((double)mX, (double)(-max), (double)max);
        mZ = MathHelper.func_151237_a((double)mZ, (double)(-max), (double)max);
        mc.func_70091_d(MoverType.SELF, mX, 0.0, mZ);
    }

    default public ItemStack getCartItem() {
        switch (this.getMinecart().func_184264_v()) {
            case FURNACE: {
                return new ItemStack((IItemProvider)Items.field_151109_aJ);
            }
            case CHEST: {
                return new ItemStack((IItemProvider)Items.field_151108_aI);
            }
            case TNT: {
                return new ItemStack((IItemProvider)Items.field_151142_bV);
            }
            case HOPPER: {
                return new ItemStack((IItemProvider)Items.field_151140_bW);
            }
            case COMMAND_BLOCK: {
                return new ItemStack((IItemProvider)Items.field_151095_cc);
            }
        }
        return new ItemStack((IItemProvider)Items.field_151143_au);
    }

    public boolean canUseRail();

    public void setCanUseRail(boolean var1);

    default public boolean shouldDoRailFunctions() {
        return true;
    }

    default public boolean isPoweredCart() {
        return this.getMinecart().func_184264_v() == EntityMinecart.Type.FURNACE;
    }

    default public boolean canBeRidden() {
        return this.getMinecart().func_184264_v() == EntityMinecart.Type.RIDEABLE;
    }

    default public float getMaxCartSpeedOnRail() {
        return 1.2f;
    }

    public float getCurrentCartSpeedCapOnRail();

    public void setCurrentCartSpeedCapOnRail(float var1);

    public float getMaxSpeedAirLateral();

    public void setMaxSpeedAirLateral(float var1);

    public float getMaxSpeedAirVertical();

    public void setMaxSpeedAirVertical(float var1);

    public double getDragAir();

    public void setDragAir(double var1);

    default public double getSlopeAdjustment() {
        return 0.0078125;
    }

    default public int getComparatorLevel() {
        return -1;
    }
}

