/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common;

import com.google.common.base.Preconditions;
import cpw.mods.modlauncher.api.INameMappingService;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.loading.FMLLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class ObfuscationReflectionHelper {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker REFLECTION = MarkerManager.getMarker((String)"REFLECTION");
    private static final Map<String, String> map = new HashMap<String, String>();
    private static boolean loaded = false;

    public static String remapName(INameMappingService.Domain domain, String name) {
        return FMLLoader.getNameFunction((String)"srg").map(f -> (String)f.apply(domain, name)).orElse(name);
    }

    public static <T, E> T getPrivateValue(Class<? super E> classToAccess, E instance, int fieldIndex) {
        try {
            Field f = classToAccess.getDeclaredFields()[fieldIndex];
            f.setAccessible(true);
            return (T)f.get(instance);
        }
        catch (Exception e) {
            LOGGER.error(REFLECTION, "There was a problem getting field index {} from {}", (Object)fieldIndex, (Object)classToAccess.getName(), (Object)e);
            throw new UnableToAccessFieldException(e);
        }
    }

    public static <T, E> T getPrivateValue(Class<? super E> classToAccess, E instance, String fieldName) {
        try {
            return (T)ObfuscationReflectionHelper.findField(classToAccess, ObfuscationReflectionHelper.remapName(INameMappingService.Domain.FIELD, fieldName)).get(instance);
        }
        catch (UnableToFindFieldException e) {
            LOGGER.error(REFLECTION, "Unable to locate field {} ({}) on type {}", (Object)fieldName, (Object)ObfuscationReflectionHelper.remapName(INameMappingService.Domain.FIELD, fieldName), (Object)classToAccess.getName(), (Object)e);
            throw e;
        }
        catch (IllegalAccessException e) {
            LOGGER.error(REFLECTION, "Unable to access field {} ({}) on type {}", (Object)fieldName, (Object)ObfuscationReflectionHelper.remapName(INameMappingService.Domain.FIELD, fieldName), (Object)classToAccess.getName(), (Object)e);
            throw new UnableToAccessFieldException(e);
        }
    }

    public static <T, E> void setPrivateValue(Class<? super T> classToAccess, T instance, E value, int fieldIndex) {
        try {
            Field f = classToAccess.getDeclaredFields()[fieldIndex];
            f.setAccessible(true);
            f.set(instance, value);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("There was a problem setting field index {} on type {}", (Object)fieldIndex, (Object)classToAccess.getName(), (Object)e);
            throw new UnableToAccessFieldException(e);
        }
    }

    public static <T, E> void setPrivateValue(Class<? super T> classToAccess, T instance, E value, String fieldName) {
        try {
            ObfuscationReflectionHelper.findField(classToAccess, ObfuscationReflectionHelper.remapName(INameMappingService.Domain.FIELD, fieldName)).set(instance, value);
        }
        catch (UnableToFindFieldException e) {
            LOGGER.error("Unable to locate any field {} on type {}", (Object)fieldName, (Object)classToAccess.getName(), (Object)e);
            throw e;
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Unable to set any field {} on type {}", (Object)fieldName, (Object)classToAccess.getName(), (Object)e);
            throw new UnableToAccessFieldException(e);
        }
    }

    @Nonnull
    public static Method findMethod(@Nonnull Class<?> clazz, @Nonnull String methodName, Class<?> ... parameterTypes) {
        Preconditions.checkNotNull(clazz);
        Preconditions.checkNotNull((Object)methodName);
        Preconditions.checkArgument((!methodName.isEmpty() ? 1 : 0) != 0, (Object)"Method name cannot be empty");
        try {
            Method m = clazz.getDeclaredMethod(ObfuscationReflectionHelper.remapName(INameMappingService.Domain.METHOD, methodName), parameterTypes);
            m.setAccessible(true);
            return m;
        }
        catch (Exception e) {
            throw new UnableToFindMethodException(e);
        }
    }

    @Nonnull
    public static <T> Constructor<T> findConstructor(@Nonnull Class<T> klass, Class<?> ... parameterTypes) {
        Preconditions.checkNotNull(klass, (Object)"class");
        Preconditions.checkNotNull(parameterTypes, (Object)"parameter types");
        try {
            Constructor<T> constructor = klass.getDeclaredConstructor(parameterTypes);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            StringBuilder desc = new StringBuilder();
            desc.append(klass.getSimpleName());
            StringJoiner joiner = new StringJoiner(", ", "(", ")");
            for (Class<?> type : parameterTypes) {
                joiner.add(type.getSimpleName());
            }
            desc.append(joiner);
            throw new UnknownConstructorException("Could not find constructor '" + desc.toString() + "' in " + klass);
        }
    }

    private static Field findField(Class<?> clazz, String name) {
        try {
            Field f = clazz.getDeclaredField(name);
            f.setAccessible(true);
            return f;
        }
        catch (Exception e) {
            throw new UnableToFindFieldException(e);
        }
    }

    public static class UnknownConstructorException
    extends RuntimeException {
        public UnknownConstructorException(String message) {
            super(message);
        }
    }

    public static class UnableToFindMethodException
    extends RuntimeException {
        public UnableToFindMethodException(Throwable failed) {
            super(failed);
        }
    }

    public static class UnableToFindFieldException
    extends RuntimeException {
        private UnableToFindFieldException(Exception e) {
            super(e);
        }
    }

    public static class UnableToAccessFieldException
    extends RuntimeException {
        private UnableToAccessFieldException(Exception e) {
            super(e);
        }
    }
}

