/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.network;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkInstance;
import net.minecraftforge.fml.network.event.EventNetworkChannel;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class NetworkRegistry {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker NETREGISTRY = MarkerManager.getMarker((String)"NETREGISTRY");
    private static Map<ResourceLocation, NetworkInstance> instances = new HashMap<ResourceLocation, NetworkInstance>();
    public static String ABSENT = new String("ABSENT \ud83e\udd14");
    public static String ACCEPTVANILLA = new String("ALLOWVANILLA \ud83d\udc93\ud83d\udc93\ud83d\udc93");
    private static boolean lock = false;

    public static List<String> getServerNonVanillaNetworkMods() {
        return NetworkRegistry.listRejectedVanillaMods(NetworkInstance::tryClientVersionOnServer);
    }

    public static List<String> getClientNonVanillaNetworkMods() {
        return NetworkRegistry.listRejectedVanillaMods(NetworkInstance::tryServerVersionOnClient);
    }

    public static boolean acceptsVanillaClientConnections() {
        return instances.isEmpty() || NetworkRegistry.getServerNonVanillaNetworkMods().isEmpty();
    }

    public static boolean canConnectToVanillaServer() {
        return instances.isEmpty() || NetworkRegistry.getClientNonVanillaNetworkMods().isEmpty();
    }

    public static SimpleChannel newSimpleChannel(ResourceLocation name, Supplier<String> networkProtocolVersion, Predicate<String> clientAcceptedVersions, Predicate<String> serverAcceptedVersions) {
        return new SimpleChannel(NetworkRegistry.createInstance(name, networkProtocolVersion, clientAcceptedVersions, serverAcceptedVersions));
    }

    public static EventNetworkChannel newEventChannel(ResourceLocation name, Supplier<String> networkProtocolVersion, Predicate<String> clientAcceptedVersions, Predicate<String> serverAcceptedVersions) {
        return new EventNetworkChannel(NetworkRegistry.createInstance(name, networkProtocolVersion, clientAcceptedVersions, serverAcceptedVersions));
    }

    private static NetworkInstance createInstance(ResourceLocation name, Supplier<String> networkProtocolVersion, Predicate<String> clientAcceptedVersions, Predicate<String> serverAcceptedVersions) {
        if (lock && !name.func_110624_b().equals("fml")) {
            LOGGER.error(NETREGISTRY, "Attempted to register channel {} even though registry phase is over", (Object)name);
            throw new IllegalArgumentException("Registration of network channels is locked");
        }
        NetworkInstance networkInstance = new NetworkInstance(name, networkProtocolVersion, clientAcceptedVersions, serverAcceptedVersions);
        if (instances.containsKey(name)) {
            LOGGER.error(NETREGISTRY, "NetworkDirection channel {} already registered.", (Object)name);
            throw new IllegalArgumentException("NetworkDirection Channel {" + name + "} already registered");
        }
        instances.put(name, networkInstance);
        return networkInstance;
    }

    static Optional<NetworkInstance> findTarget(ResourceLocation resourceLocation) {
        return Optional.ofNullable(instances.get(resourceLocation));
    }

    static Map<ResourceLocation, String> buildChannelVersions() {
        return instances.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((NetworkInstance)e.getValue()).getNetworkProtocolVersion()));
    }

    static Map<ResourceLocation, Pair<String, Boolean>> buildChannelVersionsForListPing() {
        return instances.entrySet().stream().map(p -> Pair.of(p.getKey(), (Object)Pair.of((Object)((NetworkInstance)p.getValue()).getNetworkProtocolVersion(), (Object)((NetworkInstance)p.getValue()).tryClientVersionOnServer(ABSENT)))).filter(p -> !((ResourceLocation)p.getLeft()).func_110624_b().equals("fml")).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
    }

    static List<String> listRejectedVanillaMods(BiFunction<NetworkInstance, String, Boolean> testFunction) {
        List results = instances.values().stream().map(ni -> {
            String incomingVersion = ACCEPTVANILLA;
            boolean test = (Boolean)testFunction.apply((NetworkInstance)ni, incomingVersion);
            LOGGER.debug(NETREGISTRY, "Channel '{}' : Vanilla acceptance test: {}", (Object)ni.getChannelName(), (Object)(test ? "ACCEPTED" : "REJECTED"));
            return Pair.of((Object)ni.getChannelName(), (Object)test);
        }).filter(p -> (Boolean)p.getRight() == false).collect(Collectors.toList());
        if (!results.isEmpty()) {
            LOGGER.error(NETREGISTRY, "Channels [{}] rejected vanilla connections", (Object)results.stream().map(Pair::getLeft).map(Object::toString).collect(Collectors.joining(",")));
            return results.stream().map(Pair::getLeft).map(Object::toString).collect(Collectors.toList());
        }
        LOGGER.debug(NETREGISTRY, "Accepting channel list from vanilla");
        return Collections.emptyList();
    }

    static boolean validateClientChannels(Map<ResourceLocation, String> channels) {
        return NetworkRegistry.validateChannels(channels, "server", NetworkInstance::tryServerVersionOnClient);
    }

    static boolean validateServerChannels(Map<ResourceLocation, String> channels) {
        return NetworkRegistry.validateChannels(channels, "client", NetworkInstance::tryClientVersionOnServer);
    }

    private static boolean validateChannels(Map<ResourceLocation, String> incoming, String originName, BiFunction<NetworkInstance, String, Boolean> testFunction) {
        List results = instances.values().stream().map(ni -> {
            String incomingVersion = incoming.getOrDefault(ni.getChannelName(), ABSENT);
            boolean test = (Boolean)testFunction.apply((NetworkInstance)ni, incomingVersion);
            LOGGER.debug(NETREGISTRY, "Channel '{}' : Version test of '{}' from {} : {}", (Object)ni.getChannelName(), (Object)incomingVersion, (Object)originName, (Object)(test ? "ACCEPTED" : "REJECTED"));
            return Pair.of((Object)ni.getChannelName(), (Object)test);
        }).filter(p -> (Boolean)p.getRight() == false).collect(Collectors.toList());
        if (!results.isEmpty()) {
            LOGGER.error(NETREGISTRY, "Channels [{}] rejected their {} side version number", (Object)results.stream().map(Pair::getLeft).map(Object::toString).collect(Collectors.joining(",")), (Object)originName);
            return false;
        }
        LOGGER.debug(NETREGISTRY, "Accepting channel list from {}", (Object)originName);
        return true;
    }

    static List<LoginPayload> gatherLoginPayloads(NetworkDirection direction, boolean isLocal) {
        if (direction != NetworkDirection.LOGIN_TO_CLIENT) {
            return Collections.emptyList();
        }
        ArrayList<LoginPayload> gatheredPayloads = new ArrayList<LoginPayload>();
        instances.values().forEach(ni -> ni.dispatchGatherLogin(gatheredPayloads, isLocal));
        return gatheredPayloads;
    }

    public static boolean checkListPingCompatibilityForClient(Map<ResourceLocation, Pair<String, Boolean>> incoming) {
        HashSet handled = new HashSet();
        List results = instances.values().stream().filter(p -> !p.getChannelName().func_110624_b().equals("fml")).map(ni -> {
            Pair incomingVersion = incoming.getOrDefault(ni.getChannelName(), Pair.of((Object)ABSENT, (Object)true));
            boolean test = ni.tryServerVersionOnClient((String)incomingVersion.getLeft());
            handled.add(ni.getChannelName());
            LOGGER.debug(NETREGISTRY, "Channel '{}' : Version test of '{}' during listping : {}", (Object)ni.getChannelName(), (Object)incomingVersion, (Object)(test ? "ACCEPTED" : "REJECTED"));
            return Pair.of((Object)ni.getChannelName(), (Object)test);
        }).filter(p -> (Boolean)p.getRight() == false).collect(Collectors.toList());
        List missingButRequired = incoming.entrySet().stream().filter(p -> !((ResourceLocation)p.getKey()).func_110624_b().equals("fml")).filter(p -> (Boolean)((Pair)p.getValue()).getRight() == false).filter(p -> !handled.contains(p.getKey())).map(Map.Entry::getKey).collect(Collectors.toList());
        if (!results.isEmpty()) {
            LOGGER.error(NETREGISTRY, "Channels [{}] rejected their server side version number during listping", (Object)results.stream().map(Pair::getLeft).map(Object::toString).collect(Collectors.joining(",")));
            return false;
        }
        if (!missingButRequired.isEmpty()) {
            LOGGER.error(NETREGISTRY, "The server is likely to require channel [{}] to be present, yet we don't have it", missingButRequired);
            return false;
        }
        LOGGER.debug(NETREGISTRY, "Accepting channel list during listping");
        return true;
    }

    public boolean isLocked() {
        return lock;
    }

    public static void lock() {
        lock = true;
    }

    public static class ChannelBuilder {
        private ResourceLocation channelName;
        private Supplier<String> networkProtocolVersion;
        private Predicate<String> clientAcceptedVersions;
        private Predicate<String> serverAcceptedVersions;

        public static ChannelBuilder named(ResourceLocation channelName) {
            ChannelBuilder builder = new ChannelBuilder();
            builder.channelName = channelName;
            return builder;
        }

        public ChannelBuilder networkProtocolVersion(Supplier<String> networkProtocolVersion) {
            this.networkProtocolVersion = networkProtocolVersion;
            return this;
        }

        public ChannelBuilder clientAcceptedVersions(Predicate<String> clientAcceptedVersions) {
            this.clientAcceptedVersions = clientAcceptedVersions;
            return this;
        }

        public ChannelBuilder serverAcceptedVersions(Predicate<String> serverAcceptedVersions) {
            this.serverAcceptedVersions = serverAcceptedVersions;
            return this;
        }

        private NetworkInstance createNetworkInstance() {
            return NetworkRegistry.createInstance(this.channelName, this.networkProtocolVersion, this.clientAcceptedVersions, this.serverAcceptedVersions);
        }

        public SimpleChannel simpleChannel() {
            return new SimpleChannel(this.createNetworkInstance());
        }

        public EventNetworkChannel eventNetworkChannel() {
            return new EventNetworkChannel(this.createNetworkInstance());
        }
    }

    public static class LoginPayload {
        private final PacketBuffer data;
        private final ResourceLocation channelName;
        private final String messageContext;

        public LoginPayload(PacketBuffer buffer, ResourceLocation channelName, String messageContext) {
            this.data = buffer;
            this.channelName = channelName;
            this.messageContext = messageContext;
        }

        public PacketBuffer getData() {
            return this.data;
        }

        public ResourceLocation getChannelName() {
            return this.channelName;
        }

        public String getMessageContext() {
            return this.messageContext;
        }
    }
}

