/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.network;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.NetworkDirection;

public class PacketDistributor<T> {
    public static final PacketDistributor<EntityPlayerMP> PLAYER = new PacketDistributor(PacketDistributor::playerConsumer, NetworkDirection.PLAY_TO_CLIENT);
    public static final PacketDistributor<DimensionType> DIMENSION = new PacketDistributor(PacketDistributor::playerListDimConsumer, NetworkDirection.PLAY_TO_CLIENT);
    public static final PacketDistributor<TargetPoint> NEAR = new PacketDistributor(PacketDistributor::playerListPointConsumer, NetworkDirection.PLAY_TO_CLIENT);
    public static final PacketDistributor<Void> ALL = new PacketDistributor(PacketDistributor::playerListAll, NetworkDirection.PLAY_TO_CLIENT);
    public static final PacketDistributor<Void> SERVER = new PacketDistributor(PacketDistributor::clientToServer, NetworkDirection.PLAY_TO_SERVER);
    public static final PacketDistributor<Entity> TRACKING_ENTITY = new PacketDistributor(PacketDistributor::trackingEntity, NetworkDirection.PLAY_TO_CLIENT);
    public static final PacketDistributor<Entity> TRACKING_ENTITY_AND_SELF = new PacketDistributor(PacketDistributor::trackingEntityAndSelf, NetworkDirection.PLAY_TO_CLIENT);
    public static final PacketDistributor<Chunk> TRACKING_CHUNK = new PacketDistributor(PacketDistributor::trackingChunk, NetworkDirection.PLAY_TO_CLIENT);
    public static final PacketDistributor<List<NetworkManager>> NMLIST = new PacketDistributor(PacketDistributor::networkManagerList, NetworkDirection.PLAY_TO_CLIENT);
    private final BiFunction<PacketDistributor<T>, Supplier<T>, Consumer<Packet<?>>> functor;
    private final NetworkDirection direction;

    public PacketDistributor(BiFunction<PacketDistributor<T>, Supplier<T>, Consumer<Packet<?>>> functor, NetworkDirection direction) {
        this.functor = functor;
        this.direction = direction;
    }

    public PacketTarget with(Supplier<T> input) {
        return new PacketTarget(this.functor.apply(this, input), this);
    }

    public PacketTarget noArg() {
        return new PacketTarget(this.functor.apply(this, () -> null), this);
    }

    private Consumer<Packet<?>> playerConsumer(Supplier<EntityPlayerMP> entityPlayerMPSupplier) {
        return p -> ((EntityPlayerMP)entityPlayerMPSupplier.get()).field_71135_a.field_147371_a.func_179290_a(p);
    }

    private Consumer<Packet<?>> playerListDimConsumer(Supplier<DimensionType> dimensionTypeSupplier) {
        return p -> this.getServer().func_184103_al().func_148537_a(p, (DimensionType)dimensionTypeSupplier.get());
    }

    private Consumer<Packet<?>> playerListAll(Supplier<Void> voidSupplier) {
        return p -> this.getServer().func_184103_al().func_148540_a(p);
    }

    private Consumer<Packet<?>> clientToServer(Supplier<Void> voidSupplier) {
        return p -> Minecraft.func_71410_x().func_147114_u().func_147297_a(p);
    }

    private Consumer<Packet<?>> playerListPointConsumer(Supplier<TargetPoint> targetPointSupplier) {
        return p -> {
            TargetPoint tp = (TargetPoint)targetPointSupplier.get();
            this.getServer().func_184103_al().func_148543_a((EntityPlayer)tp.excluded, tp.x, tp.y, tp.z, tp.r2, tp.dim, p);
        };
    }

    private Consumer<Packet<?>> trackingEntity(Supplier<Entity> entitySupplier) {
        return p -> {
            Entity entity = (Entity)entitySupplier.get();
            this.getServer().func_71218_a(entity.field_71093_bK).func_73039_n().func_151247_a(entity, p);
        };
    }

    private Consumer<Packet<?>> trackingEntityAndSelf(Supplier<Entity> entitySupplier) {
        return p -> {
            Entity entity = (Entity)entitySupplier.get();
            this.getServer().func_71218_a(entity.field_71093_bK).func_73039_n().func_151248_b(entity, p);
        };
    }

    private Consumer<Packet<?>> trackingChunk(Supplier<Chunk> chunkPosSupplier) {
        return p -> {
            Chunk chunk = (Chunk)chunkPosSupplier.get();
            ((WorldServer)chunk.func_177412_p()).func_184164_w().func_187301_b(chunk.field_76635_g, chunk.field_76647_h).func_187267_a(p);
        };
    }

    private Consumer<Packet<?>> networkManagerList(Supplier<List<NetworkManager>> nmListSupplier) {
        return p -> ((List)nmListSupplier.get()).forEach(nm -> nm.func_179290_a(p));
    }

    private MinecraftServer getServer() {
        return (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
    }

    public static class PacketTarget {
        private final Consumer<Packet<?>> packetConsumer;
        private final PacketDistributor<?> distributor;

        PacketTarget(Consumer<Packet<?>> packetConsumer, PacketDistributor<?> distributor) {
            this.packetConsumer = packetConsumer;
            this.distributor = distributor;
        }

        public void send(Packet<?> packet) {
            this.packetConsumer.accept(packet);
        }

        public NetworkDirection getDirection() {
            return ((PacketDistributor)this.distributor).direction;
        }
    }

    public static final class TargetPoint {
        private final EntityPlayerMP excluded;
        private final double x;
        private final double y;
        private final double z;
        private final double r2;
        private final DimensionType dim;

        public TargetPoint(EntityPlayerMP excluded, double x, double y, double z, double r2, DimensionType dim) {
            this.excluded = excluded;
            this.x = x;
            this.y = y;
            this.z = z;
            this.r2 = r2;
            this.dim = dim;
        }

        public TargetPoint(double x, double y, double z, double r2, DimensionType dim) {
            this.excluded = null;
            this.x = x;
            this.y = y;
            this.z = z;
            this.r2 = r2;
            this.dim = dim;
        }

        public static Supplier<TargetPoint> p(double x, double y, double z, double r2, DimensionType dim) {
            TargetPoint tp = new TargetPoint(x, y, z, r2, dim);
            return () -> tp;
        }
    }
}

