/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.server;

import java.util.List;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.ModLoadingWarning;
import net.minecraftforge.fml.SidedProvider;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.network.FMLStatusPing;
import net.minecraftforge.fml.server.LanguageHook;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerModLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    private static DedicatedServer server;

    public static void begin(DedicatedServer dedicatedServer) {
        server = dedicatedServer;
        SidedProvider.setServer(() -> dedicatedServer);
        LogicalSidedProvider.setServer(() -> dedicatedServer);
        LanguageHook.loadForgeAndMCLangs();
        ModLoader.get().loadMods();
    }

    public static void end() {
        ModLoader.get().finishMods();
        List<ModLoadingWarning> warnings = ModLoader.get().getWarnings();
        if (!warnings.isEmpty()) {
            LOGGER.warn(LogMarkers.LOADING, "Mods loaded with {} warnings", (Object)warnings.size());
            warnings.forEach(warning -> LOGGER.warn(LogMarkers.LOADING, warning.formatToString()));
        }
        server.func_147134_at().setForgeData(new FMLStatusPing());
    }
}

