/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.criterion.EnchantmentPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.NBTPredicate;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;

public class ItemPredicate {
    public static final ItemPredicate field_192495_a = new ItemPredicate();
    @Nullable
    private final Tag<Item> field_200018_b;
    @Nullable
    private final Item field_192496_b;
    private final MinMaxBounds.IntBound field_192498_d;
    private final MinMaxBounds.IntBound field_193444_e;
    private final EnchantmentPredicate[] field_192499_e;
    @Nullable
    private final PotionType field_192500_f;
    private final NBTPredicate field_193445_h;

    public ItemPredicate() {
        this.field_200018_b = null;
        this.field_192496_b = null;
        this.field_192500_f = null;
        this.field_192498_d = MinMaxBounds.IntBound.field_211347_e;
        this.field_193444_e = MinMaxBounds.IntBound.field_211347_e;
        this.field_192499_e = new EnchantmentPredicate[0];
        this.field_193445_h = NBTPredicate.field_193479_a;
    }

    public ItemPredicate(@Nullable Tag<Item> tag, @Nullable Item item, MinMaxBounds.IntBound intBound, MinMaxBounds.IntBound intBound2, EnchantmentPredicate[] enchantmentPredicateArray, @Nullable PotionType potionType, NBTPredicate nBTPredicate) {
        this.field_200018_b = tag;
        this.field_192496_b = item;
        this.field_192498_d = intBound;
        this.field_193444_e = intBound2;
        this.field_192499_e = enchantmentPredicateArray;
        this.field_192500_f = potionType;
        this.field_193445_h = nBTPredicate;
    }

    public boolean func_192493_a(ItemStack itemStack2) {
        ItemStack itemStack2;
        if (this.field_200018_b != null && !this.field_200018_b.func_199685_a_(itemStack2.func_77973_b())) {
            return false;
        }
        if (this.field_192496_b != null && itemStack2.func_77973_b() != this.field_192496_b) {
            return false;
        }
        if (!this.field_192498_d.func_211339_d(itemStack2.func_190916_E())) {
            return false;
        }
        if (!this.field_193444_e.func_211335_c() && !itemStack2.func_77984_f()) {
            return false;
        }
        if (!this.field_193444_e.func_211339_d(itemStack2.func_77958_k() - itemStack2.func_77952_i())) {
            return false;
        }
        if (!this.field_193445_h.func_193478_a(itemStack2)) {
            return false;
        }
        Map<Enchantment, Integer> map = EnchantmentHelper.func_82781_a(itemStack2);
        for (int i = 0; i < this.field_192499_e.length; ++i) {
            if (this.field_192499_e[i].func_192463_a(map)) continue;
            return false;
        }
        PotionType \u26032 = PotionUtils.func_185191_c(itemStack2);
        return this.field_192500_f == null || this.field_192500_f == \u26032;
    }

    public static ItemPredicate func_192492_a(@Nullable JsonElement jsonElement) {
        EnchantmentPredicate[] \u26037;
        if (jsonElement == null || jsonElement.isJsonNull()) {
            return field_192495_a;
        }
        JsonObject jsonObject = JsonUtils.func_151210_l(jsonElement, "item");
        MinMaxBounds.IntBound \u26032 = MinMaxBounds.IntBound.func_211344_a(jsonObject.get("count"));
        MinMaxBounds.IntBound \u26033 = MinMaxBounds.IntBound.func_211344_a(jsonObject.get("durability"));
        if (jsonObject.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        NBTPredicate \u26034 = NBTPredicate.func_193476_a(jsonObject.get("nbt"));
        Item \u26035 = null;
        if (jsonObject.has("item") && (\u26035 = IRegistry.field_212630_s.func_212608_b((ResourceLocation)((Object)(\u26036 = new ResourceLocation(JsonUtils.func_151200_h(jsonObject, "item")))))) == null) {
            throw new JsonSyntaxException("Unknown item id '" + \u26036 + "'");
        }
        Tag<Item> \u26036 = null;
        if (jsonObject.has("tag")) {
            \u26037 = new ResourceLocation(JsonUtils.func_151200_h(jsonObject, "tag"));
            \u26036 = ItemTags.func_199903_a().func_199910_a((ResourceLocation)\u26037);
            if (\u26036 == null) {
                throw new JsonSyntaxException("Unknown item tag '" + \u26037 + "'");
            }
        }
        \u26037 = EnchantmentPredicate.func_192465_b(jsonObject.get("enchantments"));
        PotionType \u26038 = null;
        if (jsonObject.has("potion")) {
            ResourceLocation resourceLocation = new ResourceLocation(JsonUtils.func_151200_h(jsonObject, "potion"));
            if (!IRegistry.field_212621_j.func_212607_c(resourceLocation)) {
                throw new JsonSyntaxException("Unknown potion '" + resourceLocation + "'");
            }
            \u26038 = IRegistry.field_212621_j.func_82594_a(resourceLocation);
        }
        return new ItemPredicate(\u26036, \u26035, \u26032, \u26033, \u26037, \u26038, \u26034);
    }

    public JsonElement func_200319_a() {
        if (this == field_192495_a) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonObject = new JsonObject();
        if (this.field_192496_b != null) {
            jsonObject.addProperty("item", IRegistry.field_212630_s.func_177774_c(this.field_192496_b).toString());
        }
        if (this.field_200018_b != null) {
            jsonObject.addProperty("tag", this.field_200018_b.func_199886_b().toString());
        }
        jsonObject.add("count", this.field_192498_d.func_200321_c());
        jsonObject.add("durability", this.field_193444_e.func_200321_c());
        jsonObject.add("nbt", this.field_193445_h.func_200322_a());
        if (this.field_192499_e.length > 0) {
            JsonArray jsonArray = new JsonArray();
            for (EnchantmentPredicate enchantmentPredicate : this.field_192499_e) {
                jsonArray.add(enchantmentPredicate.func_200306_a());
            }
            jsonObject.add("enchantments", (JsonElement)jsonArray);
        }
        if (this.field_192500_f != null) {
            jsonObject.addProperty("potion", IRegistry.field_212621_j.func_177774_c(this.field_192500_f).toString());
        }
        return jsonObject;
    }

    public static ItemPredicate[] func_192494_b(@Nullable JsonElement jsonElement) {
        if (jsonElement == null || jsonElement.isJsonNull()) {
            return new ItemPredicate[0];
        }
        JsonArray jsonArray = JsonUtils.func_151207_m(jsonElement, "items");
        ItemPredicate[] \u26032 = new ItemPredicate[jsonArray.size()];
        for (int i = 0; i < \u26032.length; ++i) {
            \u26032[i] = ItemPredicate.func_192492_a(jsonArray.get(i));
        }
        return \u26032;
    }

    public static class Builder {
        private final List<EnchantmentPredicate> field_200312_a = Lists.newArrayList();
        @Nullable
        private Item field_200313_b;
        @Nullable
        private Tag<Item> field_200314_c;
        private MinMaxBounds.IntBound field_200315_d = MinMaxBounds.IntBound.field_211347_e;
        private MinMaxBounds.IntBound field_200316_e = MinMaxBounds.IntBound.field_211347_e;
        @Nullable
        private PotionType field_200317_f;
        private NBTPredicate field_200318_g = NBTPredicate.field_193479_a;

        private Builder() {
        }

        public static Builder func_200309_a() {
            return new Builder();
        }

        public Builder func_200308_a(IItemProvider iItemProvider) {
            this.field_200313_b = iItemProvider.func_199767_j();
            return this;
        }

        public Builder func_200307_a(Tag<Item> tag) {
            this.field_200314_c = tag;
            return this;
        }

        public Builder func_200311_a(MinMaxBounds.IntBound intBound) {
            this.field_200315_d = intBound;
            return this;
        }

        public ItemPredicate func_200310_b() {
            return new ItemPredicate(this.field_200314_c, this.field_200313_b, this.field_200315_d, this.field_200316_e, this.field_200312_a.toArray(new EnchantmentPredicate[0]), this.field_200317_f, this.field_200318_g);
        }
    }
}

