/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BedPart;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBed;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class BlockBed
extends BlockHorizontal
implements ITileEntityProvider {
    public static final EnumProperty<BedPart> field_176472_a = BlockStateProperties.field_208139_an;
    public static final BooleanProperty field_176471_b = BlockStateProperties.field_208192_s;
    protected static final VoxelShape field_196351_c = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 9.0, 16.0);
    private final EnumDyeColor field_196352_y;

    public BlockBed(EnumDyeColor enumDyeColor, Block.Properties properties) {
        super(properties);
        this.field_196352_y = enumDyeColor;
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_176472_a, BedPart.FOOT)).func_206870_a(field_176471_b, false));
    }

    @Override
    public MaterialColor func_180659_g(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos) {
        if (iBlockState.func_177229_b(field_176472_a) == BedPart.FOOT) {
            return this.field_196352_y.func_196055_e();
        }
        return MaterialColor.field_151659_e;
    }

    @Override
    public boolean func_196250_a(IBlockState iBlockState2, World world, BlockPos blockPos, EntityPlayer entityPlayer2, EnumHand enumHand, EnumFacing enumFacing, float f, float f2, float f3) {
        Object object;
        IBlockState iBlockState2;
        if (world.field_72995_K) {
            return true;
        }
        if (iBlockState2.func_177229_b(field_176472_a) != BedPart.HEAD && (iBlockState2 = world.func_180495_p(blockPos = blockPos.func_177972_a(iBlockState2.func_177229_b(field_185512_D)))).func_177230_c() != this) {
            return true;
        }
        if (!world.field_73011_w.func_76567_e() || world.func_180494_b(blockPos) == Biomes.field_76778_j) {
            world.func_175698_g(blockPos);
            BlockPos blockPos2 = blockPos.func_177972_a(iBlockState2.func_177229_b(field_185512_D).func_176734_d());
            if (world.func_180495_p(blockPos2).func_177230_c() == this) {
                world.func_175698_g(blockPos2);
            }
            world.func_211529_a(null, DamageSource.func_199683_a(), (double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5, 5.0f, true, true);
            return true;
        }
        if (iBlockState2.func_177229_b(field_176471_b).booleanValue()) {
            object = this.func_176470_e(world, blockPos);
            if (object == null) {
                iBlockState2 = (IBlockState)iBlockState2.func_206870_a(field_176471_b, false);
                world.func_180501_a(blockPos, iBlockState2, 4);
            } else {
                EntityPlayer entityPlayer2;
                entityPlayer2.func_146105_b(new TextComponentTranslation("block.minecraft.bed.occupied", new Object[0]), true);
                return true;
            }
        }
        if ((object = entityPlayer2.func_180469_a(blockPos)) == EntityPlayer.SleepResult.OK) {
            iBlockState2 = (IBlockState)iBlockState2.func_206870_a(field_176471_b, true);
            world.func_180501_a(blockPos, iBlockState2, 4);
            return true;
        }
        if (object == EntityPlayer.SleepResult.NOT_POSSIBLE_NOW) {
            entityPlayer2.func_146105_b(new TextComponentTranslation("block.minecraft.bed.no_sleep", new Object[0]), true);
        } else if (object == EntityPlayer.SleepResult.NOT_SAFE) {
            entityPlayer2.func_146105_b(new TextComponentTranslation("block.minecraft.bed.not_safe", new Object[0]), true);
        } else if (object == EntityPlayer.SleepResult.TOO_FAR_AWAY) {
            entityPlayer2.func_146105_b(new TextComponentTranslation("block.minecraft.bed.too_far_away", new Object[0]), true);
        }
        return true;
    }

    @Nullable
    private EntityPlayer func_176470_e(World world, BlockPos blockPos) {
        for (EntityPlayer entityPlayer : world.field_73010_i) {
            if (!entityPlayer.func_70608_bn() || !entityPlayer.field_71081_bT.equals(blockPos)) continue;
            return entityPlayer;
        }
        return null;
    }

    @Override
    public boolean func_149686_d(IBlockState iBlockState) {
        return false;
    }

    @Override
    public void func_180658_a(World world, BlockPos blockPos, Entity entity, float f) {
        super.func_180658_a(world, blockPos, entity, f * 0.5f);
    }

    @Override
    public void func_176216_a(IBlockReader iBlockReader, Entity entity) {
        if (entity.func_70093_af()) {
            super.func_176216_a(iBlockReader, entity);
        } else if (entity.field_70181_x < 0.0) {
            entity.field_70181_x = -entity.field_70181_x * (double)0.66f;
            if (!(entity instanceof EntityLivingBase)) {
                entity.field_70181_x *= 0.8;
            }
        }
    }

    @Override
    public IBlockState func_196271_a(IBlockState iBlockState, EnumFacing enumFacing, IBlockState iBlockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
        if (enumFacing == BlockBed.func_208070_a(iBlockState.func_177229_b(field_176472_a), iBlockState.func_177229_b(field_185512_D))) {
            if (iBlockState2.func_177230_c() == this && iBlockState2.func_177229_b(field_176472_a) != iBlockState.func_177229_b(field_176472_a)) {
                return (IBlockState)iBlockState.func_206870_a(field_176471_b, iBlockState2.func_177229_b(field_176471_b));
            }
            return Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(iBlockState, enumFacing, iBlockState2, iWorld, blockPos, blockPos2);
    }

    private static EnumFacing func_208070_a(BedPart bedPart, EnumFacing enumFacing) {
        return bedPart == BedPart.FOOT ? enumFacing : enumFacing.func_176734_d();
    }

    @Override
    public void func_180657_a(World world, EntityPlayer entityPlayer, BlockPos blockPos, IBlockState iBlockState, @Nullable TileEntity tileEntity, ItemStack itemStack) {
        super.func_180657_a(world, entityPlayer, blockPos, Blocks.field_150350_a.func_176223_P(), tileEntity, itemStack);
    }

    @Override
    public void func_196243_a(IBlockState iBlockState, World world, BlockPos blockPos, IBlockState iBlockState2, boolean bl) {
        if (iBlockState.func_177230_c() == iBlockState2.func_177230_c()) {
            return;
        }
        super.func_196243_a(iBlockState, world, blockPos, iBlockState2, bl);
        world.func_175713_t(blockPos);
    }

    @Override
    public void func_176208_a(World world, BlockPos blockPos, IBlockState iBlockState, EntityPlayer entityPlayer) {
        BedPart bedPart = iBlockState.func_177229_b(field_176472_a);
        boolean \u26032 = bedPart == BedPart.HEAD;
        BlockPos \u26033 = blockPos.func_177972_a(BlockBed.func_208070_a(bedPart, iBlockState.func_177229_b(field_185512_D)));
        IBlockState \u26034 = world.func_180495_p(\u26033);
        if (\u26034.func_177230_c() == this && \u26034.func_177229_b(field_176472_a) != bedPart) {
            world.func_180501_a(\u26033, Blocks.field_150350_a.func_176223_P(), 35);
            world.func_180498_a(entityPlayer, 2001, \u26033, Block.func_196246_j(\u26034));
            if (!world.field_72995_K && !entityPlayer.func_184812_l_()) {
                if (\u26032) {
                    iBlockState.func_196949_c(world, blockPos, 0);
                } else {
                    \u26034.func_196949_c(world, \u26033, 0);
                }
            }
            entityPlayer.func_71029_a(StatList.field_188065_ae.func_199076_b(this));
        }
        super.func_176208_a(world, blockPos, iBlockState, entityPlayer);
    }

    @Override
    @Nullable
    public IBlockState func_196258_a(BlockItemUseContext blockItemUseContext) {
        EnumFacing enumFacing = blockItemUseContext.func_195992_f();
        BlockPos \u26032 = blockItemUseContext.func_195995_a();
        BlockPos \u26033 = \u26032.func_177972_a(enumFacing);
        if (blockItemUseContext.func_195991_k().func_180495_p(\u26033).func_196953_a(blockItemUseContext)) {
            return (IBlockState)this.func_176223_P().func_206870_a(field_185512_D, enumFacing);
        }
        return null;
    }

    @Override
    public IItemProvider func_199769_a(IBlockState iBlockState, World world, BlockPos blockPos, int n) {
        if (iBlockState.func_177229_b(field_176472_a) == BedPart.FOOT) {
            return Items.field_190931_a;
        }
        return super.func_199769_a(iBlockState, world, blockPos, n);
    }

    @Override
    public VoxelShape func_196244_b(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return field_196351_c;
    }

    @Override
    public boolean func_190946_v(IBlockState iBlockState) {
        return true;
    }

    @Nullable
    public static BlockPos func_176468_a(IBlockReader iBlockReader, BlockPos blockPos, int n) {
        EnumFacing enumFacing = iBlockReader.func_180495_p(blockPos).func_177229_b(field_185512_D);
        int \u26032 = blockPos.func_177958_n();
        int \u26033 = blockPos.func_177956_o();
        int \u26034 = blockPos.func_177952_p();
        for (int i = 0; i <= 1; ++i) {
            \u2603 = \u26032 - enumFacing.func_82601_c() * i - 1;
            \u2603 = \u26034 - enumFacing.func_82599_e() * i - 1;
            \u2603 = \u2603 + 2;
            \u2603 = \u2603 + 2;
            for (\u2603 = \u2603; \u2603 <= \u2603; ++\u2603) {
                for (\u2603 = \u2603; \u2603 <= \u2603; ++\u2603) {
                    BlockPos blockPos2 = new BlockPos(\u2603, \u26033, \u2603);
                    if (!BlockBed.func_176469_d(iBlockReader, blockPos2)) continue;
                    if (n > 0) {
                        --n;
                        continue;
                    }
                    return blockPos2;
                }
            }
        }
        return null;
    }

    protected static boolean func_176469_d(IBlockReader iBlockReader, BlockPos blockPos) {
        return iBlockReader.func_180495_p(blockPos.func_177977_b()).func_185896_q() && !iBlockReader.func_180495_p(blockPos).func_185904_a().func_76220_a() && !iBlockReader.func_180495_p(blockPos.func_177984_a()).func_185904_a().func_76220_a();
    }

    @Override
    public EnumPushReaction func_149656_h(IBlockState iBlockState) {
        return EnumPushReaction.DESTROY;
    }

    @Override
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState iBlockState) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockReader iBlockReader, IBlockState iBlockState, BlockPos blockPos, EnumFacing enumFacing) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(field_185512_D, field_176472_a, field_176471_b);
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader iBlockReader) {
        return new TileEntityBed(this.field_196352_y);
    }

    @Override
    public void func_180633_a(World world, BlockPos blockPos, IBlockState iBlockState, @Nullable EntityLivingBase entityLivingBase, ItemStack itemStack) {
        super.func_180633_a(world, blockPos, iBlockState, entityLivingBase, itemStack);
        if (!world.field_72995_K) {
            BlockPos blockPos2 = blockPos.func_177972_a(iBlockState.func_177229_b(field_185512_D));
            world.func_180501_a(blockPos2, (IBlockState)iBlockState.func_206870_a(field_176472_a, BedPart.HEAD), 3);
            world.func_195592_c(blockPos, Blocks.field_150350_a);
            iBlockState.func_196946_a(world, blockPos, 3);
        }
    }

    public EnumDyeColor func_196350_d() {
        return this.field_196352_y;
    }

    @Override
    public long func_209900_a(IBlockState iBlockState, BlockPos blockPos) {
        \u2603 = blockPos.func_177967_a(iBlockState.func_177229_b(field_185512_D), iBlockState.func_177229_b(field_176472_a) == BedPart.HEAD ? 0 : 1);
        return MathHelper.func_180187_c(\u2603.func_177958_n(), blockPos.func_177956_o(), \u2603.func_177952_p());
    }

    @Override
    public boolean func_196266_a(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos, PathType pathType) {
        return false;
    }
}

