/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.CommandBlockBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlockCommandBlock
extends BlockContainer {
    private static final Logger field_193388_c = LogManager.getLogger();
    public static final DirectionProperty field_185564_a = BlockDirectional.field_176387_N;
    public static final BooleanProperty field_185565_b = BlockStateProperties.field_208176_c;

    public BlockCommandBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_185564_a, EnumFacing.NORTH)).func_206870_a(field_185565_b, false));
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader iBlockReader) {
        TileEntityCommandBlock tileEntityCommandBlock = new TileEntityCommandBlock();
        tileEntityCommandBlock.func_184253_b(this == Blocks.field_185777_dd);
        return tileEntityCommandBlock;
    }

    @Override
    public void func_189540_a(IBlockState iBlockState, World world, BlockPos blockPos, Block block, BlockPos blockPos2) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (!(tileEntity instanceof TileEntityCommandBlock)) {
            return;
        }
        TileEntityCommandBlock \u26032 = (TileEntityCommandBlock)tileEntity;
        boolean \u26033 = world.func_175640_z(blockPos);
        boolean \u26034 = \u26032.func_184255_d();
        \u26032.func_184250_a(\u26033);
        if (\u26034 || \u26032.func_184254_e() || \u26032.func_184251_i() == TileEntityCommandBlock.Mode.SEQUENCE) {
            return;
        }
        if (\u26033) {
            \u26032.func_184249_c();
            world.func_205220_G_().func_205360_a(blockPos, this, this.func_149738_a(world));
        }
    }

    @Override
    public void func_196267_b(IBlockState iBlockState, World world, BlockPos blockPos, Random random) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (tileEntity instanceof TileEntityCommandBlock) {
            TileEntityCommandBlock tileEntityCommandBlock = (TileEntityCommandBlock)tileEntity;
            CommandBlockBaseLogic \u26032 = tileEntityCommandBlock.func_145993_a();
            boolean \u26033 = !StringUtils.func_151246_b(\u26032.func_145753_i());
            TileEntityCommandBlock.Mode \u26034 = tileEntityCommandBlock.func_184251_i();
            boolean \u26035 = tileEntityCommandBlock.func_184256_g();
            if (\u26034 == TileEntityCommandBlock.Mode.AUTO) {
                tileEntityCommandBlock.func_184249_c();
                if (\u26035) {
                    this.func_193387_a(iBlockState, world, blockPos, \u26032, \u26033);
                } else if (tileEntityCommandBlock.func_184258_j()) {
                    \u26032.func_184167_a(0);
                }
                if (tileEntityCommandBlock.func_184255_d() || tileEntityCommandBlock.func_184254_e()) {
                    world.func_205220_G_().func_205360_a(blockPos, this, this.func_149738_a(world));
                }
            } else if (\u26034 == TileEntityCommandBlock.Mode.REDSTONE) {
                if (\u26035) {
                    this.func_193387_a(iBlockState, world, blockPos, \u26032, \u26033);
                } else if (tileEntityCommandBlock.func_184258_j()) {
                    \u26032.func_184167_a(0);
                }
            }
            world.func_175666_e(blockPos, this);
        }
    }

    private void func_193387_a(IBlockState iBlockState, World world, BlockPos blockPos, CommandBlockBaseLogic commandBlockBaseLogic, boolean bl) {
        if (bl) {
            commandBlockBaseLogic.func_145755_a(world);
        } else {
            commandBlockBaseLogic.func_184167_a(0);
        }
        BlockCommandBlock.func_193386_c(world, blockPos, iBlockState.func_177229_b(field_185564_a));
    }

    @Override
    public int func_149738_a(IWorldReaderBase iWorldReaderBase) {
        return 1;
    }

    @Override
    public boolean func_196250_a(IBlockState iBlockState, World world, BlockPos blockPos, EntityPlayer entityPlayer, EnumHand enumHand, EnumFacing enumFacing, float f, float f2, float f3) {
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (tileEntity instanceof TileEntityCommandBlock && entityPlayer.func_195070_dx()) {
            entityPlayer.func_184824_a((TileEntityCommandBlock)tileEntity);
            return true;
        }
        return false;
    }

    @Override
    public boolean func_149740_M(IBlockState iBlockState) {
        return true;
    }

    @Override
    public int func_180641_l(IBlockState iBlockState, World world, BlockPos blockPos) {
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (tileEntity instanceof TileEntityCommandBlock) {
            return ((TileEntityCommandBlock)tileEntity).func_145993_a().func_145760_g();
        }
        return 0;
    }

    @Override
    public void func_180633_a(World world, BlockPos blockPos, IBlockState iBlockState, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (!(tileEntity instanceof TileEntityCommandBlock)) {
            return;
        }
        TileEntityCommandBlock \u26032 = (TileEntityCommandBlock)tileEntity;
        CommandBlockBaseLogic \u26033 = \u26032.func_145993_a();
        if (itemStack.func_82837_s()) {
            \u26033.func_207405_b(itemStack.func_200301_q());
        }
        if (!world.field_72995_K) {
            if (itemStack.func_179543_a("BlockEntityTag") == null) {
                \u26033.func_175573_a(world.func_82736_K().func_82766_b("sendCommandFeedback"));
                \u26032.func_184253_b(this == Blocks.field_185777_dd);
            }
            if (\u26032.func_184251_i() == TileEntityCommandBlock.Mode.SEQUENCE) {
                boolean bl = world.func_175640_z(blockPos);
                \u26032.func_184250_a(bl);
            }
        }
    }

    @Override
    public int func_196264_a(IBlockState iBlockState, Random random) {
        return 0;
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState iBlockState) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    public IBlockState func_185499_a(IBlockState iBlockState, Rotation rotation) {
        return (IBlockState)iBlockState.func_206870_a(field_185564_a, rotation.func_185831_a(iBlockState.func_177229_b(field_185564_a)));
    }

    @Override
    public IBlockState func_185471_a(IBlockState iBlockState, Mirror mirror) {
        return iBlockState.func_185907_a(mirror.func_185800_a(iBlockState.func_177229_b(field_185564_a)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(field_185564_a, field_185565_b);
    }

    @Override
    public IBlockState func_196258_a(BlockItemUseContext blockItemUseContext) {
        return (IBlockState)this.func_176223_P().func_206870_a(field_185564_a, blockItemUseContext.func_196010_d().func_176734_d());
    }

    private static void func_193386_c(World world, BlockPos blockPos, EnumFacing \u260352) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(blockPos);
        GameRules \u26032 = world.func_82736_K();
        int \u26033 = \u26032.func_180263_c("maxCommandChainLength");
        while (\u26033-- > 0) {
            mutableBlockPos.func_189536_c(\u260352);
            IBlockState iBlockState = world.func_180495_p(mutableBlockPos);
            Block \u26034 = iBlockState.func_177230_c();
            if (\u26034 != Blocks.field_185777_dd || !((\u2603 = world.func_175625_s(mutableBlockPos)) instanceof TileEntityCommandBlock) || (\u2603 = (TileEntityCommandBlock)\u2603).func_184251_i() != TileEntityCommandBlock.Mode.SEQUENCE) break;
            if (\u2603.func_184255_d() || \u2603.func_184254_e()) {
                CommandBlockBaseLogic commandBlockBaseLogic = \u2603.func_145993_a();
                if (\u2603.func_184249_c()) {
                    if (!commandBlockBaseLogic.func_145755_a(world)) break;
                    world.func_175666_e(mutableBlockPos, \u26034);
                } else if (\u2603.func_184258_j()) {
                    commandBlockBaseLogic.func_184167_a(0);
                }
            }
            EnumFacing \u260352 = iBlockState.func_177229_b(field_185564_a);
        }
        if (\u26033 <= 0) {
            int \u26036 = Math.max(\u26032.func_180263_c("maxCommandChainLength"), 0);
            field_193388_c.warn("Command Block chain tried to execute more than {} steps!", (Object)\u26036);
        }
    }
}

