/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.BlockPistonMoving;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockPistonStructureHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.PistonType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityPiston;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class BlockPistonBase
extends BlockDirectional {
    public static final BooleanProperty field_176320_b = BlockStateProperties.field_208181_h;
    protected static final VoxelShape field_185648_b = Block.func_208617_a(0.0, 0.0, 0.0, 12.0, 16.0, 16.0);
    protected static final VoxelShape field_185649_c = Block.func_208617_a(4.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape field_185650_d = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 16.0, 12.0);
    protected static final VoxelShape field_185651_e = Block.func_208617_a(0.0, 0.0, 4.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape field_185652_f = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 12.0, 16.0);
    protected static final VoxelShape field_185653_g = Block.func_208617_a(0.0, 4.0, 0.0, 16.0, 16.0, 16.0);
    private final boolean field_150082_a;

    public BlockPistonBase(boolean bl, Block.Properties properties) {
        super(properties);
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_176387_N, EnumFacing.NORTH)).func_206870_a(field_176320_b, false));
        this.field_150082_a = bl;
    }

    @Override
    public boolean func_176214_u(IBlockState iBlockState) {
        return iBlockState.func_177229_b(field_176320_b) == false;
    }

    @Override
    public VoxelShape func_196244_b(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos) {
        if (iBlockState.func_177229_b(field_176320_b).booleanValue()) {
            switch (iBlockState.func_177229_b(field_176387_N)) {
                case DOWN: {
                    return field_185653_g;
                }
                default: {
                    return field_185652_f;
                }
                case NORTH: {
                    return field_185651_e;
                }
                case SOUTH: {
                    return field_185650_d;
                }
                case WEST: {
                    return field_185649_c;
                }
                case EAST: 
            }
            return field_185648_b;
        }
        return VoxelShapes.func_197868_b();
    }

    @Override
    public boolean func_185481_k(IBlockState iBlockState) {
        return iBlockState.func_177229_b(field_176320_b) == false || iBlockState.func_177229_b(field_176387_N) == EnumFacing.DOWN;
    }

    @Override
    public void func_180633_a(World world, BlockPos blockPos, IBlockState iBlockState, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        if (!world.field_72995_K) {
            this.func_176316_e(world, blockPos, iBlockState);
        }
    }

    @Override
    public void func_189540_a(IBlockState iBlockState, World world, BlockPos blockPos, Block block, BlockPos blockPos2) {
        if (!world.field_72995_K) {
            this.func_176316_e(world, blockPos, iBlockState);
        }
    }

    @Override
    public void func_196259_b(IBlockState iBlockState, World world, BlockPos blockPos, IBlockState iBlockState2) {
        if (iBlockState2.func_177230_c() == iBlockState.func_177230_c()) {
            return;
        }
        if (!world.field_72995_K && world.func_175625_s(blockPos) == null) {
            this.func_176316_e(world, blockPos, iBlockState);
        }
    }

    @Override
    public IBlockState func_196258_a(BlockItemUseContext blockItemUseContext) {
        return (IBlockState)((IBlockState)this.func_176223_P().func_206870_a(field_176387_N, blockItemUseContext.func_196010_d().func_176734_d())).func_206870_a(field_176320_b, false);
    }

    private void func_176316_e(World world, BlockPos blockPos, IBlockState iBlockState) {
        EnumFacing enumFacing = iBlockState.func_177229_b(field_176387_N);
        boolean \u26032 = this.func_176318_b(world, blockPos, enumFacing);
        if (\u26032 && !iBlockState.func_177229_b(field_176320_b).booleanValue()) {
            if (new BlockPistonStructureHelper(world, blockPos, enumFacing, true).func_177253_a()) {
                world.func_175641_c(blockPos, this, 0, enumFacing.func_176745_a());
            }
        } else if (!\u26032 && iBlockState.func_177229_b(field_176320_b).booleanValue()) {
            BlockPos blockPos2 = blockPos.func_177967_a(enumFacing, 2);
            IBlockState \u26033 = world.func_180495_p(blockPos2);
            int \u26034 = 1;
            if (\u26033.func_177230_c() == Blocks.field_196603_bb && \u26033.func_177229_b(field_176387_N) == enumFacing && (\u2603 = world.func_175625_s(blockPos2)) instanceof TileEntityPiston && (\u2603 = (TileEntityPiston)\u2603).func_145868_b() && (\u2603.func_145860_a(0.0f) < 0.5f || world.func_82737_E() == \u2603.func_211146_k() || ((WorldServer)world).func_211158_j_())) {
                \u26034 = 2;
            }
            world.func_175641_c(blockPos, this, \u26034, enumFacing.func_176745_a());
        }
    }

    private boolean func_176318_b(World world, BlockPos blockPos, EnumFacing enumFacing) {
        for (EnumFacing enumFacing2 : EnumFacing.values()) {
            if (enumFacing2 == enumFacing || !world.func_175709_b(blockPos.func_177972_a(enumFacing2), enumFacing2)) continue;
            return true;
        }
        if (world.func_175709_b(blockPos, EnumFacing.DOWN)) {
            return true;
        }
        BlockPos blockPos2 = blockPos.func_177984_a();
        for (EnumFacing enumFacing3 : EnumFacing.values()) {
            if (enumFacing3 == EnumFacing.DOWN || !world.func_175709_b(blockPos2.func_177972_a(enumFacing3), enumFacing3)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean func_189539_a(IBlockState iBlockState, World world, BlockPos blockPos, int n3, int n2) {
        int n3;
        EnumFacing enumFacing = iBlockState.func_177229_b(field_176387_N);
        if (!world.field_72995_K) {
            boolean bl = this.func_176318_b(world, blockPos, enumFacing);
            if (bl && (n3 == 1 || n3 == 2)) {
                world.func_180501_a(blockPos, (IBlockState)iBlockState.func_206870_a(field_176320_b, true), 2);
                return false;
            }
            if (!bl && n3 == 0) {
                return false;
            }
        }
        if (n3 == 0) {
            if (!this.func_176319_a(world, blockPos, enumFacing, true)) return false;
            world.func_180501_a(blockPos, (IBlockState)iBlockState.func_206870_a(field_176320_b, true), 67);
            world.func_184133_a(null, blockPos, SoundEvents.field_187715_dR, SoundCategory.BLOCKS, 0.5f, world.field_73012_v.nextFloat() * 0.25f + 0.6f);
            return true;
        } else {
            if (n3 != 1 && n3 != 2) return true;
            TileEntity tileEntity = world.func_175625_s(blockPos.func_177972_a(enumFacing));
            if (tileEntity instanceof TileEntityPiston) {
                ((TileEntityPiston)tileEntity).func_145866_f();
            }
            world.func_180501_a(blockPos, (IBlockState)((IBlockState)Blocks.field_196603_bb.func_176223_P().func_206870_a(BlockPistonMoving.field_196344_a, enumFacing)).func_206870_a(BlockPistonMoving.field_196345_b, this.field_150082_a ? PistonType.STICKY : PistonType.DEFAULT), 3);
            world.func_175690_a(blockPos, BlockPistonMoving.func_196343_a((IBlockState)this.func_176223_P().func_206870_a(field_176387_N, EnumFacing.func_82600_a(n2 & 7)), enumFacing, false, true));
            if (this.field_150082_a) {
                BlockPos blockPos2 = blockPos.func_177982_a(enumFacing.func_82601_c() * 2, enumFacing.func_96559_d() * 2, enumFacing.func_82599_e() * 2);
                IBlockState \u26032 = world.func_180495_p(blockPos2);
                Block \u26033 = \u26032.func_177230_c();
                boolean \u26034 = false;
                if (\u26033 == Blocks.field_196603_bb && (\u2603 = world.func_175625_s(blockPos2)) instanceof TileEntityPiston && (\u2603 = (TileEntityPiston)\u2603).func_212363_d() == enumFacing && \u2603.func_145868_b()) {
                    \u2603.func_145866_f();
                    \u26034 = true;
                }
                if (!\u26034) {
                    if (n3 == 1 && !\u26032.func_196958_f() && BlockPistonBase.func_185646_a(\u26032, world, blockPos2, enumFacing.func_176734_d(), false, enumFacing) && (\u26032.func_185905_o() == EnumPushReaction.NORMAL || \u26033 == Blocks.field_150331_J || \u26033 == Blocks.field_150320_F)) {
                        this.func_176319_a(world, blockPos, enumFacing, false);
                    } else {
                        world.func_175698_g(blockPos.func_177972_a(enumFacing));
                    }
                }
            } else {
                world.func_175698_g(blockPos.func_177972_a(enumFacing));
            }
            world.func_184133_a(null, blockPos, SoundEvents.field_187712_dQ, SoundCategory.BLOCKS, 0.5f, world.field_73012_v.nextFloat() * 0.15f + 0.6f);
        }
        return true;
    }

    @Override
    public boolean func_149686_d(IBlockState iBlockState) {
        return false;
    }

    public static boolean func_185646_a(IBlockState iBlockState, World world, BlockPos blockPos, EnumFacing enumFacing, boolean bl, EnumFacing enumFacing2) {
        Block block = iBlockState.func_177230_c();
        if (block == Blocks.field_150343_Z) {
            return false;
        }
        if (!world.func_175723_af().func_177746_a(blockPos)) {
            return false;
        }
        if (blockPos.func_177956_o() < 0 || enumFacing == EnumFacing.DOWN && blockPos.func_177956_o() == 0) {
            return false;
        }
        if (blockPos.func_177956_o() > world.func_72800_K() - 1 || enumFacing == EnumFacing.UP && blockPos.func_177956_o() == world.func_72800_K() - 1) {
            return false;
        }
        if (block == Blocks.field_150331_J || block == Blocks.field_150320_F) {
            if (iBlockState.func_177229_b(field_176320_b).booleanValue()) {
                return false;
            }
        } else {
            if (iBlockState.func_185887_b(world, blockPos) == -1.0f) {
                return false;
            }
            switch (iBlockState.func_185905_o()) {
                case BLOCK: {
                    return false;
                }
                case DESTROY: {
                    return bl;
                }
                case PUSH_ONLY: {
                    return enumFacing == enumFacing2;
                }
            }
        }
        return !block.func_149716_u();
    }

    private boolean func_176319_a(World world, BlockPos blockPos, EnumFacing enumFacing, boolean bl2) {
        int \u260311;
        Object \u260310;
        boolean bl2;
        Object \u260392;
        int n;
        BlockPistonStructureHelper blockPistonStructureHelper;
        BlockPos blockPos2 = blockPos.func_177972_a(enumFacing);
        if (!bl2 && world.func_180495_p(blockPos2).func_177230_c() == Blocks.field_150332_K) {
            world.func_180501_a(blockPos2, Blocks.field_150350_a.func_176223_P(), 20);
        }
        if (!(blockPistonStructureHelper = new BlockPistonStructureHelper(world, blockPos, enumFacing, bl2)).func_177253_a()) {
            return false;
        }
        List<BlockPos> \u26032 = blockPistonStructureHelper.func_177254_c();
        ArrayList \u26033 = Lists.newArrayList();
        for (int i = 0; i < \u26032.size(); ++i) {
            BlockPos blockPos3 = \u26032.get(i);
            \u26033.add(world.func_180495_p(blockPos3));
        }
        List<BlockPos> \u26034 = blockPistonStructureHelper.func_177252_d();
        int \u26035 = \u26032.size() + \u26034.size();
        IBlockState[] \u26036 = new IBlockState[\u26035];
        EnumFacing \u26037 = bl2 ? enumFacing : enumFacing.func_176734_d();
        HashSet \u26038 = Sets.newHashSet(\u26032);
        for (n = \u26034.size() - 1; n >= 0; --n) {
            \u260392 = \u26034.get(n);
            \u260310 = world.func_180495_p((BlockPos)\u260392);
            \u260310.func_196949_c(world, (BlockPos)\u260392, 0);
            world.func_180501_a((BlockPos)\u260392, Blocks.field_150350_a.func_176223_P(), 18);
            \u26036[--\u26035] = \u260310;
        }
        for (n = \u26032.size() - 1; n >= 0; --n) {
            \u260392 = \u26032.get(n);
            \u260310 = world.func_180495_p((BlockPos)\u260392);
            \u260392 = ((BlockPos)\u260392).func_177972_a(\u26037);
            \u26038.remove(\u260392);
            world.func_180501_a((BlockPos)\u260392, (IBlockState)Blocks.field_196603_bb.func_176223_P().func_206870_a(field_176387_N, enumFacing), 68);
            world.func_175690_a((BlockPos)\u260392, BlockPistonMoving.func_196343_a((IBlockState)\u26033.get(n), enumFacing, bl2, false));
            \u26036[--\u26035] = \u260310;
        }
        if (bl2) {
            PistonType pistonType = this.field_150082_a ? PistonType.STICKY : PistonType.DEFAULT;
            \u260392 = (IBlockState)((IBlockState)Blocks.field_150332_K.func_176223_P().func_206870_a(BlockPistonExtension.field_176387_N, enumFacing)).func_206870_a(BlockPistonExtension.field_176325_b, pistonType);
            \u260310 = (IBlockState)((IBlockState)Blocks.field_196603_bb.func_176223_P().func_206870_a(BlockPistonMoving.field_196344_a, enumFacing)).func_206870_a(BlockPistonMoving.field_196345_b, this.field_150082_a ? PistonType.STICKY : PistonType.DEFAULT);
            \u26038.remove(blockPos2);
            world.func_180501_a(blockPos2, (IBlockState)\u260310, 68);
            world.func_175690_a(blockPos2, BlockPistonMoving.func_196343_a((IBlockState)\u260392, enumFacing, true, true));
        }
        for (Object \u260392 : \u26038) {
            world.func_180501_a((BlockPos)\u260392, Blocks.field_150350_a.func_176223_P(), 66);
        }
        for (\u260311 = \u26034.size() - 1; \u260311 >= 0; --\u260311) {
            \u260392 = \u26036[\u26035++];
            \u260310 = \u26034.get(\u260311);
            \u260392.func_196948_b(world, (BlockPos)\u260310, 2);
            world.func_195593_d((BlockPos)\u260310, \u260392.func_177230_c());
        }
        for (\u260311 = \u26032.size() - 1; \u260311 >= 0; --\u260311) {
            world.func_195593_d(\u26032.get(\u260311), \u26036[\u26035++].func_177230_c());
        }
        if (bl2) {
            world.func_195593_d(blockPos2, Blocks.field_150332_K);
        }
        return true;
    }

    @Override
    public IBlockState func_185499_a(IBlockState iBlockState, Rotation rotation) {
        return (IBlockState)iBlockState.func_206870_a(field_176387_N, rotation.func_185831_a(iBlockState.func_177229_b(field_176387_N)));
    }

    @Override
    public IBlockState func_185471_a(IBlockState iBlockState, Mirror mirror) {
        return iBlockState.func_185907_a(mirror.func_185800_a(iBlockState.func_177229_b(field_176387_N)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(field_176387_N, field_176320_b);
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockReader iBlockReader, IBlockState iBlockState, BlockPos blockPos, EnumFacing enumFacing) {
        if (iBlockState.func_177229_b(field_176387_N) == enumFacing.func_176734_d() || !iBlockState.func_177229_b(field_176320_b).booleanValue()) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public int func_200011_d(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return 0;
    }

    @Override
    public boolean func_196266_a(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos, PathType pathType) {
        return false;
    }
}

