/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.cache.LoadingCache;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.init.Blocks;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class BlockPortal
extends Block {
    public static final EnumProperty<EnumFacing.Axis> field_176550_a = BlockStateProperties.field_208199_z;
    protected static final VoxelShape field_185683_b = Block.func_208617_a(0.0, 0.0, 6.0, 16.0, 16.0, 10.0);
    protected static final VoxelShape field_185684_c = Block.func_208617_a(6.0, 0.0, 0.0, 10.0, 16.0, 16.0);

    public BlockPortal(Block.Properties properties) {
        super(properties);
        this.func_180632_j((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_176550_a, EnumFacing.Axis.X));
    }

    @Override
    public VoxelShape func_196244_b(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos) {
        switch (iBlockState.func_177229_b(field_176550_a)) {
            case Z: {
                return field_185684_c;
            }
        }
        return field_185683_b;
    }

    @Override
    public void func_196267_b(IBlockState iBlockState, World world, BlockPos blockPos, Random random) {
        if (world.field_73011_w.func_76569_d() && world.func_82736_K().func_82766_b("doMobSpawning") && random.nextInt(2000) < world.func_175659_aa().func_151525_a()) {
            int n = blockPos.func_177956_o();
            BlockPos \u26032 = blockPos;
            while (!world.func_180495_p(\u26032).func_185896_q() && \u26032.func_177956_o() > 0) {
                \u26032 = \u26032.func_177977_b();
            }
            if (n > 0 && !world.func_180495_p(\u26032.func_177984_a()).func_185915_l() && (\u2603 = EntityType.field_200785_Y.func_208050_a(world, null, null, null, \u26032.func_177984_a(), false, false)) != null) {
                \u2603.field_71088_bW = \u2603.func_82147_ab();
            }
        }
    }

    @Override
    public boolean func_149686_d(IBlockState iBlockState) {
        return false;
    }

    public boolean func_176548_d(IWorld iWorld, BlockPos blockPos) {
        Size size = this.func_201816_b(iWorld, blockPos);
        if (size != null) {
            size.func_150859_c();
            return true;
        }
        return false;
    }

    @Nullable
    public Size func_201816_b(IWorld iWorld, BlockPos blockPos) {
        Size size = new Size(iWorld, blockPos, EnumFacing.Axis.X);
        if (size.func_150860_b() && size.field_150864_e == 0) {
            return size;
        }
        \u2603 = new Size(iWorld, blockPos, EnumFacing.Axis.Z);
        if (\u2603.func_150860_b() && \u2603.field_150864_e == 0) {
            return \u2603;
        }
        return null;
    }

    @Override
    public IBlockState func_196271_a(IBlockState iBlockState, EnumFacing enumFacing, IBlockState iBlockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
        EnumFacing.Axis axis = enumFacing.func_176740_k();
        \u2603 = iBlockState.func_177229_b(field_176550_a);
        boolean bl = \u2603 = \u2603 != axis && axis.func_176722_c();
        if (\u2603 || iBlockState2.func_177230_c() == this || new Size(iWorld, blockPos, \u2603).func_208508_f()) {
            return super.func_196271_a(iBlockState, enumFacing, iBlockState2, iWorld, blockPos, blockPos2);
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    @Override
    public int func_196264_a(IBlockState iBlockState, Random random) {
        return 0;
    }

    @Override
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @Override
    public void func_196262_a(IBlockState iBlockState, World world, BlockPos blockPos, Entity entity) {
        if (!entity.func_184218_aH() && !entity.func_184207_aI() && entity.func_184222_aU()) {
            entity.func_181015_d(blockPos);
        }
    }

    @Override
    public void func_180655_c(IBlockState iBlockState, World world, BlockPos blockPos, Random random) {
        if (random.nextInt(100) == 0) {
            world.func_184134_a((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5, SoundEvents.field_187810_eg, SoundCategory.BLOCKS, 0.5f, random.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double d = (float)blockPos.func_177958_n() + random.nextFloat();
            \u2603 = (float)blockPos.func_177956_o() + random.nextFloat();
            \u2603 = (float)blockPos.func_177952_p() + random.nextFloat();
            \u2603 = ((double)random.nextFloat() - 0.5) * 0.5;
            \u2603 = ((double)random.nextFloat() - 0.5) * 0.5;
            \u2603 = ((double)random.nextFloat() - 0.5) * 0.5;
            int \u26032 = random.nextInt(2) * 2 - 1;
            if (world.func_180495_p(blockPos.func_177976_e()).func_177230_c() == this || world.func_180495_p(blockPos.func_177974_f()).func_177230_c() == this) {
                \u2603 = (double)blockPos.func_177952_p() + 0.5 + 0.25 * (double)\u26032;
                \u2603 = random.nextFloat() * 2.0f * (float)\u26032;
            } else {
                d = (double)blockPos.func_177958_n() + 0.5 + 0.25 * (double)\u26032;
                \u2603 = random.nextFloat() * 2.0f * (float)\u26032;
            }
            world.func_195594_a(Particles.field_197599_J, d, \u2603, \u2603, \u2603, \u2603, \u2603);
        }
    }

    @Override
    public ItemStack func_185473_a(IBlockReader iBlockReader, BlockPos blockPos, IBlockState iBlockState) {
        return ItemStack.field_190927_a;
    }

    @Override
    public IBlockState func_185499_a(IBlockState iBlockState, Rotation rotation) {
        switch (rotation) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch (iBlockState.func_177229_b(field_176550_a)) {
                    case X: {
                        return (IBlockState)iBlockState.func_206870_a(field_176550_a, EnumFacing.Axis.Z);
                    }
                    case Z: {
                        return (IBlockState)iBlockState.func_206870_a(field_176550_a, EnumFacing.Axis.X);
                    }
                }
                return iBlockState;
            }
        }
        return iBlockState;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(field_176550_a);
    }

    public BlockPattern.PatternHelper func_181089_f(IWorld iWorld, BlockPos blockPos) {
        EnumFacing.Axis axis = EnumFacing.Axis.Z;
        Size \u26032 = new Size(iWorld, blockPos, EnumFacing.Axis.X);
        LoadingCache<BlockPos, BlockWorldState> \u26033 = BlockPattern.func_181627_a(iWorld, true);
        if (!\u26032.func_150860_b()) {
            axis = EnumFacing.Axis.X;
            \u26032 = new Size(iWorld, blockPos, EnumFacing.Axis.Z);
        }
        if (!\u26032.func_150860_b()) {
            return new BlockPattern.PatternHelper(blockPos, EnumFacing.NORTH, EnumFacing.UP, \u26033, 1, 1, 1);
        }
        int[] \u26034 = new int[EnumFacing.AxisDirection.values().length];
        EnumFacing \u26035 = \u26032.field_150866_c.func_176735_f();
        BlockPos \u26036 = \u26032.field_150861_f.func_177981_b(\u26032.func_181100_a() - 1);
        for (EnumFacing.AxisDirection axisDirection : EnumFacing.AxisDirection.values()) {
            Object object = new BlockPattern.PatternHelper(\u26035.func_176743_c() == axisDirection ? \u26036 : \u26036.func_177967_a(\u26032.field_150866_c, \u26032.func_181101_b() - 1), EnumFacing.func_181076_a(axisDirection, axis), EnumFacing.UP, \u26033, \u26032.func_181101_b(), \u26032.func_181100_a(), 1);
            for (int i = 0; i < \u26032.func_181101_b(); ++i) {
                for (\u2603 = 0; \u2603 < \u26032.func_181100_a(); ++\u2603) {
                    BlockWorldState blockWorldState = ((BlockPattern.PatternHelper)object).func_177670_a(i, \u2603, 1);
                    if (blockWorldState.func_177509_a().func_196958_f()) continue;
                    int n = axisDirection.ordinal();
                    \u26034[n] = \u26034[n] + 1;
                }
            }
        }
        EnumFacing.AxisDirection axisDirection = EnumFacing.AxisDirection.POSITIVE;
        for (Object object : EnumFacing.AxisDirection.values()) {
            if (\u26034[object.ordinal()] >= \u26034[axisDirection.ordinal()]) continue;
            axisDirection = object;
        }
        return new BlockPattern.PatternHelper(\u26035.func_176743_c() == axisDirection ? \u26036 : \u26036.func_177967_a(\u26032.field_150866_c, \u26032.func_181101_b() - 1), EnumFacing.func_181076_a(axisDirection, axis), EnumFacing.UP, \u26033, \u26032.func_181101_b(), \u26032.func_181100_a(), 1);
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockReader iBlockReader, IBlockState iBlockState, BlockPos blockPos, EnumFacing enumFacing) {
        return BlockFaceShape.UNDEFINED;
    }

    public static class Size {
        private final IWorld field_150867_a;
        private final EnumFacing.Axis field_150865_b;
        private final EnumFacing field_150866_c;
        private final EnumFacing field_150863_d;
        private int field_150864_e;
        private BlockPos field_150861_f;
        private int field_150862_g;
        private int field_150868_h;

        public Size(IWorld iWorld, BlockPos blockPos, EnumFacing.Axis axis) {
            this.field_150867_a = iWorld;
            this.field_150865_b = axis;
            if (axis == EnumFacing.Axis.X) {
                this.field_150863_d = EnumFacing.EAST;
                this.field_150866_c = EnumFacing.WEST;
            } else {
                this.field_150863_d = EnumFacing.NORTH;
                this.field_150866_c = EnumFacing.SOUTH;
            }
            BlockPos blockPos2 = blockPos;
            while (blockPos.func_177956_o() > blockPos2.func_177956_o() - 21 && blockPos.func_177956_o() > 0 && this.func_196900_a(iWorld.func_180495_p(blockPos.func_177977_b()))) {
                blockPos = blockPos.func_177977_b();
            }
            int \u26032 = this.func_180120_a(blockPos, this.field_150863_d) - 1;
            if (\u26032 >= 0) {
                this.field_150861_f = blockPos.func_177967_a(this.field_150863_d, \u26032);
                this.field_150868_h = this.func_180120_a(this.field_150861_f, this.field_150866_c);
                if (this.field_150868_h < 2 || this.field_150868_h > 21) {
                    this.field_150861_f = null;
                    this.field_150868_h = 0;
                }
            }
            if (this.field_150861_f != null) {
                this.field_150862_g = this.func_150858_a();
            }
        }

        protected int func_180120_a(BlockPos blockPos2, EnumFacing enumFacing) {
            BlockPos blockPos2;
            for (int i = 0; i < 22 && this.func_196900_a(this.field_150867_a.func_180495_p((BlockPos)(\u26032 = blockPos2.func_177967_a(enumFacing, i)))) && this.field_150867_a.func_180495_p(((BlockPos)\u26032).func_177977_b()).func_177230_c() == Blocks.field_150343_Z; ++i) {
            }
            Object \u26032 = this.field_150867_a.func_180495_p(blockPos2.func_177967_a(enumFacing, i)).func_177230_c();
            if (\u26032 == Blocks.field_150343_Z) {
                return i;
            }
            return 0;
        }

        public int func_181100_a() {
            return this.field_150862_g;
        }

        public int func_181101_b() {
            return this.field_150868_h;
        }

        protected int func_150858_a() {
            int n;
            this.field_150862_g = 0;
            block0: while (this.field_150862_g < 21) {
                for (n = 0; n < this.field_150868_h; ++n) {
                    BlockPos blockPos = this.field_150861_f.func_177967_a(this.field_150866_c, n).func_177981_b(this.field_150862_g);
                    IBlockState \u26032 = this.field_150867_a.func_180495_p(blockPos);
                    if (!this.func_196900_a(\u26032)) break block0;
                    Block \u26033 = \u26032.func_177230_c();
                    if (\u26033 == Blocks.field_150427_aO) {
                        ++this.field_150864_e;
                    }
                    if (n == 0 ? (\u26033 = this.field_150867_a.func_180495_p(blockPos.func_177972_a(this.field_150863_d)).func_177230_c()) != Blocks.field_150343_Z : n == this.field_150868_h - 1 && (\u26033 = this.field_150867_a.func_180495_p(blockPos.func_177972_a(this.field_150866_c)).func_177230_c()) != Blocks.field_150343_Z) break block0;
                }
                ++this.field_150862_g;
            }
            for (n = 0; n < this.field_150868_h; ++n) {
                if (this.field_150867_a.func_180495_p(this.field_150861_f.func_177967_a(this.field_150866_c, n).func_177981_b(this.field_150862_g)).func_177230_c() == Blocks.field_150343_Z) continue;
                this.field_150862_g = 0;
                break;
            }
            if (this.field_150862_g > 21 || this.field_150862_g < 3) {
                this.field_150861_f = null;
                this.field_150868_h = 0;
                this.field_150862_g = 0;
                return 0;
            }
            return this.field_150862_g;
        }

        protected boolean func_196900_a(IBlockState iBlockState) {
            Block block = iBlockState.func_177230_c();
            return iBlockState.func_196958_f() || block == Blocks.field_150480_ab || block == Blocks.field_150427_aO;
        }

        public boolean func_150860_b() {
            return this.field_150861_f != null && this.field_150868_h >= 2 && this.field_150868_h <= 21 && this.field_150862_g >= 3 && this.field_150862_g <= 21;
        }

        public void func_150859_c() {
            for (int i = 0; i < this.field_150868_h; ++i) {
                BlockPos blockPos = this.field_150861_f.func_177967_a(this.field_150866_c, i);
                for (int j = 0; j < this.field_150862_g; ++j) {
                    this.field_150867_a.func_180501_a(blockPos.func_177981_b(j), (IBlockState)Blocks.field_150427_aO.func_176223_P().func_206870_a(field_176550_a, this.field_150865_b), 18);
                }
            }
        }

        private boolean func_196899_f() {
            return this.field_150864_e >= this.field_150868_h * this.field_150862_g;
        }

        public boolean func_208508_f() {
            return this.func_150860_b() && this.func_196899_f();
        }
    }
}

