/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityShulkerBox;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockShulkerBox
extends BlockContainer {
    public static final EnumProperty<EnumFacing> field_190957_a = BlockDirectional.field_176387_N;
    @Nullable
    private final EnumDyeColor field_190958_b;

    public BlockShulkerBox(@Nullable EnumDyeColor enumDyeColor, Block.Properties properties) {
        super(properties);
        this.field_190958_b = enumDyeColor;
        this.func_180632_j((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_190957_a, EnumFacing.UP));
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader iBlockReader) {
        return new TileEntityShulkerBox(this.field_190958_b);
    }

    @Override
    public boolean func_176214_u(IBlockState iBlockState) {
        return true;
    }

    @Override
    public boolean func_149686_d(IBlockState iBlockState) {
        return false;
    }

    @Override
    public boolean func_190946_v(IBlockState iBlockState) {
        return true;
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState iBlockState) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @Override
    public boolean func_196250_a(IBlockState iBlockState, World world, BlockPos blockPos, EntityPlayer entityPlayer, EnumHand enumHand, EnumFacing enumFacing, float f, float f2, float f3) {
        if (world.field_72995_K) {
            return true;
        }
        if (entityPlayer.func_175149_v()) {
            return true;
        }
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (tileEntity instanceof TileEntityShulkerBox) {
            boolean \u26032;
            EnumFacing enumFacing2 = iBlockState.func_177229_b(field_190957_a);
            if (((TileEntityShulkerBox)tileEntity).func_190591_p() == TileEntityShulkerBox.AnimationStatus.CLOSED) {
                AxisAlignedBB axisAlignedBB = VoxelShapes.func_197868_b().func_197752_a().func_72321_a(0.5f * (float)enumFacing2.func_82601_c(), 0.5f * (float)enumFacing2.func_96559_d(), 0.5f * (float)enumFacing2.func_82599_e()).func_191195_a(enumFacing2.func_82601_c(), enumFacing2.func_96559_d(), enumFacing2.func_82599_e());
                \u26032 = world.func_195586_b(null, axisAlignedBB.func_186670_a(blockPos.func_177972_a(enumFacing2)));
            } else {
                \u26032 = true;
            }
            if (\u26032) {
                entityPlayer.func_195066_a(StatList.field_191272_ae);
                entityPlayer.func_71007_a((IInventory)((Object)tileEntity));
            }
            return true;
        }
        return false;
    }

    @Override
    public IBlockState func_196258_a(BlockItemUseContext blockItemUseContext) {
        return (IBlockState)this.func_176223_P().func_206870_a(field_190957_a, blockItemUseContext.func_196000_l());
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(field_190957_a);
    }

    @Override
    public void func_176208_a(World world2, BlockPos blockPos, IBlockState iBlockState, EntityPlayer entityPlayer) {
        World world2;
        if (world2.func_175625_s(blockPos) instanceof TileEntityShulkerBox) {
            TileEntityShulkerBox tileEntityShulkerBox = (TileEntityShulkerBox)world2.func_175625_s(blockPos);
            tileEntityShulkerBox.func_190579_a(entityPlayer.field_71075_bZ.field_75098_d);
            tileEntityShulkerBox.func_184281_d(entityPlayer);
        }
        super.func_176208_a(world2, blockPos, iBlockState, entityPlayer);
    }

    @Override
    public void func_196255_a(IBlockState iBlockState, World world, BlockPos blockPos, float f, int n) {
    }

    @Override
    public void func_180633_a(World world, BlockPos blockPos, IBlockState iBlockState, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        if (itemStack.func_82837_s() && (\u2603 = world.func_175625_s(blockPos)) instanceof TileEntityShulkerBox) {
            ((TileEntityShulkerBox)\u2603).func_200226_a(itemStack.func_200301_q());
        }
    }

    @Override
    public void func_196243_a(IBlockState iBlockState3, World world2, BlockPos blockPos, IBlockState iBlockState2, boolean bl) {
        IBlockState iBlockState3;
        if (iBlockState3.func_177230_c() == iBlockState2.func_177230_c()) {
            return;
        }
        TileEntity tileEntity = world2.func_175625_s(blockPos);
        if (tileEntity instanceof TileEntityShulkerBox) {
            World world2;
            TileEntityShulkerBox tileEntityShulkerBox = (TileEntityShulkerBox)tileEntity;
            if (!tileEntityShulkerBox.func_190590_r() && tileEntityShulkerBox.func_190582_F()) {
                ItemStack itemStack = new ItemStack(this);
                itemStack.func_196082_o().func_74782_a("BlockEntityTag", ((TileEntityShulkerBox)tileEntity).func_190580_f(new NBTTagCompound()));
                if (tileEntityShulkerBox.func_145818_k_()) {
                    itemStack.func_200302_a(tileEntityShulkerBox.func_200201_e());
                    tileEntityShulkerBox.func_200226_a(null);
                }
                BlockShulkerBox.func_180635_a(world2, blockPos, itemStack);
            }
            world2.func_175666_e(blockPos, iBlockState3.func_177230_c());
        }
        super.func_196243_a(iBlockState3, world2, blockPos, iBlockState2, bl);
    }

    @Override
    public void func_190948_a(ItemStack itemStack, @Nullable IBlockReader iBlockReader, List<ITextComponent> list2, ITooltipFlag iTooltipFlag) {
        super.func_190948_a(itemStack, iBlockReader, list2, iTooltipFlag);
        NBTTagCompound nBTTagCompound = itemStack.func_179543_a("BlockEntityTag");
        if (nBTTagCompound != null) {
            if (nBTTagCompound.func_150297_b("LootTable", 8)) {
                list2.add(new TextComponentString("???????"));
            }
            if (nBTTagCompound.func_150297_b("Items", 9)) {
                NonNullList<ItemStack> nonNullList = NonNullList.func_191197_a(27, ItemStack.field_190927_a);
                ItemStackHelper.func_191283_b(nBTTagCompound, nonNullList);
                int \u26032 = 0;
                int \u26033 = 0;
                for (ItemStack itemStack2 : nonNullList) {
                    if (itemStack2.func_190926_b()) continue;
                    ++\u26033;
                    if (\u26032 > 4) continue;
                    ++\u26032;
                    ITextComponent iTextComponent = itemStack2.func_200301_q().func_212638_h();
                    iTextComponent.func_150258_a(" x").func_150258_a(String.valueOf(itemStack2.func_190916_E()));
                    list2.add(iTextComponent);
                }
                if (\u26033 - \u26032 > 0) {
                    List<ITextComponent> list2;
                    list2.add(new TextComponentTranslation("container.shulkerBox.more", \u26033 - \u26032).func_211708_a(TextFormatting.ITALIC));
                }
            }
        }
    }

    @Override
    public EnumPushReaction func_149656_h(IBlockState iBlockState) {
        return EnumPushReaction.DESTROY;
    }

    @Override
    public VoxelShape func_196244_b(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos) {
        TileEntity tileEntity = iBlockReader.func_175625_s(blockPos);
        if (tileEntity instanceof TileEntityShulkerBox) {
            return VoxelShapes.func_197881_a(((TileEntityShulkerBox)tileEntity).func_190584_a(iBlockState));
        }
        return VoxelShapes.func_197868_b();
    }

    @Override
    public boolean func_200124_e(IBlockState iBlockState) {
        return false;
    }

    @Override
    public boolean func_149740_M(IBlockState iBlockState) {
        return true;
    }

    @Override
    public int func_180641_l(IBlockState iBlockState, World world, BlockPos blockPos) {
        return Container.func_94526_b((IInventory)((Object)world.func_175625_s(blockPos)));
    }

    @Override
    public ItemStack func_185473_a(IBlockReader iBlockReader, BlockPos blockPos, IBlockState iBlockState) {
        ItemStack itemStack = super.func_185473_a(iBlockReader, blockPos, iBlockState);
        TileEntityShulkerBox \u26032 = (TileEntityShulkerBox)iBlockReader.func_175625_s(blockPos);
        NBTTagCompound \u26033 = \u26032.func_190580_f(new NBTTagCompound());
        if (!\u26033.isEmpty()) {
            itemStack.func_77983_a("BlockEntityTag", \u26033);
        }
        return itemStack;
    }

    public static EnumDyeColor func_190955_b(Item item) {
        return BlockShulkerBox.func_190954_c(Block.func_149634_a(item));
    }

    public static EnumDyeColor func_190954_c(Block block) {
        if (block instanceof BlockShulkerBox) {
            return ((BlockShulkerBox)block).func_190956_e();
        }
        return null;
    }

    public static Block func_190952_a(EnumDyeColor enumDyeColor) {
        if (enumDyeColor == null) {
            return Blocks.field_204409_il;
        }
        switch (enumDyeColor) {
            case WHITE: {
                return Blocks.field_190977_dl;
            }
            case ORANGE: {
                return Blocks.field_190978_dm;
            }
            case MAGENTA: {
                return Blocks.field_190979_dn;
            }
            case LIGHT_BLUE: {
                return Blocks.field_190980_do;
            }
            case YELLOW: {
                return Blocks.field_190981_dp;
            }
            case LIME: {
                return Blocks.field_190982_dq;
            }
            case PINK: {
                return Blocks.field_190983_dr;
            }
            case GRAY: {
                return Blocks.field_190984_ds;
            }
            case LIGHT_GRAY: {
                return Blocks.field_196875_ie;
            }
            case CYAN: {
                return Blocks.field_190986_du;
            }
            default: {
                return Blocks.field_190987_dv;
            }
            case BLUE: {
                return Blocks.field_190988_dw;
            }
            case BROWN: {
                return Blocks.field_190989_dx;
            }
            case GREEN: {
                return Blocks.field_190990_dy;
            }
            case RED: {
                return Blocks.field_190991_dz;
            }
            case BLACK: 
        }
        return Blocks.field_190975_dA;
    }

    public EnumDyeColor func_190956_e() {
        return this.field_190958_b;
    }

    public static ItemStack func_190953_b(EnumDyeColor enumDyeColor) {
        return new ItemStack(BlockShulkerBox.func_190952_a(enumDyeColor));
    }

    @Override
    public IBlockState func_185499_a(IBlockState iBlockState, Rotation rotation) {
        return (IBlockState)iBlockState.func_206870_a(field_190957_a, rotation.func_185831_a(iBlockState.func_177229_b(field_190957_a)));
    }

    @Override
    public IBlockState func_185471_a(IBlockState iBlockState, Mirror mirror) {
        return iBlockState.func_185907_a(mirror.func_185800_a(iBlockState.func_177229_b(field_190957_a)));
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockReader iBlockReader, IBlockState iBlockState, BlockPos blockPos, EnumFacing enumFacing) {
        \u2603 = iBlockState.func_177229_b(field_190957_a);
        TileEntityShulkerBox.AnimationStatus animationStatus = ((TileEntityShulkerBox)iBlockReader.func_175625_s(blockPos)).func_190591_p();
        if (animationStatus == TileEntityShulkerBox.AnimationStatus.CLOSED || animationStatus == TileEntityShulkerBox.AnimationStatus.OPENED && (\u2603 == enumFacing.func_176734_d() || \u2603 == enumFacing)) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }
}

