/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;

public class BlockSlab
extends Block
implements IBucketPickupHandler,
ILiquidContainer {
    public static final EnumProperty<SlabType> field_196505_a = BlockStateProperties.field_208145_at;
    public static final BooleanProperty field_204512_b = BlockStateProperties.field_208198_y;
    protected static final VoxelShape field_196506_b = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
    protected static final VoxelShape field_196507_c = Block.func_208617_a(0.0, 8.0, 0.0, 16.0, 16.0, 16.0);

    public BlockSlab(Block.Properties properties) {
        super(properties);
        this.func_180632_j((IBlockState)((IBlockState)this.func_176223_P().func_206870_a(field_196505_a, SlabType.BOTTOM)).func_206870_a(field_204512_b, false));
    }

    @Override
    public int func_200011_d(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return iBlockReader.func_201572_C();
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(field_196505_a, field_204512_b);
    }

    @Override
    protected boolean func_149700_E() {
        return false;
    }

    @Override
    public VoxelShape func_196244_b(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos) {
        SlabType slabType = iBlockState.func_177229_b(field_196505_a);
        switch (slabType) {
            case DOUBLE: {
                return VoxelShapes.func_197868_b();
            }
            case TOP: {
                return field_196507_c;
            }
        }
        return field_196506_b;
    }

    @Override
    public boolean func_185481_k(IBlockState iBlockState) {
        return iBlockState.func_177229_b(field_196505_a) == SlabType.DOUBLE || iBlockState.func_177229_b(field_196505_a) == SlabType.TOP;
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockReader iBlockReader, IBlockState iBlockState, BlockPos blockPos, EnumFacing enumFacing) {
        SlabType slabType = iBlockState.func_177229_b(field_196505_a);
        if (slabType == SlabType.DOUBLE) {
            return BlockFaceShape.SOLID;
        }
        if (enumFacing == EnumFacing.UP && slabType == SlabType.TOP) {
            return BlockFaceShape.SOLID;
        }
        if (enumFacing == EnumFacing.DOWN && slabType == SlabType.BOTTOM) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    @Nullable
    public IBlockState func_196258_a(BlockItemUseContext blockItemUseContext) {
        IBlockState iBlockState = blockItemUseContext.func_195991_k().func_180495_p(blockItemUseContext.func_195995_a());
        if (iBlockState.func_177230_c() == this) {
            return (IBlockState)((IBlockState)iBlockState.func_206870_a(field_196505_a, SlabType.DOUBLE)).func_206870_a(field_204512_b, false);
        }
        IFluidState \u26032 = blockItemUseContext.func_195991_k().func_204610_c(blockItemUseContext.func_195995_a());
        \u2603 = (IBlockState)((IBlockState)this.func_176223_P().func_206870_a(field_196505_a, SlabType.BOTTOM)).func_206870_a(field_204512_b, \u26032.func_206886_c() == Fluids.field_204546_a);
        EnumFacing \u26033 = blockItemUseContext.func_196000_l();
        if (\u26033 == EnumFacing.DOWN || \u26033 != EnumFacing.UP && (double)blockItemUseContext.func_195993_n() > 0.5) {
            return (IBlockState)\u2603.func_206870_a(field_196505_a, SlabType.TOP);
        }
        return \u2603;
    }

    @Override
    public int func_196264_a(IBlockState iBlockState, Random random) {
        if (iBlockState.func_177229_b(field_196505_a) == SlabType.DOUBLE) {
            return 2;
        }
        return 1;
    }

    @Override
    public boolean func_149686_d(IBlockState iBlockState) {
        return iBlockState.func_177229_b(field_196505_a) == SlabType.DOUBLE;
    }

    @Override
    public boolean func_196253_a(IBlockState iBlockState, BlockItemUseContext blockItemUseContext) {
        ItemStack itemStack = blockItemUseContext.func_195996_i();
        SlabType \u26032 = iBlockState.func_177229_b(field_196505_a);
        if (\u26032 == SlabType.DOUBLE || itemStack.func_77973_b() != this.func_199767_j()) {
            return false;
        }
        if (blockItemUseContext.func_196012_c()) {
            boolean bl = (double)blockItemUseContext.func_195993_n() > 0.5;
            EnumFacing \u26033 = blockItemUseContext.func_196000_l();
            if (\u26032 == SlabType.BOTTOM) {
                return \u26033 == EnumFacing.UP || bl && \u26033.func_176740_k().func_176722_c();
            }
            return \u26033 == EnumFacing.DOWN || !bl && \u26033.func_176740_k().func_176722_c();
        }
        return true;
    }

    @Override
    public Fluid func_204508_a(IWorld iWorld, BlockPos blockPos, IBlockState iBlockState) {
        if (iBlockState.func_177229_b(field_204512_b).booleanValue()) {
            iWorld.func_180501_a(blockPos, (IBlockState)iBlockState.func_206870_a(field_204512_b, false), 3);
            return Fluids.field_204546_a;
        }
        return Fluids.field_204541_a;
    }

    @Override
    public IFluidState func_204507_t(IBlockState iBlockState) {
        if (iBlockState.func_177229_b(field_204512_b).booleanValue()) {
            return Fluids.field_204546_a.func_207204_a(false);
        }
        return super.func_204507_t(iBlockState);
    }

    @Override
    public boolean func_204510_a(IBlockReader iBlockReader, BlockPos blockPos, IBlockState iBlockState, Fluid fluid) {
        return iBlockState.func_177229_b(field_196505_a) != SlabType.DOUBLE && iBlockState.func_177229_b(field_204512_b) == false && fluid == Fluids.field_204546_a;
    }

    @Override
    public boolean func_204509_a(IWorld iWorld, BlockPos blockPos, IBlockState iBlockState, IFluidState iFluidState) {
        if (iBlockState.func_177229_b(field_196505_a) != SlabType.DOUBLE && !iBlockState.func_177229_b(field_204512_b).booleanValue() && iFluidState.func_206886_c() == Fluids.field_204546_a) {
            if (!iWorld.func_201670_d()) {
                iWorld.func_180501_a(blockPos, (IBlockState)iBlockState.func_206870_a(field_204512_b, true), 3);
                iWorld.func_205219_F_().func_205360_a(blockPos, iFluidState.func_206886_c(), iFluidState.func_206886_c().func_205569_a(iWorld));
            }
            return true;
        }
        return false;
    }

    @Override
    public IBlockState func_196271_a(IBlockState iBlockState, EnumFacing enumFacing, IBlockState iBlockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
        if (iBlockState.func_177229_b(field_204512_b).booleanValue()) {
            iWorld.func_205219_F_().func_205360_a(blockPos, Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a(iWorld));
        }
        return super.func_196271_a(iBlockState, enumFacing, iBlockState2, iWorld, blockPos, blockPos2);
    }

    @Override
    public boolean func_196266_a(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos, PathType pathType) {
        switch (pathType) {
            case LAND: {
                return iBlockState.func_177229_b(field_196505_a) == SlabType.BOTTOM;
            }
            case WATER: {
                return iBlockReader.func_204610_c(blockPos).func_206884_a(FluidTags.field_206959_a);
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }
}

