/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;

public class BlockStairs
extends Block
implements IBucketPickupHandler,
ILiquidContainer {
    public static final DirectionProperty field_176309_a = BlockHorizontal.field_185512_D;
    public static final EnumProperty<Half> field_176308_b = BlockStateProperties.field_208164_Q;
    public static final EnumProperty<StairsShape> field_176310_M = BlockStateProperties.field_208146_au;
    public static final BooleanProperty field_204513_t = BlockStateProperties.field_208198_y;
    protected static final VoxelShape field_185712_d = BlockSlab.field_196507_c;
    protected static final VoxelShape field_185719_G = BlockSlab.field_196506_b;
    protected static final VoxelShape field_196512_A = Block.func_208617_a(0.0, 0.0, 0.0, 8.0, 8.0, 8.0);
    protected static final VoxelShape field_196513_B = Block.func_208617_a(0.0, 0.0, 8.0, 8.0, 8.0, 16.0);
    protected static final VoxelShape field_196514_C = Block.func_208617_a(0.0, 8.0, 0.0, 8.0, 16.0, 8.0);
    protected static final VoxelShape field_196515_D = Block.func_208617_a(0.0, 8.0, 8.0, 8.0, 16.0, 16.0);
    protected static final VoxelShape field_196516_E = Block.func_208617_a(8.0, 0.0, 0.0, 16.0, 8.0, 8.0);
    protected static final VoxelShape field_196517_F = Block.func_208617_a(8.0, 0.0, 8.0, 16.0, 8.0, 16.0);
    protected static final VoxelShape field_196518_G = Block.func_208617_a(8.0, 8.0, 0.0, 16.0, 16.0, 8.0);
    protected static final VoxelShape field_196519_H = Block.func_208617_a(8.0, 8.0, 8.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape[] field_196520_I = BlockStairs.func_199779_a(field_185712_d, field_196512_A, field_196516_E, field_196513_B, field_196517_F);
    protected static final VoxelShape[] field_196521_J = BlockStairs.func_199779_a(field_185719_G, field_196514_C, field_196518_G, field_196515_D, field_196519_H);
    private static final int[] field_196522_K = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};
    private final Block field_150149_b;
    private final IBlockState field_150151_M;

    private static VoxelShape[] func_199779_a(VoxelShape voxelShape, VoxelShape voxelShape2, VoxelShape voxelShape3, VoxelShape voxelShape4, VoxelShape voxelShape5) {
        return (VoxelShape[])IntStream.range(0, 16).mapToObj(n -> BlockStairs.func_199781_a(n, voxelShape, voxelShape2, voxelShape3, voxelShape4, voxelShape5)).toArray(VoxelShape[]::new);
    }

    private static VoxelShape func_199781_a(int n, VoxelShape voxelShape, VoxelShape voxelShape2, VoxelShape voxelShape3, VoxelShape voxelShape4, VoxelShape voxelShape5) {
        \u2603 = voxelShape;
        if ((n & 1) != 0) {
            \u2603 = VoxelShapes.func_197872_a(\u2603, voxelShape2);
        }
        if ((n & 2) != 0) {
            \u2603 = VoxelShapes.func_197872_a(\u2603, voxelShape3);
        }
        if ((n & 4) != 0) {
            \u2603 = VoxelShapes.func_197872_a(\u2603, voxelShape4);
        }
        if ((n & 8) != 0) {
            \u2603 = VoxelShapes.func_197872_a(\u2603, voxelShape5);
        }
        return \u2603;
    }

    protected BlockStairs(IBlockState iBlockState, Block.Properties properties) {
        super(properties);
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_176309_a, EnumFacing.NORTH)).func_206870_a(field_176308_b, Half.BOTTOM)).func_206870_a(field_176310_M, StairsShape.STRAIGHT)).func_206870_a(field_204513_t, false));
        this.field_150149_b = iBlockState.func_177230_c();
        this.field_150151_M = iBlockState;
    }

    @Override
    public int func_200011_d(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return iBlockReader.func_201572_C();
    }

    @Override
    public VoxelShape func_196244_b(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return (iBlockState.func_177229_b(field_176308_b) == Half.TOP ? field_196520_I : field_196521_J)[field_196522_K[this.func_196511_x(iBlockState)]];
    }

    private int func_196511_x(IBlockState iBlockState) {
        return iBlockState.func_177229_b(field_176310_M).ordinal() * 4 + iBlockState.func_177229_b(field_176309_a).func_176736_b();
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockReader iBlockReader, IBlockState iBlockState, BlockPos blockPos, EnumFacing enumFacing) {
        if (enumFacing.func_176740_k() == EnumFacing.Axis.Y) {
            return enumFacing == EnumFacing.UP == (iBlockState.func_177229_b(field_176308_b) == Half.TOP) ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
        }
        StairsShape stairsShape = iBlockState.func_177229_b(field_176310_M);
        if (stairsShape == StairsShape.OUTER_LEFT || stairsShape == StairsShape.OUTER_RIGHT) {
            return BlockFaceShape.UNDEFINED;
        }
        EnumFacing \u26032 = iBlockState.func_177229_b(field_176309_a);
        switch (stairsShape) {
            case STRAIGHT: {
                return \u26032 == enumFacing ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
            }
            case INNER_LEFT: {
                return \u26032 == enumFacing || \u26032 == enumFacing.func_176746_e() ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
            }
            case INNER_RIGHT: {
                return \u26032 == enumFacing || \u26032 == enumFacing.func_176735_f() ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
            }
        }
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public boolean func_149686_d(IBlockState iBlockState) {
        return false;
    }

    @Override
    public void func_180655_c(IBlockState iBlockState, World world, BlockPos blockPos, Random random) {
        this.field_150149_b.func_180655_c(iBlockState, world, blockPos, random);
    }

    @Override
    public void func_196270_a(IBlockState iBlockState, World world, BlockPos blockPos, EntityPlayer entityPlayer) {
        this.field_150151_M.func_196942_a(world, blockPos, entityPlayer);
    }

    @Override
    public void func_176206_d(IWorld iWorld, BlockPos blockPos, IBlockState iBlockState) {
        this.field_150149_b.func_176206_d(iWorld, blockPos, iBlockState);
    }

    @Override
    public int func_185484_c(IBlockState iBlockState, IWorldReader iWorldReader, BlockPos blockPos) {
        return this.field_150151_M.func_185889_a(iWorldReader, blockPos);
    }

    @Override
    public float func_149638_a() {
        return this.field_150149_b.func_149638_a();
    }

    @Override
    public BlockRenderLayer func_180664_k() {
        return this.field_150149_b.func_180664_k();
    }

    @Override
    public int func_149738_a(IWorldReaderBase iWorldReaderBase) {
        return this.field_150149_b.func_149738_a(iWorldReaderBase);
    }

    @Override
    public boolean func_149703_v() {
        return this.field_150149_b.func_149703_v();
    }

    @Override
    public boolean func_200293_a(IBlockState iBlockState) {
        return this.field_150149_b.func_200293_a(iBlockState);
    }

    @Override
    public void func_196259_b(IBlockState iBlockState, World world, BlockPos blockPos, IBlockState iBlockState2) {
        if (iBlockState.func_177230_c() == iBlockState.func_177230_c()) {
            return;
        }
        this.field_150151_M.func_189546_a(world, blockPos, Blocks.field_150350_a, blockPos);
        this.field_150149_b.func_196259_b(this.field_150151_M, world, blockPos, iBlockState2);
    }

    @Override
    public void func_196243_a(IBlockState iBlockState, World world, BlockPos blockPos, IBlockState iBlockState2, boolean bl) {
        if (iBlockState.func_177230_c() == iBlockState2.func_177230_c()) {
            return;
        }
        this.field_150151_M.func_196947_b(world, blockPos, iBlockState2, bl);
    }

    @Override
    public void func_176199_a(World world, BlockPos blockPos, Entity entity) {
        this.field_150149_b.func_176199_a(world, blockPos, entity);
    }

    @Override
    public void func_196267_b(IBlockState iBlockState, World world, BlockPos blockPos, Random random) {
        this.field_150149_b.func_196267_b(iBlockState, world, blockPos, random);
    }

    @Override
    public boolean func_196250_a(IBlockState iBlockState, World world, BlockPos blockPos, EntityPlayer entityPlayer, EnumHand enumHand, EnumFacing enumFacing, float f, float f2, float f3) {
        return this.field_150151_M.func_196943_a(world, blockPos, entityPlayer, enumHand, EnumFacing.DOWN, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public void func_180652_a(World world, BlockPos blockPos, Explosion explosion) {
        this.field_150149_b.func_180652_a(world, blockPos, explosion);
    }

    @Override
    public boolean func_185481_k(IBlockState iBlockState) {
        return iBlockState.func_177229_b(field_176308_b) == Half.TOP;
    }

    @Override
    public IBlockState func_196258_a(BlockItemUseContext blockItemUseContext) {
        EnumFacing enumFacing = blockItemUseContext.func_196000_l();
        IFluidState \u26032 = blockItemUseContext.func_195991_k().func_204610_c(blockItemUseContext.func_195995_a());
        IBlockState \u26033 = (IBlockState)((IBlockState)((IBlockState)this.func_176223_P().func_206870_a(field_176309_a, blockItemUseContext.func_195992_f())).func_206870_a(field_176308_b, enumFacing == EnumFacing.DOWN || enumFacing != EnumFacing.UP && (double)blockItemUseContext.func_195993_n() > 0.5 ? Half.TOP : Half.BOTTOM)).func_206870_a(field_204513_t, \u26032.func_206886_c() == Fluids.field_204546_a);
        return (IBlockState)\u26033.func_206870_a(field_176310_M, BlockStairs.func_208064_n(\u26033, blockItemUseContext.func_195991_k(), blockItemUseContext.func_195995_a()));
    }

    @Override
    public IBlockState func_196271_a(IBlockState iBlockState, EnumFacing enumFacing, IBlockState iBlockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
        if (iBlockState.func_177229_b(field_204513_t).booleanValue()) {
            iWorld.func_205219_F_().func_205360_a(blockPos, Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a(iWorld));
        }
        if (enumFacing.func_176740_k().func_176722_c()) {
            return (IBlockState)iBlockState.func_206870_a(field_176310_M, BlockStairs.func_208064_n(iBlockState, iWorld, blockPos));
        }
        return super.func_196271_a(iBlockState, enumFacing, iBlockState2, iWorld, blockPos, blockPos2);
    }

    private static StairsShape func_208064_n(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos) {
        EnumFacing enumFacing = iBlockState.func_177229_b(field_176309_a);
        IBlockState \u26032 = iBlockReader.func_180495_p(blockPos.func_177972_a(enumFacing));
        if (BlockStairs.func_185709_i(\u26032) && iBlockState.func_177229_b(field_176308_b) == \u26032.func_177229_b(field_176308_b) && ((EnumFacing)(\u26033 = \u26032.func_177229_b(field_176309_a))).func_176740_k() != iBlockState.func_177229_b(field_176309_a).func_176740_k() && BlockStairs.func_185704_d(iBlockState, iBlockReader, blockPos, ((EnumFacing)\u26033).func_176734_d())) {
            if (\u26033 == enumFacing.func_176735_f()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        Object \u26033 = iBlockReader.func_180495_p(blockPos.func_177972_a(enumFacing.func_176734_d()));
        if (BlockStairs.func_185709_i((IBlockState)\u26033) && iBlockState.func_177229_b(field_176308_b) == \u26033.func_177229_b(field_176308_b) && (\u2603 = \u26033.func_177229_b(field_176309_a)).func_176740_k() != iBlockState.func_177229_b(field_176309_a).func_176740_k() && BlockStairs.func_185704_d(iBlockState, iBlockReader, blockPos, \u2603)) {
            if (\u2603 == enumFacing.func_176735_f()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean func_185704_d(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos, EnumFacing enumFacing) {
        IBlockState iBlockState2 = iBlockReader.func_180495_p(blockPos.func_177972_a(enumFacing));
        return !BlockStairs.func_185709_i(iBlockState2) || iBlockState2.func_177229_b(field_176309_a) != iBlockState.func_177229_b(field_176309_a) || iBlockState2.func_177229_b(field_176308_b) != iBlockState.func_177229_b(field_176308_b);
    }

    public static boolean func_185709_i(IBlockState iBlockState) {
        return iBlockState.func_177230_c() instanceof BlockStairs;
    }

    @Override
    public IBlockState func_185499_a(IBlockState iBlockState, Rotation rotation) {
        return (IBlockState)iBlockState.func_206870_a(field_176309_a, rotation.func_185831_a(iBlockState.func_177229_b(field_176309_a)));
    }

    @Override
    public IBlockState func_185471_a(IBlockState iBlockState, Mirror mirror) {
        EnumFacing enumFacing = iBlockState.func_177229_b(field_176309_a);
        StairsShape \u26032 = iBlockState.func_177229_b(field_176310_M);
        switch (mirror) {
            case LEFT_RIGHT: {
                if (enumFacing.func_176740_k() != EnumFacing.Axis.Z) break;
                switch (\u26032) {
                    case INNER_LEFT: {
                        return (IBlockState)iBlockState.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(field_176310_M, StairsShape.INNER_RIGHT);
                    }
                    case INNER_RIGHT: {
                        return (IBlockState)iBlockState.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(field_176310_M, StairsShape.INNER_LEFT);
                    }
                    case OUTER_LEFT: {
                        return (IBlockState)iBlockState.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(field_176310_M, StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (IBlockState)iBlockState.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(field_176310_M, StairsShape.OUTER_LEFT);
                    }
                }
                return iBlockState.func_185907_a(Rotation.CLOCKWISE_180);
            }
            case FRONT_BACK: {
                if (enumFacing.func_176740_k() != EnumFacing.Axis.X) break;
                switch (\u26032) {
                    case INNER_LEFT: {
                        return (IBlockState)iBlockState.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(field_176310_M, StairsShape.INNER_LEFT);
                    }
                    case INNER_RIGHT: {
                        return (IBlockState)iBlockState.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(field_176310_M, StairsShape.INNER_RIGHT);
                    }
                    case OUTER_LEFT: {
                        return (IBlockState)iBlockState.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(field_176310_M, StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (IBlockState)iBlockState.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(field_176310_M, StairsShape.OUTER_LEFT);
                    }
                    case STRAIGHT: {
                        return iBlockState.func_185907_a(Rotation.CLOCKWISE_180);
                    }
                }
                break;
            }
        }
        return super.func_185471_a(iBlockState, mirror);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(field_176309_a, field_176308_b, field_176310_M, field_204513_t);
    }

    @Override
    public Fluid func_204508_a(IWorld iWorld, BlockPos blockPos, IBlockState iBlockState) {
        if (iBlockState.func_177229_b(field_204513_t).booleanValue()) {
            iWorld.func_180501_a(blockPos, (IBlockState)iBlockState.func_206870_a(field_204513_t, false), 3);
            return Fluids.field_204546_a;
        }
        return Fluids.field_204541_a;
    }

    @Override
    public IFluidState func_204507_t(IBlockState iBlockState) {
        if (iBlockState.func_177229_b(field_204513_t).booleanValue()) {
            return Fluids.field_204546_a.func_207204_a(false);
        }
        return super.func_204507_t(iBlockState);
    }

    @Override
    public boolean func_204510_a(IBlockReader iBlockReader, BlockPos blockPos, IBlockState iBlockState, Fluid fluid) {
        return iBlockState.func_177229_b(field_204513_t) == false && fluid == Fluids.field_204546_a;
    }

    @Override
    public boolean func_204509_a(IWorld iWorld, BlockPos blockPos, IBlockState iBlockState, IFluidState iFluidState) {
        if (!iBlockState.func_177229_b(field_204513_t).booleanValue() && iFluidState.func_206886_c() == Fluids.field_204546_a) {
            if (!iWorld.func_201670_d()) {
                iWorld.func_180501_a(blockPos, (IBlockState)iBlockState.func_206870_a(field_204513_t, true), 3);
                iWorld.func_205219_F_().func_205360_a(blockPos, iFluidState.func_206886_c(), iFluidState.func_206886_c().func_205569_a(iWorld));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean func_196266_a(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos, PathType pathType) {
        return false;
    }
}

