/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockStemGrown;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockStem
extends BlockBush
implements IGrowable {
    public static final IntegerProperty field_176484_a = BlockStateProperties.field_208170_W;
    protected static final VoxelShape[] field_196388_b = new VoxelShape[]{Block.func_208617_a(7.0, 0.0, 7.0, 9.0, 2.0, 9.0), Block.func_208617_a(7.0, 0.0, 7.0, 9.0, 4.0, 9.0), Block.func_208617_a(7.0, 0.0, 7.0, 9.0, 6.0, 9.0), Block.func_208617_a(7.0, 0.0, 7.0, 9.0, 8.0, 9.0), Block.func_208617_a(7.0, 0.0, 7.0, 9.0, 10.0, 9.0), Block.func_208617_a(7.0, 0.0, 7.0, 9.0, 12.0, 9.0), Block.func_208617_a(7.0, 0.0, 7.0, 9.0, 14.0, 9.0), Block.func_208617_a(7.0, 0.0, 7.0, 9.0, 16.0, 9.0)};
    private final BlockStemGrown field_149877_a;

    protected BlockStem(BlockStemGrown blockStemGrown, Block.Properties properties) {
        super(properties);
        this.field_149877_a = blockStemGrown;
        this.func_180632_j((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_176484_a, 0));
    }

    @Override
    public VoxelShape func_196244_b(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return field_196388_b[iBlockState.func_177229_b(field_176484_a)];
    }

    @Override
    protected boolean func_200014_a_(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return iBlockState.func_177230_c() == Blocks.field_150458_ak;
    }

    @Override
    public void func_196267_b(IBlockState iBlockState2, World world, BlockPos blockPos, Random random2) {
        super.func_196267_b(iBlockState2, world, blockPos, random2);
        if (world.func_201669_a(blockPos.func_177984_a(), 0) < 9) {
            return;
        }
        float f = BlockCrops.func_180672_a(this, world, blockPos);
        if (random2.nextInt((int)(25.0f / f) + 1) == 0) {
            int n = iBlockState2.func_177229_b(field_176484_a);
            if (n < 7) {
                IBlockState iBlockState2 = (IBlockState)iBlockState2.func_206870_a(field_176484_a, n + 1);
                world.func_180501_a(blockPos, iBlockState2, 2);
            } else {
                Random random2;
                EnumFacing \u26032 = EnumFacing.Plane.HORIZONTAL.func_179518_a(random2);
                BlockPos \u26033 = blockPos.func_177972_a(\u26032);
                Block \u26034 = world.func_180495_p(\u26033.func_177977_b()).func_177230_c();
                if (world.func_180495_p(\u26033).func_196958_f() && (\u26034 == Blocks.field_150458_ak || \u26034 == Blocks.field_150346_d || \u26034 == Blocks.field_196660_k || \u26034 == Blocks.field_196661_l || \u26034 == Blocks.field_196658_i)) {
                    world.func_175656_a(\u26033, this.field_149877_a.func_176223_P());
                    world.func_175656_a(blockPos, (IBlockState)this.field_149877_a.func_196523_e().func_176223_P().func_206870_a(BlockHorizontal.field_185512_D, \u26032));
                }
            }
        }
    }

    @Override
    public void func_196255_a(IBlockState iBlockState, World world, BlockPos blockPos, float f, int n) {
        super.func_196255_a(iBlockState, world, blockPos, f, n);
        if (world.field_72995_K) {
            return;
        }
        Item item = this.func_176481_j();
        if (item == null) {
            return;
        }
        int \u26032 = iBlockState.func_177229_b(field_176484_a);
        for (int i = 0; i < 3; ++i) {
            if (world.field_73012_v.nextInt(15) > \u26032) continue;
            BlockStem.func_180635_a(world, blockPos, new ItemStack(item));
        }
    }

    @Nullable
    protected Item func_176481_j() {
        if (this.field_149877_a == Blocks.field_150423_aK) {
            return Items.field_151080_bb;
        }
        if (this.field_149877_a == Blocks.field_150440_ba) {
            return Items.field_151081_bc;
        }
        return null;
    }

    @Override
    public IItemProvider func_199769_a(IBlockState iBlockState, World world, BlockPos blockPos, int n) {
        return Items.field_190931_a;
    }

    @Override
    public ItemStack func_185473_a(IBlockReader iBlockReader, BlockPos blockPos, IBlockState iBlockState) {
        Item item = this.func_176481_j();
        return item == null ? ItemStack.field_190927_a : new ItemStack(item);
    }

    @Override
    public boolean func_176473_a(IBlockReader iBlockReader, BlockPos blockPos, IBlockState iBlockState, boolean bl) {
        return iBlockState.func_177229_b(field_176484_a) != 7;
    }

    @Override
    public boolean func_180670_a(World world, Random random, BlockPos blockPos, IBlockState iBlockState) {
        return true;
    }

    @Override
    public void func_176474_b(World world, Random random, BlockPos blockPos, IBlockState iBlockState) {
        int n = Math.min(7, iBlockState.func_177229_b(field_176484_a) + MathHelper.func_76136_a(world.field_73012_v, 2, 5));
        IBlockState \u26032 = (IBlockState)iBlockState.func_206870_a(field_176484_a, n);
        world.func_180501_a(blockPos, \u26032, 2);
        if (n == 7) {
            \u26032.func_196940_a(world, blockPos, world.field_73012_v);
        }
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(field_176484_a);
    }

    public BlockStemGrown func_208486_d() {
        return this.field_149877_a;
    }
}

