/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.BlockSixWay;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.stats.StatList;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;

public class BlockVine
extends Block {
    public static final BooleanProperty field_176277_a = BlockSixWay.field_196496_z;
    public static final BooleanProperty field_176273_b = BlockSixWay.field_196488_a;
    public static final BooleanProperty field_176278_M = BlockSixWay.field_196490_b;
    public static final BooleanProperty field_176279_N = BlockSixWay.field_196492_c;
    public static final BooleanProperty field_176280_O = BlockSixWay.field_196495_y;
    public static final Map<EnumFacing, BooleanProperty> field_196546_A = BlockSixWay.field_196491_B.entrySet().stream().filter(entry -> entry.getKey() != EnumFacing.DOWN).collect(Util.func_199749_a());
    protected static final VoxelShape field_185757_g = Block.func_208617_a(0.0, 15.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape field_185753_B = Block.func_208617_a(0.0, 0.0, 0.0, 1.0, 16.0, 16.0);
    protected static final VoxelShape field_185754_C = Block.func_208617_a(15.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape field_185755_D = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 16.0, 1.0);
    protected static final VoxelShape field_185756_E = Block.func_208617_a(0.0, 0.0, 15.0, 16.0, 16.0, 16.0);

    public BlockVine(Block.Properties properties) {
        super(properties);
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_176277_a, false)).func_206870_a(field_176273_b, false)).func_206870_a(field_176278_M, false)).func_206870_a(field_176279_N, false)).func_206870_a(field_176280_O, false));
    }

    @Override
    public VoxelShape func_196244_b(IBlockState iBlockState, IBlockReader iBlockReader, BlockPos blockPos) {
        VoxelShape voxelShape = VoxelShapes.func_197880_a();
        if (iBlockState.func_177229_b(field_176277_a).booleanValue()) {
            voxelShape = VoxelShapes.func_197872_a(voxelShape, field_185757_g);
        }
        if (iBlockState.func_177229_b(field_176273_b).booleanValue()) {
            voxelShape = VoxelShapes.func_197872_a(voxelShape, field_185755_D);
        }
        if (iBlockState.func_177229_b(field_176278_M).booleanValue()) {
            voxelShape = VoxelShapes.func_197872_a(voxelShape, field_185754_C);
        }
        if (iBlockState.func_177229_b(field_176279_N).booleanValue()) {
            voxelShape = VoxelShapes.func_197872_a(voxelShape, field_185756_E);
        }
        if (iBlockState.func_177229_b(field_176280_O).booleanValue()) {
            voxelShape = VoxelShapes.func_197872_a(voxelShape, field_185753_B);
        }
        return voxelShape;
    }

    @Override
    public boolean func_149686_d(IBlockState iBlockState) {
        return false;
    }

    @Override
    public boolean func_196260_a(IBlockState iBlockState, IWorldReaderBase iWorldReaderBase, BlockPos blockPos) {
        return this.func_196543_i(this.func_196545_h(iBlockState, iWorldReaderBase, blockPos));
    }

    private boolean func_196543_i(IBlockState iBlockState) {
        return this.func_208496_w(iBlockState) > 0;
    }

    private int func_208496_w(IBlockState iBlockState) {
        int n = 0;
        for (BooleanProperty booleanProperty : field_196546_A.values()) {
            if (!iBlockState.func_177229_b(booleanProperty).booleanValue()) continue;
            ++n;
        }
        return n;
    }

    private boolean func_196541_a(IBlockReader iBlockReader, BlockPos blockPos, EnumFacing enumFacing) {
        if (enumFacing == EnumFacing.DOWN) {
            return false;
        }
        BlockPos blockPos2 = blockPos.func_177972_a(enumFacing);
        if (this.func_196542_b(iBlockReader, blockPos2, enumFacing)) {
            return true;
        }
        if (enumFacing.func_176740_k() != EnumFacing.Axis.Y) {
            BooleanProperty booleanProperty = field_196546_A.get(enumFacing);
            IBlockState \u26032 = iBlockReader.func_180495_p(blockPos.func_177984_a());
            return \u26032.func_177230_c() == this && \u26032.func_177229_b(booleanProperty) != false;
        }
        return false;
    }

    private boolean func_196542_b(IBlockReader iBlockReader, BlockPos blockPos, EnumFacing enumFacing) {
        IBlockState iBlockState = iBlockReader.func_180495_p(blockPos);
        return iBlockState.func_193401_d(iBlockReader, blockPos, enumFacing.func_176734_d()) == BlockFaceShape.SOLID && !BlockVine.func_193397_e(iBlockState.func_177230_c());
    }

    protected static boolean func_193397_e(Block block) {
        return block instanceof BlockShulkerBox || block instanceof BlockStainedGlass || block == Blocks.field_150461_bJ || block == Blocks.field_150383_bp || block == Blocks.field_150359_w || block == Blocks.field_150331_J || block == Blocks.field_150320_F || block == Blocks.field_150332_K || block.func_203417_a(BlockTags.field_212186_k);
    }

    private IBlockState func_196545_h(IBlockState iBlockState2, IBlockReader iBlockReader, BlockPos blockPos) {
        IBlockState iBlockState2;
        \u2603 = blockPos.func_177984_a();
        if (iBlockState2.func_177229_b(field_176277_a).booleanValue()) {
            iBlockState2 = (IBlockState)iBlockState2.func_206870_a(field_176277_a, this.func_196542_b(iBlockReader, \u2603, EnumFacing.DOWN));
        }
        IBlockState iBlockState3 = null;
        for (EnumFacing enumFacing : EnumFacing.Plane.HORIZONTAL) {
            BooleanProperty booleanProperty = BlockVine.func_176267_a(enumFacing);
            if (!iBlockState2.func_177229_b(booleanProperty).booleanValue()) continue;
            boolean \u26032 = this.func_196541_a(iBlockReader, blockPos, enumFacing);
            if (!\u26032) {
                if (iBlockState3 == null) {
                    iBlockState3 = iBlockReader.func_180495_p(\u2603);
                }
                \u26032 = iBlockState3.func_177230_c() == this && iBlockState3.func_177229_b(booleanProperty) != false;
            }
            iBlockState2 = (IBlockState)iBlockState2.func_206870_a(booleanProperty, \u26032);
        }
        return iBlockState2;
    }

    @Override
    public IBlockState func_196271_a(IBlockState iBlockState, EnumFacing enumFacing, IBlockState iBlockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
        if (enumFacing == EnumFacing.DOWN) {
            return super.func_196271_a(iBlockState, enumFacing, iBlockState2, iWorld, blockPos, blockPos2);
        }
        IBlockState iBlockState3 = this.func_196545_h(iBlockState, iWorld, blockPos);
        if (!this.func_196543_i(iBlockState3)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return iBlockState3;
    }

    @Override
    public void func_196267_b(IBlockState iBlockState, World world, BlockPos blockPos, Random random) {
        if (world.field_72995_K) {
            return;
        }
        IBlockState iBlockState2 = this.func_196545_h(iBlockState, world, blockPos);
        if (iBlockState2 != iBlockState) {
            if (this.func_196543_i(iBlockState2)) {
                world.func_180501_a(blockPos, iBlockState2, 2);
            } else {
                iBlockState.func_196949_c(world, blockPos, 0);
                world.func_175698_g(blockPos);
            }
            return;
        }
        if (world.field_73012_v.nextInt(4) != 0) {
            return;
        }
        EnumFacing \u26032 = EnumFacing.func_176741_a(random);
        BlockPos \u26033 = blockPos.func_177984_a();
        if (\u26032.func_176740_k().func_176722_c() && !iBlockState.func_177229_b(BlockVine.func_176267_a(\u26032)).booleanValue()) {
            if (!this.func_196539_a(world, blockPos)) {
                return;
            }
            BlockPos blockPos2 = blockPos.func_177972_a(\u26032);
            IBlockState \u26034 = world.func_180495_p(blockPos2);
            if (\u26034.func_196958_f()) {
                EnumFacing enumFacing = \u26032.func_176746_e();
                \u2603 = \u26032.func_176735_f();
                boolean \u26035 = iBlockState.func_177229_b(BlockVine.func_176267_a(enumFacing));
                boolean \u26036 = iBlockState.func_177229_b(BlockVine.func_176267_a(\u2603));
                BlockPos \u26037 = blockPos2.func_177972_a(enumFacing);
                BlockPos \u26038 = blockPos2.func_177972_a(\u2603);
                if (\u26035 && this.func_196542_b(world, \u26037, enumFacing)) {
                    world.func_180501_a(blockPos2, (IBlockState)this.func_176223_P().func_206870_a(BlockVine.func_176267_a(enumFacing), true), 2);
                } else if (\u26036 && this.func_196542_b(world, \u26038, \u2603)) {
                    world.func_180501_a(blockPos2, (IBlockState)this.func_176223_P().func_206870_a(BlockVine.func_176267_a(\u2603), true), 2);
                } else {
                    \u2603 = \u26032.func_176734_d();
                    if (\u26035 && world.func_175623_d(\u26037) && this.func_196542_b(world, blockPos.func_177972_a(enumFacing), \u2603)) {
                        world.func_180501_a(\u26037, (IBlockState)this.func_176223_P().func_206870_a(BlockVine.func_176267_a(\u2603), true), 2);
                    } else if (\u26036 && world.func_175623_d(\u26038) && this.func_196542_b(world, blockPos.func_177972_a(\u2603), \u2603)) {
                        world.func_180501_a(\u26038, (IBlockState)this.func_176223_P().func_206870_a(BlockVine.func_176267_a(\u2603), true), 2);
                    } else if ((double)world.field_73012_v.nextFloat() < 0.05 && this.func_196542_b(world, blockPos2.func_177984_a(), EnumFacing.UP)) {
                        world.func_180501_a(blockPos2, (IBlockState)this.func_176223_P().func_206870_a(field_176277_a, true), 2);
                    }
                }
            } else if (this.func_196542_b(world, blockPos2, \u26032)) {
                world.func_180501_a(blockPos, (IBlockState)iBlockState.func_206870_a(BlockVine.func_176267_a(\u26032), true), 2);
            }
            return;
        }
        if (\u26032 == EnumFacing.UP && blockPos.func_177956_o() < 255) {
            if (this.func_196541_a(world, blockPos, \u26032)) {
                world.func_180501_a(blockPos, (IBlockState)iBlockState.func_206870_a(field_176277_a, true), 2);
                return;
            }
            if (world.func_175623_d(\u26033)) {
                if (!this.func_196539_a(world, blockPos)) {
                    return;
                }
                IBlockState \u26039 = iBlockState;
                for (EnumFacing enumFacing : EnumFacing.Plane.HORIZONTAL) {
                    if (!random.nextBoolean() && this.func_196542_b(world, \u26033.func_177972_a(enumFacing), EnumFacing.UP)) continue;
                    \u26039 = (IBlockState)\u26039.func_206870_a(BlockVine.func_176267_a(enumFacing), false);
                }
                if (this.func_196540_x(\u26039)) {
                    world.func_180501_a(\u26033, \u26039, 2);
                }
                return;
            }
        }
        if (blockPos.func_177956_o() > 0 && ((\u2603 = world.func_180495_p(\u2603 = blockPos.func_177977_b())).func_196958_f() || \u2603.func_177230_c() == this) && (\u2603 = \u2603.func_196958_f() ? this.func_176223_P() : \u2603) != (\u2603 = this.func_196544_a(iBlockState, \u2603, random)) && this.func_196540_x(\u2603)) {
            world.func_180501_a(\u2603, \u2603, 2);
        }
    }

    private IBlockState func_196544_a(IBlockState iBlockState, IBlockState iBlockState22, Random random) {
        IBlockState iBlockState22;
        for (EnumFacing enumFacing : EnumFacing.Plane.HORIZONTAL) {
            if (!random.nextBoolean() || !iBlockState.func_177229_b(\u2603 = BlockVine.func_176267_a(enumFacing)).booleanValue()) continue;
            iBlockState22 = (IBlockState)iBlockState22.func_206870_a(\u2603, true);
        }
        return iBlockState22;
    }

    private boolean func_196540_x(IBlockState iBlockState) {
        return iBlockState.func_177229_b(field_176273_b) != false || iBlockState.func_177229_b(field_176278_M) != false || iBlockState.func_177229_b(field_176279_N) != false || iBlockState.func_177229_b(field_176280_O) != false;
    }

    private boolean func_196539_a(IBlockReader iBlockReader, BlockPos blockPos) {
        int n = 4;
        Iterable<BlockPos.MutableBlockPos> \u26032 = BlockPos.MutableBlockPos.func_191531_b(blockPos.func_177958_n() - 4, blockPos.func_177956_o() - 1, blockPos.func_177952_p() - 4, blockPos.func_177958_n() + 4, blockPos.func_177956_o() + 1, blockPos.func_177952_p() + 4);
        int n2 = 5;
        for (BlockPos blockPos2 : \u26032) {
            if (iBlockReader.func_180495_p(blockPos2).func_177230_c() != this || --n2 > 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean func_196253_a(IBlockState iBlockState, BlockItemUseContext blockItemUseContext) {
        IBlockState iBlockState2 = blockItemUseContext.func_195991_k().func_180495_p(blockItemUseContext.func_195995_a());
        if (iBlockState2.func_177230_c() == this) {
            return this.func_208496_w(iBlockState2) < field_196546_A.size();
        }
        return super.func_196253_a(iBlockState, blockItemUseContext);
    }

    @Override
    @Nullable
    public IBlockState func_196258_a(BlockItemUseContext blockItemUseContext) {
        IBlockState iBlockState;
        IBlockState iBlockState2 = blockItemUseContext.func_195991_k().func_180495_p(blockItemUseContext.func_195995_a());
        boolean \u26032 = iBlockState2.func_177230_c() == this;
        iBlockState = \u26032 ? iBlockState2 : this.func_176223_P();
        for (EnumFacing enumFacing : blockItemUseContext.func_196009_e()) {
            if (enumFacing == EnumFacing.DOWN) continue;
            BooleanProperty booleanProperty = BlockVine.func_176267_a(enumFacing);
            boolean bl = \u2603 = \u26032 && iBlockState2.func_177229_b(booleanProperty) != false;
            if (\u2603 || !this.func_196541_a(blockItemUseContext.func_195991_k(), blockItemUseContext.func_195995_a(), enumFacing)) continue;
            return (IBlockState)iBlockState.func_206870_a(booleanProperty, true);
        }
        return \u26032 ? iBlockState : null;
    }

    @Override
    public IItemProvider func_199769_a(IBlockState iBlockState, World world, BlockPos blockPos, int n) {
        return Items.field_190931_a;
    }

    @Override
    public void func_180657_a(World world, EntityPlayer entityPlayer, BlockPos blockPos, IBlockState iBlockState, @Nullable TileEntity tileEntity, ItemStack itemStack) {
        if (!world.field_72995_K && itemStack.func_77973_b() == Items.field_151097_aZ) {
            entityPlayer.func_71029_a(StatList.field_188065_ae.func_199076_b(this));
            entityPlayer.func_71020_j(0.005f);
            BlockVine.func_180635_a(world, blockPos, new ItemStack(Blocks.field_150395_bd));
        } else {
            super.func_180657_a(world, entityPlayer, blockPos, iBlockState, tileEntity, itemStack);
        }
    }

    @Override
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(field_176277_a, field_176273_b, field_176278_M, field_176279_N, field_176280_O);
    }

    @Override
    public IBlockState func_185499_a(IBlockState iBlockState, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return (IBlockState)((IBlockState)((IBlockState)((IBlockState)iBlockState.func_206870_a(field_176273_b, iBlockState.func_177229_b(field_176279_N))).func_206870_a(field_176278_M, iBlockState.func_177229_b(field_176280_O))).func_206870_a(field_176279_N, iBlockState.func_177229_b(field_176273_b))).func_206870_a(field_176280_O, iBlockState.func_177229_b(field_176278_M));
            }
            case COUNTERCLOCKWISE_90: {
                return (IBlockState)((IBlockState)((IBlockState)((IBlockState)iBlockState.func_206870_a(field_176273_b, iBlockState.func_177229_b(field_176278_M))).func_206870_a(field_176278_M, iBlockState.func_177229_b(field_176279_N))).func_206870_a(field_176279_N, iBlockState.func_177229_b(field_176280_O))).func_206870_a(field_176280_O, iBlockState.func_177229_b(field_176273_b));
            }
            case CLOCKWISE_90: {
                return (IBlockState)((IBlockState)((IBlockState)((IBlockState)iBlockState.func_206870_a(field_176273_b, iBlockState.func_177229_b(field_176280_O))).func_206870_a(field_176278_M, iBlockState.func_177229_b(field_176273_b))).func_206870_a(field_176279_N, iBlockState.func_177229_b(field_176278_M))).func_206870_a(field_176280_O, iBlockState.func_177229_b(field_176279_N));
            }
        }
        return iBlockState;
    }

    @Override
    public IBlockState func_185471_a(IBlockState iBlockState, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return (IBlockState)((IBlockState)iBlockState.func_206870_a(field_176273_b, iBlockState.func_177229_b(field_176279_N))).func_206870_a(field_176279_N, iBlockState.func_177229_b(field_176273_b));
            }
            case FRONT_BACK: {
                return (IBlockState)((IBlockState)iBlockState.func_206870_a(field_176278_M, iBlockState.func_177229_b(field_176280_O))).func_206870_a(field_176280_O, iBlockState.func_177229_b(field_176278_M));
            }
        }
        return super.func_185471_a(iBlockState, mirror);
    }

    public static BooleanProperty func_176267_a(EnumFacing enumFacing) {
        return field_196546_A.get(enumFacing);
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockReader iBlockReader, IBlockState iBlockState, BlockPos blockPos, EnumFacing enumFacing) {
        return BlockFaceShape.UNDEFINED;
    }
}

