/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixTypes;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.ResourcePackInfoClient;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.tutorial.TutorialSteps;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.play.client.CPacketClientSettings;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GameSettings {
    private static final Logger field_151454_ax = LogManager.getLogger();
    private static final Gson field_151450_ay = new Gson();
    private static final Type field_151449_az = new ParameterizedType(){

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{String.class};
        }

        @Override
        public Type getRawType() {
            return List.class;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }
    };
    public static final Splitter field_189990_a = Splitter.on((char)':');
    private static final String[] field_74364_ag = new String[]{"options.particles.all", "options.particles.decreased", "options.particles.minimal"};
    private static final String[] field_98303_au = new String[]{"options.ao.off", "options.ao.min", "options.ao.max"};
    private static final String[] field_181149_aW = new String[]{"options.off", "options.clouds.fast", "options.clouds.fancy"};
    private static final String[] field_186713_aK = new String[]{"options.off", "options.attack.crosshair", "options.attack.hotbar"};
    public static final String[] field_193632_b = new String[]{"options.narrator.off", "options.narrator.all", "options.narrator.chat", "options.narrator.system"};
    public double field_74341_c = 0.5;
    public boolean field_74338_d;
    public int field_151451_c = -1;
    public boolean field_74336_f = true;
    public boolean field_151448_g = true;
    public int field_74350_i = 120;
    public int field_74345_l = 2;
    public boolean field_74347_j = true;
    public int field_74348_k = 2;
    public List<String> field_151453_l = Lists.newArrayList();
    public List<String> field_183018_l = Lists.newArrayList();
    public EntityPlayer.EnumChatVisibility field_74343_n = EntityPlayer.EnumChatVisibility.FULL;
    public boolean field_74344_o = true;
    public boolean field_74359_p = true;
    public boolean field_74358_q = true;
    public double field_74357_r = 1.0;
    public boolean field_74355_t = true;
    public boolean field_74353_u;
    @Nullable
    public String field_198019_u;
    public boolean field_74352_v = true;
    public boolean field_178881_t = true;
    public boolean field_178879_v;
    public boolean field_80005_w;
    public boolean field_82882_x;
    public boolean field_82881_y = true;
    private final Set<EnumPlayerModelParts> field_178882_aU = Sets.newHashSet((Object[])EnumPlayerModelParts.values());
    public boolean field_85185_A;
    public EnumHandSide field_186715_A = EnumHandSide.RIGHT;
    public int field_92118_B;
    public int field_92119_C;
    public boolean field_92117_D = true;
    public double field_96691_E = 1.0;
    public double field_96692_F = 1.0;
    public double field_96693_G = 0.44366195797920227;
    public double field_96694_H = 1.0;
    public int field_151442_I = 4;
    private final Map<SoundCategory, Float> field_186714_aM = Maps.newEnumMap(SoundCategory.class);
    public boolean field_181150_U = true;
    public boolean field_181151_V = true;
    public int field_186716_M = 1;
    public boolean field_189422_N;
    public boolean field_186717_N;
    public boolean field_183509_X = true;
    public boolean field_189989_R = true;
    public TutorialSteps field_193631_S = TutorialSteps.MOVEMENT;
    public boolean field_198018_T = true;
    public int field_205217_U = 2;
    public double field_208033_V = 1.0;
    public int field_209231_W = 1;
    public KeyBinding field_74351_w = new KeyBinding("key.forward", 87, "key.categories.movement");
    public KeyBinding field_74370_x = new KeyBinding("key.left", 65, "key.categories.movement");
    public KeyBinding field_74368_y = new KeyBinding("key.back", 83, "key.categories.movement");
    public KeyBinding field_74366_z = new KeyBinding("key.right", 68, "key.categories.movement");
    public KeyBinding field_74314_A = new KeyBinding("key.jump", 32, "key.categories.movement");
    public KeyBinding field_74311_E = new KeyBinding("key.sneak", 340, "key.categories.movement");
    public KeyBinding field_151444_V = new KeyBinding("key.sprint", 341, "key.categories.movement");
    public KeyBinding field_151445_Q = new KeyBinding("key.inventory", 69, "key.categories.inventory");
    public KeyBinding field_186718_X = new KeyBinding("key.swapHands", 70, "key.categories.inventory");
    public KeyBinding field_74316_C = new KeyBinding("key.drop", 81, "key.categories.inventory");
    public KeyBinding field_74313_G = new KeyBinding("key.use", InputMappings.Type.MOUSE, 1, "key.categories.gameplay");
    public KeyBinding field_74312_F = new KeyBinding("key.attack", InputMappings.Type.MOUSE, 0, "key.categories.gameplay");
    public KeyBinding field_74322_I = new KeyBinding("key.pickItem", InputMappings.Type.MOUSE, 2, "key.categories.gameplay");
    public KeyBinding field_74310_D = new KeyBinding("key.chat", 84, "key.categories.multiplayer");
    public KeyBinding field_74321_H = new KeyBinding("key.playerlist", 258, "key.categories.multiplayer");
    public KeyBinding field_74323_J = new KeyBinding("key.command", 47, "key.categories.multiplayer");
    public KeyBinding field_151447_Z = new KeyBinding("key.screenshot", 291, "key.categories.misc");
    public KeyBinding field_151457_aa = new KeyBinding("key.togglePerspective", 294, "key.categories.misc");
    public KeyBinding field_151458_ab = new KeyBinding("key.smoothCamera", -1, "key.categories.misc");
    public KeyBinding field_152395_am = new KeyBinding("key.fullscreen", 300, "key.categories.misc");
    public KeyBinding field_178883_an = new KeyBinding("key.spectatorOutlines", -1, "key.categories.misc");
    public KeyBinding field_194146_ao = new KeyBinding("key.advancements", 76, "key.categories.misc");
    public KeyBinding[] field_151456_ac = new KeyBinding[]{new KeyBinding("key.hotbar.1", 49, "key.categories.inventory"), new KeyBinding("key.hotbar.2", 50, "key.categories.inventory"), new KeyBinding("key.hotbar.3", 51, "key.categories.inventory"), new KeyBinding("key.hotbar.4", 52, "key.categories.inventory"), new KeyBinding("key.hotbar.5", 53, "key.categories.inventory"), new KeyBinding("key.hotbar.6", 54, "key.categories.inventory"), new KeyBinding("key.hotbar.7", 55, "key.categories.inventory"), new KeyBinding("key.hotbar.8", 56, "key.categories.inventory"), new KeyBinding("key.hotbar.9", 57, "key.categories.inventory")};
    public KeyBinding field_193629_ap = new KeyBinding("key.saveToolbarActivator", 67, "key.categories.creative");
    public KeyBinding field_193630_aq = new KeyBinding("key.loadToolbarActivator", 88, "key.categories.creative");
    public KeyBinding[] field_74324_K = (KeyBinding[])ArrayUtils.addAll((Object[])new KeyBinding[]{this.field_74312_F, this.field_74313_G, this.field_74351_w, this.field_74370_x, this.field_74368_y, this.field_74366_z, this.field_74314_A, this.field_74311_E, this.field_151444_V, this.field_74316_C, this.field_151445_Q, this.field_74310_D, this.field_74321_H, this.field_74322_I, this.field_74323_J, this.field_151447_Z, this.field_151457_aa, this.field_151458_ab, this.field_152395_am, this.field_178883_an, this.field_186718_X, this.field_193629_ap, this.field_193630_aq, this.field_194146_ao}, (Object[])this.field_151456_ac);
    protected Minecraft field_74317_L;
    private File field_74354_ai;
    public EnumDifficulty field_74318_M = EnumDifficulty.NORMAL;
    public boolean field_74319_N;
    public int field_74320_O;
    public boolean field_74330_P;
    public boolean field_74329_Q;
    public boolean field_181657_aC;
    public String field_74332_R = "";
    public boolean field_74326_T;
    public boolean field_74325_U;
    public double field_74334_X = 70.0;
    public double field_74333_Y;
    public float field_151452_as;
    public int field_74335_Z;
    public int field_74362_aa;
    public int field_192571_R;
    public String field_74363_ab = "en_us";
    public boolean field_211842_aO;

    public GameSettings(Minecraft minecraft, File file) {
        this.field_74317_L = minecraft;
        this.field_74354_ai = new File(file, "options.txt");
        if (minecraft.func_147111_S() && Runtime.getRuntime().maxMemory() >= 1000000000L) {
            Options.RENDER_DISTANCE.func_148263_a(32.0f);
        } else {
            Options.RENDER_DISTANCE.func_148263_a(16.0f);
        }
        this.field_151451_c = minecraft.func_147111_S() ? 12 : 8;
        this.func_74300_a();
    }

    public GameSettings() {
    }

    public void func_198014_a(KeyBinding keyBinding, InputMappings.Input input) {
        keyBinding.func_197979_b(input);
        this.func_74303_b();
    }

    public void func_198016_a(Options options2, double d) {
        Options options2;
        if (options2 == Options.SENSITIVITY) {
            this.field_74341_c = d;
        }
        if (options2 == Options.FOV) {
            this.field_74334_X = d;
        }
        if (options2 == Options.GAMMA) {
            this.field_74333_Y = d;
        }
        if (options2 == Options.FRAMERATE_LIMIT) {
            this.field_74350_i = (int)d;
        }
        if (options2 == Options.CHAT_OPACITY) {
            this.field_74357_r = d;
            this.field_74317_L.field_71456_v.func_146158_b().func_146245_b();
        }
        if (options2 == Options.CHAT_HEIGHT_FOCUSED) {
            this.field_96694_H = d;
            this.field_74317_L.field_71456_v.func_146158_b().func_146245_b();
        }
        if (options2 == Options.CHAT_HEIGHT_UNFOCUSED) {
            this.field_96693_G = d;
            this.field_74317_L.field_71456_v.func_146158_b().func_146245_b();
        }
        if (options2 == Options.CHAT_WIDTH) {
            this.field_96692_F = d;
            this.field_74317_L.field_71456_v.func_146158_b().func_146245_b();
        }
        if (options2 == Options.CHAT_SCALE) {
            this.field_96691_E = d;
            this.field_74317_L.field_71456_v.func_146158_b().func_146245_b();
        }
        if (options2 == Options.MIPMAP_LEVELS) {
            int n = this.field_151442_I;
            this.field_151442_I = (int)d;
            if ((double)n != d) {
                this.field_74317_L.func_147117_R().func_147633_a(this.field_151442_I);
                this.field_74317_L.func_110434_K().func_110577_a(TextureMap.field_110575_b);
                this.field_74317_L.func_147117_R().func_174937_a(false, this.field_151442_I > 0);
                this.field_74317_L.func_175603_A();
            }
        }
        if (options2 == Options.RENDER_DISTANCE) {
            this.field_151451_c = (int)d;
            this.field_74317_L.field_71438_f.func_174979_m();
        }
        if (options2 == Options.BIOME_BLEND_RADIUS) {
            this.field_205217_U = MathHelper.func_76125_a((int)d, 0, 7);
            this.field_74317_L.field_71438_f.func_72712_a();
        }
        if (options2 == Options.FULLSCREEN_RESOLUTION) {
            this.field_74317_L.field_195558_d.func_198104_b((int)d);
        }
        if (options2 == Options.MOUSE_WHEEL_SENSITIVITY) {
            this.field_208033_V = d;
        }
    }

    public void func_74306_a(Options options, int n) {
        if (options == Options.RENDER_DISTANCE) {
            this.func_198016_a(options, MathHelper.func_151237_a(this.field_151451_c + n, options.func_198007_e(), options.func_198009_f()));
        }
        if (options == Options.MAIN_HAND) {
            this.field_186715_A = this.field_186715_A.func_188468_a();
        }
        if (options == Options.INVERT_MOUSE) {
            boolean bl = this.field_74338_d = !this.field_74338_d;
        }
        if (options == Options.GUI_SCALE) {
            this.field_74335_Z = Integer.remainderUnsigned(this.field_74335_Z + n, this.field_74317_L.field_195558_d.func_198078_c(0) + 1);
        }
        if (options == Options.PARTICLES) {
            this.field_74362_aa = (this.field_74362_aa + n) % 3;
        }
        if (options == Options.VIEW_BOBBING) {
            boolean bl = this.field_74336_f = !this.field_74336_f;
        }
        if (options == Options.RENDER_CLOUDS) {
            this.field_74345_l = (this.field_74345_l + n) % 3;
        }
        if (options == Options.FORCE_UNICODE_FONT) {
            this.field_211842_aO = !this.field_211842_aO;
            this.field_74317_L.func_211500_ak().func_211825_a(this.field_211842_aO);
        }
        if (options == Options.FBO_ENABLE) {
            boolean bl = this.field_151448_g = !this.field_151448_g;
        }
        if (options == Options.GRAPHICS) {
            this.field_74347_j = !this.field_74347_j;
            this.field_74317_L.field_71438_f.func_72712_a();
        }
        if (options == Options.AMBIENT_OCCLUSION) {
            this.field_74348_k = (this.field_74348_k + n) % 3;
            this.field_74317_L.field_71438_f.func_72712_a();
        }
        if (options == Options.CHAT_VISIBILITY) {
            this.field_74343_n = EntityPlayer.EnumChatVisibility.func_151426_a((this.field_74343_n.func_151428_a() + n) % 3);
        }
        if (options == Options.CHAT_COLOR) {
            boolean bl = this.field_74344_o = !this.field_74344_o;
        }
        if (options == Options.CHAT_LINKS) {
            boolean bl = this.field_74359_p = !this.field_74359_p;
        }
        if (options == Options.CHAT_LINKS_PROMPT) {
            boolean bl = this.field_74358_q = !this.field_74358_q;
        }
        if (options == Options.SNOOPER_ENABLED) {
            boolean bl = this.field_74355_t = !this.field_74355_t;
        }
        if (options == Options.TOUCHSCREEN) {
            boolean bl = this.field_85185_A = !this.field_85185_A;
        }
        if (options == Options.USE_FULLSCREEN) {
            boolean bl = this.field_74353_u = !this.field_74353_u;
            if (this.field_74317_L.field_195558_d.func_198113_j() != this.field_74353_u) {
                this.field_74317_L.field_195558_d.func_198077_g();
            }
        }
        if (options == Options.ENABLE_VSYNC) {
            this.field_74352_v = !this.field_74352_v;
            this.field_74317_L.field_195558_d.func_209548_c();
        }
        if (options == Options.USE_VBO) {
            this.field_178881_t = !this.field_178881_t;
            this.field_74317_L.field_71438_f.func_72712_a();
        }
        if (options == Options.REDUCED_DEBUG_INFO) {
            boolean bl = this.field_178879_v = !this.field_178879_v;
        }
        if (options == Options.ENTITY_SHADOWS) {
            boolean bl = this.field_181151_V = !this.field_181151_V;
        }
        if (options == Options.ATTACK_INDICATOR) {
            this.field_186716_M = (this.field_186716_M + n) % 3;
        }
        if (options == Options.SHOW_SUBTITLES) {
            boolean bl = this.field_186717_N = !this.field_186717_N;
        }
        if (options == Options.REALMS_NOTIFICATIONS) {
            boolean bl = this.field_183509_X = !this.field_183509_X;
        }
        if (options == Options.AUTO_JUMP) {
            boolean bl = this.field_189989_R = !this.field_189989_R;
        }
        if (options == Options.AUTO_SUGGESTIONS) {
            boolean bl = this.field_198018_T = !this.field_198018_T;
        }
        if (options == Options.NARRATOR) {
            this.field_192571_R = NarratorChatListener.field_193643_a.func_193640_a() ? (this.field_192571_R + n) % field_193632_b.length : 0;
            NarratorChatListener.field_193643_a.func_193641_a(this.field_192571_R);
        }
        this.func_74303_b();
    }

    public double func_198015_a(Options options) {
        if (options == Options.BIOME_BLEND_RADIUS) {
            return this.field_205217_U;
        }
        if (options == Options.FOV) {
            return this.field_74334_X;
        }
        if (options == Options.GAMMA) {
            return this.field_74333_Y;
        }
        if (options == Options.SATURATION) {
            return this.field_151452_as;
        }
        if (options == Options.SENSITIVITY) {
            return this.field_74341_c;
        }
        if (options == Options.CHAT_OPACITY) {
            return this.field_74357_r;
        }
        if (options == Options.CHAT_HEIGHT_FOCUSED) {
            return this.field_96694_H;
        }
        if (options == Options.CHAT_HEIGHT_UNFOCUSED) {
            return this.field_96693_G;
        }
        if (options == Options.CHAT_SCALE) {
            return this.field_96691_E;
        }
        if (options == Options.CHAT_WIDTH) {
            return this.field_96692_F;
        }
        if (options == Options.FRAMERATE_LIMIT) {
            return this.field_74350_i;
        }
        if (options == Options.MIPMAP_LEVELS) {
            return this.field_151442_I;
        }
        if (options == Options.RENDER_DISTANCE) {
            return this.field_151451_c;
        }
        if (options == Options.FULLSCREEN_RESOLUTION) {
            return this.field_74317_L.field_195558_d.func_198090_e();
        }
        if (options == Options.MOUSE_WHEEL_SENSITIVITY) {
            return this.field_208033_V;
        }
        return 0.0;
    }

    public boolean func_74308_b(Options options) {
        switch (options) {
            case INVERT_MOUSE: {
                return this.field_74338_d;
            }
            case VIEW_BOBBING: {
                return this.field_74336_f;
            }
            case FBO_ENABLE: {
                return this.field_151448_g;
            }
            case CHAT_COLOR: {
                return this.field_74344_o;
            }
            case CHAT_LINKS: {
                return this.field_74359_p;
            }
            case CHAT_LINKS_PROMPT: {
                return this.field_74358_q;
            }
            case SNOOPER_ENABLED: {
                if (this.field_74355_t) {
                    // empty if block
                }
                return false;
            }
            case USE_FULLSCREEN: {
                return this.field_74353_u;
            }
            case ENABLE_VSYNC: {
                return this.field_74352_v;
            }
            case USE_VBO: {
                return this.field_178881_t;
            }
            case TOUCHSCREEN: {
                return this.field_85185_A;
            }
            case FORCE_UNICODE_FONT: {
                return this.field_211842_aO;
            }
            case REDUCED_DEBUG_INFO: {
                return this.field_178879_v;
            }
            case ENTITY_SHADOWS: {
                return this.field_181151_V;
            }
            case SHOW_SUBTITLES: {
                return this.field_186717_N;
            }
            case REALMS_NOTIFICATIONS: {
                return this.field_183509_X;
            }
            case ENABLE_WEAK_ATTACKS: {
                return this.field_189422_N;
            }
            case AUTO_JUMP: {
                return this.field_189989_R;
            }
            case AUTO_SUGGESTIONS: {
                return this.field_198018_T;
            }
        }
        return false;
    }

    private static String func_74299_a(String[] stringArray, int n) {
        if (n < 0 || n >= stringArray.length) {
            n = 0;
        }
        return I18n.func_135052_a(stringArray[n], new Object[0]);
    }

    public String func_74297_c(Options options2) {
        Options options2;
        String string = I18n.func_135052_a(options2.func_74378_d(), new Object[0]) + ": ";
        if (options2.func_74380_a()) {
            double d = this.func_198015_a(options2);
            \u2603 = options2.func_198008_a(d);
            if (options2 == Options.SENSITIVITY) {
                if (\u2603 == 0.0) {
                    return string + I18n.func_135052_a("options.sensitivity.min", new Object[0]);
                }
                if (\u2603 == 1.0) {
                    return string + I18n.func_135052_a("options.sensitivity.max", new Object[0]);
                }
                return string + (int)(\u2603 * 200.0) + "%";
            }
            if (options2 == Options.BIOME_BLEND_RADIUS) {
                if (\u2603 == 0.0) {
                    return string + I18n.func_135052_a("options.off", new Object[0]);
                }
                int n = this.field_205217_U * 2 + 1;
                return string + n + "x" + n;
            }
            if (options2 == Options.FOV) {
                if (d == 70.0) {
                    return string + I18n.func_135052_a("options.fov.min", new Object[0]);
                }
                if (d == 110.0) {
                    return string + I18n.func_135052_a("options.fov.max", new Object[0]);
                }
                return string + (int)d;
            }
            if (options2 == Options.FRAMERATE_LIMIT) {
                if (d == options2.field_148272_O) {
                    return string + I18n.func_135052_a("options.framerateLimit.max", new Object[0]);
                }
                return string + I18n.func_135052_a("options.framerate", (int)d);
            }
            if (options2 == Options.RENDER_CLOUDS) {
                if (d == options2.field_148271_N) {
                    return string + I18n.func_135052_a("options.cloudHeight.min", new Object[0]);
                }
                return string + ((int)d + 128);
            }
            if (options2 == Options.GAMMA) {
                if (\u2603 == 0.0) {
                    return string + I18n.func_135052_a("options.gamma.min", new Object[0]);
                }
                if (\u2603 == 1.0) {
                    return string + I18n.func_135052_a("options.gamma.max", new Object[0]);
                }
                return string + "+" + (int)(\u2603 * 100.0) + "%";
            }
            if (options2 == Options.SATURATION) {
                return string + (int)(\u2603 * 400.0) + "%";
            }
            if (options2 == Options.CHAT_OPACITY) {
                return string + (int)(\u2603 * 90.0 + 10.0) + "%";
            }
            if (options2 == Options.CHAT_HEIGHT_UNFOCUSED) {
                return string + GuiNewChat.func_194816_c(\u2603) + "px";
            }
            if (options2 == Options.CHAT_HEIGHT_FOCUSED) {
                return string + GuiNewChat.func_194816_c(\u2603) + "px";
            }
            if (options2 == Options.CHAT_WIDTH) {
                return string + GuiNewChat.func_194814_b(\u2603) + "px";
            }
            if (options2 == Options.RENDER_DISTANCE) {
                return string + I18n.func_135052_a("options.chunks", (int)d);
            }
            if (options2 == Options.MOUSE_WHEEL_SENSITIVITY) {
                if (\u2603 == 1.0) {
                    return string + I18n.func_135052_a("options.mouseWheelSensitivity.default", new Object[0]);
                }
                return string + "+" + (int)\u2603 + "." + (int)(\u2603 * 10.0) % 10;
            }
            if (options2 == Options.MIPMAP_LEVELS) {
                if (d == 0.0) {
                    return string + I18n.func_135052_a("options.off", new Object[0]);
                }
                return string + (int)d;
            }
            if (options2 == Options.FULLSCREEN_RESOLUTION) {
                if (d == 0.0) {
                    return string + I18n.func_135052_a("options.fullscreen.current", new Object[0]);
                }
                return string + this.field_74317_L.field_195558_d.func_198088_a((int)d - 1);
            }
            if (\u2603 == 0.0) {
                return string + I18n.func_135052_a("options.off", new Object[0]);
            }
            return string + (int)(\u2603 * 100.0) + "%";
        }
        if (options2.func_74382_b()) {
            boolean bl = this.func_74308_b(options2);
            if (bl) {
                return string + I18n.func_135052_a("options.on", new Object[0]);
            }
            return string + I18n.func_135052_a("options.off", new Object[0]);
        }
        if (options2 == Options.MAIN_HAND) {
            return string + (Object)((Object)this.field_186715_A);
        }
        if (options2 == Options.GUI_SCALE) {
            return string + (this.field_74335_Z == 0 ? I18n.func_135052_a("options.guiScale.auto", new Object[0]) : Integer.valueOf(this.field_74335_Z));
        }
        if (options2 == Options.CHAT_VISIBILITY) {
            return string + I18n.func_135052_a(this.field_74343_n.func_151429_b(), new Object[0]);
        }
        if (options2 == Options.PARTICLES) {
            return string + GameSettings.func_74299_a(field_74364_ag, this.field_74362_aa);
        }
        if (options2 == Options.AMBIENT_OCCLUSION) {
            return string + GameSettings.func_74299_a(field_98303_au, this.field_74348_k);
        }
        if (options2 == Options.RENDER_CLOUDS) {
            return string + GameSettings.func_74299_a(field_181149_aW, this.field_74345_l);
        }
        if (options2 == Options.GRAPHICS) {
            if (this.field_74347_j) {
                return string + I18n.func_135052_a("options.graphics.fancy", new Object[0]);
            }
            String string2 = "options.graphics.fast";
            return string + I18n.func_135052_a("options.graphics.fast", new Object[0]);
        }
        if (options2 == Options.ATTACK_INDICATOR) {
            return string + GameSettings.func_74299_a(field_186713_aK, this.field_186716_M);
        }
        if (options2 == Options.NARRATOR) {
            if (NarratorChatListener.field_193643_a.func_193640_a()) {
                return string + GameSettings.func_74299_a(field_193632_b, this.field_192571_R);
            }
            return string + I18n.func_135052_a("options.narrator.notavailable", new Object[0]);
        }
        return string;
    }

    public void func_74300_a() {
        try {
            if (!this.field_74354_ai.exists()) {
                return;
            }
            this.field_186714_aM.clear();
            List list = IOUtils.readLines((InputStream)new FileInputStream(this.field_74354_ai));
            NBTTagCompound \u26032 = new NBTTagCompound();
            for (String string : list) {
                try {
                    Iterator object = field_189990_a.omitEmptyStrings().limit(2).split((CharSequence)string).iterator();
                    \u26032.func_74778_a((String)object.next(), (String)object.next());
                }
                catch (Exception exception) {
                    field_151454_ax.warn("Skipping bad option: {}", (Object)string);
                }
            }
            \u26032 = this.func_189988_a(\u26032);
            for (String string : \u26032.func_150296_c()) {
                \u2603 = \u26032.func_74779_i(string);
                try {
                    if ("mouseSensitivity".equals(string)) {
                        this.field_74341_c = this.func_74305_a(\u2603);
                    }
                    if ("fov".equals(string)) {
                        this.field_74334_X = this.func_74305_a(\u2603) * 40.0f + 70.0f;
                    }
                    if ("gamma".equals(string)) {
                        this.field_74333_Y = this.func_74305_a(\u2603);
                    }
                    if ("saturation".equals(string)) {
                        this.field_151452_as = this.func_74305_a(\u2603);
                    }
                    if ("invertYMouse".equals(string)) {
                        this.field_74338_d = "true".equals(\u2603);
                    }
                    if ("renderDistance".equals(string)) {
                        this.field_151451_c = Integer.parseInt(\u2603);
                    }
                    if ("guiScale".equals(string)) {
                        this.field_74335_Z = Integer.parseInt(\u2603);
                    }
                    if ("particles".equals(string)) {
                        this.field_74362_aa = Integer.parseInt(\u2603);
                    }
                    if ("bobView".equals(string)) {
                        this.field_74336_f = "true".equals(\u2603);
                    }
                    if ("maxFps".equals(string)) {
                        this.field_74350_i = Integer.parseInt(\u2603);
                    }
                    if ("fboEnable".equals(string)) {
                        this.field_151448_g = "true".equals(\u2603);
                    }
                    if ("difficulty".equals(string)) {
                        this.field_74318_M = EnumDifficulty.func_151523_a(Integer.parseInt(\u2603));
                    }
                    if ("fancyGraphics".equals(string)) {
                        this.field_74347_j = "true".equals(\u2603);
                    }
                    if ("tutorialStep".equals(string)) {
                        this.field_193631_S = TutorialSteps.func_193307_a(\u2603);
                    }
                    if ("ao".equals(string)) {
                        this.field_74348_k = "true".equals(\u2603) ? 2 : ("false".equals(\u2603) ? 0 : Integer.parseInt(\u2603));
                    }
                    if ("renderClouds".equals(string)) {
                        if ("true".equals(\u2603)) {
                            this.field_74345_l = 2;
                        } else if ("false".equals(\u2603)) {
                            this.field_74345_l = 0;
                        } else if ("fast".equals(\u2603)) {
                            this.field_74345_l = 1;
                        }
                    }
                    if ("attackIndicator".equals(string)) {
                        if ("0".equals(\u2603)) {
                            this.field_186716_M = 0;
                        } else if ("1".equals(\u2603)) {
                            this.field_186716_M = 1;
                        } else if ("2".equals(\u2603)) {
                            this.field_186716_M = 2;
                        }
                    }
                    if ("resourcePacks".equals(string)) {
                        this.field_151453_l = (List)JsonUtils.func_193840_a(field_151450_ay, \u2603, field_151449_az);
                        if (this.field_151453_l == null) {
                            this.field_151453_l = Lists.newArrayList();
                        }
                    }
                    if ("incompatibleResourcePacks".equals(string)) {
                        this.field_183018_l = (List)JsonUtils.func_193840_a(field_151450_ay, \u2603, field_151449_az);
                        if (this.field_183018_l == null) {
                            this.field_183018_l = Lists.newArrayList();
                        }
                    }
                    if ("lastServer".equals(string)) {
                        this.field_74332_R = \u2603;
                    }
                    if ("lang".equals(string)) {
                        this.field_74363_ab = \u2603;
                    }
                    if ("chatVisibility".equals(string)) {
                        this.field_74343_n = EntityPlayer.EnumChatVisibility.func_151426_a(Integer.parseInt(\u2603));
                    }
                    if ("chatColors".equals(string)) {
                        this.field_74344_o = "true".equals(\u2603);
                    }
                    if ("chatLinks".equals(string)) {
                        this.field_74359_p = "true".equals(\u2603);
                    }
                    if ("chatLinksPrompt".equals(string)) {
                        this.field_74358_q = "true".equals(\u2603);
                    }
                    if ("chatOpacity".equals(string)) {
                        this.field_74357_r = this.func_74305_a(\u2603);
                    }
                    if ("snooperEnabled".equals(string)) {
                        this.field_74355_t = "true".equals(\u2603);
                    }
                    if ("fullscreen".equals(string)) {
                        this.field_74353_u = "true".equals(\u2603);
                    }
                    if ("fullscreenResolution".equals(string)) {
                        this.field_198019_u = \u2603;
                    }
                    if ("enableVsync".equals(string)) {
                        this.field_74352_v = "true".equals(\u2603);
                    }
                    if ("useVbo".equals(string)) {
                        this.field_178881_t = "true".equals(\u2603);
                    }
                    if ("hideServerAddress".equals(string)) {
                        this.field_80005_w = "true".equals(\u2603);
                    }
                    if ("advancedItemTooltips".equals(string)) {
                        this.field_82882_x = "true".equals(\u2603);
                    }
                    if ("pauseOnLostFocus".equals(string)) {
                        this.field_82881_y = "true".equals(\u2603);
                    }
                    if ("touchscreen".equals(string)) {
                        this.field_85185_A = "true".equals(\u2603);
                    }
                    if ("overrideHeight".equals(string)) {
                        this.field_92119_C = Integer.parseInt(\u2603);
                    }
                    if ("overrideWidth".equals(string)) {
                        this.field_92118_B = Integer.parseInt(\u2603);
                    }
                    if ("heldItemTooltips".equals(string)) {
                        this.field_92117_D = "true".equals(\u2603);
                    }
                    if ("chatHeightFocused".equals(string)) {
                        this.field_96694_H = this.func_74305_a(\u2603);
                    }
                    if ("chatHeightUnfocused".equals(string)) {
                        this.field_96693_G = this.func_74305_a(\u2603);
                    }
                    if ("chatScale".equals(string)) {
                        this.field_96691_E = this.func_74305_a(\u2603);
                    }
                    if ("chatWidth".equals(string)) {
                        this.field_96692_F = this.func_74305_a(\u2603);
                    }
                    if ("mipmapLevels".equals(string)) {
                        this.field_151442_I = Integer.parseInt(\u2603);
                    }
                    if ("forceUnicodeFont".equals(string)) {
                        this.field_211842_aO = "true".equals(\u2603);
                    }
                    if ("reducedDebugInfo".equals(string)) {
                        this.field_178879_v = "true".equals(\u2603);
                    }
                    if ("useNativeTransport".equals(string)) {
                        this.field_181150_U = "true".equals(\u2603);
                    }
                    if ("entityShadows".equals(string)) {
                        this.field_181151_V = "true".equals(\u2603);
                    }
                    if ("mainHand".equals(string)) {
                        EnumHandSide enumHandSide = this.field_186715_A = "left".equals(\u2603) ? EnumHandSide.LEFT : EnumHandSide.RIGHT;
                    }
                    if ("showSubtitles".equals(string)) {
                        this.field_186717_N = "true".equals(\u2603);
                    }
                    if ("realmsNotifications".equals(string)) {
                        this.field_183509_X = "true".equals(\u2603);
                    }
                    if ("enableWeakAttacks".equals(string)) {
                        this.field_189422_N = "true".equals(\u2603);
                    }
                    if ("autoJump".equals(string)) {
                        this.field_189989_R = "true".equals(\u2603);
                    }
                    if ("narrator".equals(string)) {
                        this.field_192571_R = Integer.parseInt(\u2603);
                    }
                    if ("autoSuggestions".equals(string)) {
                        this.field_198018_T = "true".equals(\u2603);
                    }
                    if ("biomeBlendRadius".equals(string)) {
                        this.field_205217_U = Integer.parseInt(\u2603);
                    }
                    if ("mouseWheelSensitivity".equals(string)) {
                        this.field_208033_V = this.func_74305_a(\u2603);
                    }
                    if ("glDebugVerbosity".equals(string)) {
                        this.field_209231_W = Integer.parseInt(\u2603);
                    }
                    for (KeyBinding keyBinding : this.field_74324_K) {
                        if (!string.equals("key_" + keyBinding.func_151464_g())) continue;
                        keyBinding.func_197979_b(InputMappings.func_197955_a(\u2603));
                    }
                    for (SoundCategory soundCategory : SoundCategory.values()) {
                        if (!string.equals("soundCategory_" + soundCategory.func_187948_a())) continue;
                        this.field_186714_aM.put(soundCategory, Float.valueOf(this.func_74305_a(\u2603)));
                    }
                    for (EnumPlayerModelParts enumPlayerModelParts : EnumPlayerModelParts.values()) {
                        if (!string.equals("modelPart_" + enumPlayerModelParts.func_179329_c())) continue;
                        this.func_178878_a(enumPlayerModelParts, "true".equals(\u2603));
                    }
                }
                catch (Exception exception) {
                    field_151454_ax.warn("Skipping bad option: {}:{}", (Object)string, (Object)\u2603);
                }
            }
            KeyBinding.func_74508_b();
        }
        catch (Exception exception) {
            field_151454_ax.error("Failed to load options", (Throwable)exception);
        }
    }

    private NBTTagCompound func_189988_a(NBTTagCompound nBTTagCompound) {
        int n = 0;
        try {
            n = Integer.parseInt(nBTTagCompound.func_74779_i("version"));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return NBTUtil.func_210822_a(this.field_74317_L.func_184126_aj(), (DSL.TypeReference)DataFixTypes.OPTIONS, nBTTagCompound, n);
    }

    private float func_74305_a(String string) {
        if ("true".equals(string)) {
            return 1.0f;
        }
        if ("false".equals(string)) {
            return 0.0f;
        }
        return Float.parseFloat(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_74303_b() {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.field_74354_ai), StandardCharsets.UTF_8));
            printWriter.println("version:1631");
            printWriter.println("invertYMouse:" + this.field_74338_d);
            printWriter.println("mouseSensitivity:" + this.field_74341_c);
            printWriter.println("fov:" + (this.field_74334_X - 70.0) / 40.0);
            printWriter.println("gamma:" + this.field_74333_Y);
            printWriter.println("saturation:" + this.field_151452_as);
            printWriter.println("renderDistance:" + this.field_151451_c);
            printWriter.println("guiScale:" + this.field_74335_Z);
            printWriter.println("particles:" + this.field_74362_aa);
            printWriter.println("bobView:" + this.field_74336_f);
            printWriter.println("maxFps:" + this.field_74350_i);
            printWriter.println("fboEnable:" + this.field_151448_g);
            printWriter.println("difficulty:" + this.field_74318_M.func_151525_a());
            printWriter.println("fancyGraphics:" + this.field_74347_j);
            printWriter.println("ao:" + this.field_74348_k);
            printWriter.println("biomeBlendRadius:" + this.field_205217_U);
            switch (this.field_74345_l) {
                case 2: {
                    printWriter.println("renderClouds:true");
                    break;
                }
                case 1: {
                    printWriter.println("renderClouds:fast");
                    break;
                }
                case 0: {
                    printWriter.println("renderClouds:false");
                }
            }
            printWriter.println("resourcePacks:" + field_151450_ay.toJson(this.field_151453_l));
            printWriter.println("incompatibleResourcePacks:" + field_151450_ay.toJson(this.field_183018_l));
            printWriter.println("lastServer:" + this.field_74332_R);
            printWriter.println("lang:" + this.field_74363_ab);
            printWriter.println("chatVisibility:" + this.field_74343_n.func_151428_a());
            printWriter.println("chatColors:" + this.field_74344_o);
            printWriter.println("chatLinks:" + this.field_74359_p);
            printWriter.println("chatLinksPrompt:" + this.field_74358_q);
            printWriter.println("chatOpacity:" + this.field_74357_r);
            printWriter.println("snooperEnabled:" + this.field_74355_t);
            printWriter.println("fullscreen:" + this.field_74353_u);
            if (this.field_74317_L.field_195558_d.func_198106_d().isPresent()) {
                printWriter.println("fullscreenResolution:" + this.field_74317_L.field_195558_d.func_198106_d().get().func_198066_g());
            }
            printWriter.println("enableVsync:" + this.field_74352_v);
            printWriter.println("useVbo:" + this.field_178881_t);
            printWriter.println("hideServerAddress:" + this.field_80005_w);
            printWriter.println("advancedItemTooltips:" + this.field_82882_x);
            printWriter.println("pauseOnLostFocus:" + this.field_82881_y);
            printWriter.println("touchscreen:" + this.field_85185_A);
            printWriter.println("overrideWidth:" + this.field_92118_B);
            printWriter.println("overrideHeight:" + this.field_92119_C);
            printWriter.println("heldItemTooltips:" + this.field_92117_D);
            printWriter.println("chatHeightFocused:" + this.field_96694_H);
            printWriter.println("chatHeightUnfocused:" + this.field_96693_G);
            printWriter.println("chatScale:" + this.field_96691_E);
            printWriter.println("chatWidth:" + this.field_96692_F);
            printWriter.println("mipmapLevels:" + this.field_151442_I);
            printWriter.println("forceUnicodeFont:" + this.field_211842_aO);
            printWriter.println("reducedDebugInfo:" + this.field_178879_v);
            printWriter.println("useNativeTransport:" + this.field_181150_U);
            printWriter.println("entityShadows:" + this.field_181151_V);
            printWriter.println("mainHand:" + (this.field_186715_A == EnumHandSide.LEFT ? "left" : "right"));
            printWriter.println("attackIndicator:" + this.field_186716_M);
            printWriter.println("showSubtitles:" + this.field_186717_N);
            printWriter.println("realmsNotifications:" + this.field_183509_X);
            printWriter.println("enableWeakAttacks:" + this.field_189422_N);
            printWriter.println("autoJump:" + this.field_189989_R);
            printWriter.println("narrator:" + this.field_192571_R);
            printWriter.println("tutorialStep:" + this.field_193631_S.func_193308_a());
            printWriter.println("autoSuggestions:" + this.field_198018_T);
            printWriter.println("mouseWheelSensitivity:" + this.field_208033_V);
            printWriter.println("glDebugVerbosity:" + this.field_209231_W);
            for (KeyBinding keyBinding : this.field_74324_K) {
                printWriter.println("key_" + keyBinding.func_151464_g() + ":" + keyBinding.func_197982_m());
            }
            for (SoundCategory soundCategory : SoundCategory.values()) {
                printWriter.println("soundCategory_" + soundCategory.func_187948_a() + ":" + this.func_186711_a(soundCategory));
            }
            for (EnumPlayerModelParts enumPlayerModelParts : EnumPlayerModelParts.values()) {
                printWriter.println("modelPart_" + enumPlayerModelParts.func_179329_c() + ":" + this.field_178882_aU.contains((Object)enumPlayerModelParts));
            }
            IOUtils.closeQuietly((Writer)printWriter);
        }
        catch (Exception exception) {
            field_151454_ax.error("Failed to save options", (Throwable)exception);
        }
        finally {
            IOUtils.closeQuietly(printWriter);
        }
        this.func_82879_c();
    }

    public float func_186711_a(SoundCategory soundCategory) {
        if (this.field_186714_aM.containsKey((Object)soundCategory)) {
            return this.field_186714_aM.get((Object)soundCategory).floatValue();
        }
        return 1.0f;
    }

    public void func_186712_a(SoundCategory soundCategory, float f) {
        this.field_74317_L.func_147118_V().func_184399_a(soundCategory, f);
        this.field_186714_aM.put(soundCategory, Float.valueOf(f));
    }

    public void func_82879_c() {
        if (this.field_74317_L.field_71439_g != null) {
            int n = 0;
            for (EnumPlayerModelParts enumPlayerModelParts : this.field_178882_aU) {
                n |= enumPlayerModelParts.func_179327_a();
            }
            this.field_74317_L.field_71439_g.field_71174_a.func_147297_a(new CPacketClientSettings(this.field_74363_ab, this.field_151451_c, this.field_74343_n, this.field_74344_o, n, this.field_186715_A));
        }
    }

    public Set<EnumPlayerModelParts> func_178876_d() {
        return ImmutableSet.copyOf(this.field_178882_aU);
    }

    public void func_178878_a(EnumPlayerModelParts enumPlayerModelParts, boolean bl) {
        if (bl) {
            this.field_178882_aU.add(enumPlayerModelParts);
        } else {
            this.field_178882_aU.remove((Object)enumPlayerModelParts);
        }
        this.func_82879_c();
    }

    public void func_178877_a(EnumPlayerModelParts enumPlayerModelParts) {
        if (this.func_178876_d().contains((Object)enumPlayerModelParts)) {
            this.field_178882_aU.remove((Object)enumPlayerModelParts);
        } else {
            this.field_178882_aU.add(enumPlayerModelParts);
        }
        this.func_82879_c();
    }

    public int func_181147_e() {
        if (this.field_151451_c >= 4) {
            return this.field_74345_l;
        }
        return 0;
    }

    public boolean func_181148_f() {
        return this.field_181150_U;
    }

    public void func_198017_a(ResourcePackList<ResourcePackInfoClient> resourcePackList) {
        resourcePackList.func_198983_a();
        LinkedHashSet linkedHashSet = Sets.newLinkedHashSet();
        Iterator<String> \u26032 = this.field_151453_l.iterator();
        while (\u26032.hasNext()) {
            String string = \u26032.next();
            ResourcePackInfoClient \u26033 = resourcePackList.func_198981_a(string);
            if (\u26033 == null && !string.startsWith("file/")) {
                \u26033 = resourcePackList.func_198981_a("file/" + string);
            }
            if (\u26033 == null) {
                field_151454_ax.warn("Removed resource pack {} from options because it doesn't seem to exist anymore", (Object)string);
                \u26032.remove();
                continue;
            }
            if (!\u26033.func_195791_d().func_198968_a() && !this.field_183018_l.contains(string)) {
                field_151454_ax.warn("Removed resource pack {} from options because it is no longer compatible", (Object)string);
                \u26032.remove();
                continue;
            }
            if (\u26033.func_195791_d().func_198968_a() && this.field_183018_l.contains(string)) {
                field_151454_ax.info("Removed resource pack {} from incompatibility list because it's now compatible", (Object)string);
                this.field_183018_l.remove(string);
                continue;
            }
            linkedHashSet.add(\u26033);
        }
        resourcePackList.func_198985_a(linkedHashSet);
    }

    public static enum Options {
        INVERT_MOUSE("options.invertMouse", false, true),
        SENSITIVITY("options.sensitivity", true, false),
        FOV("options.fov", true, false, 30.0, 110.0, 1.0f),
        GAMMA("options.gamma", true, false),
        SATURATION("options.saturation", true, false),
        RENDER_DISTANCE("options.renderDistance", true, false, 2.0, 16.0, 1.0f),
        VIEW_BOBBING("options.viewBobbing", false, true),
        FRAMERATE_LIMIT("options.framerateLimit", true, false, 10.0, 260.0, 10.0f),
        FBO_ENABLE("options.fboEnable", false, true),
        RENDER_CLOUDS("options.renderClouds", false, false),
        GRAPHICS("options.graphics", false, false),
        AMBIENT_OCCLUSION("options.ao", false, false),
        GUI_SCALE("options.guiScale", false, false),
        PARTICLES("options.particles", false, false),
        CHAT_VISIBILITY("options.chat.visibility", false, false),
        CHAT_COLOR("options.chat.color", false, true),
        CHAT_LINKS("options.chat.links", false, true),
        CHAT_OPACITY("options.chat.opacity", true, false),
        CHAT_LINKS_PROMPT("options.chat.links.prompt", false, true),
        SNOOPER_ENABLED("options.snooper", false, true),
        FULLSCREEN_RESOLUTION("options.fullscreen.resolution", true, false, 0.0, 0.0, 1.0f),
        USE_FULLSCREEN("options.fullscreen", false, true),
        ENABLE_VSYNC("options.vsync", false, true),
        USE_VBO("options.vbo", false, true),
        TOUCHSCREEN("options.touchscreen", false, true),
        CHAT_SCALE("options.chat.scale", true, false),
        CHAT_WIDTH("options.chat.width", true, false),
        CHAT_HEIGHT_FOCUSED("options.chat.height.focused", true, false),
        CHAT_HEIGHT_UNFOCUSED("options.chat.height.unfocused", true, false),
        MIPMAP_LEVELS("options.mipmapLevels", true, false, 0.0, 4.0, 1.0f),
        FORCE_UNICODE_FONT("options.forceUnicodeFont", false, true),
        REDUCED_DEBUG_INFO("options.reducedDebugInfo", false, true),
        ENTITY_SHADOWS("options.entityShadows", false, true),
        MAIN_HAND("options.mainHand", false, false),
        ATTACK_INDICATOR("options.attackIndicator", false, false),
        ENABLE_WEAK_ATTACKS("options.enableWeakAttacks", false, true),
        SHOW_SUBTITLES("options.showSubtitles", false, true),
        REALMS_NOTIFICATIONS("options.realmsNotifications", false, true),
        AUTO_JUMP("options.autoJump", false, true),
        NARRATOR("options.narrator", false, false),
        AUTO_SUGGESTIONS("options.autoSuggestCommands", false, true),
        BIOME_BLEND_RADIUS("options.biomeBlendRadius", true, false, 0.0, 7.0, 1.0f),
        MOUSE_WHEEL_SENSITIVITY("options.mouseWheelSensitivity", true, false, 1.0, 10.0, 0.5f);

        private final boolean field_74385_A;
        private final boolean field_74386_B;
        private final String field_74387_C;
        private final float field_148270_M;
        private double field_148271_N;
        private double field_148272_O;

        public static Options func_74379_a(int n) {
            for (Options options : Options.values()) {
                if (options.func_74381_c() != n) continue;
                return options;
            }
            return null;
        }

        private Options(String string2, boolean bl, boolean bl2) {
            this(string2, bl, bl2, 0.0, 1.0, 0.0f);
        }

        private Options(String string2, boolean bl, boolean bl2, double d, double d2, float f) {
            this.field_74387_C = string2;
            this.field_74385_A = bl;
            this.field_74386_B = bl2;
            this.field_148271_N = d;
            this.field_148272_O = d2;
            this.field_148270_M = f;
        }

        public boolean func_74380_a() {
            return this.field_74385_A;
        }

        public boolean func_74382_b() {
            return this.field_74386_B;
        }

        public int func_74381_c() {
            return this.ordinal();
        }

        public String func_74378_d() {
            return this.field_74387_C;
        }

        public double func_198007_e() {
            return this.field_148271_N;
        }

        public double func_198009_f() {
            return this.field_148272_O;
        }

        public void func_148263_a(float f) {
            this.field_148272_O = f;
        }

        public double func_198008_a(double d) {
            return MathHelper.func_151237_a((this.func_198011_c(d) - this.field_148271_N) / (this.field_148272_O - this.field_148271_N), 0.0, 1.0);
        }

        public double func_198004_b(double d) {
            return this.func_198011_c(this.field_148271_N + (this.field_148272_O - this.field_148271_N) * MathHelper.func_151237_a(d, 0.0, 1.0));
        }

        public double func_198011_c(double d) {
            d = this.func_198006_d(d);
            return MathHelper.func_151237_a(d, this.field_148271_N, this.field_148272_O);
        }

        private double func_198006_d(double d) {
            if (this.field_148270_M > 0.0f) {
                d = this.field_148270_M * (float)Math.round(d / (double)this.field_148270_M);
            }
            return d;
        }
    }
}

