/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.GameSettings;
import net.minecraft.client.KeyboardListener;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Monitor;
import net.minecraft.client.MouseHelper;
import net.minecraft.client.main.GameConfiguration;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.VideoMode;
import net.minecraft.client.renderer.VirtualScreen;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.Callbacks;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.opengl.GL;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public final class MainWindow
implements AutoCloseable {
    private static final Logger field_198114_a = LogManager.getLogger();
    private final GLFWErrorCallback field_198115_b = GLFWErrorCallback.create(this::func_198084_a);
    private final Minecraft field_198116_c;
    private final VirtualScreen field_198117_d;
    private Monitor field_198118_e;
    private final long field_198119_f;
    private int field_198120_g;
    private int field_198121_h;
    private int field_198122_i;
    private int field_198123_j;
    private Optional<VideoMode> field_198124_k;
    private boolean field_198125_l;
    private boolean field_198126_m;
    private int field_198127_n;
    private int field_198128_o;
    private int field_198129_p;
    private int field_198130_q;
    private int field_198131_r;
    private int field_198132_s;
    private int field_198133_t;
    private int field_198134_u;
    private double field_198135_v;
    private String field_198136_w = "";
    private boolean field_198138_y;
    private double field_198139_z = Double.MIN_VALUE;

    public MainWindow(Minecraft minecraft, VirtualScreen virtualScreen, GameConfiguration.DisplayInformation displayInformation, String string) {
        this.field_198117_d = virtualScreen;
        this.func_198093_u();
        this.func_198076_a("Pre startup");
        this.field_198116_c = minecraft;
        Optional<VideoMode> optional = VideoMode.func_198061_a(string);
        this.field_198124_k = optional.isPresent() ? optional : (displayInformation.field_199045_c.isPresent() && displayInformation.field_199046_d.isPresent() ? Optional.of(new VideoMode(displayInformation.field_199045_c.get(), displayInformation.field_199046_d.get(), 8, 8, 8, 60)) : Optional.empty());
        this.field_198126_m = this.field_198125_l = displayInformation.field_178763_c;
        this.field_198118_e = virtualScreen.func_198054_a(GLFW.glfwGetPrimaryMonitor());
        VideoMode \u26032 = this.field_198118_e.func_197992_a(this.field_198125_l ? this.field_198124_k : Optional.empty());
        this.field_198129_p = displayInformation.field_178764_a > 0 ? displayInformation.field_178764_a : 1;
        this.field_198122_i = this.field_198129_p;
        this.field_198130_q = displayInformation.field_178762_b > 0 ? displayInformation.field_178762_b : 1;
        this.field_198123_j = this.field_198130_q;
        this.field_198120_g = this.field_198127_n = this.field_198118_e.func_197989_c() + \u26032.func_198064_a() / 2 - this.field_198129_p / 2;
        this.field_198121_h = this.field_198128_o = this.field_198118_e.func_197990_d() + \u26032.func_198065_b() / 2 - this.field_198130_q / 2;
        GLFW.glfwDefaultWindowHints();
        this.field_198119_f = GLFW.glfwCreateWindow((int)this.field_198129_p, (int)this.field_198130_q, (CharSequence)"Minecraft 1.13.2", (long)(this.field_198125_l ? this.field_198118_e.func_197995_f() : 0L), (long)0L);
        minecraft.field_195555_I = true;
        this.func_198085_v();
        GLFW.glfwMakeContextCurrent((long)this.field_198119_f);
        GL.createCapabilities();
        this.func_198108_y();
        this.func_198103_w();
        this.func_198110_t();
        GLFW.glfwSetFramebufferSizeCallback((long)this.field_198119_f, this::func_198102_b);
        GLFW.glfwSetWindowPosCallback((long)this.field_198119_f, this::func_198080_a);
        GLFW.glfwSetWindowSizeCallback((long)this.field_198119_f, this::func_198089_c);
        GLFW.glfwSetWindowFocusCallback((long)this.field_198119_f, this::func_198095_a);
        minecraft.field_71417_B = new MouseHelper(minecraft);
        minecraft.field_71417_B.func_198029_a(this.field_198119_f);
        minecraft.field_195559_v = new KeyboardListener(minecraft);
        minecraft.field_195559_v.func_197968_a(this.field_198119_f);
    }

    public static void func_211162_a(BiConsumer<Integer, String> biConsumer) {
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            PointerBuffer pointerBuffer = memoryStack.mallocPointer(1);
            int \u26032 = GLFW.glfwGetError((PointerBuffer)pointerBuffer);
            if (\u26032 != 0) {
                long l = pointerBuffer.get();
                String \u26033 = l != 0L ? MemoryUtil.memUTF8((long)l) : "";
                biConsumer.accept(\u26032, \u26033);
            }
        }
    }

    public void func_198094_a() {
        GlStateManager.func_179086_m(256);
        GlStateManager.func_179128_n(5889);
        GlStateManager.func_179096_D();
        GlStateManager.func_179130_a(0.0, (double)this.func_198109_k() / this.func_198100_s(), (double)this.func_198091_l() / this.func_198100_s(), 0.0, 1000.0, 3000.0);
        GlStateManager.func_179128_n(5888);
        GlStateManager.func_179096_D();
        GlStateManager.func_179109_b(0.0f, 0.0f, -2000.0f);
    }

    private void func_198110_t() {
        try (MemoryStack memoryStack = MemoryStack.stackPush();
             InputStream inputStream = this.field_198116_c.func_195541_I().func_195746_a().func_195761_a(ResourcePackType.CLIENT_RESOURCES, new ResourceLocation("icons/icon_16x16.png"));){
            \u2603 = this.field_198116_c.func_195541_I().func_195746_a().func_195761_a(ResourcePackType.CLIENT_RESOURCES, new ResourceLocation("icons/icon_32x32.png"));
            Throwable throwable = null;
            try {
                if (inputStream == null) {
                    throw new FileNotFoundException("icons/icon_16x16.png");
                }
                if (\u2603 == null) {
                    throw new FileNotFoundException("icons/icon_32x32.png");
                }
                IntBuffer intBuffer = memoryStack.mallocInt(1);
                \u2603 = memoryStack.mallocInt(1);
                \u2603 = memoryStack.mallocInt(1);
                GLFWImage.Buffer \u26032 = GLFWImage.mallocStack((int)2, (MemoryStack)memoryStack);
                ByteBuffer \u26033 = this.func_198111_a(inputStream, intBuffer, \u2603, \u2603);
                if (\u26033 == null) {
                    throw new IllegalStateException("Could not load icon: " + STBImage.stbi_failure_reason());
                }
                \u26032.position(0);
                \u26032.width(intBuffer.get(0));
                \u26032.height(\u2603.get(0));
                \u26032.pixels(\u26033);
                ByteBuffer \u26034 = this.func_198111_a(\u2603, intBuffer, \u2603, \u2603);
                if (\u26034 == null) {
                    throw new IllegalStateException("Could not load icon: " + STBImage.stbi_failure_reason());
                }
                \u26032.position(1);
                \u26032.width(intBuffer.get(0));
                \u26032.height(\u2603.get(0));
                \u26032.pixels(\u26034);
                \u26032.position(0);
                GLFW.glfwSetWindowIcon((long)this.field_198119_f, (GLFWImage.Buffer)\u26032);
                STBImage.stbi_image_free((ByteBuffer)\u26033);
                STBImage.stbi_image_free((ByteBuffer)\u26034);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (\u2603 != null) {
                    if (throwable != null) {
                        try {
                            \u2603.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        \u2603.close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            field_198114_a.error("Couldn't set icon", (Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ByteBuffer func_198111_a(InputStream inputStream, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3) throws IOException {
        ByteBuffer byteBuffer = null;
        try {
            byteBuffer = TextureUtil.func_195724_a(inputStream);
            byteBuffer.rewind();
            ByteBuffer byteBuffer2 = STBImage.stbi_load_from_memory((ByteBuffer)byteBuffer, (IntBuffer)intBuffer, (IntBuffer)intBuffer2, (IntBuffer)intBuffer3, (int)0);
            return byteBuffer2;
        }
        finally {
            if (byteBuffer != null) {
                MemoryUtil.memFree((Buffer)byteBuffer);
            }
        }
    }

    void func_198076_a(String string) {
        this.field_198136_w = string;
    }

    private void func_198093_u() {
        GLFW.glfwSetErrorCallback(MainWindow::func_208034_b);
    }

    private static void func_208034_b(int n, long l) {
        throw new IllegalStateException("GLFW error " + n + ": " + MemoryUtil.memUTF8((long)l));
    }

    void func_198084_a(int n, long l) {
        String string = MemoryUtil.memUTF8((long)l);
        field_198114_a.error("########## GL ERROR ##########");
        field_198114_a.error("@ {}", (Object)this.field_198136_w);
        field_198114_a.error("{}: {}", (Object)n, (Object)string);
    }

    void func_198112_b() {
        GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)this.field_198115_b).free();
    }

    public void func_209548_c() {
        GLFW.glfwSwapInterval((int)(this.field_198116_c.field_71474_y.field_74352_v ? 1 : 0));
    }

    @Override
    public void close() {
        Util.field_211180_a = System::nanoTime;
        Callbacks.glfwFreeCallbacks((long)this.field_198119_f);
        this.field_198115_b.close();
        GLFW.glfwDestroyWindow((long)this.field_198119_f);
        GLFW.glfwTerminate();
    }

    private void func_198085_v() {
        this.field_198118_e = this.field_198117_d.func_198055_a(this);
    }

    private void func_198080_a(long l, int n, int n2) {
        this.field_198127_n = n;
        this.field_198128_o = n2;
        this.func_198085_v();
    }

    private void func_198102_b(long l, int n, int n2) {
        if (l != this.field_198119_f) {
            return;
        }
        \u2603 = this.func_198109_k();
        \u2603 = this.func_198091_l();
        if (n == 0 || n2 == 0) {
            return;
        }
        this.field_198131_r = n;
        this.field_198132_s = n2;
        if (this.func_198109_k() != \u2603 || this.func_198091_l() != \u2603) {
            this.func_198098_h();
        }
    }

    private void func_198103_w() {
        int[] nArray = new int[1];
        \u2603 = new int[1];
        GLFW.glfwGetFramebufferSize((long)this.field_198119_f, (int[])nArray, (int[])\u2603);
        this.field_198131_r = nArray[0];
        this.field_198132_s = \u2603[0];
    }

    private void func_198089_c(long l, int n, int n2) {
        this.field_198129_p = n;
        this.field_198130_q = n2;
        this.func_198085_v();
    }

    private void func_198095_a(long l, boolean bl) {
        if (l == this.field_198119_f) {
            this.field_198116_c.field_195555_I = bl;
        }
    }

    private int func_198082_x() {
        if (this.field_198116_c.field_71441_e == null && this.field_198116_c.field_71462_r != null) {
            return 60;
        }
        return this.field_198116_c.field_71474_y.field_74350_i;
    }

    public boolean func_198096_c() {
        return (double)this.func_198082_x() < GameSettings.Options.FRAMERATE_LIMIT.func_198009_f();
    }

    public void func_198086_a(boolean bl) {
        this.field_198116_c.field_71424_I.func_76320_a("display_update");
        GLFW.glfwSwapBuffers((long)this.field_198119_f);
        GLFW.glfwPollEvents();
        if (this.field_198125_l != this.field_198126_m) {
            this.field_198126_m = this.field_198125_l;
            this.func_198081_z();
        }
        this.field_198116_c.field_71424_I.func_76319_b();
        if (bl && this.func_198096_c()) {
            this.field_198116_c.field_71424_I.func_76320_a("fpslimit_wait");
            double d = this.field_198139_z + 1.0 / (double)this.func_198082_x();
            \u2603 = GLFW.glfwGetTime();
            while (\u2603 < d) {
                GLFW.glfwWaitEventsTimeout((double)(d - \u2603));
                \u2603 = GLFW.glfwGetTime();
            }
            this.field_198139_z = \u2603;
            this.field_198116_c.field_71424_I.func_76319_b();
        }
    }

    public Optional<VideoMode> func_198106_d() {
        return this.field_198124_k;
    }

    public int func_198090_e() {
        if (this.field_198124_k.isPresent()) {
            return this.field_198118_e.func_197993_b(this.field_198124_k) + 1;
        }
        return 0;
    }

    public String func_198088_a(int n) {
        if (this.field_198118_e.func_197994_e() <= n) {
            n = this.field_198118_e.func_197994_e() - 1;
        }
        return this.field_198118_e.func_197991_a(n).toString();
    }

    public void func_198104_b(int n) {
        Optional<VideoMode> optional = this.field_198124_k;
        this.field_198124_k = n == 0 ? Optional.empty() : Optional.of(this.field_198118_e.func_197991_a(n - 1));
        if (!this.field_198124_k.equals(optional)) {
            this.field_198138_y = true;
        }
    }

    public void func_198097_f() {
        if (this.field_198125_l && this.field_198138_y) {
            this.field_198138_y = false;
            this.func_198108_y();
            this.func_198098_h();
        }
    }

    private void func_198108_y() {
        boolean bl;
        boolean bl2 = bl = GLFW.glfwGetWindowMonitor((long)this.field_198119_f) != 0L;
        if (this.field_198125_l) {
            VideoMode videoMode = this.field_198118_e.func_197992_a(this.field_198124_k);
            if (!bl) {
                this.field_198120_g = this.field_198127_n;
                this.field_198121_h = this.field_198128_o;
                this.field_198122_i = this.field_198129_p;
                this.field_198123_j = this.field_198130_q;
            }
            this.field_198127_n = 0;
            this.field_198128_o = 0;
            this.field_198129_p = videoMode.func_198064_a();
            this.field_198130_q = videoMode.func_198065_b();
            GLFW.glfwSetWindowMonitor((long)this.field_198119_f, (long)this.field_198118_e.func_197995_f(), (int)this.field_198127_n, (int)this.field_198128_o, (int)this.field_198129_p, (int)this.field_198130_q, (int)videoMode.func_198067_f());
        } else {
            VideoMode videoMode = this.field_198118_e.func_197987_b();
            this.field_198127_n = this.field_198120_g;
            this.field_198128_o = this.field_198121_h;
            this.field_198129_p = this.field_198122_i;
            this.field_198130_q = this.field_198123_j;
            GLFW.glfwSetWindowMonitor((long)this.field_198119_f, (long)0L, (int)this.field_198127_n, (int)this.field_198128_o, (int)this.field_198129_p, (int)this.field_198130_q, (int)-1);
        }
    }

    public void func_198077_g() {
        this.field_198116_c.field_71474_y.field_74353_u = this.field_198125_l = !this.field_198125_l;
    }

    private void func_198081_z() {
        try {
            this.func_198108_y();
            this.func_198098_h();
            this.func_209548_c();
            this.func_198086_a(false);
        }
        catch (Exception exception) {
            field_198114_a.error("Couldn't toggle fullscreen", (Throwable)exception);
        }
    }

    public void func_198098_h() {
        Framebuffer framebuffer;
        this.field_198135_v = this.func_198078_c(this.field_198116_c.field_71474_y.field_74335_Z);
        this.field_198133_t = MathHelper.func_76143_f((double)this.field_198131_r / this.field_198135_v);
        this.field_198134_u = MathHelper.func_76143_f((double)this.field_198132_s / this.field_198135_v);
        if (this.field_198116_c.field_71462_r != null) {
            this.field_198116_c.field_71462_r.func_175273_b(this.field_198116_c, this.field_198133_t, this.field_198134_u);
        }
        if ((framebuffer = this.field_198116_c.func_147110_a()) != null) {
            framebuffer.func_147613_a(this.field_198131_r, this.field_198132_s);
        }
        if (this.field_198116_c.field_71460_t != null) {
            this.field_198116_c.field_71460_t.func_147704_a(this.field_198131_r, this.field_198132_s);
        }
        if (this.field_198116_c.field_71417_B != null) {
            this.field_198116_c.field_71417_B.func_198021_g();
        }
    }

    public int func_198078_c(int n) {
        for (\u2603 = 1; \u2603 != n && \u2603 < this.field_198131_r && \u2603 < this.field_198132_s && this.field_198131_r / (\u2603 + 1) >= 320 && this.field_198132_s / (\u2603 + 1) >= 240; ++\u2603) {
        }
        if (this.field_198116_c.func_211821_e() && \u2603 % 2 != 0) {
            ++\u2603;
        }
        return \u2603;
    }

    public long func_198092_i() {
        return this.field_198119_f;
    }

    public boolean func_198113_j() {
        return this.field_198125_l;
    }

    public int func_198109_k() {
        return this.field_198131_r;
    }

    public int func_198091_l() {
        return this.field_198132_s;
    }

    public int func_198105_m() {
        return this.field_198129_p;
    }

    public int func_198083_n() {
        return this.field_198130_q;
    }

    public int func_198107_o() {
        return this.field_198133_t;
    }

    public int func_198087_p() {
        return this.field_198134_u;
    }

    public int func_198099_q() {
        return this.field_198127_n;
    }

    public int func_198079_r() {
        return this.field_198128_o;
    }

    public double func_198100_s() {
        return this.field_198135_v;
    }
}

