/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import java.io.File;
import java.net.Proxy;
import java.net.SocketAddress;
import java.nio.ByteOrder;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.GameSettings;
import net.minecraft.client.KeyboardListener;
import net.minecraft.client.MainWindow;
import net.minecraft.client.MouseHelper;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiConnecting;
import net.minecraft.client.gui.GuiDirtMessageScreen;
import net.minecraft.client.gui.GuiGameOver;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiMemoryErrorScreen;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenLoading;
import net.minecraft.client.gui.GuiScreenWorking;
import net.minecraft.client.gui.GuiSleepMP;
import net.minecraft.client.gui.GuiWinGame;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IGuiEventListenerDeferred;
import net.minecraft.client.gui.advancements.GuiScreenAdvancements;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.fonts.FontResourceManager;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.gui.recipebook.RecipeList;
import net.minecraft.client.gui.toasts.GuiToast;
import net.minecraft.client.main.GameConfiguration;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.network.NetHandlerLoginClient;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.FirstPersonRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.GlDebugTextUtils;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VirtualScreen;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.DownloadingPackFinder;
import net.minecraft.client.resources.FoliageColorReloadListener;
import net.minecraft.client.resources.GrassColorReloadListener;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.LanguageManager;
import net.minecraft.client.resources.LegacyResourcePackWrapper;
import net.minecraft.client.resources.ResourcePackInfoClient;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.client.settings.CreativeSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.tutorial.Tutorial;
import net.minecraft.client.util.ISearchTree;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.util.RecipeBookClient;
import net.minecraft.client.util.SearchTree;
import net.minecraft.client.util.SearchTreeManager;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLeashKnot;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Bootstrap;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemSkull;
import net.minecraft.item.ItemSpawnEgg;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.EnumConnectionState;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.handshake.client.CPacketHandshake;
import net.minecraft.network.login.client.CPacketLoginStart;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.profiler.ISnooperInfo;
import net.minecraft.profiler.Profiler;
import net.minecraft.profiler.Snooper;
import net.minecraft.resources.FolderPackFinder;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.stats.StatisticsManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.FrameTimer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.MovementInputFromOptions;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Session;
import net.minecraft.util.Timer;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentKeybind;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.storage.AnvilSaveConverter;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.dimension.EndDimension;
import net.minecraft.world.dimension.NetherDimension;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.Version;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;

public class Minecraft
implements IThreadListener,
ISnooperInfo,
IGuiEventListenerDeferred {
    private static final Logger field_147123_G = LogManager.getLogger();
    public static final boolean field_142025_a = Util.func_110647_a() == Util.EnumOS.OSX;
    public static final ResourceLocation field_211502_b = new ResourceLocation("default");
    public static final ResourceLocation field_71464_q = new ResourceLocation("alt");
    public static byte[] field_71444_a = new byte[0xA00000];
    private static int field_211120_F = -1;
    private final File field_130070_K;
    private final PropertyMap field_181038_N;
    private final GameConfiguration.DisplayInformation field_195556_O;
    private ServerData field_71422_O;
    private TextureManager field_71446_o;
    private static Minecraft field_71432_P;
    private final DataFixer field_184131_U;
    public PlayerControllerMP field_71442_b;
    private VirtualScreen field_195557_T;
    public MainWindow field_195558_d;
    private boolean field_71434_R;
    private CrashReport field_71433_S;
    private boolean field_181541_X;
    private final Timer field_71428_T = new Timer(20.0f, 0L);
    private final Snooper field_71427_U = new Snooper("client", this, Util.func_211177_b());
    public WorldClient field_71441_e;
    public WorldRenderer field_71438_f;
    private RenderManager field_175616_W;
    private ItemRenderer field_175621_X;
    private FirstPersonRenderer field_175620_Y;
    public EntityPlayerSP field_71439_g;
    @Nullable
    private Entity field_175622_Z;
    @Nullable
    public Entity field_147125_j;
    public ParticleManager field_71452_i;
    private final SearchTreeManager field_193995_ae = new SearchTreeManager();
    private final Session field_71449_j;
    private boolean field_71445_n;
    private float field_193996_ah;
    public FontRenderer field_71466_p;
    @Nullable
    public GuiScreen field_71462_r;
    public GameRenderer field_71460_t;
    public DebugRenderer field_184132_p;
    int field_71429_W;
    @Nullable
    private IntegratedServer field_71437_Z;
    public GuiIngame field_71456_v;
    public boolean field_71454_w;
    public RayTraceResult field_71476_x;
    public GameSettings field_71474_y;
    private CreativeSettings field_191950_u;
    public MouseHelper field_71417_B;
    public KeyboardListener field_195559_v;
    public final File field_71412_D;
    private final File field_110446_Y;
    private final String field_110447_Z;
    private final String field_184130_ao;
    private final Proxy field_110453_aa;
    private ISaveFormat field_71469_aa;
    private static int field_71470_ab;
    private int field_71467_ac;
    private String field_71475_ae;
    private int field_71477_af;
    private int field_71457_ai;
    public final FrameTimer field_181542_y = new FrameTimer();
    private long field_181543_z = Util.func_211178_c();
    private final boolean field_147129_ai;
    private final boolean field_71459_aj;
    @Nullable
    private NetworkManager field_71453_ak;
    private boolean field_71455_al;
    public final Profiler field_71424_I = new Profiler();
    private IReloadableResourceManager field_110451_am;
    private final DownloadingPackFinder field_195554_ax;
    private final ResourcePackList<ResourcePackInfoClient> field_110448_aq;
    private LanguageManager field_135017_as;
    private BlockColors field_184127_aH;
    private ItemColors field_184128_aI;
    private Framebuffer field_147124_at;
    private TextureMap field_147128_au;
    private SoundHandler field_147127_av;
    private MusicTicker field_147126_aw;
    private FontResourceManager field_211501_aD;
    private final MinecraftSessionService field_152355_az;
    private SkinManager field_152350_aA;
    private final Queue<FutureTask<?>> field_152351_aB = Queues.newConcurrentLinkedQueue();
    private final Thread field_152352_aC = Thread.currentThread();
    private ModelManager field_175617_aL;
    private BlockRendererDispatcher field_175618_aM;
    private final GuiToast field_193034_aS;
    private volatile boolean field_71425_J = true;
    public String field_71426_K = "";
    public boolean field_175612_E = true;
    private long field_71419_L;
    private int field_71420_M;
    private final Tutorial field_193035_aW;
    boolean field_195555_I;
    private String field_71465_an = "root";

    public Minecraft(GameConfiguration gameConfiguration) {
        this.field_195556_O = gameConfiguration.field_178743_b;
        field_71432_P = this;
        this.field_71412_D = gameConfiguration.field_178744_c.field_178760_a;
        this.field_110446_Y = gameConfiguration.field_178744_c.field_178759_c;
        this.field_130070_K = gameConfiguration.field_178744_c.field_178758_b;
        this.field_110447_Z = gameConfiguration.field_178741_d.field_178755_b;
        this.field_184130_ao = gameConfiguration.field_178741_d.field_187053_c;
        this.field_181038_N = gameConfiguration.field_178745_a.field_181172_c;
        this.field_195554_ax = new DownloadingPackFinder(new File(this.field_71412_D, "server-resource-packs"), gameConfiguration.field_178744_c.func_187052_a());
        this.field_110448_aq = new ResourcePackList<ResourcePackInfoClient>((string, bl, supplier, iResourcePack, packMetadataSection, priority) -> {
            Supplier<IResourcePack> supplier2 = packMetadataSection.func_198962_b() < 4 ? () -> Minecraft.func_211809_a((Supplier)supplier) : supplier;
            return new ResourcePackInfoClient(string, bl, supplier2, iResourcePack, packMetadataSection, priority);
        });
        this.field_110448_aq.func_198982_a(this.field_195554_ax);
        this.field_110448_aq.func_198982_a(new FolderPackFinder(this.field_130070_K));
        this.field_110453_aa = gameConfiguration.field_178745_a.field_178751_c == null ? Proxy.NO_PROXY : gameConfiguration.field_178745_a.field_178751_c;
        this.field_152355_az = new YggdrasilAuthenticationService(this.field_110453_aa, UUID.randomUUID().toString()).createMinecraftSessionService();
        this.field_71449_j = gameConfiguration.field_178745_a.field_178752_a;
        field_147123_G.info("Setting user: {}", (Object)this.field_71449_j.func_111285_a());
        field_147123_G.debug("(Session ID is {})", (Object)this.field_71449_j.func_111286_b());
        this.field_71459_aj = gameConfiguration.field_178741_d.field_178756_a;
        this.field_147129_ai = Minecraft.func_147122_X();
        this.field_71437_Z = null;
        if (gameConfiguration.field_178742_e.field_178754_a != null) {
            this.field_71475_ae = gameConfiguration.field_178742_e.field_178754_a;
            this.field_71477_af = gameConfiguration.field_178742_e.field_178753_b;
        }
        Bootstrap.func_151354_b();
        TextComponentKeybind.field_193637_b = KeyBinding::func_193626_b;
        this.field_184131_U = DataFixesManager.func_210901_a();
        this.field_193034_aS = new GuiToast(this);
        this.field_193035_aW = new Tutorial(this);
    }

    public void func_99999_d() {
        this.field_71425_J = true;
        try {
            this.func_71384_a();
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, "Initializing game");
            crashReport.func_85058_a("Initialization");
            this.func_71377_b(this.func_71396_d(crashReport));
            return;
        }
        try {
            while (this.field_71425_J) {
                if (this.field_71434_R && this.field_71433_S != null) {
                    this.func_71377_b(this.field_71433_S);
                    return;
                }
                try {
                    this.func_195542_b(true);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    this.func_71398_f();
                    this.func_147108_a(new GuiMemoryErrorScreen());
                    System.gc();
                }
            }
        }
        catch (ReportedException reportedException) {
            this.func_71396_d(reportedException.func_71575_a());
            this.func_71398_f();
            field_147123_G.fatal("Reported exception thrown!", (Throwable)reportedException);
            this.func_71377_b(reportedException.func_71575_a());
        }
        catch (Throwable throwable) {
            CrashReport crashReport = this.func_71396_d(new CrashReport("Unexpected error", throwable));
            this.func_71398_f();
            field_147123_G.fatal("Unreported exception thrown!", throwable);
            this.func_71377_b(crashReport);
        }
        finally {
            this.func_71405_e();
        }
    }

    private void func_71384_a() {
        this.field_71474_y = new GameSettings(this, this.field_71412_D);
        this.field_191950_u = new CreativeSettings(this.field_71412_D, this.field_184131_U);
        this.func_71389_H();
        field_147123_G.info("LWJGL Version: {}", (Object)Version.getVersion());
        GameConfiguration.DisplayInformation displayInformation = this.field_195556_O;
        if (this.field_71474_y.field_92119_C > 0 && this.field_71474_y.field_92118_B > 0) {
            displayInformation = new GameConfiguration.DisplayInformation(this.field_71474_y.field_92118_B, this.field_71474_y.field_92119_C, displayInformation.field_199045_c, displayInformation.field_199046_d, displayInformation.field_178763_c);
        }
        this.func_211118_al();
        this.field_195557_T = new VirtualScreen(this);
        this.field_195558_d = this.field_195557_T.func_198053_a(displayInformation, this.field_71474_y.field_198019_u);
        OpenGlHelper.func_77474_a();
        GlDebugTextUtils.func_209247_b(this.field_71474_y.field_209231_W);
        this.field_147124_at = new Framebuffer(this.field_195558_d.func_198109_k(), this.field_195558_d.func_198091_l(), true);
        this.field_147124_at.func_147604_a(0.0f, 0.0f, 0.0f, 0.0f);
        this.field_110451_am = new SimpleReloadableResourceManager(ResourcePackType.CLIENT_RESOURCES);
        this.field_135017_as = new LanguageManager(this.field_71474_y.field_74363_ab);
        this.field_110451_am.func_199006_a(this.field_135017_as);
        this.field_71474_y.func_198017_a(this.field_110448_aq);
        this.func_110436_a();
        this.field_71446_o = new TextureManager(this.field_110451_am);
        this.field_110451_am.func_199006_a(this.field_71446_o);
        this.field_195558_d.func_198098_h();
        this.func_147108_a(new GuiScreenLoading());
        this.func_195547_ap();
        this.field_152350_aA = new SkinManager(this.field_71446_o, new File(this.field_110446_Y, "skins"), this.field_152355_az);
        this.field_71469_aa = new AnvilSaveConverter(this.field_71412_D.toPath().resolve("saves"), this.field_71412_D.toPath().resolve("backups"), this.field_184131_U);
        this.field_147127_av = new SoundHandler(this.field_110451_am, this.field_71474_y);
        this.field_110451_am.func_199006_a(this.field_147127_av);
        this.field_147126_aw = new MusicTicker(this);
        this.field_211501_aD = new FontResourceManager(this.field_71446_o, this.func_211821_e());
        this.field_110451_am.func_199006_a(this.field_211501_aD);
        this.field_71466_p = this.field_211501_aD.func_211504_a(field_211502_b);
        if (this.field_71474_y.field_74363_ab != null) {
            this.field_71466_p.func_78275_b(this.field_135017_as.func_135044_b());
        }
        this.field_110451_am.func_199006_a(new GrassColorReloadListener());
        this.field_110451_am.func_199006_a(new FoliageColorReloadListener());
        this.field_195558_d.func_198076_a("Startup");
        GlStateManager.func_179098_w();
        GlStateManager.func_179103_j(7425);
        GlStateManager.func_179151_a(1.0);
        GlStateManager.func_179126_j();
        GlStateManager.func_179143_c(515);
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a(516, 0.1f);
        GlStateManager.func_187407_a(GlStateManager.CullFace.BACK);
        GlStateManager.func_179128_n(5889);
        GlStateManager.func_179096_D();
        GlStateManager.func_179128_n(5888);
        this.field_195558_d.func_198076_a("Post startup");
        this.field_147128_au = new TextureMap("textures");
        this.field_147128_au.func_147633_a(this.field_71474_y.field_151442_I);
        this.field_71446_o.func_110580_a(TextureMap.field_110575_b, this.field_147128_au);
        this.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        this.field_147128_au.func_174937_a(false, this.field_71474_y.field_151442_I > 0);
        this.field_175617_aL = new ModelManager(this.field_147128_au);
        this.field_110451_am.func_199006_a(this.field_175617_aL);
        this.field_184127_aH = BlockColors.func_186723_a();
        this.field_184128_aI = ItemColors.func_186729_a(this.field_184127_aH);
        this.field_175621_X = new ItemRenderer(this.field_71446_o, this.field_175617_aL, this.field_184128_aI);
        this.field_175616_W = new RenderManager(this.field_71446_o, this.field_175621_X);
        this.field_175620_Y = new FirstPersonRenderer(this);
        this.field_110451_am.func_199006_a(this.field_175621_X);
        this.field_71460_t = new GameRenderer(this, this.field_110451_am);
        this.field_110451_am.func_199006_a(this.field_71460_t);
        this.field_175618_aM = new BlockRendererDispatcher(this.field_175617_aL.func_174954_c(), this.field_184127_aH);
        this.field_110451_am.func_199006_a(this.field_175618_aM);
        this.field_71438_f = new WorldRenderer(this);
        this.field_110451_am.func_199006_a(this.field_71438_f);
        this.func_193986_ar();
        this.field_110451_am.func_199006_a(this.field_193995_ae);
        GlStateManager.func_179083_b(0, 0, this.field_195558_d.func_198109_k(), this.field_195558_d.func_198091_l());
        this.field_71452_i = new ParticleManager(this.field_71441_e, this.field_71446_o);
        this.field_71456_v = new GuiIngame(this);
        if (this.field_71475_ae != null) {
            this.func_147108_a(new GuiConnecting(new GuiMainMenu(), this, this.field_71475_ae, this.field_71477_af));
        } else {
            this.func_147108_a(new GuiMainMenu());
        }
        this.field_184132_p = new DebugRenderer(this);
        GLFW.glfwSetErrorCallback(this::func_195545_a).free();
        if (this.field_71474_y.field_74353_u && !this.field_195558_d.func_198113_j()) {
            this.field_195558_d.func_198077_g();
        }
        this.field_195558_d.func_209548_c();
        this.field_195558_d.func_198112_b();
        this.field_71438_f.func_174966_b();
    }

    private void func_211118_al() {
        MainWindow.func_211162_a((n, string) -> {
            throw new IllegalStateException(String.format("GLFW error before init: [0x%X]%s", n, string));
        });
        ArrayList arrayList = Lists.newArrayList();
        GLFWErrorCallback \u26032 = GLFW.glfwSetErrorCallback((n, l) -> arrayList.add(String.format("GLFW error during init: [0x%X]%s", n, l)));
        if (!GLFW.glfwInit()) {
            throw new IllegalStateException("Failed to initialize GLFW, errors: " + Joiner.on((String)",").join((Iterable)arrayList));
        }
        Util.field_211180_a = () -> (long)(GLFW.glfwGetTime() * 1.0E9);
        for (String string2 : arrayList) {
            field_147123_G.error("GLFW error collected during initialization: {}", (Object)string2);
        }
        GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)\u26032).free();
    }

    private void func_193986_ar() {
        SearchTree<ItemStack> searchTree = new SearchTree<ItemStack>(itemStack -> itemStack.func_82840_a(null, ITooltipFlag.TooltipFlags.NORMAL).stream().map(iTextComponent -> TextFormatting.func_110646_a(iTextComponent.getString()).trim()).filter(string -> !string.isEmpty()).collect(Collectors.toList()), itemStack -> Collections.singleton(IRegistry.field_212630_s.func_177774_c(itemStack.func_77973_b())));
        NonNullList<ItemStack> \u26032 = NonNullList.func_191196_a();
        for (Item item : IRegistry.field_212630_s) {
            item.func_150895_a(ItemGroup.field_78027_g, \u26032);
        }
        \u26032.forEach(searchTree::func_194043_a);
        SearchTree<RecipeList> \u26033 = new SearchTree<RecipeList>(recipeList -> recipeList.func_192711_b().stream().flatMap(iRecipe -> iRecipe.func_77571_b().func_82840_a(null, ITooltipFlag.TooltipFlags.NORMAL).stream()).map(iTextComponent -> TextFormatting.func_110646_a(iTextComponent.getString()).trim()).filter(string -> !string.isEmpty()).collect(Collectors.toList()), recipeList -> recipeList.func_192711_b().stream().map(iRecipe -> IRegistry.field_212630_s.func_177774_c(iRecipe.func_77571_b().func_77973_b())).collect(Collectors.toList()));
        this.field_193995_ae.func_194009_a(SearchTreeManager.field_194011_a, searchTree);
        this.field_193995_ae.func_194009_a(SearchTreeManager.field_194012_b, \u26033);
    }

    private void func_195545_a(int n, long l) {
        this.field_71474_y.field_74352_v = false;
        this.field_71474_y.func_74303_b();
    }

    private static boolean func_147122_X() {
        String[] stringArray;
        for (String \u26032 : stringArray = new String[]{"sun.arch.data.model", "com.ibm.vm.bitmode", "os.arch"}) {
            String string = System.getProperty(\u26032);
            if (string == null || !string.contains("64")) continue;
            return true;
        }
        return false;
    }

    public Framebuffer func_147110_a() {
        return this.field_147124_at;
    }

    public String func_175600_c() {
        return this.field_110447_Z;
    }

    public String func_184123_d() {
        return this.field_184130_ao;
    }

    private void func_71389_H() {
        Thread thread = new Thread("Timer hack thread"){

            @Override
            public void run() {
                while (Minecraft.this.field_71425_J) {
                    try {
                        Thread.sleep(Integer.MAX_VALUE);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(field_147123_G));
        thread.start();
    }

    public void func_71404_a(CrashReport crashReport) {
        this.field_71434_R = true;
        this.field_71433_S = crashReport;
    }

    public void func_71377_b(CrashReport crashReport) {
        File file = new File(Minecraft.func_71410_x().field_71412_D, "crash-reports");
        \u2603 = new File(file, "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-client.txt");
        Bootstrap.func_179870_a(crashReport.func_71502_e());
        if (crashReport.func_71497_f() != null) {
            Bootstrap.func_179870_a("#@!@# Game crashed! Crash report saved to: #@!@# " + crashReport.func_71497_f());
            System.exit(-1);
        } else if (crashReport.func_147149_a(\u2603)) {
            Bootstrap.func_179870_a("#@!@# Game crashed! Crash report saved to: #@!@# " + \u2603.getAbsolutePath());
            System.exit(-1);
        } else {
            Bootstrap.func_179870_a("#@?@# Game crashed! Crash report could not be saved. #@?@#");
            System.exit(-2);
        }
    }

    public boolean func_211821_e() {
        return this.field_71474_y.field_211842_aO;
    }

    public void func_110436_a() {
        this.field_110448_aq.func_198983_a();
        List<IResourcePack> list = this.field_110448_aq.func_198980_d().stream().map(ResourcePackInfo::func_195796_e).collect(Collectors.toList());
        if (this.field_71437_Z != null) {
            this.field_71437_Z.func_193031_aM();
        }
        try {
            this.field_110451_am.func_199005_a(list);
        }
        catch (RuntimeException \u26032) {
            field_147123_G.info("Caught error stitching, removing all assigned resourcepacks", (Throwable)\u26032);
            this.field_110448_aq.func_198985_a(Collections.emptyList());
            \u2603 = this.field_110448_aq.func_198980_d().stream().map(ResourcePackInfo::func_195796_e).collect(Collectors.toList());
            this.field_110451_am.func_199005_a(\u2603);
            this.field_71474_y.field_151453_l.clear();
            this.field_71474_y.field_183018_l.clear();
            this.field_71474_y.func_74303_b();
        }
        this.field_135017_as.func_135043_a(list);
        if (this.field_71438_f != null) {
            this.field_71438_f.func_72712_a();
        }
    }

    private void func_195547_ap() {
        this.field_195558_d.func_198094_a();
        this.field_71462_r.func_73863_a(0, 0, 0.0f);
        this.field_195558_d.func_198086_a(false);
    }

    public void func_181536_a(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        float \u26032 = 0.00390625f;
        float \u26033 = 0.00390625f;
        bufferBuilder.func_181662_b(n, n2 + n6, 0.0).func_187315_a((float)n3 * 0.00390625f, (float)(n4 + n6) * 0.00390625f).func_181669_b(n7, n8, n9, n10).func_181675_d();
        bufferBuilder.func_181662_b(n + n5, n2 + n6, 0.0).func_187315_a((float)(n3 + n5) * 0.00390625f, (float)(n4 + n6) * 0.00390625f).func_181669_b(n7, n8, n9, n10).func_181675_d();
        bufferBuilder.func_181662_b(n + n5, n2, 0.0).func_187315_a((float)(n3 + n5) * 0.00390625f, (float)n4 * 0.00390625f).func_181669_b(n7, n8, n9, n10).func_181675_d();
        bufferBuilder.func_181662_b(n, n2, 0.0).func_187315_a((float)n3 * 0.00390625f, (float)n4 * 0.00390625f).func_181669_b(n7, n8, n9, n10).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public ISaveFormat func_71359_d() {
        return this.field_71469_aa;
    }

    @Override
    @Nullable
    public IGuiEventListener getFocused() {
        return this.field_71462_r;
    }

    public void func_147108_a(@Nullable GuiScreen guiScreen) {
        if (this.field_71462_r != null) {
            this.field_71462_r.func_146281_b();
        }
        if (guiScreen == null && this.field_71441_e == null) {
            guiScreen = new GuiMainMenu();
        } else if (guiScreen == null && this.field_71439_g.func_110143_aJ() <= 0.0f) {
            guiScreen = new GuiGameOver(null);
        }
        if (guiScreen instanceof GuiMainMenu || guiScreen instanceof GuiMultiplayer) {
            this.field_71474_y.field_74330_P = false;
            this.field_71456_v.func_146158_b().func_146231_a(true);
        }
        this.field_71462_r = guiScreen;
        if (guiScreen != null) {
            this.field_71417_B.func_198032_j();
            KeyBinding.func_74506_a();
            guiScreen.func_146280_a(this, this.field_195558_d.func_198107_o(), this.field_195558_d.func_198087_p());
            this.field_71454_w = false;
        } else {
            this.field_147127_av.func_147687_e();
            this.field_71417_B.func_198034_i();
        }
    }

    public void func_71405_e() {
        try {
            field_147123_G.info("Stopping!");
            try {
                this.func_71403_a(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.field_71462_r != null) {
                this.field_71462_r.func_146281_b();
            }
            this.field_147128_au.func_195419_g();
            this.field_71466_p.close();
            this.field_71460_t.close();
            this.field_71438_f.close();
            this.field_147127_av.func_147685_d();
        }
        finally {
            this.field_195557_T.close();
            this.field_195558_d.close();
            if (!this.field_71434_R) {
                System.exit(0);
            }
        }
        System.gc();
    }

    private void func_195542_b(boolean bl) {
        long l;
        this.field_195558_d.func_198076_a("Pre render");
        long l2 = Util.func_211178_c();
        this.field_71424_I.func_76320_a("root");
        if (GLFW.glfwWindowShouldClose((long)this.field_195558_d.func_198092_i())) {
            this.func_71400_g();
        }
        if (bl) {
            this.field_71428_T.func_74275_a(Util.func_211177_b());
            this.field_71424_I.func_76320_a("scheduledExecutables");
            while ((\u2603 = this.field_152351_aB.poll()) != null) {
                Util.func_181617_a(\u2603, field_147123_G);
            }
            this.field_71424_I.func_76319_b();
        }
        l = Util.func_211178_c();
        if (bl) {
            this.field_71424_I.func_76320_a("tick");
            for (int i = 0; i < Math.min(10, this.field_71428_T.field_74280_b); ++i) {
                this.func_71407_l();
            }
        }
        this.field_71417_B.func_198028_a();
        this.field_195558_d.func_198076_a("Render");
        GLFW.glfwPollEvents();
        \u2603 = Util.func_211178_c() - l;
        this.field_71424_I.func_76318_c("sound");
        this.field_147127_av.func_147691_a(this.field_71439_g, this.field_71428_T.field_194147_b);
        this.field_71424_I.func_76319_b();
        this.field_71424_I.func_76320_a("render");
        GlStateManager.func_179094_E();
        GlStateManager.func_179086_m(16640);
        this.field_147124_at.func_147610_a(true);
        this.field_71424_I.func_76320_a("display");
        GlStateManager.func_179098_w();
        this.field_71424_I.func_76319_b();
        if (!this.field_71454_w) {
            this.field_71424_I.func_76318_c("gameRenderer");
            this.field_71460_t.func_195458_a(this.field_71445_n ? this.field_193996_ah : this.field_71428_T.field_194147_b, l2, bl);
            this.field_71424_I.func_76318_c("toasts");
            this.field_193034_aS.func_195625_a();
            this.field_71424_I.func_76319_b();
        }
        this.field_71424_I.func_76319_b();
        if (this.field_71474_y.field_74330_P && this.field_71474_y.field_74329_Q && !this.field_71474_y.field_74319_N) {
            this.field_71424_I.func_199095_a(this.field_71428_T.field_74280_b);
            this.func_203410_as();
        } else {
            this.field_71424_I.func_199098_b();
        }
        this.field_147124_at.func_147609_e();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        this.field_147124_at.func_147615_c(this.field_195558_d.func_198109_k(), this.field_195558_d.func_198091_l());
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        this.field_71460_t.func_152430_c(this.field_71428_T.field_194147_b);
        GlStateManager.func_179121_F();
        this.field_71424_I.func_76320_a("root");
        this.field_195558_d.func_198086_a(true);
        Thread.yield();
        this.field_195558_d.func_198076_a("Post render");
        ++this.field_71420_M;
        boolean bl2 = \u2603 = this.func_71356_B() && this.field_71462_r != null && this.field_71462_r.func_73868_f() && !this.field_71437_Z.func_71344_c();
        if (this.field_71445_n != \u2603) {
            if (this.field_71445_n) {
                this.field_193996_ah = this.field_71428_T.field_194147_b;
            } else {
                this.field_71428_T.field_194147_b = this.field_193996_ah;
            }
            this.field_71445_n = \u2603;
        }
        \u2603 = Util.func_211178_c();
        this.field_181542_y.func_181747_a(\u2603 - this.field_181543_z);
        this.field_181543_z = \u2603;
        while (Util.func_211177_b() >= this.field_71419_L + 1000L) {
            field_71470_ab = this.field_71420_M;
            Object[] objectArray = new Object[8];
            objectArray[0] = field_71470_ab;
            objectArray[1] = RenderChunk.field_178592_a;
            objectArray[2] = RenderChunk.field_178592_a == 1 ? "" : "s";
            objectArray[3] = (double)this.field_71474_y.field_74350_i == GameSettings.Options.FRAMERATE_LIMIT.func_198009_f() ? "inf" : Integer.valueOf(this.field_71474_y.field_74350_i);
            objectArray[4] = this.field_71474_y.field_74352_v ? " vsync" : "";
            Object object = objectArray[5] = this.field_71474_y.field_74347_j ? "" : " fast";
            objectArray[6] = this.field_71474_y.field_74345_l == 0 ? "" : (this.field_71474_y.field_74345_l == 1 ? " fast-clouds" : " fancy-clouds");
            objectArray[7] = OpenGlHelper.func_176075_f() ? " vbo" : "";
            this.field_71426_K = String.format("%d fps (%d chunk update%s) T: %s%s%s%s%s", objectArray);
            RenderChunk.field_178592_a = 0;
            this.field_71419_L += 1000L;
            this.field_71420_M = 0;
            this.field_71427_U.func_76471_b();
            if (this.field_71427_U.func_76468_d()) continue;
            this.field_71427_U.func_76463_a();
        }
        this.field_71424_I.func_76319_b();
    }

    public void func_71398_f() {
        try {
            field_71444_a = new byte[0];
            this.field_71438_f.func_72728_f();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.gc();
            this.func_205055_a(null, new GuiDirtMessageScreen(I18n.func_135052_a("menu.savingLevel", new Object[0])));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.gc();
    }

    void func_71383_b(int n) {
        List<Profiler.Result> list = this.field_71424_I.func_76321_b(this.field_71465_an);
        if (list.isEmpty()) {
            return;
        }
        Profiler.Result \u26032 = list.remove(0);
        if (n == 0) {
            if (!\u26032.field_76331_c.isEmpty() && (\u2603 = this.field_71465_an.lastIndexOf(46)) >= 0) {
                this.field_71465_an = this.field_71465_an.substring(0, \u2603);
            }
        } else if (--n < list.size() && !"unspecified".equals(list.get((int)n).field_76331_c)) {
            if (!this.field_71465_an.isEmpty()) {
                this.field_71465_an = this.field_71465_an + ".";
            }
            this.field_71465_an = this.field_71465_an + list.get((int)n).field_76331_c;
        }
    }

    private void func_203410_as() {
        int \u26039;
        Object \u260314;
        if (!this.field_71424_I.func_199094_a()) {
            return;
        }
        List<Profiler.Result> list = this.field_71424_I.func_76321_b(this.field_71465_an);
        Profiler.Result \u26032 = list.remove(0);
        GlStateManager.func_179086_m(256);
        GlStateManager.func_179128_n(5889);
        GlStateManager.func_179142_g();
        GlStateManager.func_179096_D();
        GlStateManager.func_179130_a(0.0, this.field_195558_d.func_198109_k(), this.field_195558_d.func_198091_l(), 0.0, 1000.0, 3000.0);
        GlStateManager.func_179128_n(5888);
        GlStateManager.func_179096_D();
        GlStateManager.func_179109_b(0.0f, 0.0f, -2000.0f);
        GlStateManager.func_187441_d(1.0f);
        GlStateManager.func_179090_x();
        Tessellator \u26033 = Tessellator.func_178181_a();
        BufferBuilder \u26034 = \u26033.func_178180_c();
        int \u26035 = 160;
        int \u26036 = this.field_195558_d.func_198109_k() - 160 - 10;
        int \u26037 = this.field_195558_d.func_198091_l() - 320;
        GlStateManager.func_179147_l();
        \u26034.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        \u26034.func_181662_b((float)\u26036 - 176.0f, (float)\u26037 - 96.0f - 16.0f, 0.0).func_181669_b(200, 0, 0, 0).func_181675_d();
        \u26034.func_181662_b((float)\u26036 - 176.0f, \u26037 + 320, 0.0).func_181669_b(200, 0, 0, 0).func_181675_d();
        \u26034.func_181662_b((float)\u26036 + 176.0f, \u26037 + 320, 0.0).func_181669_b(200, 0, 0, 0).func_181675_d();
        \u26034.func_181662_b((float)\u26036 + 176.0f, (float)\u26037 - 96.0f - 16.0f, 0.0).func_181669_b(200, 0, 0, 0).func_181675_d();
        \u26033.func_78381_a();
        GlStateManager.func_179084_k();
        double \u26038 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            float f;
            int n;
            \u260314 = list.get(i);
            \u26039 = MathHelper.func_76128_c(((Profiler.Result)\u260314).field_76332_a / 4.0) + 1;
            \u26034.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            int \u260310 = ((Profiler.Result)\u260314).func_76329_a();
            int \u260311 = \u260310 >> 16 & 0xFF;
            int \u260312 = \u260310 >> 8 & 0xFF;
            int \u260313 = \u260310 & 0xFF;
            \u26034.func_181662_b(\u26036, \u26037, 0.0).func_181669_b(\u260311, \u260312, \u260313, 255).func_181675_d();
            for (n = \u26039; n >= 0; --n) {
                f = (float)((\u26038 + ((Profiler.Result)\u260314).field_76332_a * (double)n / (double)\u26039) * 6.2831854820251465 / 100.0);
                \u2603 = MathHelper.func_76126_a(f) * 160.0f;
                \u2603 = MathHelper.func_76134_b(f) * 160.0f * 0.5f;
                \u26034.func_181662_b((float)\u26036 + \u2603, (float)\u26037 - \u2603, 0.0).func_181669_b(\u260311, \u260312, \u260313, 255).func_181675_d();
            }
            \u26033.func_78381_a();
            \u26034.func_181668_a(5, DefaultVertexFormats.field_181706_f);
            for (n = \u26039; n >= 0; --n) {
                f = (float)((\u26038 + ((Profiler.Result)\u260314).field_76332_a * (double)n / (double)\u26039) * 6.2831854820251465 / 100.0);
                \u2603 = MathHelper.func_76126_a(f) * 160.0f;
                \u2603 = MathHelper.func_76134_b(f) * 160.0f * 0.5f;
                \u26034.func_181662_b((float)\u26036 + \u2603, (float)\u26037 - \u2603, 0.0).func_181669_b(\u260311 >> 1, \u260312 >> 1, \u260313 >> 1, 255).func_181675_d();
                \u26034.func_181662_b((float)\u26036 + \u2603, (float)\u26037 - \u2603 + 10.0f, 0.0).func_181669_b(\u260311 >> 1, \u260312 >> 1, \u260313 >> 1, 255).func_181675_d();
            }
            \u26033.func_78381_a();
            \u26038 += ((Profiler.Result)\u260314).field_76332_a;
        }
        DecimalFormat decimalFormat = new DecimalFormat("##0.00");
        decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT));
        GlStateManager.func_179098_w();
        \u260314 = "";
        if (!"unspecified".equals(\u26032.field_76331_c)) {
            \u260314 = (String)\u260314 + "[0] ";
        }
        \u260314 = \u26032.field_76331_c.isEmpty() ? (String)\u260314 + "ROOT " : (String)\u260314 + \u26032.field_76331_c + ' ';
        \u26039 = 0xFFFFFF;
        this.field_71466_p.func_175063_a((String)\u260314, \u26036 - 160, \u26037 - 80 - 16, 0xFFFFFF);
        \u260314 = decimalFormat.format(\u26032.field_76330_b) + "%";
        this.field_71466_p.func_175063_a((String)\u260314, \u26036 + 160 - this.field_71466_p.func_78256_a((String)\u260314), \u26037 - 80 - 16, 0xFFFFFF);
        for (int i = 0; i < list.size(); ++i) {
            Profiler.Result result = list.get(i);
            StringBuilder \u260315 = new StringBuilder();
            if ("unspecified".equals(result.field_76331_c)) {
                \u260315.append("[?] ");
            } else {
                \u260315.append("[").append(i + 1).append("] ");
            }
            String \u260316 = \u260315.append(result.field_76331_c).toString();
            this.field_71466_p.func_175063_a(\u260316, \u26036 - 160, \u26037 + 80 + i * 8 + 20, result.func_76329_a());
            \u260316 = decimalFormat.format(result.field_76332_a) + "%";
            this.field_71466_p.func_175063_a(\u260316, \u26036 + 160 - 50 - this.field_71466_p.func_78256_a(\u260316), \u26037 + 80 + i * 8 + 20, result.func_76329_a());
            \u260316 = decimalFormat.format(result.field_76330_b) + "%";
            this.field_71466_p.func_175063_a(\u260316, \u26036 + 160 - this.field_71466_p.func_78256_a(\u260316), \u26037 + 80 + i * 8 + 20, result.func_76329_a());
        }
    }

    public void func_71400_g() {
        this.field_71425_J = false;
    }

    public void func_71385_j() {
        if (this.field_71462_r != null) {
            return;
        }
        this.func_147108_a(new GuiIngameMenu());
        if (this.func_71356_B() && !this.field_71437_Z.func_71344_c()) {
            this.field_147127_av.func_147689_b();
        }
    }

    private void func_147115_a(boolean bl) {
        if (!bl) {
            this.field_71429_W = 0;
        }
        if (this.field_71429_W > 0 || this.field_71439_g.func_184587_cr()) {
            return;
        }
        if (bl && this.field_71476_x != null && this.field_71476_x.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos blockPos = this.field_71476_x.func_178782_a();
            if (!this.field_71441_e.func_180495_p(blockPos).func_196958_f() && this.field_71442_b.func_180512_c(blockPos, this.field_71476_x.field_178784_b)) {
                this.field_71452_i.func_180532_a(blockPos, this.field_71476_x.field_178784_b);
                this.field_71439_g.func_184609_a(EnumHand.MAIN_HAND);
            }
            return;
        }
        this.field_71442_b.func_78767_c();
    }

    private void func_147116_af() {
        if (this.field_71429_W > 0) {
            return;
        }
        if (this.field_71476_x == null) {
            field_147123_G.error("Null returned as 'hitResult', this shouldn't happen!");
            if (this.field_71442_b.func_78762_g()) {
                this.field_71429_W = 10;
            }
            return;
        }
        if (this.field_71439_g.func_184838_M()) {
            return;
        }
        switch (this.field_71476_x.field_72313_a) {
            case ENTITY: {
                this.field_71442_b.func_78764_a(this.field_71439_g, this.field_71476_x.field_72308_g);
                break;
            }
            case BLOCK: {
                BlockPos blockPos = this.field_71476_x.func_178782_a();
                if (!this.field_71441_e.func_180495_p(blockPos).func_196958_f()) {
                    this.field_71442_b.func_180511_b(blockPos, this.field_71476_x.field_178784_b);
                    break;
                }
            }
            case MISS: {
                if (this.field_71442_b.func_78762_g()) {
                    this.field_71429_W = 10;
                }
                this.field_71439_g.func_184821_cY();
            }
        }
        this.field_71439_g.func_184609_a(EnumHand.MAIN_HAND);
    }

    private void func_147121_ag() {
        if (this.field_71442_b.func_181040_m()) {
            return;
        }
        this.field_71467_ac = 4;
        if (this.field_71439_g.func_184838_M()) {
            return;
        }
        if (this.field_71476_x == null) {
            field_147123_G.warn("Null returned as 'hitResult', this shouldn't happen!");
        }
        for (EnumHand enumHand : EnumHand.values()) {
            ItemStack itemStack = this.field_71439_g.func_184586_b(enumHand);
            if (this.field_71476_x != null) {
                switch (this.field_71476_x.field_72313_a) {
                    case ENTITY: {
                        if (this.field_71442_b.func_187102_a(this.field_71439_g, this.field_71476_x.field_72308_g, this.field_71476_x, enumHand) == EnumActionResult.SUCCESS) {
                            return;
                        }
                        if (this.field_71442_b.func_187097_a(this.field_71439_g, this.field_71476_x.field_72308_g, enumHand) != EnumActionResult.SUCCESS) break;
                        return;
                    }
                    case BLOCK: {
                        BlockPos blockPos = this.field_71476_x.func_178782_a();
                        if (this.field_71441_e.func_180495_p(blockPos).func_196958_f()) break;
                        int \u26032 = itemStack.func_190916_E();
                        EnumActionResult \u26033 = this.field_71442_b.func_187099_a(this.field_71439_g, this.field_71441_e, blockPos, this.field_71476_x.field_178784_b, this.field_71476_x.field_72307_f, enumHand);
                        if (\u26033 == EnumActionResult.SUCCESS) {
                            this.field_71439_g.func_184609_a(enumHand);
                            if (!itemStack.func_190926_b() && (itemStack.func_190916_E() != \u26032 || this.field_71442_b.func_78758_h())) {
                                this.field_71460_t.field_78516_c.func_187460_a(enumHand);
                            }
                            return;
                        }
                        if (\u26033 != EnumActionResult.FAIL) break;
                        return;
                    }
                }
            }
            if (itemStack.func_190926_b() || this.field_71442_b.func_187101_a(this.field_71439_g, this.field_71441_e, enumHand) != EnumActionResult.SUCCESS) continue;
            this.field_71460_t.field_78516_c.func_187460_a(enumHand);
            return;
        }
    }

    public MusicTicker func_181535_r() {
        return this.field_147126_aw;
    }

    public void func_71407_l() {
        if (this.field_71467_ac > 0) {
            --this.field_71467_ac;
        }
        this.field_71424_I.func_76320_a("gui");
        if (!this.field_71445_n) {
            this.field_71456_v.func_73831_a();
        }
        this.field_71424_I.func_76319_b();
        this.field_71460_t.func_78473_a(1.0f);
        this.field_193035_aW.func_193297_a(this.field_71441_e, this.field_71476_x);
        this.field_71424_I.func_76320_a("gameMode");
        if (!this.field_71445_n && this.field_71441_e != null) {
            this.field_71442_b.func_78765_e();
        }
        this.field_71424_I.func_76318_c("textures");
        if (this.field_71441_e != null) {
            this.field_71446_o.func_110550_d();
        }
        if (this.field_71462_r == null && this.field_71439_g != null) {
            if (this.field_71439_g.func_110143_aJ() <= 0.0f && !(this.field_71462_r instanceof GuiGameOver)) {
                this.func_147108_a(null);
            } else if (this.field_71439_g.func_70608_bn() && this.field_71441_e != null) {
                this.func_147108_a(new GuiSleepMP());
            }
        } else if (this.field_71462_r != null && this.field_71462_r instanceof GuiSleepMP && !this.field_71439_g.func_70608_bn()) {
            this.func_147108_a(null);
        }
        if (this.field_71462_r != null) {
            this.field_71429_W = 10000;
        }
        if (this.field_71462_r != null) {
            GuiScreen.func_195121_a(() -> this.field_71462_r.func_73876_c(), "Ticking screen", this.field_71462_r.getClass().getCanonicalName());
        }
        if (this.field_71462_r == null || this.field_71462_r.field_146291_p) {
            this.field_71424_I.func_76318_c("GLFW events");
            GLFW.glfwPollEvents();
            this.func_184117_aA();
            if (this.field_71429_W > 0) {
                --this.field_71429_W;
            }
        }
        if (this.field_71441_e != null) {
            if (this.field_71439_g != null) {
                ++this.field_71457_ai;
                if (this.field_71457_ai == 30) {
                    this.field_71457_ai = 0;
                    this.field_71441_e.func_72897_h(this.field_71439_g);
                }
            }
            this.field_71424_I.func_76318_c("gameRenderer");
            if (!this.field_71445_n) {
                this.field_71460_t.func_78464_a();
            }
            this.field_71424_I.func_76318_c("levelRenderer");
            if (!this.field_71445_n) {
                this.field_71438_f.func_72734_e();
            }
            this.field_71424_I.func_76318_c("level");
            if (!this.field_71445_n) {
                if (this.field_71441_e.func_175658_ac() > 0) {
                    this.field_71441_e.func_175702_c(this.field_71441_e.func_175658_ac() - 1);
                }
                this.field_71441_e.func_72939_s();
            }
        } else if (this.field_71460_t.func_147702_a()) {
            this.field_71460_t.func_181022_b();
        }
        if (!this.field_71445_n) {
            this.field_147126_aw.func_73660_a();
            this.field_147127_av.func_73660_a();
        }
        if (this.field_71441_e != null) {
            if (!this.field_71445_n) {
                this.field_71441_e.func_72891_a(this.field_71441_e.func_175659_aa() != EnumDifficulty.PEACEFUL, true);
                this.field_193035_aW.func_193303_d();
                try {
                    this.field_71441_e.func_72835_b(() -> true);
                }
                catch (Throwable throwable) {
                    CrashReport crashReport = CrashReport.func_85055_a(throwable, "Exception in world tick");
                    if (this.field_71441_e == null) {
                        CrashReportCategory crashReportCategory = crashReport.func_85058_a("Affected level");
                        crashReportCategory.func_71507_a("Problem", "Level is null!");
                    } else {
                        this.field_71441_e.func_72914_a(crashReport);
                    }
                    throw new ReportedException(crashReport);
                }
            }
            this.field_71424_I.func_76318_c("animateTick");
            if (!this.field_71445_n && this.field_71441_e != null) {
                this.field_71441_e.func_73029_E(MathHelper.func_76128_c(this.field_71439_g.field_70165_t), MathHelper.func_76128_c(this.field_71439_g.field_70163_u), MathHelper.func_76128_c(this.field_71439_g.field_70161_v));
            }
            this.field_71424_I.func_76318_c("particles");
            if (!this.field_71445_n) {
                this.field_71452_i.func_78868_a();
            }
        } else if (this.field_71453_ak != null) {
            this.field_71424_I.func_76318_c("pendingConnection");
            this.field_71453_ak.func_74428_b();
        }
        this.field_71424_I.func_76318_c("keyboard");
        this.field_195559_v.func_204870_b();
        this.field_71424_I.func_76319_b();
    }

    private void func_184117_aA() {
        int n;
        while (this.field_71474_y.field_151457_aa.func_151468_f()) {
            ++this.field_71474_y.field_74320_O;
            if (this.field_71474_y.field_74320_O > 2) {
                this.field_71474_y.field_74320_O = 0;
            }
            if (this.field_71474_y.field_74320_O == 0) {
                this.field_71460_t.func_175066_a(this.func_175606_aa());
            } else if (this.field_71474_y.field_74320_O == 1) {
                this.field_71460_t.func_175066_a(null);
            }
            this.field_71438_f.func_174979_m();
        }
        while (this.field_71474_y.field_151458_ab.func_151468_f()) {
            this.field_71474_y.field_74326_T = !this.field_71474_y.field_74326_T;
        }
        for (n = 0; n < 9; ++n) {
            boolean bl = this.field_71474_y.field_193629_ap.func_151470_d();
            \u2603 = this.field_71474_y.field_193630_aq.func_151470_d();
            if (!this.field_71474_y.field_151456_ac[n].func_151468_f()) continue;
            if (this.field_71439_g.func_175149_v()) {
                this.field_71456_v.func_175187_g().func_175260_a(n);
                continue;
            }
            if (this.field_71439_g.func_184812_l_() && this.field_71462_r == null && (\u2603 || bl)) {
                GuiContainerCreative.func_192044_a(this, n, \u2603, bl);
                continue;
            }
            this.field_71439_g.field_71071_by.field_70461_c = n;
        }
        while (this.field_71474_y.field_151445_Q.func_151468_f()) {
            if (this.field_71442_b.func_110738_j()) {
                this.field_71439_g.func_175163_u();
                continue;
            }
            this.field_193035_aW.func_193296_a();
            this.func_147108_a(new GuiInventory(this.field_71439_g));
        }
        while (this.field_71474_y.field_194146_ao.func_151468_f()) {
            this.func_147108_a(new GuiScreenAdvancements(this.field_71439_g.field_71174_a.func_191982_f()));
        }
        while (this.field_71474_y.field_186718_X.func_151468_f()) {
            if (this.field_71439_g.func_175149_v()) continue;
            this.func_147114_u().func_147297_a(new CPacketPlayerDigging(CPacketPlayerDigging.Action.SWAP_HELD_ITEMS, BlockPos.field_177992_a, EnumFacing.DOWN));
        }
        while (this.field_71474_y.field_74316_C.func_151468_f()) {
            if (this.field_71439_g.func_175149_v()) continue;
            this.field_71439_g.func_71040_bB(GuiScreen.func_146271_m());
        }
        int n2 = n = this.field_71474_y.field_74343_n != EntityPlayer.EnumChatVisibility.HIDDEN ? 1 : 0;
        if (n != 0) {
            while (this.field_71474_y.field_74310_D.func_151468_f()) {
                this.func_147108_a(new GuiChat());
            }
            if (this.field_71462_r == null && this.field_71474_y.field_74323_J.func_151468_f()) {
                this.func_147108_a(new GuiChat("/"));
            }
        }
        if (this.field_71439_g.func_184587_cr()) {
            if (!this.field_71474_y.field_74313_G.func_151470_d()) {
                this.field_71442_b.func_78766_c(this.field_71439_g);
            }
            while (this.field_71474_y.field_74312_F.func_151468_f()) {
            }
            while (this.field_71474_y.field_74313_G.func_151468_f()) {
            }
            while (this.field_71474_y.field_74322_I.func_151468_f()) {
            }
        } else {
            while (this.field_71474_y.field_74312_F.func_151468_f()) {
                this.func_147116_af();
            }
            while (this.field_71474_y.field_74313_G.func_151468_f()) {
                this.func_147121_ag();
            }
            while (this.field_71474_y.field_74322_I.func_151468_f()) {
                this.func_147112_ai();
            }
        }
        if (this.field_71474_y.field_74313_G.func_151470_d() && this.field_71467_ac == 0 && !this.field_71439_g.func_184587_cr()) {
            this.func_147121_ag();
        }
        this.func_147115_a(this.field_71462_r == null && this.field_71474_y.field_74312_F.func_151470_d() && this.field_71417_B.func_198035_h());
    }

    public void func_71371_a(String string, String string2, @Nullable WorldSettings worldSettings2) {
        Object object;
        this.func_71403_a(null);
        System.gc();
        ISaveHandler iSaveHandler = this.field_71469_aa.func_197715_a(string, null);
        WorldInfo \u26032 = iSaveHandler.func_75757_d();
        if (\u26032 == null && worldSettings2 != null) {
            \u26032 = new WorldInfo(worldSettings2, string);
            iSaveHandler.func_75761_a(\u26032);
        }
        if (worldSettings2 == null) {
            WorldSettings worldSettings2 = new WorldSettings(\u26032);
        }
        try {
            object = new YggdrasilAuthenticationService(this.field_110453_aa, UUID.randomUUID().toString());
            object2 = object.createMinecraftSessionService();
            \u2603 = object.createProfileRepository();
            PlayerProfileCache \u26033 = new PlayerProfileCache((GameProfileRepository)\u2603, new File(this.field_71412_D, MinecraftServer.field_152367_a.getName()));
            TileEntitySkull.func_184293_a(\u26033);
            TileEntitySkull.func_184294_a((MinecraftSessionService)object2);
            PlayerProfileCache.func_187320_a(false);
            this.field_71437_Z = new IntegratedServer(this, string, string2, worldSettings2, (YggdrasilAuthenticationService)object, (MinecraftSessionService)object2, (GameProfileRepository)\u2603, \u26033);
            this.field_71437_Z.func_71256_s();
            this.field_71455_al = true;
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, "Starting integrated server");
            CrashReportCategory \u26034 = crashReport.func_85058_a("Starting integrated server");
            \u26034.func_71507_a("Level ID", string);
            \u26034.func_71507_a("Level Name", string2);
            throw new ReportedException(crashReport);
        }
        object = new GuiScreenWorking();
        this.func_147108_a((GuiScreen)object);
        ((GuiScreenWorking)object).func_200210_a(new TextComponentTranslation("menu.loadingLevel", new Object[0]));
        while (!this.field_71437_Z.func_71200_ad()) {
            object2 = this.field_71437_Z.func_200253_h_();
            if (object2 != null) {
                \u2603 = this.field_71437_Z.func_200246_aJ();
                if (\u2603 != null) {
                    ((GuiScreenWorking)object).func_200209_c((ITextComponent)\u2603);
                    ((GuiScreenWorking)object).func_73718_a(this.field_71437_Z.func_195566_aK());
                } else {
                    ((GuiScreenWorking)object).func_200209_c((ITextComponent)object2);
                }
            } else {
                ((GuiScreenWorking)object).func_200209_c(new TextComponentString(""));
            }
            this.func_195542_b(false);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.field_71434_R || this.field_71433_S == null) continue;
            this.func_71377_b(this.field_71433_S);
            return;
        }
        Object object2 = this.field_71437_Z.func_147137_ag().func_151270_a();
        \u2603 = NetworkManager.func_150722_a((SocketAddress)object2);
        ((NetworkManager)((Object)\u2603)).func_150719_a(new NetHandlerLoginClient((NetworkManager)((Object)\u2603), this, null, iTextComponent -> {}));
        ((NetworkManager)((Object)\u2603)).func_179290_a(new CPacketHandshake(object2.toString(), 0, EnumConnectionState.LOGIN));
        ((NetworkManager)((Object)\u2603)).func_179290_a(new CPacketLoginStart(this.func_110432_I().func_148256_e()));
        this.field_71453_ak = \u2603;
    }

    public void func_71403_a(@Nullable WorldClient worldClient) {
        GuiScreenWorking guiScreenWorking = new GuiScreenWorking();
        if (worldClient != null) {
            guiScreenWorking.func_200210_a(new TextComponentTranslation("connect.joining", new Object[0]));
        }
        this.func_205055_a(worldClient, guiScreenWorking);
    }

    public void func_205055_a(@Nullable WorldClient worldClient, GuiScreen guiScreen2) {
        GuiScreen guiScreen2;
        NetHandlerPlayClient netHandlerPlayClient;
        if (worldClient == null) {
            netHandlerPlayClient = this.func_147114_u();
            if (netHandlerPlayClient != null) {
                this.field_152351_aB.clear();
                netHandlerPlayClient.func_147296_c();
            }
            this.field_71437_Z = null;
            this.field_71460_t.func_190564_k();
            this.field_71442_b = null;
            NarratorChatListener.field_193643_a.func_193642_b();
        }
        this.field_147126_aw.func_209200_a();
        this.field_147127_av.func_147690_c();
        this.field_175622_Z = null;
        this.field_71453_ak = null;
        this.func_147108_a(guiScreen2);
        this.func_195542_b(false);
        if (worldClient == null && this.field_71441_e != null) {
            this.field_195554_ax.func_195749_c();
            this.field_71456_v.func_181029_i();
            this.func_71351_a(null);
            this.field_71455_al = false;
        }
        this.field_71441_e = worldClient;
        if (this.field_71438_f != null) {
            this.field_71438_f.func_72732_a(worldClient);
        }
        if (this.field_71452_i != null) {
            this.field_71452_i.func_78870_a(worldClient);
        }
        TileEntityRendererDispatcher.field_147556_a.func_147543_a(worldClient);
        if (worldClient != null) {
            if (!this.field_71455_al) {
                netHandlerPlayClient = new YggdrasilAuthenticationService(this.field_110453_aa, UUID.randomUUID().toString());
                MinecraftSessionService \u26032 = netHandlerPlayClient.createMinecraftSessionService();
                GameProfileRepository \u26033 = netHandlerPlayClient.createProfileRepository();
                PlayerProfileCache \u26034 = new PlayerProfileCache(\u26033, new File(this.field_71412_D, MinecraftServer.field_152367_a.getName()));
                TileEntitySkull.func_184293_a(\u26034);
                TileEntitySkull.func_184294_a(\u26032);
                PlayerProfileCache.func_187320_a(false);
            }
            if (this.field_71439_g == null) {
                this.field_71439_g = this.field_71442_b.func_199681_a(worldClient, new StatisticsManager(), new RecipeBookClient(worldClient.func_199532_z()));
                this.field_71442_b.func_78745_b(this.field_71439_g);
                if (this.field_71437_Z != null) {
                    this.field_71437_Z.func_211527_b(this.field_71439_g.func_110124_au());
                }
            }
            this.field_71439_g.func_70065_x();
            worldClient.func_72838_d(this.field_71439_g);
            this.field_71439_g.field_71158_b = new MovementInputFromOptions(this.field_71474_y);
            this.field_71442_b.func_78748_a(this.field_71439_g);
            this.field_175622_Z = this.field_71439_g;
        } else {
            this.field_71439_g = null;
        }
        System.gc();
    }

    public void func_212315_a(DimensionType dimensionType) {
        this.field_71441_e.func_72974_f();
        this.field_71441_e.func_73022_a();
        int n = 0;
        String \u26032 = null;
        if (this.field_71439_g != null) {
            n = this.field_71439_g.func_145782_y();
            this.field_71441_e.func_72900_e(this.field_71439_g);
            \u26032 = this.field_71439_g.func_142021_k();
        }
        this.field_175622_Z = null;
        EntityPlayerSP \u26033 = this.field_71439_g;
        this.field_71439_g = this.field_71442_b.func_199681_a(this.field_71441_e, this.field_71439_g == null ? new StatisticsManager() : this.field_71439_g.func_146107_m(), this.field_71439_g == null ? new RecipeBookClient(new RecipeManager()) : this.field_71439_g.func_199507_B());
        this.field_71439_g.func_184212_Q().func_187218_a(\u26033.func_184212_Q().func_187231_c());
        this.field_71439_g.field_71093_bK = dimensionType;
        this.field_175622_Z = this.field_71439_g;
        this.field_71439_g.func_70065_x();
        this.field_71439_g.func_175158_f(\u26032);
        this.field_71441_e.func_72838_d(this.field_71439_g);
        this.field_71442_b.func_78745_b(this.field_71439_g);
        this.field_71439_g.field_71158_b = new MovementInputFromOptions(this.field_71474_y);
        this.field_71439_g.func_145769_d(n);
        this.field_71442_b.func_78748_a(this.field_71439_g);
        this.field_71439_g.func_175150_k(\u26033.func_175140_cp());
        if (this.field_71462_r instanceof GuiGameOver) {
            this.func_147108_a(null);
        }
    }

    public final boolean func_71355_q() {
        return this.field_71459_aj;
    }

    @Nullable
    public NetHandlerPlayClient func_147114_u() {
        return this.field_71439_g == null ? null : this.field_71439_g.field_71174_a;
    }

    public static boolean func_71382_s() {
        return field_71432_P == null || !Minecraft.field_71432_P.field_71474_y.field_74319_N;
    }

    public static boolean func_71375_t() {
        return field_71432_P != null && Minecraft.field_71432_P.field_71474_y.field_74347_j;
    }

    public static boolean func_71379_u() {
        return field_71432_P != null && Minecraft.field_71432_P.field_71474_y.field_74348_k != 0;
    }

    private void func_147112_ai() {
        ItemStack \u26034;
        if (this.field_71476_x == null || this.field_71476_x.field_72313_a == RayTraceResult.Type.MISS) {
            return;
        }
        boolean bl = this.field_71439_g.field_71075_bZ.field_75098_d;
        TileEntity \u26032 = null;
        if (this.field_71476_x.field_72313_a == RayTraceResult.Type.BLOCK) {
            Object object = this.field_71476_x.func_178782_a();
            \u2603 = this.field_71441_e.func_180495_p((BlockPos)object);
            Block \u26033 = \u2603.func_177230_c();
            if (\u2603.func_196958_f()) {
                return;
            }
            \u26034 = \u26033.func_185473_a(this.field_71441_e, (BlockPos)object, (IBlockState)\u2603);
            if (\u26034.func_190926_b()) {
                return;
            }
            if (bl && GuiScreen.func_146271_m() && \u26033.func_149716_u()) {
                \u26032 = this.field_71441_e.func_175625_s((BlockPos)object);
            }
        } else if (this.field_71476_x.field_72313_a == RayTraceResult.Type.ENTITY && this.field_71476_x.field_72308_g != null && bl) {
            if (this.field_71476_x.field_72308_g instanceof EntityPainting) {
                \u26034 = new ItemStack(Items.field_151159_an);
            } else if (this.field_71476_x.field_72308_g instanceof EntityLeashKnot) {
                \u26034 = new ItemStack(Items.field_151058_ca);
            } else if (this.field_71476_x.field_72308_g instanceof EntityItemFrame) {
                object = (EntityItemFrame)this.field_71476_x.field_72308_g;
                \u2603 = ((EntityItemFrame)object).func_82335_i();
                \u26034 = ((ItemStack)\u2603).func_190926_b() ? new ItemStack(Items.field_151160_bD) : ((ItemStack)\u2603).func_77946_l();
            } else if (this.field_71476_x.field_72308_g instanceof EntityMinecart) {
                object = (EntityMinecart)this.field_71476_x.field_72308_g;
                switch (((EntityMinecart)object).func_184264_v()) {
                    case FURNACE: {
                        \u2603 = Items.field_151109_aJ;
                        break;
                    }
                    case CHEST: {
                        \u2603 = Items.field_151108_aI;
                        break;
                    }
                    case TNT: {
                        \u2603 = Items.field_151142_bV;
                        break;
                    }
                    case HOPPER: {
                        \u2603 = Items.field_151140_bW;
                        break;
                    }
                    case COMMAND_BLOCK: {
                        \u2603 = Items.field_151095_cc;
                        break;
                    }
                    default: {
                        \u2603 = Items.field_151143_au;
                    }
                }
                \u26034 = new ItemStack((IItemProvider)\u2603);
            } else if (this.field_71476_x.field_72308_g instanceof EntityBoat) {
                \u26034 = new ItemStack(((EntityBoat)this.field_71476_x.field_72308_g).func_184455_j());
            } else if (this.field_71476_x.field_72308_g instanceof EntityArmorStand) {
                \u26034 = new ItemStack(Items.field_179565_cj);
            } else if (this.field_71476_x.field_72308_g instanceof EntityEnderCrystal) {
                \u26034 = new ItemStack(Items.field_185158_cP);
            } else {
                object = ItemSpawnEgg.func_200889_b(this.field_71476_x.field_72308_g.func_200600_R());
                if (object == null) {
                    return;
                }
                \u26034 = new ItemStack((IItemProvider)object);
            }
        } else {
            return;
        }
        if (\u26034.func_190926_b()) {
            object = "";
            if (this.field_71476_x.field_72313_a == RayTraceResult.Type.BLOCK) {
                object = IRegistry.field_212618_g.func_177774_c(this.field_71441_e.func_180495_p(this.field_71476_x.func_178782_a()).func_177230_c()).toString();
            } else if (this.field_71476_x.field_72313_a == RayTraceResult.Type.ENTITY) {
                object = IRegistry.field_212629_r.func_177774_c(this.field_71476_x.field_72308_g.func_200600_R()).toString();
            }
            field_147123_G.warn("Picking on: [{}] {} gave null item", (Object)this.field_71476_x.field_72313_a, object);
            return;
        }
        object = this.field_71439_g.field_71071_by;
        if (\u26032 != null) {
            this.func_184119_a(\u26034, \u26032);
        }
        int n = ((InventoryPlayer)object).func_184429_b(\u26034);
        if (bl) {
            ((InventoryPlayer)object).func_184434_a(\u26034);
            this.field_71442_b.func_78761_a(this.field_71439_g.func_184586_b(EnumHand.MAIN_HAND), 36 + ((InventoryPlayer)object).field_70461_c);
        } else if (n != -1) {
            if (InventoryPlayer.func_184435_e(n)) {
                ((InventoryPlayer)object).field_70461_c = n;
            } else {
                this.field_71442_b.func_187100_a(n);
            }
        }
    }

    private ItemStack func_184119_a(ItemStack itemStack, TileEntity tileEntity) {
        NBTTagCompound nBTTagCompound = tileEntity.func_189515_b(new NBTTagCompound());
        if (itemStack.func_77973_b() instanceof ItemSkull && nBTTagCompound.func_74764_b("Owner")) {
            \u2603 = nBTTagCompound.func_74775_l("Owner");
            itemStack.func_196082_o().func_74782_a("SkullOwner", \u2603);
            return itemStack;
        }
        itemStack.func_77983_a("BlockEntityTag", nBTTagCompound);
        \u2603 = new NBTTagCompound();
        NBTTagList \u26032 = new NBTTagList();
        \u26032.add(new NBTTagString("(+NBT)"));
        \u2603.func_74782_a("Lore", \u26032);
        itemStack.func_77983_a("display", \u2603);
        return itemStack;
    }

    public CrashReport func_71396_d(CrashReport crashReport) {
        CrashReportCategory crashReportCategory = crashReport.func_85056_g();
        crashReportCategory.func_189529_a("Launched Version", () -> this.field_110447_Z);
        crashReportCategory.func_189529_a("LWJGL", Version::getVersion);
        crashReportCategory.func_189529_a("OpenGL", () -> {
            if (GLFW.glfwGetCurrentContext() == 0L) {
                return "NO CONTEXT";
            }
            return GlStateManager.func_187416_u(7937) + " GL version " + GlStateManager.func_187416_u(7938) + ", " + GlStateManager.func_187416_u(7936);
        });
        crashReportCategory.func_189529_a("GL Caps", OpenGlHelper::func_153172_c);
        crashReportCategory.func_189529_a("Using VBOs", () -> this.field_71474_y.field_178881_t ? "Yes" : "No");
        crashReportCategory.func_189529_a("Is Modded", () -> {
            String string = ClientBrandRetriever.getClientModName();
            if (!"vanilla".equals(string)) {
                return "Definitely; Client brand changed to '" + string + "'";
            }
            if (Minecraft.class.getSigners() == null) {
                return "Very likely; Jar signature invalidated";
            }
            return "Probably not. Jar signature remains and client brand is untouched.";
        });
        crashReportCategory.func_71507_a("Type", "Client (map_client.txt)");
        crashReportCategory.func_189529_a("Resource Packs", () -> {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : this.field_71474_y.field_151453_l) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(string);
                if (!this.field_71474_y.field_183018_l.contains(string)) continue;
                stringBuilder.append(" (incompatible)");
            }
            return stringBuilder.toString();
        });
        crashReportCategory.func_189529_a("Current Language", () -> this.field_135017_as.func_135041_c().toString());
        crashReportCategory.func_189529_a("Profiler Position", () -> this.field_71424_I.func_199094_a() ? this.field_71424_I.func_76322_c() : "N/A (disabled)");
        crashReportCategory.func_189529_a("CPU", OpenGlHelper::func_183029_j);
        if (this.field_71441_e != null) {
            this.field_71441_e.func_72914_a(crashReport);
        }
        return crashReport;
    }

    public static Minecraft func_71410_x() {
        return field_71432_P;
    }

    public ListenableFuture<Object> func_175603_A() {
        return this.func_152344_a(this::func_110436_a);
    }

    @Override
    public void func_70000_a(Snooper snooper2) {
        Snooper snooper2;
        snooper2.func_152768_a("fps", field_71470_ab);
        snooper2.func_152768_a("vsync_enabled", this.field_71474_y.field_74352_v);
        long l = GLFW.glfwGetWindowMonitor((long)this.field_195558_d.func_198092_i());
        if (l == 0L) {
            l = GLFW.glfwGetPrimaryMonitor();
        }
        snooper2.func_152768_a("display_frequency", GLFW.glfwGetVideoMode((long)l).refreshRate());
        snooper2.func_152768_a("display_type", this.field_195558_d.func_198113_j() ? "fullscreen" : "windowed");
        snooper2.func_152768_a("run_time", (Util.func_211177_b() - snooper2.func_130105_g()) / 60L * 1000L);
        snooper2.func_152768_a("current_action", this.func_181538_aA());
        snooper2.func_152768_a("language", this.field_71474_y.field_74363_ab == null ? "en_us" : this.field_71474_y.field_74363_ab);
        String \u26032 = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? "little" : "big";
        snooper2.func_152768_a("endianness", \u26032);
        snooper2.func_152768_a("subtitles", this.field_71474_y.field_186717_N);
        snooper2.func_152768_a("touch", this.field_71474_y.field_85185_A ? "touch" : "mouse");
        int \u26033 = 0;
        for (ResourcePackInfoClient resourcePackInfoClient : this.field_110448_aq.func_198980_d()) {
            if (resourcePackInfoClient.func_195797_g() || resourcePackInfoClient.func_195798_h()) continue;
            snooper2.func_152768_a("resource_pack[" + \u26033++ + "]", resourcePackInfoClient.func_195790_f());
        }
        snooper2.func_152768_a("resource_packs", \u26033);
        if (this.field_71437_Z != null && this.field_71437_Z.func_80003_ah() != null) {
            snooper2.func_152768_a("snooper_partner", this.field_71437_Z.func_80003_ah().func_80006_f());
        }
    }

    private String func_181538_aA() {
        if (this.field_71437_Z != null) {
            if (this.field_71437_Z.func_71344_c()) {
                return "hosting_lan";
            }
            return "singleplayer";
        }
        if (this.field_71422_O != null) {
            if (this.field_71422_O.func_181041_d()) {
                return "playing_lan";
            }
            return "multiplayer";
        }
        return "out_of_game";
    }

    public static int func_71369_N() {
        if (field_211120_F == -1) {
            for (int i = 16384; i > 0; i >>= 1) {
                GlStateManager.func_187419_a(32868, 0, 6408, i, i, 0, 6408, 5121, null);
                \u2603 = GlStateManager.func_187411_c(32868, 0, 4096);
                if (\u2603 == 0) continue;
                field_211120_F = i;
                return i;
            }
        }
        return field_211120_F;
    }

    public boolean func_70002_Q() {
        return this.field_71474_y.field_74355_t;
    }

    public void func_71351_a(ServerData serverData) {
        this.field_71422_O = serverData;
    }

    @Nullable
    public ServerData func_147104_D() {
        return this.field_71422_O;
    }

    public boolean func_71387_A() {
        return this.field_71455_al;
    }

    public boolean func_71356_B() {
        return this.field_71455_al && this.field_71437_Z != null;
    }

    @Nullable
    public IntegratedServer func_71401_C() {
        return this.field_71437_Z;
    }

    public static void func_71363_D() {
        if (field_71432_P == null) {
            return;
        }
        IntegratedServer integratedServer = field_71432_P.func_71401_C();
        if (integratedServer != null) {
            integratedServer.func_71260_j();
        }
    }

    public Snooper func_71378_E() {
        return this.field_71427_U;
    }

    public Session func_110432_I() {
        return this.field_71449_j;
    }

    public PropertyMap func_181037_M() {
        if (this.field_181038_N.isEmpty()) {
            GameProfile gameProfile = this.func_152347_ac().fillProfileProperties(this.field_71449_j.func_148256_e(), false);
            this.field_181038_N.putAll((Multimap)gameProfile.getProperties());
        }
        return this.field_181038_N;
    }

    public Proxy func_110437_J() {
        return this.field_110453_aa;
    }

    public TextureManager func_110434_K() {
        return this.field_71446_o;
    }

    public IResourceManager func_195551_G() {
        return this.field_110451_am;
    }

    public ResourcePackList<ResourcePackInfoClient> func_195548_H() {
        return this.field_110448_aq;
    }

    public DownloadingPackFinder func_195541_I() {
        return this.field_195554_ax;
    }

    public File func_195549_J() {
        return this.field_130070_K;
    }

    public LanguageManager func_135016_M() {
        return this.field_135017_as;
    }

    public TextureMap func_147117_R() {
        return this.field_147128_au;
    }

    public boolean func_147111_S() {
        return this.field_147129_ai;
    }

    public boolean func_147113_T() {
        return this.field_71445_n;
    }

    public SoundHandler func_147118_V() {
        return this.field_147127_av;
    }

    public MusicTicker.MusicType func_147109_W() {
        if (this.field_71462_r instanceof GuiWinGame) {
            return MusicTicker.MusicType.CREDITS;
        }
        if (this.field_71439_g != null) {
            if (this.field_71439_g.field_70170_p.field_73011_w instanceof NetherDimension) {
                return MusicTicker.MusicType.NETHER;
            }
            if (this.field_71439_g.field_70170_p.field_73011_w instanceof EndDimension) {
                if (this.field_71456_v.func_184046_j().func_184054_d()) {
                    return MusicTicker.MusicType.END_BOSS;
                }
                return MusicTicker.MusicType.END;
            }
            Biome.Category category = this.field_71439_g.field_70170_p.func_180494_b(new BlockPos(this.field_71439_g.field_70165_t, this.field_71439_g.field_70163_u, this.field_71439_g.field_70161_v)).func_201856_r();
            if (this.field_147126_aw.func_209100_b(MusicTicker.MusicType.UNDER_WATER) || this.field_71439_g.func_204231_K() && !this.field_147126_aw.func_209100_b(MusicTicker.MusicType.GAME) && (category == Biome.Category.OCEAN || category == Biome.Category.RIVER)) {
                return MusicTicker.MusicType.UNDER_WATER;
            }
            if (this.field_71439_g.field_71075_bZ.field_75098_d && this.field_71439_g.field_71075_bZ.field_75101_c) {
                return MusicTicker.MusicType.CREATIVE;
            }
            return MusicTicker.MusicType.GAME;
        }
        return MusicTicker.MusicType.MENU;
    }

    public MinecraftSessionService func_152347_ac() {
        return this.field_152355_az;
    }

    public SkinManager func_152342_ad() {
        return this.field_152350_aA;
    }

    @Nullable
    public Entity func_175606_aa() {
        return this.field_175622_Z;
    }

    public void func_175607_a(Entity entity) {
        this.field_175622_Z = entity;
        this.field_71460_t.func_175066_a(entity);
    }

    public <V> ListenableFuture<V> func_152343_a(Callable<V> callable2) {
        Callable<V> callable2;
        Validate.notNull(callable2);
        if (this.func_152345_ab()) {
            try {
                return Futures.immediateFuture(callable2.call());
            }
            catch (Exception exception) {
                return Futures.immediateFailedCheckedFuture((Exception)exception);
            }
        }
        ListenableFutureTask \u26032 = ListenableFutureTask.create(callable2);
        this.field_152351_aB.add((FutureTask<?>)\u26032);
        return \u26032;
    }

    @Override
    public ListenableFuture<Object> func_152344_a(Runnable runnable) {
        Validate.notNull((Object)runnable);
        return this.func_152343_a(Executors.callable(runnable));
    }

    @Override
    public boolean func_152345_ab() {
        return Thread.currentThread() == this.field_152352_aC;
    }

    public BlockRendererDispatcher func_175602_ab() {
        return this.field_175618_aM;
    }

    public RenderManager func_175598_ae() {
        return this.field_175616_W;
    }

    public ItemRenderer func_175599_af() {
        return this.field_175621_X;
    }

    public FirstPersonRenderer func_175597_ag() {
        return this.field_175620_Y;
    }

    public <T> ISearchTree<T> func_193987_a(SearchTreeManager.Key<T> key) {
        return this.field_193995_ae.func_194010_a(key);
    }

    public static int func_175610_ah() {
        return field_71470_ab;
    }

    public FrameTimer func_181539_aj() {
        return this.field_181542_y;
    }

    public boolean func_181540_al() {
        return this.field_181541_X;
    }

    public void func_181537_a(boolean bl) {
        this.field_181541_X = bl;
    }

    public DataFixer func_184126_aj() {
        return this.field_184131_U;
    }

    public float func_184121_ak() {
        return this.field_71428_T.field_194147_b;
    }

    public float func_193989_ak() {
        return this.field_71428_T.field_194148_c;
    }

    public BlockColors func_184125_al() {
        return this.field_184127_aH;
    }

    public boolean func_189648_am() {
        return this.field_71439_g != null && this.field_71439_g.func_175140_cp() || this.field_71474_y.field_178879_v;
    }

    public GuiToast func_193033_an() {
        return this.field_193034_aS;
    }

    public Tutorial func_193032_ao() {
        return this.field_193035_aW;
    }

    public boolean func_195544_aj() {
        return this.field_195555_I;
    }

    public CreativeSettings func_199403_al() {
        return this.field_191950_u;
    }

    public ModelManager func_209506_al() {
        return this.field_175617_aL;
    }

    public FontResourceManager func_211500_ak() {
        return this.field_211501_aD;
    }

    private static /* synthetic */ IResourcePack func_211809_a(Supplier supplier) {
        return new LegacyResourcePackWrapper((IResourcePack)supplier.get(), LegacyResourcePackWrapper.field_211853_a);
    }
}

