/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.audio;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.GameSettings;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ISoundEventAccessor;
import net.minecraft.client.audio.ISoundEventListener;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundList;
import net.minecraft.client.audio.SoundListSerializer;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.ITickable;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SoundHandler
implements ITickable,
IResourceManagerReloadListener {
    public static final Sound field_147700_a = new Sound("meta:missing_sound", 1.0f, 1.0f, 1, Sound.Type.FILE, false, false, 16);
    private static final Logger field_147698_b = LogManager.getLogger();
    private static final Gson field_147699_c = new GsonBuilder().registerTypeHierarchyAdapter(ITextComponent.class, (Object)new ITextComponent.Serializer()).registerTypeAdapter(SoundList.class, (Object)new SoundListSerializer()).create();
    private static final ParameterizedType field_147696_d = new ParameterizedType(){

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{String.class, SoundList.class};
        }

        @Override
        public Type getRawType() {
            return Map.class;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }
    };
    private final Map<ResourceLocation, SoundEventAccessor> field_147697_e = Maps.newHashMap();
    private final SoundManager field_147694_f;
    private final IResourceManager field_147695_g;

    public SoundHandler(IResourceManager iResourceManager, GameSettings gameSettings) {
        this.field_147695_g = iResourceManager;
        this.field_147694_f = new SoundManager(this, gameSettings);
    }

    @Override
    public void func_195410_a(IResourceManager iResourceManager) {
        this.field_147697_e.clear();
        for (String string : iResourceManager.func_199001_a()) {
            try {
                List<IResource> iOException = iResourceManager.func_199004_b(new ResourceLocation(string, "sounds.json"));
                for (IResource iResource : iOException) {
                    try {
                        Map<String, SoundList> map = this.func_175085_a(iResource.func_199027_b());
                        for (Map.Entry<String, SoundList> entry : map.entrySet()) {
                            this.func_147693_a(new ResourceLocation(string, entry.getKey()), entry.getValue());
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        field_147698_b.warn("Invalid sounds.json in resourcepack: '{}'", (Object)iResource.func_199026_d(), (Object)runtimeException);
                    }
                }
            }
            catch (IOException iOException) {
            }
        }
        for (ResourceLocation resourceLocation : this.field_147697_e.keySet()) {
            SoundEventAccessor soundEventAccessor = this.field_147697_e.get(resourceLocation);
            if (!(soundEventAccessor.func_188712_c() instanceof TextComponentTranslation) || I18n.func_188566_a(\u2603 = ((TextComponentTranslation)soundEventAccessor.func_188712_c()).func_150268_i())) continue;
            field_147698_b.debug("Missing subtitle {} for event: {}", (Object)\u2603, (Object)resourceLocation);
        }
        for (ResourceLocation resourceLocation : this.field_147697_e.keySet()) {
            if (IRegistry.field_212633_v.func_212608_b(resourceLocation) != null) continue;
            field_147698_b.debug("Not having sound event for: {}", (Object)resourceLocation);
        }
        this.field_147694_f.func_148596_a();
    }

    @Nullable
    protected Map<String, SoundList> func_175085_a(InputStream inputStream) {
        try {
            Map map = (Map)JsonUtils.func_193841_a(field_147699_c, new InputStreamReader(inputStream, StandardCharsets.UTF_8), field_147696_d);
            return map;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    private void func_147693_a(ResourceLocation resourceLocation, SoundList soundList) {
        SoundEventAccessor soundEventAccessor = this.field_147697_e.get(resourceLocation);
        boolean bl = \u2603 = soundEventAccessor == null;
        if (\u2603 || soundList.func_148574_b()) {
            if (!\u2603) {
                field_147698_b.debug("Replaced sound event location {}", (Object)resourceLocation);
            }
            soundEventAccessor = new SoundEventAccessor(resourceLocation, soundList.func_188701_c());
            this.field_147697_e.put(resourceLocation, soundEventAccessor);
        }
        block4: for (final Sound sound : soundList.func_188700_a()) {
            ISoundEventAccessor<Sound> \u26032;
            final ResourceLocation resourceLocation2 = sound.func_188719_a();
            switch (sound.func_188722_g()) {
                case FILE: {
                    if (!this.func_184401_a(sound, resourceLocation)) continue block4;
                    \u26032 = sound;
                    break;
                }
                case SOUND_EVENT: {
                    \u26032 = new ISoundEventAccessor<Sound>(){

                        @Override
                        public int func_148721_a() {
                            SoundEventAccessor soundEventAccessor = (SoundEventAccessor)SoundHandler.this.field_147697_e.get(resourceLocation2);
                            return soundEventAccessor == null ? 0 : soundEventAccessor.func_148721_a();
                        }

                        @Override
                        public Sound func_148720_g() {
                            SoundEventAccessor soundEventAccessor = (SoundEventAccessor)SoundHandler.this.field_147697_e.get(resourceLocation2);
                            if (soundEventAccessor == null) {
                                return field_147700_a;
                            }
                            Sound \u26032 = soundEventAccessor.func_148720_g();
                            return new Sound(\u26032.func_188719_a().toString(), \u26032.func_188724_c() * sound.func_188724_c(), \u26032.func_188725_d() * sound.func_188725_d(), sound.func_148721_a(), Sound.Type.FILE, \u26032.func_188723_h() || sound.func_188723_h(), \u26032.func_204257_i(), \u26032.func_206255_j());
                        }

                        @Override
                        public /* synthetic */ Object func_148720_g() {
                            return this.func_148720_g();
                        }
                    };
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown SoundEventRegistration type: " + (Object)((Object)sound.func_188722_g()));
                }
            }
            if (\u26032.func_148720_g().func_204257_i()) {
                this.field_147694_f.func_204259_a(\u26032.func_148720_g());
            }
            soundEventAccessor.func_188715_a(\u26032);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean func_184401_a(Sound sound, ResourceLocation resourceLocation) {
        resourceLocation2 = sound.func_188721_b();
        IResource iResource = null;
        try {
            iResource = this.field_147695_g.func_199002_a(resourceLocation2);
            iResource.func_199027_b();
        }
        catch (FileNotFoundException \u26032) {
            field_147698_b.warn("File {} does not exist, cannot add it to event {}", (Object)resourceLocation2, (Object)resourceLocation);
            boolean bl = false;
            IOUtils.closeQuietly((Closeable)iResource);
            return bl;
        }
        catch (IOException \u26033) {
            field_147698_b.warn("Could not load sound file {}, cannot add it to event {}", (Object)resourceLocation2, (Object)resourceLocation, (Object)\u26033);
            boolean bl = false;
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(iResource);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Closeable)iResource);
            return bl;
        }
        IOUtils.closeQuietly((Closeable)iResource);
        return true;
    }

    @Nullable
    public SoundEventAccessor func_184398_a(ResourceLocation resourceLocation) {
        return this.field_147697_e.get(resourceLocation);
    }

    public Collection<ResourceLocation> func_195477_a() {
        return this.field_147697_e.keySet();
    }

    public void func_147682_a(ISound iSound) {
        this.field_147694_f.func_148611_c(iSound);
    }

    public void func_147681_a(ISound iSound, int n) {
        this.field_147694_f.func_148599_a(iSound, n);
    }

    public void func_147691_a(EntityPlayer entityPlayer, float f) {
        this.field_147694_f.func_148615_a(entityPlayer, f);
    }

    public void func_147689_b() {
        this.field_147694_f.func_148610_e();
    }

    public void func_147690_c() {
        this.field_147694_f.func_148614_c();
    }

    public void func_147685_d() {
        this.field_147694_f.func_148613_b();
    }

    @Override
    public void func_73660_a() {
        this.field_147694_f.func_148605_d();
    }

    public void func_147687_e() {
        this.field_147694_f.func_148604_f();
    }

    public void func_184399_a(SoundCategory soundCategory, float f) {
        if (soundCategory == SoundCategory.MASTER && f <= 0.0f) {
            this.func_147690_c();
        }
        this.field_147694_f.func_188771_a(soundCategory, f);
    }

    public void func_147683_b(ISound iSound) {
        this.field_147694_f.func_148602_b(iSound);
    }

    public boolean func_147692_c(ISound iSound) {
        return this.field_147694_f.func_148597_a(iSound);
    }

    public void func_184402_a(ISoundEventListener iSoundEventListener) {
        this.field_147694_f.func_188774_a(iSoundEventListener);
    }

    public void func_184400_b(ISoundEventListener iSoundEventListener) {
        this.field_147694_f.func_188773_b(iSoundEventListener);
    }

    public void func_195478_a(@Nullable ResourceLocation resourceLocation, @Nullable SoundCategory soundCategory) {
        this.field_147694_f.func_195855_a(resourceLocation, soundCategory);
    }
}

