/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ElytraSound;
import net.minecraft.client.audio.IAmbientSoundHandler;
import net.minecraft.client.audio.MovingSoundMinecartRiding;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.audio.UnderwaterAmbientSoundHandler;
import net.minecraft.client.audio.UnderwaterAmbientSounds;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.GuiCommandBlock;
import net.minecraft.client.gui.GuiEditCommandBlockMinecart;
import net.minecraft.client.gui.GuiEnchantment;
import net.minecraft.client.gui.GuiHopper;
import net.minecraft.client.gui.GuiMerchant;
import net.minecraft.client.gui.GuiRepair;
import net.minecraft.client.gui.GuiScreenBook;
import net.minecraft.client.gui.inventory.GuiBeacon;
import net.minecraft.client.gui.inventory.GuiBrewingStand;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiCrafting;
import net.minecraft.client.gui.inventory.GuiDispenser;
import net.minecraft.client.gui.inventory.GuiEditSign;
import net.minecraft.client.gui.inventory.GuiEditStructure;
import net.minecraft.client.gui.inventory.GuiFurnace;
import net.minecraft.client.gui.inventory.GuiScreenHorseInventory;
import net.minecraft.client.gui.inventory.GuiShulkerBox;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.util.RecipeBookClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemElytra;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.play.client.CPacketAnimation;
import net.minecraft.network.play.client.CPacketChatMessage;
import net.minecraft.network.play.client.CPacketClientStatus;
import net.minecraft.network.play.client.CPacketCloseWindow;
import net.minecraft.network.play.client.CPacketEntityAction;
import net.minecraft.network.play.client.CPacketInput;
import net.minecraft.network.play.client.CPacketPlayer;
import net.minecraft.network.play.client.CPacketPlayerAbilities;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.network.play.client.CPacketRecipeInfo;
import net.minecraft.network.play.client.CPacketVehicleMove;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatisticsManager;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.CommandBlockBaseLogic;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.tileentity.TileEntityStructure;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.MovementInput;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;

public class EntityPlayerSP
extends AbstractClientPlayer {
    public final NetHandlerPlayClient field_71174_a;
    private final StatisticsManager field_146108_bO;
    private final RecipeBookClient field_192036_cb;
    private final List<IAmbientSoundHandler> field_204232_cf = Lists.newArrayList();
    private int field_184845_bX = 0;
    private double field_175172_bI;
    private double field_175166_bJ;
    private double field_175167_bK;
    private float field_175164_bL;
    private float field_175165_bM;
    private boolean field_184841_cd;
    private boolean field_175170_bN;
    private boolean field_175171_bO;
    private int field_175168_bP;
    private boolean field_175169_bQ;
    private String field_142022_ce;
    public MovementInput field_71158_b;
    protected Minecraft field_71159_c;
    protected int field_71156_d;
    public int field_71157_e;
    public float field_71154_f;
    public float field_71155_g;
    public float field_71163_h;
    public float field_71164_i;
    private int field_110320_a;
    private float field_110321_bQ;
    public float field_71086_bY;
    public float field_71080_cy;
    private boolean field_184842_cm;
    private EnumHand field_184843_cn;
    private boolean field_184844_co;
    private boolean field_189811_cr = true;
    private int field_189812_cs;
    private boolean field_189813_ct;
    private int field_203720_cz;

    public EntityPlayerSP(Minecraft minecraft, World world, NetHandlerPlayClient netHandlerPlayClient, StatisticsManager statisticsManager, RecipeBookClient recipeBookClient) {
        super(world, netHandlerPlayClient.func_175105_e());
        this.field_71174_a = netHandlerPlayClient;
        this.field_146108_bO = statisticsManager;
        this.field_192036_cb = recipeBookClient;
        this.field_71159_c = minecraft;
        this.field_71093_bK = DimensionType.OVERWORLD;
        this.field_204232_cf.add(new UnderwaterAmbientSoundHandler(this, minecraft.func_147118_V()));
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float f) {
        return false;
    }

    @Override
    public void func_70691_i(float f) {
    }

    @Override
    public boolean func_184205_a(Entity entity, boolean bl) {
        if (!super.func_184205_a(entity, bl)) {
            return false;
        }
        if (entity instanceof EntityMinecart) {
            this.field_71159_c.func_147118_V().func_147682_a(new MovingSoundMinecartRiding(this, (EntityMinecart)entity));
        }
        if (entity instanceof EntityBoat) {
            this.field_70126_B = entity.field_70177_z;
            this.field_70177_z = entity.field_70177_z;
            this.func_70034_d(entity.field_70177_z);
        }
        return true;
    }

    @Override
    public void func_184210_p() {
        super.func_184210_p();
        this.field_184844_co = false;
    }

    @Override
    public float func_195050_f(float f) {
        return this.field_70125_A;
    }

    @Override
    public float func_195046_g(float f) {
        if (this.func_184218_aH()) {
            return super.func_195046_g(f);
        }
        return this.field_70177_z;
    }

    @Override
    public void func_70071_h_() {
        if (!this.field_70170_p.func_175667_e(new BlockPos(this.field_70165_t, 0.0, this.field_70161_v))) {
            return;
        }
        super.func_70071_h_();
        if (this.func_184218_aH()) {
            this.field_71174_a.func_147297_a(new CPacketPlayer.Rotation(this.field_70177_z, this.field_70125_A, this.field_70122_E));
            this.field_71174_a.func_147297_a(new CPacketInput(this.field_70702_br, this.field_191988_bg, this.field_71158_b.field_78901_c, this.field_71158_b.field_78899_d));
            Entity entity = this.func_184208_bv();
            if (entity != this && entity.func_184186_bw()) {
                this.field_71174_a.func_147297_a(new CPacketVehicleMove(entity));
            }
        } else {
            this.func_175161_p();
        }
        for (IAmbientSoundHandler iAmbientSoundHandler : this.field_204232_cf) {
            iAmbientSoundHandler.func_204253_a();
        }
    }

    private void func_175161_p() {
        boolean bl = this.func_70051_ag();
        if (bl != this.field_175171_bO) {
            if (bl) {
                this.field_71174_a.func_147297_a(new CPacketEntityAction(this, CPacketEntityAction.Action.START_SPRINTING));
            } else {
                this.field_71174_a.func_147297_a(new CPacketEntityAction(this, CPacketEntityAction.Action.STOP_SPRINTING));
            }
            this.field_175171_bO = bl;
        }
        if ((\u2603 = this.func_70093_af()) != this.field_175170_bN) {
            if (\u2603) {
                this.field_71174_a.func_147297_a(new CPacketEntityAction(this, CPacketEntityAction.Action.START_SNEAKING));
            } else {
                this.field_71174_a.func_147297_a(new CPacketEntityAction(this, CPacketEntityAction.Action.STOP_SNEAKING));
            }
            this.field_175170_bN = \u2603;
        }
        if (this.func_175160_A()) {
            AxisAlignedBB axisAlignedBB = this.func_174813_aQ();
            double \u26032 = this.field_70165_t - this.field_175172_bI;
            double \u26033 = axisAlignedBB.field_72338_b - this.field_175166_bJ;
            double \u26034 = this.field_70161_v - this.field_175167_bK;
            double \u26035 = this.field_70177_z - this.field_175164_bL;
            double \u26036 = this.field_70125_A - this.field_175165_bM;
            ++this.field_175168_bP;
            boolean \u26037 = \u26032 * \u26032 + \u26033 * \u26033 + \u26034 * \u26034 > 9.0E-4 || this.field_175168_bP >= 20;
            boolean bl2 = \u2603 = \u26035 != 0.0 || \u26036 != 0.0;
            if (this.func_184218_aH()) {
                this.field_71174_a.func_147297_a(new CPacketPlayer.PositionRotation(this.field_70159_w, -999.0, this.field_70179_y, this.field_70177_z, this.field_70125_A, this.field_70122_E));
                \u26037 = false;
            } else if (\u26037 && \u2603) {
                this.field_71174_a.func_147297_a(new CPacketPlayer.PositionRotation(this.field_70165_t, axisAlignedBB.field_72338_b, this.field_70161_v, this.field_70177_z, this.field_70125_A, this.field_70122_E));
            } else if (\u26037) {
                this.field_71174_a.func_147297_a(new CPacketPlayer.Position(this.field_70165_t, axisAlignedBB.field_72338_b, this.field_70161_v, this.field_70122_E));
            } else if (\u2603) {
                this.field_71174_a.func_147297_a(new CPacketPlayer.Rotation(this.field_70177_z, this.field_70125_A, this.field_70122_E));
            } else if (this.field_184841_cd != this.field_70122_E) {
                this.field_71174_a.func_147297_a(new CPacketPlayer(this.field_70122_E));
            }
            if (\u26037) {
                this.field_175172_bI = this.field_70165_t;
                this.field_175166_bJ = axisAlignedBB.field_72338_b;
                this.field_175167_bK = this.field_70161_v;
                this.field_175168_bP = 0;
            }
            if (\u2603) {
                this.field_175164_bL = this.field_70177_z;
                this.field_175165_bM = this.field_70125_A;
            }
            this.field_184841_cd = this.field_70122_E;
            this.field_189811_cr = this.field_71159_c.field_71474_y.field_189989_R;
        }
    }

    @Override
    @Nullable
    public EntityItem func_71040_bB(boolean bl) {
        CPacketPlayerDigging.Action action = bl ? CPacketPlayerDigging.Action.DROP_ALL_ITEMS : CPacketPlayerDigging.Action.DROP_ITEM;
        this.field_71174_a.func_147297_a(new CPacketPlayerDigging(action, BlockPos.field_177992_a, EnumFacing.DOWN));
        this.field_71071_by.func_70298_a(this.field_71071_by.field_70461_c, bl && !this.field_71071_by.func_70448_g().func_190926_b() ? this.field_71071_by.func_70448_g().func_190916_E() : 1);
        return null;
    }

    @Override
    protected ItemStack func_184816_a(EntityItem entityItem) {
        return ItemStack.field_190927_a;
    }

    public void func_71165_d(String string) {
        this.field_71174_a.func_147297_a(new CPacketChatMessage(string));
    }

    @Override
    public void func_184609_a(EnumHand enumHand) {
        super.func_184609_a(enumHand);
        this.field_71174_a.func_147297_a(new CPacketAnimation(enumHand));
    }

    @Override
    public void func_71004_bE() {
        this.field_71174_a.func_147297_a(new CPacketClientStatus(CPacketClientStatus.State.PERFORM_RESPAWN));
    }

    @Override
    protected void func_70665_d(DamageSource damageSource, float f) {
        if (this.func_180431_b(damageSource)) {
            return;
        }
        this.func_70606_j(this.func_110143_aJ() - f);
    }

    @Override
    public void func_71053_j() {
        this.field_71174_a.func_147297_a(new CPacketCloseWindow(this.field_71070_bA.field_75152_c));
        this.func_175159_q();
    }

    public void func_175159_q() {
        this.field_71071_by.func_70437_b(ItemStack.field_190927_a);
        super.func_71053_j();
        this.field_71159_c.func_147108_a(null);
    }

    public void func_71150_b(float f) {
        if (this.field_175169_bQ) {
            \u2603 = this.func_110143_aJ() - f;
            if (\u2603 <= 0.0f) {
                this.func_70606_j(f);
                if (\u2603 < 0.0f) {
                    this.field_70172_ad = this.field_70771_an / 2;
                }
            } else {
                this.field_110153_bc = \u2603;
                this.func_70606_j(this.func_110143_aJ());
                this.field_70172_ad = this.field_70771_an;
                this.func_70665_d(DamageSource.field_76377_j, \u2603);
                this.field_70737_aN = this.field_70738_aO = 10;
            }
        } else {
            this.func_70606_j(f);
            this.field_175169_bQ = true;
        }
    }

    @Override
    public void func_71016_p() {
        this.field_71174_a.func_147297_a(new CPacketPlayerAbilities(this.field_71075_bZ));
    }

    @Override
    public boolean func_175144_cb() {
        return true;
    }

    protected void func_110318_g() {
        this.field_71174_a.func_147297_a(new CPacketEntityAction(this, CPacketEntityAction.Action.START_RIDING_JUMP, MathHelper.func_76141_d(this.func_110319_bJ() * 100.0f)));
    }

    public void func_175163_u() {
        this.field_71174_a.func_147297_a(new CPacketEntityAction(this, CPacketEntityAction.Action.OPEN_INVENTORY));
    }

    public void func_175158_f(String string) {
        this.field_142022_ce = string;
    }

    public String func_142021_k() {
        return this.field_142022_ce;
    }

    public StatisticsManager func_146107_m() {
        return this.field_146108_bO;
    }

    public RecipeBookClient func_199507_B() {
        return this.field_192036_cb;
    }

    public void func_193103_a(IRecipe iRecipe) {
        if (this.field_192036_cb.func_194076_e(iRecipe)) {
            this.field_192036_cb.func_194074_f(iRecipe);
            this.field_71174_a.func_147297_a(new CPacketRecipeInfo(iRecipe));
        }
    }

    @Override
    protected int func_184840_I() {
        return this.field_184845_bX;
    }

    public void func_184839_n(int n) {
        this.field_184845_bX = n;
    }

    @Override
    public void func_146105_b(ITextComponent iTextComponent, boolean bl) {
        if (bl) {
            this.field_71159_c.field_71456_v.func_175188_a(iTextComponent, false);
        } else {
            this.field_71159_c.field_71456_v.func_146158_b().func_146227_a(iTextComponent);
        }
    }

    @Override
    protected boolean func_145771_j(double d, double d2, double d3) {
        if (this.field_70145_X) {
            return false;
        }
        BlockPos blockPos = new BlockPos(d, d2, d3);
        double \u26032 = d - (double)blockPos.func_177958_n();
        double \u26033 = d3 - (double)blockPos.func_177952_p();
        if (this.func_205027_h(blockPos)) {
            int n = -1;
            double \u26034 = 9999.0;
            if (this.func_207402_f(blockPos.func_177976_e()) && \u26032 < \u26034) {
                \u26034 = \u26032;
                n = 0;
            }
            if (this.func_207402_f(blockPos.func_177974_f()) && 1.0 - \u26032 < \u26034) {
                \u26034 = 1.0 - \u26032;
                n = 1;
            }
            if (this.func_207402_f(blockPos.func_177978_c()) && \u26033 < \u26034) {
                \u26034 = \u26033;
                n = 4;
            }
            if (this.func_207402_f(blockPos.func_177968_d()) && 1.0 - \u26033 < \u26034) {
                \u26034 = 1.0 - \u26033;
                n = 5;
            }
            float \u26035 = 0.1f;
            if (n == 0) {
                this.field_70159_w = -0.1f;
            }
            if (n == 1) {
                this.field_70159_w = 0.1f;
            }
            if (n == 4) {
                this.field_70179_y = -0.1f;
            }
            if (n == 5) {
                this.field_70179_y = 0.1f;
            }
        }
        return false;
    }

    private boolean func_205027_h(BlockPos blockPos) {
        if (this.func_203007_ba()) {
            return !this.func_207401_g(blockPos);
        }
        return !this.func_207402_f(blockPos);
    }

    @Override
    public void func_70031_b(boolean bl) {
        super.func_70031_b(bl);
        this.field_71157_e = 0;
    }

    public void func_71152_a(float f, int n, int n2) {
        this.field_71106_cc = f;
        this.field_71067_cb = n;
        this.field_71068_ca = n2;
    }

    @Override
    public void func_145747_a(ITextComponent iTextComponent) {
        this.field_71159_c.field_71456_v.func_146158_b().func_146227_a(iTextComponent);
    }

    @Override
    public void func_70103_a(byte by) {
        if (by >= 24 && by <= 28) {
            this.func_184839_n(by - 24);
        } else {
            super.func_70103_a(by);
        }
    }

    @Override
    public void func_184185_a(SoundEvent soundEvent, float f, float f2) {
        this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, soundEvent, this.func_184176_by(), f, f2, false);
    }

    @Override
    public boolean func_70613_aW() {
        return true;
    }

    @Override
    public void func_184598_c(EnumHand enumHand) {
        ItemStack itemStack = this.func_184586_b(enumHand);
        if (itemStack.func_190926_b() || this.func_184587_cr()) {
            return;
        }
        super.func_184598_c(enumHand);
        this.field_184842_cm = true;
        this.field_184843_cn = enumHand;
    }

    @Override
    public boolean func_184587_cr() {
        return this.field_184842_cm;
    }

    @Override
    public void func_184602_cy() {
        super.func_184602_cy();
        this.field_184842_cm = false;
    }

    @Override
    public EnumHand func_184600_cs() {
        return this.field_184843_cn;
    }

    @Override
    public void func_184206_a(DataParameter<?> dataParameter2) {
        DataParameter<?> dataParameter2;
        super.func_184206_a(dataParameter2);
        if (field_184621_as.equals(dataParameter2)) {
            boolean bl = ((Byte)this.field_70180_af.func_187225_a(field_184621_as) & 1) > 0;
            EnumHand enumHand = \u2603 = ((Byte)this.field_70180_af.func_187225_a(field_184621_as) & 2) > 0 ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND;
            if (bl && !this.field_184842_cm) {
                this.func_184598_c(\u2603);
            } else if (!bl && this.field_184842_cm) {
                this.func_184602_cy();
            }
        }
        if (field_184240_ax.equals(dataParameter2) && this.func_184613_cA() && !this.field_189813_ct) {
            this.field_71159_c.func_147118_V().func_147682_a(new ElytraSound(this));
        }
    }

    public boolean func_110317_t() {
        Entity entity = this.func_184187_bx();
        return this.func_184218_aH() && entity instanceof IJumpingMount && ((IJumpingMount)((Object)entity)).func_184776_b();
    }

    public float func_110319_bJ() {
        return this.field_110321_bQ;
    }

    @Override
    public void func_175141_a(TileEntitySign tileEntitySign) {
        this.field_71159_c.func_147108_a(new GuiEditSign(tileEntitySign));
    }

    @Override
    public void func_184809_a(CommandBlockBaseLogic commandBlockBaseLogic) {
        this.field_71159_c.func_147108_a(new GuiEditCommandBlockMinecart(commandBlockBaseLogic));
    }

    @Override
    public void func_184824_a(TileEntityCommandBlock tileEntityCommandBlock) {
        this.field_71159_c.func_147108_a(new GuiCommandBlock(tileEntityCommandBlock));
    }

    @Override
    public void func_189807_a(TileEntityStructure tileEntityStructure) {
        this.field_71159_c.func_147108_a(new GuiEditStructure(tileEntityStructure));
    }

    @Override
    public void func_184814_a(ItemStack itemStack, EnumHand enumHand) {
        Item item = itemStack.func_77973_b();
        if (item == Items.field_151099_bA) {
            this.field_71159_c.func_147108_a(new GuiScreenBook(this, itemStack, true, enumHand));
        }
    }

    @Override
    public void func_71007_a(IInventory iInventory) {
        String string = \u2603 = iInventory instanceof IInteractionObject ? ((IInteractionObject)((Object)iInventory)).func_174875_k() : "minecraft:container";
        if ("minecraft:chest".equals(\u2603)) {
            this.field_71159_c.func_147108_a(new GuiChest(this.field_71071_by, iInventory));
        } else if ("minecraft:hopper".equals(\u2603)) {
            this.field_71159_c.func_147108_a(new GuiHopper(this.field_71071_by, iInventory));
        } else if ("minecraft:furnace".equals(\u2603)) {
            this.field_71159_c.func_147108_a(new GuiFurnace(this.field_71071_by, iInventory));
        } else if ("minecraft:brewing_stand".equals(\u2603)) {
            this.field_71159_c.func_147108_a(new GuiBrewingStand(this.field_71071_by, iInventory));
        } else if ("minecraft:beacon".equals(\u2603)) {
            this.field_71159_c.func_147108_a(new GuiBeacon(this.field_71071_by, iInventory));
        } else if ("minecraft:dispenser".equals(\u2603) || "minecraft:dropper".equals(\u2603)) {
            this.field_71159_c.func_147108_a(new GuiDispenser(this.field_71071_by, iInventory));
        } else if ("minecraft:shulker_box".equals(\u2603)) {
            this.field_71159_c.func_147108_a(new GuiShulkerBox(this.field_71071_by, iInventory));
        } else {
            this.field_71159_c.func_147108_a(new GuiChest(this.field_71071_by, iInventory));
        }
    }

    @Override
    public void func_184826_a(AbstractHorse abstractHorse, IInventory iInventory) {
        this.field_71159_c.func_147108_a(new GuiScreenHorseInventory(this.field_71071_by, iInventory, abstractHorse));
    }

    @Override
    public void func_180468_a(IInteractionObject iInteractionObject) {
        String string = iInteractionObject.func_174875_k();
        if ("minecraft:crafting_table".equals(string)) {
            this.field_71159_c.func_147108_a(new GuiCrafting(this.field_71071_by, this.field_70170_p));
        } else if ("minecraft:enchanting_table".equals(string)) {
            this.field_71159_c.func_147108_a(new GuiEnchantment(this.field_71071_by, this.field_70170_p, iInteractionObject));
        } else if ("minecraft:anvil".equals(string)) {
            this.field_71159_c.func_147108_a(new GuiRepair(this.field_71071_by, this.field_70170_p));
        }
    }

    @Override
    public void func_180472_a(IMerchant iMerchant) {
        this.field_71159_c.func_147108_a(new GuiMerchant(this.field_71071_by, iMerchant, this.field_70170_p));
    }

    @Override
    public void func_71009_b(Entity entity) {
        this.field_71159_c.field_71452_i.func_199282_a(entity, Particles.field_197614_g);
    }

    @Override
    public void func_71047_c(Entity entity) {
        this.field_71159_c.field_71452_i.func_199282_a(entity, Particles.field_197622_o);
    }

    @Override
    public boolean func_70093_af() {
        boolean bl = this.field_71158_b != null && this.field_71158_b.field_78899_d;
        return bl && !this.field_71083_bS;
    }

    @Override
    public void func_70626_be() {
        super.func_70626_be();
        if (this.func_175160_A()) {
            this.field_70702_br = this.field_71158_b.field_78902_a;
            this.field_191988_bg = this.field_71158_b.field_192832_b;
            this.field_70703_bu = this.field_71158_b.field_78901_c;
            this.field_71163_h = this.field_71154_f;
            this.field_71164_i = this.field_71155_g;
            this.field_71155_g = (float)((double)this.field_71155_g + (double)(this.field_70125_A - this.field_71155_g) * 0.5);
            this.field_71154_f = (float)((double)this.field_71154_f + (double)(this.field_70177_z - this.field_71154_f) * 0.5);
        }
    }

    protected boolean func_175160_A() {
        return this.field_71159_c.func_175606_aa() == this;
    }

    @Override
    public void func_70636_d() {
        int n;
        ++this.field_71157_e;
        if (this.field_71156_d > 0) {
            --this.field_71156_d;
        }
        this.field_71080_cy = this.field_71086_bY;
        if (this.field_71087_bX) {
            if (this.field_71159_c.field_71462_r != null && !this.field_71159_c.field_71462_r.func_73868_f()) {
                if (this.field_71159_c.field_71462_r instanceof GuiContainer) {
                    this.func_71053_j();
                }
                this.field_71159_c.func_147108_a(null);
            }
            if (this.field_71086_bY == 0.0f) {
                this.field_71159_c.func_147118_V().func_147682_a(SimpleSound.func_184371_a(SoundEvents.field_187814_ei, this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
            }
            this.field_71086_bY += 0.0125f;
            if (this.field_71086_bY >= 1.0f) {
                this.field_71086_bY = 1.0f;
            }
            this.field_71087_bX = false;
        } else if (this.func_70644_a(MobEffects.field_76431_k) && this.func_70660_b(MobEffects.field_76431_k).func_76459_b() > 60) {
            this.field_71086_bY += 0.006666667f;
            if (this.field_71086_bY > 1.0f) {
                this.field_71086_bY = 1.0f;
            }
        } else {
            if (this.field_71086_bY > 0.0f) {
                this.field_71086_bY -= 0.05f;
            }
            if (this.field_71086_bY < 0.0f) {
                this.field_71086_bY = 0.0f;
            }
        }
        if (this.field_71088_bW > 0) {
            --this.field_71088_bW;
        }
        boolean bl = this.field_71158_b.field_78901_c;
        \u2603 = this.field_71158_b.field_78899_d;
        float \u26032 = 0.8f;
        \u2603 = this.field_71158_b.field_192832_b >= 0.8f;
        this.field_71158_b.func_78898_a();
        this.field_71159_c.func_193032_ao().func_193293_a(this.field_71158_b);
        if (this.func_184587_cr() && !this.func_184218_aH()) {
            this.field_71158_b.field_78902_a *= 0.2f;
            this.field_71158_b.field_192832_b *= 0.2f;
            this.field_71156_d = 0;
        }
        \u2603 = false;
        if (this.field_189812_cs > 0) {
            --this.field_189812_cs;
            \u2603 = true;
            this.field_71158_b.field_78901_c = true;
        }
        AxisAlignedBB \u26033 = this.func_174813_aQ();
        this.func_145771_j(this.field_70165_t - (double)this.field_70130_N * 0.35, \u26033.field_72338_b + 0.5, this.field_70161_v + (double)this.field_70130_N * 0.35);
        this.func_145771_j(this.field_70165_t - (double)this.field_70130_N * 0.35, \u26033.field_72338_b + 0.5, this.field_70161_v - (double)this.field_70130_N * 0.35);
        this.func_145771_j(this.field_70165_t + (double)this.field_70130_N * 0.35, \u26033.field_72338_b + 0.5, this.field_70161_v - (double)this.field_70130_N * 0.35);
        this.func_145771_j(this.field_70165_t + (double)this.field_70130_N * 0.35, \u26033.field_72338_b + 0.5, this.field_70161_v + (double)this.field_70130_N * 0.35);
        boolean bl2 = \u2603 = (float)this.func_71024_bL().func_75116_a() > 6.0f || this.field_71075_bZ.field_75101_c;
        if (!(!this.field_70122_E && !this.func_204231_K() || \u2603 || \u2603 || !(this.field_71158_b.field_192832_b >= 0.8f) || this.func_70051_ag() || !\u2603 || this.func_184587_cr() || this.func_70644_a(MobEffects.field_76440_q))) {
            if (this.field_71156_d > 0 || this.field_71159_c.field_71474_y.field_151444_V.func_151470_d()) {
                this.func_70031_b(true);
            } else {
                this.field_71156_d = 7;
            }
        }
        if (!this.func_70051_ag() && (!this.func_70090_H() || this.func_204231_K()) && this.field_71158_b.field_192832_b >= 0.8f && \u2603 && !this.func_184587_cr() && !this.func_70644_a(MobEffects.field_76440_q) && this.field_71159_c.field_71474_y.field_151444_V.func_151470_d()) {
            this.func_70031_b(true);
        }
        if (this.func_70051_ag()) {
            n = this.field_71158_b.field_192832_b < 0.8f || !\u2603 ? 1 : 0;
            boolean bl3 = \u2603 = n != 0 || this.field_70123_F || this.func_70090_H() && !this.func_204231_K();
            if (this.func_203007_ba()) {
                if (!this.field_70122_E && !this.field_71158_b.field_78899_d && n != 0 || !this.func_70090_H()) {
                    this.func_70031_b(false);
                }
            } else if (\u2603) {
                this.func_70031_b(false);
            }
        }
        if (this.field_71075_bZ.field_75101_c) {
            if (this.field_71159_c.field_71442_b.func_178887_k()) {
                if (!this.field_71075_bZ.field_75100_b) {
                    this.field_71075_bZ.field_75100_b = true;
                    this.func_71016_p();
                }
            } else if (!bl && this.field_71158_b.field_78901_c && !\u2603) {
                if (this.field_71101_bC == 0) {
                    this.field_71101_bC = 7;
                } else if (!this.func_203007_ba()) {
                    this.field_71075_bZ.field_75100_b = !this.field_71075_bZ.field_75100_b;
                    this.func_71016_p();
                    this.field_71101_bC = 0;
                }
            }
        }
        if (this.field_71158_b.field_78901_c && !bl && !this.field_70122_E && this.field_70181_x < 0.0 && !this.func_184613_cA() && !this.field_71075_bZ.field_75100_b && (\u2603 = this.func_184582_a(EntityEquipmentSlot.CHEST)).func_77973_b() == Items.field_185160_cR && ItemElytra.func_185069_d(\u2603)) {
            this.field_71174_a.func_147297_a(new CPacketEntityAction(this, CPacketEntityAction.Action.START_FALL_FLYING));
        }
        this.field_189813_ct = this.func_184613_cA();
        if (this.func_70090_H() && this.field_71158_b.field_78899_d) {
            this.func_203010_cG();
        }
        if (this.func_208600_a(FluidTags.field_206959_a)) {
            n = this.func_175149_v() ? 10 : 1;
            this.field_203720_cz = MathHelper.func_76125_a(this.field_203720_cz + n, 0, 600);
        } else if (this.field_203720_cz > 0) {
            this.func_208600_a(FluidTags.field_206959_a);
            this.field_203720_cz = MathHelper.func_76125_a(this.field_203720_cz - 10, 0, 600);
        }
        if (this.field_71075_bZ.field_75100_b && this.func_175160_A()) {
            if (this.field_71158_b.field_78899_d) {
                this.field_71158_b.field_78902_a = (float)((double)this.field_71158_b.field_78902_a / 0.3);
                this.field_71158_b.field_192832_b = (float)((double)this.field_71158_b.field_192832_b / 0.3);
                this.field_70181_x -= (double)(this.field_71075_bZ.func_75093_a() * 3.0f);
            }
            if (this.field_71158_b.field_78901_c) {
                this.field_70181_x += (double)(this.field_71075_bZ.func_75093_a() * 3.0f);
            }
        }
        if (this.func_110317_t()) {
            IJumpingMount iJumpingMount = (IJumpingMount)((Object)this.func_184187_bx());
            if (this.field_110320_a < 0) {
                ++this.field_110320_a;
                if (this.field_110320_a == 0) {
                    this.field_110321_bQ = 0.0f;
                }
            }
            if (bl && !this.field_71158_b.field_78901_c) {
                this.field_110320_a = -10;
                iJumpingMount.func_110206_u(MathHelper.func_76141_d(this.func_110319_bJ() * 100.0f));
                this.func_110318_g();
            } else if (!bl && this.field_71158_b.field_78901_c) {
                this.field_110320_a = 0;
                this.field_110321_bQ = 0.0f;
            } else if (bl) {
                ++this.field_110320_a;
                this.field_110321_bQ = this.field_110320_a < 10 ? (float)this.field_110320_a * 0.1f : 0.8f + 2.0f / (float)(this.field_110320_a - 9) * 0.1f;
            }
        } else {
            this.field_110321_bQ = 0.0f;
        }
        super.func_70636_d();
        if (this.field_70122_E && this.field_71075_bZ.field_75100_b && !this.field_71159_c.field_71442_b.func_178887_k()) {
            this.field_71075_bZ.field_75100_b = false;
            this.func_71016_p();
        }
    }

    @Override
    public void func_70098_U() {
        super.func_70098_U();
        this.field_184844_co = false;
        if (this.func_184187_bx() instanceof EntityBoat) {
            EntityBoat entityBoat = (EntityBoat)this.func_184187_bx();
            entityBoat.func_184442_a(this.field_71158_b.field_187257_e, this.field_71158_b.field_187258_f, this.field_71158_b.field_187255_c, this.field_71158_b.field_187256_d);
            this.field_184844_co |= this.field_71158_b.field_187257_e || this.field_71158_b.field_187258_f || this.field_71158_b.field_187255_c || this.field_71158_b.field_187256_d;
        }
    }

    public boolean func_184838_M() {
        return this.field_184844_co;
    }

    @Override
    @Nullable
    public PotionEffect func_184596_c(@Nullable Potion potion) {
        if (potion == MobEffects.field_76431_k) {
            this.field_71080_cy = 0.0f;
            this.field_71086_bY = 0.0f;
        }
        return super.func_184596_c(potion);
    }

    @Override
    public void func_70091_d(MoverType moverType, double d, double d2, double d3) {
        \u2603 = this.field_70165_t;
        \u2603 = this.field_70161_v;
        super.func_70091_d(moverType, d, d2, d3);
        this.func_189810_i((float)(this.field_70165_t - \u2603), (float)(this.field_70161_v - \u2603));
    }

    public boolean func_189809_N() {
        return this.field_189811_cr;
    }

    protected void func_189810_i(float f, float f2) {
        float \u260322;
        float f3;
        if (!this.func_189809_N()) {
            return;
        }
        if (this.field_189812_cs > 0 || !this.field_70122_E || this.func_70093_af() || this.func_184218_aH()) {
            return;
        }
        Vec2f vec2f = this.field_71158_b.func_190020_b();
        if (vec2f.field_189982_i == 0.0f && vec2f.field_189983_j == 0.0f) {
            return;
        }
        Vec3d \u26032 = new Vec3d(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        Vec3d \u26033 = new Vec3d(this.field_70165_t + (double)f, this.func_174813_aQ().field_72338_b, this.field_70161_v + (double)f2);
        Vec3d \u26034 = new Vec3d(f, 0.0, f2);
        float \u26035 = this.func_70689_ay();
        float \u26036 = (float)\u26034.func_189985_c();
        if (\u26036 <= 0.001f) {
            f3 = \u26035 * vec2f.field_189982_i;
            \u2603 = \u26035 * vec2f.field_189983_j;
            \u2603 = MathHelper.func_76126_a(this.field_70177_z * ((float)Math.PI / 180));
            \u2603 = MathHelper.func_76134_b(this.field_70177_z * ((float)Math.PI / 180));
            \u26034 = new Vec3d(f3 * \u2603 - \u2603 * \u2603, \u26034.field_72448_b, \u2603 * \u2603 + f3 * \u2603);
            \u26036 = (float)\u26034.func_189985_c();
            if (\u26036 <= 0.001f) {
                return;
            }
        }
        f3 = (float)MathHelper.func_181161_i(\u26036);
        Vec3d \u26037 = \u26034.func_186678_a(f3);
        Vec3d \u26038 = this.func_189651_aD();
        \u2603 = (float)(\u26038.field_72450_a * \u26037.field_72450_a + \u26038.field_72449_c * \u26037.field_72449_c);
        if (\u2603 < -0.15f) {
            return;
        }
        BlockPos \u26039 = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72337_e, this.field_70161_v);
        IBlockState \u260310 = this.field_70170_p.func_180495_p(\u26039);
        if (!\u260310.func_196952_d(this.field_70170_p, \u26039).func_197766_b()) {
            return;
        }
        IBlockState \u260311 = this.field_70170_p.func_180495_p(\u26039 = \u26039.func_177984_a());
        if (!\u260311.func_196952_d(this.field_70170_p, \u26039).func_197766_b()) {
            return;
        }
        \u2603 = 7.0f;
        \u2603 = 1.2f;
        if (this.func_70644_a(MobEffects.field_76430_j)) {
            \u2603 += (float)(this.func_70660_b(MobEffects.field_76430_j).func_76458_c() + 1) * 0.75f;
        }
        \u2603 = Math.max(\u26035 * 7.0f, 1.0f / f3);
        Vec3d \u260312 = \u26032;
        Vec3d \u260313 = \u26033.func_178787_e(\u26037.func_186678_a(\u2603));
        \u2603 = this.field_70130_N;
        \u2603 = this.field_70131_O;
        AxisAlignedBB \u260314 = new AxisAlignedBB(\u260312, \u260313.func_72441_c(0.0, \u2603, 0.0)).func_72314_b(\u2603, 0.0, \u2603);
        \u260312 = \u260312.func_72441_c(0.0, 0.51f, 0.0);
        \u260313 = \u260313.func_72441_c(0.0, 0.51f, 0.0);
        Vec3d \u260315 = \u26037.func_72431_c(new Vec3d(0.0, 1.0, 0.0));
        Vec3d \u260316 = \u260315.func_186678_a(\u2603 * 0.5f);
        Vec3d \u260317 = \u260312.func_178788_d(\u260316);
        Vec3d \u260318 = \u260313.func_178788_d(\u260316);
        Vec3d \u260319 = \u260312.func_178787_e(\u260316);
        Vec3d \u260320 = \u260313.func_178787_e(\u260316);
        Iterator \u260321 = this.field_70170_p.func_212388_b(this, \u260314).flatMap(voxelShape -> voxelShape.func_197756_d().stream()).iterator();
        \u260322 = Float.MIN_VALUE;
        while (\u260321.hasNext()) {
            AxisAlignedBB axisAlignedBB = (AxisAlignedBB)\u260321.next();
            if (!axisAlignedBB.func_189973_a(\u260317, \u260318) && !axisAlignedBB.func_189973_a(\u260319, \u260320)) continue;
            \u260322 = (float)axisAlignedBB.field_72337_e;
            Vec3d \u260323 = axisAlignedBB.func_189972_c();
            BlockPos \u260324 = new BlockPos(\u260323);
            int \u260325 = 1;
            while ((float)\u260325 < \u2603) {
                BlockPos blockPos = \u260324.func_177981_b(\u260325);
                IBlockState \u260326 = this.field_70170_p.func_180495_p(blockPos);
                VoxelShape \u260327 = \u260326.func_196952_d(this.field_70170_p, blockPos);
                if (!\u260327.func_197766_b() && (double)(\u260322 = (float)\u260327.func_197758_c(EnumFacing.Axis.Y) + (float)blockPos.func_177956_o()) - this.func_174813_aQ().field_72338_b > (double)\u2603) {
                    return;
                }
                if (\u260325 > 1 && !(\u2603 = this.field_70170_p.func_180495_p(\u26039 = \u26039.func_177984_a())).func_196952_d(this.field_70170_p, \u26039).func_197766_b()) {
                    return;
                }
                ++\u260325;
            }
            break block0;
        }
        if (\u260322 == Float.MIN_VALUE) {
            return;
        }
        float f4 = (float)((double)\u260322 - this.func_174813_aQ().field_72338_b);
        if (f4 <= 0.5f || f4 > \u2603) {
            return;
        }
        this.field_189812_cs = 1;
    }

    public float func_203719_J() {
        if (!this.func_208600_a(FluidTags.field_206959_a)) {
            return 0.0f;
        }
        float f = 600.0f;
        \u2603 = 100.0f;
        if ((float)this.field_203720_cz >= 600.0f) {
            return 1.0f;
        }
        \u2603 = MathHelper.func_76131_a((float)this.field_203720_cz / 100.0f, 0.0f, 1.0f);
        \u2603 = (float)this.field_203720_cz < 100.0f ? 0.0f : MathHelper.func_76131_a(((float)this.field_203720_cz - 100.0f) / 500.0f, 0.0f, 1.0f);
        return \u2603 * 0.6f + \u2603 * 0.39999998f;
    }

    @Override
    public boolean func_204231_K() {
        return this.field_204230_bP;
    }

    @Override
    protected boolean func_204229_de() {
        boolean bl = this.field_204230_bP;
        \u2603 = super.func_204229_de();
        if (this.func_175149_v()) {
            return this.field_204230_bP;
        }
        if (!bl && \u2603) {
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_204326_e, SoundCategory.AMBIENT, 1.0f, 1.0f, false);
            this.field_71159_c.func_147118_V().func_147682_a(new UnderwaterAmbientSounds.UnderWaterSound(this));
        }
        if (bl && !\u2603) {
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_204327_f, SoundCategory.AMBIENT, 1.0f, 1.0f, false);
        }
        return this.field_204230_bP;
    }
}

