/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiDisconnected;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.ServerAddress;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.network.NetHandlerLoginClient;
import net.minecraft.client.resources.I18n;
import net.minecraft.network.EnumConnectionState;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.handshake.client.CPacketHandshake;
import net.minecraft.network.login.client.CPacketLoginStart;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GuiConnecting
extends GuiScreen {
    private static final AtomicInteger field_146372_a = new AtomicInteger(0);
    private static final Logger field_146370_f = LogManager.getLogger();
    private NetworkManager field_146371_g;
    private boolean field_146373_h;
    private final GuiScreen field_146374_i;
    private ITextComponent field_209515_s = new TextComponentTranslation("connect.connecting", new Object[0]);

    public GuiConnecting(GuiScreen guiScreen, Minecraft minecraft, ServerData serverData) {
        this.field_146297_k = minecraft;
        this.field_146374_i = guiScreen;
        ServerAddress serverAddress = ServerAddress.func_78860_a(serverData.field_78845_b);
        minecraft.func_71403_a(null);
        minecraft.func_71351_a(serverData);
        this.func_146367_a(serverAddress.func_78861_a(), serverAddress.func_78864_b());
    }

    public GuiConnecting(GuiScreen guiScreen, Minecraft minecraft, String string, int n) {
        this.field_146297_k = minecraft;
        this.field_146374_i = guiScreen;
        minecraft.func_71403_a(null);
        this.func_146367_a(string, n);
    }

    private void func_146367_a(final String string, final int n) {
        field_146370_f.info("Connecting to {}, {}", (Object)string, (Object)n);
        Thread thread = new Thread("Server Connector #" + field_146372_a.incrementAndGet()){

            @Override
            public void run() {
                InetAddress inetAddress = null;
                try {
                    if (GuiConnecting.this.field_146373_h) {
                        return;
                    }
                    inetAddress = InetAddress.getByName(string);
                    GuiConnecting.this.field_146371_g = NetworkManager.func_181124_a(inetAddress, n, GuiConnecting.this.field_146297_k.field_71474_y.func_181148_f());
                    GuiConnecting.this.field_146371_g.func_150719_a(new NetHandlerLoginClient(GuiConnecting.this.field_146371_g, GuiConnecting.this.field_146297_k, GuiConnecting.this.field_146374_i, iTextComponent -> GuiConnecting.this.func_209514_a(iTextComponent)));
                    GuiConnecting.this.field_146371_g.func_179290_a(new CPacketHandshake(string, n, EnumConnectionState.LOGIN));
                    GuiConnecting.this.field_146371_g.func_179290_a(new CPacketLoginStart(GuiConnecting.this.field_146297_k.func_110432_I().func_148256_e()));
                }
                catch (UnknownHostException \u26032) {
                    if (GuiConnecting.this.field_146373_h) {
                        return;
                    }
                    field_146370_f.error("Couldn't connect to server", (Throwable)\u26032);
                    GuiConnecting.this.field_146297_k.func_152344_a(() -> GuiConnecting.this.field_146297_k.func_147108_a(new GuiDisconnected(GuiConnecting.this.field_146374_i, "connect.failed", new TextComponentTranslation("disconnect.genericReason", "Unknown host"))));
                }
                catch (Exception \u26033) {
                    if (GuiConnecting.this.field_146373_h) {
                        return;
                    }
                    field_146370_f.error("Couldn't connect to server", (Throwable)\u26033);
                    String string2 = inetAddress == null ? \u26033.toString() : \u26033.toString().replaceAll(inetAddress + ":" + n, "");
                    GuiConnecting.this.field_146297_k.func_152344_a(() -> GuiConnecting.this.field_146297_k.func_147108_a(new GuiDisconnected(GuiConnecting.this.field_146374_i, "connect.failed", new TextComponentTranslation("disconnect.genericReason", string2))));
                }
            }
        };
        thread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(field_146370_f));
        thread.start();
    }

    private void func_209514_a(ITextComponent iTextComponent) {
        this.field_209515_s = iTextComponent;
    }

    @Override
    public void func_73876_c() {
        if (this.field_146371_g != null) {
            if (this.field_146371_g.func_150724_d()) {
                this.field_146371_g.func_74428_b();
            } else {
                this.field_146371_g.func_179293_l();
            }
        }
    }

    @Override
    public boolean func_195120_Y_() {
        return false;
    }

    @Override
    protected void func_73866_w_() {
        this.func_189646_b(new GuiButton(0, this.field_146294_l / 2 - 100, this.field_146295_m / 4 + 120 + 12, I18n.func_135052_a("gui.cancel", new Object[0])){

            @Override
            public void func_194829_a(double d, double d2) {
                GuiConnecting.this.field_146373_h = true;
                if (GuiConnecting.this.field_146371_g != null) {
                    GuiConnecting.this.field_146371_g.func_150718_a(new TextComponentTranslation("connect.aborted", new Object[0]));
                }
                GuiConnecting.this.field_146297_k.func_147108_a(GuiConnecting.this.field_146374_i);
            }
        });
    }

    @Override
    public void func_73863_a(int n, int n2, float f) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, this.field_209515_s.func_150254_d(), this.field_146294_l / 2, this.field_146295_m / 2 - 50, 0xFFFFFF);
        super.func_73863_a(n, n2, f);
    }
}

