/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiBossOverlay;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.client.gui.GuiOverlayDebug;
import net.minecraft.client.gui.GuiPlayerTabOverlay;
import net.minecraft.client.gui.GuiSpectator;
import net.minecraft.client.gui.GuiSubtitleOverlay;
import net.minecraft.client.gui.chat.IChatListener;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.chat.NormalChatListener;
import net.minecraft.client.gui.chat.OverlayChatListener;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.FoodStats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraft.world.border.WorldBorder;

public class GuiIngame
extends Gui {
    private static final ResourceLocation field_110329_b = new ResourceLocation("textures/misc/vignette.png");
    private static final ResourceLocation field_110330_c = new ResourceLocation("textures/gui/widgets.png");
    private static final ResourceLocation field_110328_d = new ResourceLocation("textures/misc/pumpkinblur.png");
    private final Random field_73842_c = new Random();
    private final Minecraft field_73839_d;
    private final ItemRenderer field_73841_b;
    private final GuiNewChat field_73840_e;
    private int field_73837_f;
    private String field_73838_g = "";
    private int field_73845_h;
    private boolean field_73844_j;
    public float field_73843_a = 1.0f;
    private int field_92017_k;
    private ItemStack field_92016_l = ItemStack.field_190927_a;
    private final GuiOverlayDebug field_175198_t;
    private final GuiSubtitleOverlay field_184049_t;
    private final GuiSpectator field_175197_u;
    private final GuiPlayerTabOverlay field_175196_v;
    private final GuiBossOverlay field_184050_w;
    private int field_175195_w;
    private String field_175201_x = "";
    private String field_175200_y = "";
    private int field_175199_z;
    private int field_175192_A;
    private int field_175193_B;
    private int field_175194_C;
    private int field_175189_D;
    private long field_175190_E;
    private long field_175191_F;
    private int field_194811_H;
    private int field_194812_I;
    private final Map<ChatType, List<IChatListener>> field_191743_I = Maps.newHashMap();

    public GuiIngame(Minecraft minecraft) {
        this.field_73839_d = minecraft;
        this.field_73841_b = minecraft.func_175599_af();
        this.field_175198_t = new GuiOverlayDebug(minecraft);
        this.field_175197_u = new GuiSpectator(minecraft);
        this.field_73840_e = new GuiNewChat(minecraft);
        this.field_175196_v = new GuiPlayerTabOverlay(minecraft, this);
        this.field_184050_w = new GuiBossOverlay(minecraft);
        this.field_184049_t = new GuiSubtitleOverlay(minecraft);
        for (ChatType chatType : ChatType.values()) {
            this.field_191743_I.put(chatType, Lists.newArrayList());
        }
        NarratorChatListener narratorChatListener = NarratorChatListener.field_193643_a;
        this.field_191743_I.get((Object)ChatType.CHAT).add(new NormalChatListener(minecraft));
        this.field_191743_I.get((Object)ChatType.CHAT).add(narratorChatListener);
        this.field_191743_I.get((Object)ChatType.SYSTEM).add(new NormalChatListener(minecraft));
        this.field_191743_I.get((Object)ChatType.SYSTEM).add(narratorChatListener);
        this.field_191743_I.get((Object)ChatType.GAME_INFO).add(new OverlayChatListener(minecraft));
        this.func_175177_a();
    }

    public void func_175177_a() {
        this.field_175199_z = 10;
        this.field_175192_A = 70;
        this.field_175193_B = 20;
    }

    public void func_175180_a(float f3) {
        int \u26033;
        this.field_194811_H = this.field_73839_d.field_195558_d.func_198107_o();
        this.field_194812_I = this.field_73839_d.field_195558_d.func_198087_p();
        FontRenderer fontRenderer = this.func_175179_f();
        GlStateManager.func_179147_l();
        if (Minecraft.func_71375_t()) {
            this.func_212303_b(this.field_73839_d.func_175606_aa());
        } else {
            GlStateManager.func_179126_j();
            GlStateManager.func_187428_a(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        }
        ItemStack \u26032 = this.field_73839_d.field_71439_g.field_71071_by.func_70440_f(3);
        if (this.field_73839_d.field_71474_y.field_74320_O == 0 && \u26032.func_77973_b() == Blocks.field_196625_cS.func_199767_j()) {
            this.func_194808_p();
        }
        if (!this.field_73839_d.field_71439_g.func_70644_a(MobEffects.field_76431_k) && (f2 = this.field_73839_d.field_71439_g.field_71080_cy + (this.field_73839_d.field_71439_g.field_71086_bY - this.field_73839_d.field_71439_g.field_71080_cy) * f3) > 0.0f) {
            this.func_194805_e(f2);
        }
        if (this.field_73839_d.field_71442_b.func_178889_l() == GameType.SPECTATOR) {
            this.field_175197_u.func_195622_a(f3);
        } else if (!this.field_73839_d.field_71474_y.field_74319_N) {
            this.func_194806_b(f3);
        }
        if (!this.field_73839_d.field_71474_y.field_74319_N) {
            GlStateManager.func_179131_c(1.0f, 1.0f, 1.0f, 1.0f);
            this.field_73839_d.func_110434_K().func_110577_a(field_110324_m);
            GlStateManager.func_179147_l();
            GlStateManager.func_179141_d();
            this.func_194798_c(f3);
            GlStateManager.func_187428_a(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
            this.field_73839_d.field_71424_I.func_76320_a("bossHealth");
            this.field_184050_w.func_184051_a();
            this.field_73839_d.field_71424_I.func_76319_b();
            GlStateManager.func_179131_c(1.0f, 1.0f, 1.0f, 1.0f);
            this.field_73839_d.func_110434_K().func_110577_a(field_110324_m);
            if (this.field_73839_d.field_71442_b.func_78755_b()) {
                this.func_194807_n();
            }
            this.func_194799_o();
            GlStateManager.func_179084_k();
            int n = this.field_194811_H / 2 - 91;
            if (this.field_73839_d.field_71439_g.func_110317_t()) {
                this.func_194803_a(n);
            } else if (this.field_73839_d.field_71442_b.func_78763_f()) {
                this.func_194804_b(n);
            }
            if (this.field_73839_d.field_71474_y.field_92117_D && this.field_73839_d.field_71442_b.func_178889_l() != GameType.SPECTATOR) {
                this.func_194801_c();
            } else if (this.field_73839_d.field_71439_g.func_175149_v()) {
                this.field_175197_u.func_195623_a();
            }
        }
        if (this.field_73839_d.field_71439_g.func_71060_bI() > 0) {
            this.field_73839_d.field_71424_I.func_76320_a("sleep");
            GlStateManager.func_179097_i();
            GlStateManager.func_179118_c();
            float f2 = this.field_73839_d.field_71439_g.func_71060_bI();
            \u2603 = f2 / 100.0f;
            if (\u2603 > 1.0f) {
                \u2603 = 1.0f - (f2 - 100.0f) / 10.0f;
            }
            \u26033 = (int)(220.0f * \u2603) << 24 | 0x101020;
            GuiIngame.func_73734_a(0, 0, this.field_194811_H, this.field_194812_I, \u26033);
            GlStateManager.func_179141_d();
            GlStateManager.func_179126_j();
            this.field_73839_d.field_71424_I.func_76319_b();
            GlStateManager.func_179131_c(1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (this.field_73839_d.func_71355_q()) {
            this.func_194810_d();
        }
        this.func_194809_b();
        if (this.field_73839_d.field_71474_y.field_74330_P) {
            this.field_175198_t.func_194818_a();
        }
        if (!this.field_73839_d.field_71474_y.field_74319_N) {
            if (this.field_73845_h > 0) {
                this.field_73839_d.field_71424_I.func_76320_a("overlayMessage");
                f2 = (float)this.field_73845_h - f3;
                int n = (int)(f2 * 255.0f / 20.0f);
                if (n > 255) {
                    n = 255;
                }
                if (n > 8) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b(this.field_194811_H / 2, this.field_194812_I - 68, 0.0f);
                    GlStateManager.func_179147_l();
                    GlStateManager.func_187428_a(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
                    \u26033 = 0xFFFFFF;
                    if (this.field_73844_j) {
                        \u26033 = MathHelper.func_181758_c(f2 / 50.0f, 0.7f, 0.6f) & 0xFFFFFF;
                    }
                    fontRenderer.func_211126_b(this.field_73838_g, -fontRenderer.func_78256_a(this.field_73838_g) / 2, -4.0f, \u26033 + (n << 24 & 0xFF000000));
                    GlStateManager.func_179084_k();
                    GlStateManager.func_179121_F();
                }
                this.field_73839_d.field_71424_I.func_76319_b();
            }
            if (this.field_175195_w > 0) {
                float f3;
                this.field_73839_d.field_71424_I.func_76320_a("titleAndSubtitle");
                f2 = (float)this.field_175195_w - f3;
                int \u26034 = 255;
                if (this.field_175195_w > this.field_175193_B + this.field_175192_A) {
                    \u2603 = (float)(this.field_175199_z + this.field_175192_A + this.field_175193_B) - f2;
                    \u26034 = (int)(\u2603 * 255.0f / (float)this.field_175199_z);
                }
                if (this.field_175195_w <= this.field_175193_B) {
                    \u26034 = (int)(f2 * 255.0f / (float)this.field_175193_B);
                }
                if ((\u26034 = MathHelper.func_76125_a(\u26034, 0, 255)) > 8) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b(this.field_194811_H / 2, this.field_194812_I / 2, 0.0f);
                    GlStateManager.func_179147_l();
                    GlStateManager.func_187428_a(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179152_a(4.0f, 4.0f, 4.0f);
                    int n = \u26034 << 24 & 0xFF000000;
                    fontRenderer.func_175063_a(this.field_175201_x, -fontRenderer.func_78256_a(this.field_175201_x) / 2, -10.0f, 0xFFFFFF | n);
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179152_a(2.0f, 2.0f, 2.0f);
                    fontRenderer.func_175063_a(this.field_175200_y, -fontRenderer.func_78256_a(this.field_175200_y) / 2, 5.0f, 0xFFFFFF | n);
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179084_k();
                    GlStateManager.func_179121_F();
                }
                this.field_73839_d.field_71424_I.func_76319_b();
            }
            this.field_184049_t.func_195620_a();
            Scoreboard scoreboard = this.field_73839_d.field_71441_e.func_96441_U();
            ScoreObjective \u26035 = null;
            ScorePlayerTeam \u26036 = scoreboard.func_96509_i(this.field_73839_d.field_71439_g.func_195047_I_());
            if (\u26036 != null && (\u2603 = \u26036.func_178775_l().func_175746_b()) >= 0) {
                \u26035 = scoreboard.func_96539_a(3 + \u2603);
            }
            ScoreObjective scoreObjective = \u26037 = \u26035 != null ? \u26035 : scoreboard.func_96539_a(1);
            if (\u26037 != null) {
                this.func_194802_a(\u26037);
            }
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179118_c();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b(0.0f, this.field_194812_I - 48, 0.0f);
            this.field_73839_d.field_71424_I.func_76320_a("chat");
            this.field_73840_e.func_146230_a(this.field_73837_f);
            this.field_73839_d.field_71424_I.func_76319_b();
            GlStateManager.func_179121_F();
            ScoreObjective \u26037 = scoreboard.func_96539_a(0);
            if (this.field_73839_d.field_71474_y.field_74321_H.func_151470_d() && (!this.field_73839_d.func_71387_A() || this.field_73839_d.field_71439_g.field_71174_a.func_175106_d().size() > 1 || \u26037 != null)) {
                this.field_175196_v.func_175246_a(true);
                this.field_175196_v.func_175249_a(this.field_194811_H, scoreboard, \u26037);
            } else {
                this.field_175196_v.func_175246_a(false);
            }
        }
        GlStateManager.func_179131_c(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179141_d();
    }

    private void func_194798_c(float f) {
        GameSettings gameSettings = this.field_73839_d.field_71474_y;
        if (gameSettings.field_74320_O != 0) {
            return;
        }
        if (this.field_73839_d.field_71442_b.func_178889_l() == GameType.SPECTATOR && this.field_73839_d.field_147125_j == null) {
            Object object = this.field_73839_d.field_71476_x;
            if (object == null || ((RayTraceResult)object).field_72313_a != RayTraceResult.Type.BLOCK) {
                return;
            }
            BlockPos \u26032 = ((RayTraceResult)object).func_178782_a();
            if (!this.field_73839_d.field_71441_e.func_180495_p(\u26032).func_177230_c().func_149716_u() || !(this.field_73839_d.field_71441_e.func_175625_s(\u26032) instanceof IInventory)) {
                return;
            }
        }
        if (gameSettings.field_74330_P && !gameSettings.field_74319_N && !this.field_73839_d.field_71439_g.func_175140_cp() && !gameSettings.field_178879_v) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b(this.field_194811_H / 2, this.field_194812_I / 2, this.field_73735_i);
            object = this.field_73839_d.func_175606_aa();
            GlStateManager.func_179114_b(((Entity)object).field_70127_C + (((Entity)object).field_70125_A - ((Entity)object).field_70127_C) * f, -1.0f, 0.0f, 0.0f);
            GlStateManager.func_179114_b(((Entity)object).field_70126_B + (((Entity)object).field_70177_z - ((Entity)object).field_70126_B) * f, 0.0f, 1.0f, 0.0f);
            GlStateManager.func_179152_a(-1.0f, -1.0f, -1.0f);
            OpenGlHelper.func_188785_m(10);
            GlStateManager.func_179121_F();
        } else {
            GlStateManager.func_187428_a(GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
            int \u26033 = 15;
            this.func_175174_a((float)this.field_194811_H / 2.0f - 7.5f, (float)this.field_194812_I / 2.0f - 7.5f, 0, 0, 15, 15);
            if (this.field_73839_d.field_71474_y.field_186716_M == 1) {
                float f2 = this.field_73839_d.field_71439_g.func_184825_o(0.0f);
                boolean \u26034 = false;
                if (this.field_73839_d.field_147125_j != null && this.field_73839_d.field_147125_j instanceof EntityLivingBase && f2 >= 1.0f) {
                    \u26034 = this.field_73839_d.field_71439_g.func_184818_cX() > 5.0f;
                    \u26034 &= this.field_73839_d.field_147125_j.func_70089_S();
                }
                int \u26035 = this.field_194812_I / 2 - 7 + 16;
                int \u26036 = this.field_194811_H / 2 - 8;
                if (\u26034) {
                    this.func_73729_b(\u26036, \u26035, 68, 94, 16, 16);
                } else if (f2 < 1.0f) {
                    int n = (int)(f2 * 17.0f);
                    this.func_73729_b(\u26036, \u26035, 36, 94, 16, 4);
                    this.func_73729_b(\u26036, \u26035, 52, 94, n, 4);
                }
            }
        }
    }

    protected void func_194809_b() {
        Collection<PotionEffect> collection = this.field_73839_d.field_71439_g.func_70651_bq();
        if (collection.isEmpty()) {
            return;
        }
        this.field_73839_d.func_110434_K().func_110577_a(GuiContainer.field_147001_a);
        GlStateManager.func_179147_l();
        int \u26032 = 0;
        int \u26033 = 0;
        for (PotionEffect potionEffect : Ordering.natural().reverse().sortedCopy(collection)) {
            int n;
            Potion potion = potionEffect.func_188419_a();
            if (!potion.func_76400_d() || !potionEffect.func_205348_f()) continue;
            int \u26034 = this.field_194811_H;
            int \u26035 = 1;
            if (this.field_73839_d.func_71355_q()) {
                \u26035 += 15;
            }
            int \u26036 = potion.func_76392_e();
            if (potion.func_188408_i()) {
                \u26034 -= 25 * ++\u26032;
            } else {
                \u26034 -= 25 * ++\u26033;
                \u26035 += 26;
            }
            GlStateManager.func_179131_c(1.0f, 1.0f, 1.0f, 1.0f);
            float \u26037 = 1.0f;
            if (potionEffect.func_82720_e()) {
                this.func_73729_b(\u26034, \u26035, 165, 166, 24, 24);
            } else {
                this.func_73729_b(\u26034, \u26035, 141, 166, 24, 24);
                if (potionEffect.func_76459_b() <= 200) {
                    n = 10 - potionEffect.func_76459_b() / 20;
                    \u26037 = MathHelper.func_76131_a((float)potionEffect.func_76459_b() / 10.0f / 5.0f * 0.5f, 0.0f, 0.5f) + MathHelper.func_76134_b((float)potionEffect.func_76459_b() * (float)Math.PI / 5.0f) * MathHelper.func_76131_a((float)n / 10.0f * 0.25f, 0.0f, 0.25f);
                }
            }
            GlStateManager.func_179131_c(1.0f, 1.0f, 1.0f, \u26037);
            n = \u26036 % 12;
            \u2603 = \u26036 / 12;
            this.func_73729_b(\u26034 + 3, \u26035 + 3, n * 18, 198 + \u2603 * 18, 18, 18);
        }
    }

    protected void func_194806_b(float f) {
        float f2;
        int n;
        EntityPlayer entityPlayer = this.func_212304_m();
        if (entityPlayer == null) {
            return;
        }
        GlStateManager.func_179131_c(1.0f, 1.0f, 1.0f, 1.0f);
        this.field_73839_d.func_110434_K().func_110577_a(field_110330_c);
        ItemStack \u26032 = entityPlayer.func_184592_cb();
        EnumHandSide \u26033 = entityPlayer.func_184591_cq().func_188468_a();
        int \u26034 = this.field_194811_H / 2;
        float \u26035 = this.field_73735_i;
        int \u26036 = 182;
        int \u26037 = 91;
        this.field_73735_i = -90.0f;
        this.func_73729_b(\u26034 - 91, this.field_194812_I - 22, 0, 0, 182, 22);
        this.func_73729_b(\u26034 - 91 - 1 + entityPlayer.field_71071_by.field_70461_c * 20, this.field_194812_I - 22 - 1, 0, 22, 24, 22);
        if (!\u26032.func_190926_b()) {
            if (\u26033 == EnumHandSide.LEFT) {
                this.func_73729_b(\u26034 - 91 - 29, this.field_194812_I - 23, 24, 22, 29, 24);
            } else {
                this.func_73729_b(\u26034 + 91, this.field_194812_I - 23, 53, 22, 29, 24);
            }
        }
        this.field_73735_i = \u26035;
        GlStateManager.func_179091_B();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        RenderHelper.func_74520_c();
        for (n = 0; n < 9; ++n) {
            n2 = \u26034 - 90 + n * 20 + 2;
            \u2603 = this.field_194812_I - 16 - 3;
            this.func_184044_a(n2, \u2603, f, entityPlayer, entityPlayer.field_71071_by.field_70462_a.get(n));
        }
        if (!\u26032.func_190926_b()) {
            n = this.field_194812_I - 16 - 3;
            if (\u26033 == EnumHandSide.LEFT) {
                this.func_184044_a(\u26034 - 91 - 26, n, f, entityPlayer, \u26032);
            } else {
                this.func_184044_a(\u26034 + 91 + 10, n, f, entityPlayer, \u26032);
            }
        }
        if (this.field_73839_d.field_71474_y.field_186716_M == 2 && (f2 = this.field_73839_d.field_71439_g.func_184825_o(0.0f)) < 1.0f) {
            int n2 = this.field_194812_I - 20;
            \u2603 = \u26034 + 91 + 6;
            if (\u26033 == EnumHandSide.RIGHT) {
                \u2603 = \u26034 - 91 - 22;
            }
            this.field_73839_d.func_110434_K().func_110577_a(Gui.field_110324_m);
            \u2603 = (int)(f2 * 19.0f);
            GlStateManager.func_179131_c(1.0f, 1.0f, 1.0f, 1.0f);
            this.func_73729_b(\u2603, n2, 0, 94, 18, 18);
            this.func_73729_b(\u2603, n2 + 18 - \u2603, 18, 112 - \u2603, 18, \u2603);
        }
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179084_k();
    }

    public void func_194803_a(int n) {
        this.field_73839_d.field_71424_I.func_76320_a("jumpBar");
        this.field_73839_d.func_110434_K().func_110577_a(Gui.field_110324_m);
        float f = this.field_73839_d.field_71439_g.func_110319_bJ();
        int \u26032 = 182;
        int \u26033 = (int)(f * 183.0f);
        int \u26034 = this.field_194812_I - 32 + 3;
        this.func_73729_b(n, \u26034, 0, 84, 182, 5);
        if (\u26033 > 0) {
            this.func_73729_b(n, \u26034, 0, 89, \u26033, 5);
        }
        this.field_73839_d.field_71424_I.func_76319_b();
    }

    public void func_194804_b(int n) {
        this.field_73839_d.field_71424_I.func_76320_a("expBar");
        this.field_73839_d.func_110434_K().func_110577_a(Gui.field_110324_m);
        \u2603 = this.field_73839_d.field_71439_g.func_71050_bK();
        if (\u2603 > 0) {
            \u2603 = 182;
            \u26032 = (int)(this.field_73839_d.field_71439_g.field_71106_cc * 183.0f);
            \u26033 = this.field_194812_I - 32 + 3;
            this.func_73729_b(n, \u26033, 0, 64, 182, 5);
            if (\u26032 > 0) {
                this.func_73729_b(n, \u26033, 0, 69, \u26032, 5);
            }
        }
        this.field_73839_d.field_71424_I.func_76319_b();
        if (this.field_73839_d.field_71439_g.field_71068_ca > 0) {
            this.field_73839_d.field_71424_I.func_76320_a("expLevel");
            String string = "" + this.field_73839_d.field_71439_g.field_71068_ca;
            int \u26032 = (this.field_194811_H - this.func_175179_f().func_78256_a(string)) / 2;
            int \u26033 = this.field_194812_I - 31 - 4;
            this.func_175179_f().func_211126_b(string, \u26032 + 1, \u26033, 0);
            this.func_175179_f().func_211126_b(string, \u26032 - 1, \u26033, 0);
            this.func_175179_f().func_211126_b(string, \u26032, \u26033 + 1, 0);
            this.func_175179_f().func_211126_b(string, \u26032, \u26033 - 1, 0);
            this.func_175179_f().func_211126_b(string, \u26032, \u26033, 8453920);
            this.field_73839_d.field_71424_I.func_76319_b();
        }
    }

    public void func_194801_c() {
        this.field_73839_d.field_71424_I.func_76320_a("selectedItemName");
        if (this.field_92017_k > 0 && !this.field_92016_l.func_190926_b()) {
            int n;
            ITextComponent iTextComponent = new TextComponentString("").func_150257_a(this.field_92016_l.func_200301_q()).func_211708_a(this.field_92016_l.func_77953_t().field_77937_e);
            if (this.field_92016_l.func_82837_s()) {
                iTextComponent.func_211708_a(TextFormatting.ITALIC);
            }
            String \u26032 = iTextComponent.func_150254_d();
            int \u26033 = (this.field_194811_H - this.func_175179_f().func_78256_a(\u26032)) / 2;
            int \u26034 = this.field_194812_I - 59;
            if (!this.field_73839_d.field_71442_b.func_78755_b()) {
                \u26034 += 14;
            }
            if ((n = (int)((float)this.field_92017_k * 256.0f / 10.0f)) > 255) {
                n = 255;
            }
            if (n > 0) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
                this.func_175179_f().func_175063_a(\u26032, \u26033, \u26034, 0xFFFFFF + (n << 24));
                GlStateManager.func_179084_k();
                GlStateManager.func_179121_F();
            }
        }
        this.field_73839_d.field_71424_I.func_76319_b();
    }

    public void func_194810_d() {
        this.field_73839_d.field_71424_I.func_76320_a("demo");
        String string = this.field_73839_d.field_71441_e.func_82737_E() >= 120500L ? I18n.func_135052_a("demo.demoExpired", new Object[0]) : I18n.func_135052_a("demo.remainingTime", StringUtils.func_76337_a((int)(120500L - this.field_73839_d.field_71441_e.func_82737_E())));
        int \u26032 = this.func_175179_f().func_78256_a(string);
        this.func_175179_f().func_175063_a(string, this.field_194811_H - \u26032 - 10, 5.0f, 0xFFFFFF);
        this.field_73839_d.field_71424_I.func_76319_b();
    }

    private void func_194802_a(ScoreObjective scoreObjective) {
        Scoreboard scoreboard = scoreObjective.func_96682_a();
        List<Object> \u26032 = scoreboard.func_96534_i(scoreObjective);
        List \u26033 = \u26032.stream().filter(score -> score.func_96653_e() != null && !score.func_96653_e().startsWith("#")).collect(Collectors.toList());
        \u26032 = \u26033.size() > 15 ? Lists.newArrayList((Iterable)Iterables.skip(\u26033, (int)(\u26032.size() - 15))) : \u26033;
        String \u26034 = scoreObjective.func_96678_d().func_150254_d();
        int \u26035 = \u2603 = this.func_175179_f().func_78256_a(\u26034);
        for (Score score2 : \u26032) {
            ScorePlayerTeam scorePlayerTeam = scoreboard.func_96509_i(score2.func_96653_e());
            String \u26036 = ScorePlayerTeam.func_200541_a(scorePlayerTeam, new TextComponentString(score2.func_96653_e())).func_150254_d() + ": " + (Object)((Object)TextFormatting.RED) + score2.func_96652_c();
            \u26035 = Math.max(\u26035, this.func_175179_f().func_78256_a(\u26036));
        }
        int n = \u26032.size() * this.func_175179_f().field_78288_b;
        \u2603 = this.field_194812_I / 2 + n / 3;
        \u2603 = 3;
        \u2603 = this.field_194811_H - \u26035 - 3;
        \u2603 = 0;
        for (Score score3 : \u26032) {
            ScorePlayerTeam scorePlayerTeam = scoreboard.func_96509_i(score3.func_96653_e());
            String \u26037 = ScorePlayerTeam.func_200541_a(scorePlayerTeam, new TextComponentString(score3.func_96653_e())).func_150254_d();
            String \u26038 = (Object)((Object)TextFormatting.RED) + "" + score3.func_96652_c();
            int \u26039 = \u2603;
            int \u260310 = \u2603 - ++\u2603 * this.func_175179_f().field_78288_b;
            int \u260311 = this.field_194811_H - 3 + 2;
            GuiIngame.func_73734_a(\u26039 - 2, \u260310, \u260311, \u260310 + this.func_175179_f().field_78288_b, 0x50000000);
            this.func_175179_f().func_211126_b(\u26037, \u26039, \u260310, 0x20FFFFFF);
            this.func_175179_f().func_211126_b(\u26038, \u260311 - this.func_175179_f().func_78256_a(\u26038), \u260310, 0x20FFFFFF);
            if (\u2603 != \u26032.size()) continue;
            GuiIngame.func_73734_a(\u26039 - 2, \u260310 - this.func_175179_f().field_78288_b - 1, \u260311, \u260310 - 1, 0x60000000);
            GuiIngame.func_73734_a(\u26039 - 2, \u260310 - 1, \u260311, \u260310, 0x50000000);
            this.func_175179_f().func_211126_b(\u26034, \u26039 + \u26035 / 2 - \u2603 / 2, \u260310 - this.func_175179_f().field_78288_b, 0x20FFFFFF);
        }
    }

    private EntityPlayer func_212304_m() {
        if (!(this.field_73839_d.func_175606_aa() instanceof EntityPlayer)) {
            return null;
        }
        return (EntityPlayer)this.field_73839_d.func_175606_aa();
    }

    private EntityLivingBase func_212305_n() {
        EntityPlayer entityPlayer = this.func_212304_m();
        if (entityPlayer != null) {
            Entity entity = entityPlayer.func_184187_bx();
            if (entity == null) {
                return null;
            }
            if (entity instanceof EntityLivingBase) {
                return (EntityLivingBase)entity;
            }
        }
        return null;
    }

    private int func_212306_a(EntityLivingBase entityLivingBase) {
        if (entityLivingBase == null || !entityLivingBase.func_203003_aK()) {
            return 0;
        }
        float f = entityLivingBase.func_110138_aP();
        int \u26032 = (int)(f + 0.5f) / 2;
        if (\u26032 > 30) {
            \u26032 = 30;
        }
        return \u26032;
    }

    private int func_212302_c(int n) {
        return (int)Math.ceil((double)n / 10.0);
    }

    private void func_194807_n() {
        int \u260322;
        int n;
        EntityPlayer entityPlayer = this.func_212304_m();
        if (entityPlayer == null) {
            return;
        }
        int \u26032 = MathHelper.func_76123_f(entityPlayer.func_110143_aJ());
        boolean \u26033 = this.field_175191_F > (long)this.field_73837_f && (this.field_175191_F - (long)this.field_73837_f) / 3L % 2L == 1L;
        long \u26034 = Util.func_211177_b();
        if (\u26032 < this.field_175194_C && entityPlayer.field_70172_ad > 0) {
            this.field_175190_E = \u26034;
            this.field_175191_F = this.field_73837_f + 20;
        } else if (\u26032 > this.field_175194_C && entityPlayer.field_70172_ad > 0) {
            this.field_175190_E = \u26034;
            this.field_175191_F = this.field_73837_f + 10;
        }
        if (\u26034 - this.field_175190_E > 1000L) {
            this.field_175194_C = \u26032;
            this.field_175189_D = \u26032;
            this.field_175190_E = \u26034;
        }
        this.field_175194_C = \u26032;
        int \u26035 = this.field_175189_D;
        this.field_73842_c.setSeed(this.field_73837_f * 312871);
        FoodStats \u26036 = entityPlayer.func_71024_bL();
        int \u26037 = \u26036.func_75116_a();
        IAttributeInstance \u26038 = entityPlayer.func_110148_a(SharedMonsterAttributes.field_111267_a);
        int \u26039 = this.field_194811_H / 2 - 91;
        int \u260310 = this.field_194811_H / 2 + 91;
        int \u260311 = this.field_194812_I - 39;
        float \u260312 = (float)\u26038.func_111126_e();
        int \u260313 = MathHelper.func_76123_f(entityPlayer.func_110139_bj());
        int \u260314 = MathHelper.func_76123_f((\u260312 + (float)\u260313) / 2.0f / 10.0f);
        int \u260315 = Math.max(10 - (\u260314 - 2), 3);
        int \u260316 = \u260311 - (\u260314 - 1) * \u260315 - 10;
        int \u260317 = \u260311 - 10;
        int \u260318 = \u260313;
        int \u260319 = entityPlayer.func_70658_aO();
        int \u260320 = -1;
        if (entityPlayer.func_70644_a(MobEffects.field_76428_l)) {
            \u260320 = this.field_73837_f % MathHelper.func_76123_f(\u260312 + 5.0f);
        }
        this.field_73839_d.field_71424_I.func_76320_a("armor");
        for (n = 0; n < 10; ++n) {
            if (\u260319 <= 0) continue;
            \u260321 = \u26039 + n * 8;
            if (n * 2 + 1 < \u260319) {
                this.func_73729_b(\u260321, \u260316, 34, 9, 9, 9);
            }
            if (n * 2 + 1 == \u260319) {
                this.func_73729_b(\u260321, \u260316, 25, 9, 9, 9);
            }
            if (n * 2 + 1 <= \u260319) continue;
            this.func_73729_b(\u260321, \u260316, 16, 9, 9, 9);
        }
        this.field_73839_d.field_71424_I.func_76318_c("health");
        for (n = MathHelper.func_76123_f((\u260312 + (float)\u260313) / 2.0f) - 1; n >= 0; --n) {
            \u260321 = 16;
            if (entityPlayer.func_70644_a(MobEffects.field_76436_u)) {
                \u260321 += 36;
            } else if (entityPlayer.func_70644_a(MobEffects.field_82731_v)) {
                \u260321 += 72;
            }
            \u260322 = 0;
            if (\u26033) {
                \u260322 = 1;
            }
            \u260323 = MathHelper.func_76123_f((float)(n + 1) / 10.0f) - 1;
            n2 = \u26039 + n % 10 * 8;
            \u2603 = \u260311 - \u260323 * \u260315;
            if (\u26032 <= 4) {
                \u2603 += this.field_73842_c.nextInt(2);
            }
            if (\u260318 <= 0 && n == \u260320) {
                \u2603 -= 2;
            }
            \u2603 = 0;
            if (entityPlayer.field_70170_p.func_72912_H().func_76093_s()) {
                \u2603 = 5;
            }
            this.func_73729_b(n2, \u2603, 16 + \u260322 * 9, 9 * \u2603, 9, 9);
            if (\u26033) {
                if (n * 2 + 1 < \u26035) {
                    this.func_73729_b(n2, \u2603, \u260321 + 54, 9 * \u2603, 9, 9);
                }
                if (n * 2 + 1 == \u26035) {
                    this.func_73729_b(n2, \u2603, \u260321 + 63, 9 * \u2603, 9, 9);
                }
            }
            if (\u260318 > 0) {
                if (\u260318 == \u260313 && \u260313 % 2 == 1) {
                    this.func_73729_b(n2, \u2603, \u260321 + 153, 9 * \u2603, 9, 9);
                    --\u260318;
                    continue;
                }
                this.func_73729_b(n2, \u2603, \u260321 + 144, 9 * \u2603, 9, 9);
                \u260318 -= 2;
                continue;
            }
            if (n * 2 + 1 < \u26032) {
                this.func_73729_b(n2, \u2603, \u260321 + 36, 9 * \u2603, 9, 9);
            }
            if (n * 2 + 1 != \u26032) continue;
            this.func_73729_b(n2, \u2603, \u260321 + 45, 9 * \u2603, 9, 9);
        }
        EntityLivingBase entityLivingBase = this.func_212305_n();
        int \u260321 = this.func_212306_a(entityLivingBase);
        if (\u260321 == 0) {
            this.field_73839_d.field_71424_I.func_76318_c("food");
            for (\u260322 = 0; \u260322 < 10; ++\u260322) {
                \u260323 = \u260311;
                n2 = 16;
                \u2603 = 0;
                if (entityPlayer.func_70644_a(MobEffects.field_76438_s)) {
                    n2 += 36;
                    \u2603 = 13;
                }
                if (entityPlayer.func_71024_bL().func_75115_e() <= 0.0f && this.field_73837_f % (\u26037 * 3 + 1) == 0) {
                    \u260323 += this.field_73842_c.nextInt(3) - 1;
                }
                \u2603 = \u260310 - \u260322 * 8 - 9;
                this.func_73729_b(\u2603, \u260323, 16 + \u2603 * 9, 27, 9, 9);
                if (\u260322 * 2 + 1 < \u26037) {
                    this.func_73729_b(\u2603, \u260323, n2 + 36, 27, 9, 9);
                }
                if (\u260322 * 2 + 1 != \u26037) continue;
                this.func_73729_b(\u2603, \u260323, n2 + 45, 27, 9, 9);
            }
            \u260317 -= 10;
        }
        this.field_73839_d.field_71424_I.func_76318_c("air");
        \u260322 = entityPlayer.func_70086_ai();
        int \u260323 = entityPlayer.func_205010_bg();
        if (entityPlayer.func_208600_a(FluidTags.field_206959_a) || \u260322 < \u260323) {
            int n2 = this.func_212302_c(\u260321) - 1;
            \u260317 -= n2 * 10;
            \u2603 = MathHelper.func_76143_f((double)(\u260322 - 2) * 10.0 / (double)\u260323);
            \u2603 = MathHelper.func_76143_f((double)\u260322 * 10.0 / (double)\u260323) - \u2603;
            for (\u2603 = 0; \u2603 < \u2603 + \u2603; ++\u2603) {
                if (\u2603 < \u2603) {
                    this.func_73729_b(\u260310 - \u2603 * 8 - 9, \u260317, 16, 18, 9, 9);
                    continue;
                }
                this.func_73729_b(\u260310 - \u2603 * 8 - 9, \u260317, 25, 18, 9, 9);
            }
        }
        this.field_73839_d.field_71424_I.func_76319_b();
    }

    private void func_194799_o() {
        EntityLivingBase entityLivingBase = this.func_212305_n();
        if (entityLivingBase == null) {
            return;
        }
        int \u26032 = this.func_212306_a(entityLivingBase);
        if (\u26032 == 0) {
            return;
        }
        int \u26033 = (int)Math.ceil(entityLivingBase.func_110143_aJ());
        this.field_73839_d.field_71424_I.func_76318_c("mountHealth");
        int \u26034 = this.field_194812_I - 39;
        int \u26035 = this.field_194811_H / 2 + 91;
        int \u26036 = \u26034;
        int \u26037 = 0;
        boolean \u26038 = false;
        while (\u26032 > 0) {
            int n = Math.min(\u26032, 10);
            \u26032 -= n;
            for (\u2603 = 0; \u2603 < n; ++\u2603) {
                \u2603 = 52;
                \u2603 = 0;
                \u2603 = \u26035 - \u2603 * 8 - 9;
                this.func_73729_b(\u2603, \u26036, 52 + \u2603 * 9, 9, 9, 9);
                if (\u2603 * 2 + 1 + \u26037 < \u26033) {
                    this.func_73729_b(\u2603, \u26036, 88, 9, 9, 9);
                }
                if (\u2603 * 2 + 1 + \u26037 != \u26033) continue;
                this.func_73729_b(\u2603, \u26036, 97, 9, 9, 9);
            }
            \u26036 -= 10;
            \u26037 += 20;
        }
    }

    private void func_194808_p() {
        GlStateManager.func_179097_i();
        GlStateManager.func_179132_a(false);
        GlStateManager.func_187428_a(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.func_179118_c();
        this.field_73839_d.func_110434_K().func_110577_a(field_110328_d);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder \u26032 = tessellator.func_178180_c();
        \u26032.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        \u26032.func_181662_b(0.0, this.field_194812_I, -90.0).func_187315_a(0.0, 1.0).func_181675_d();
        \u26032.func_181662_b(this.field_194811_H, this.field_194812_I, -90.0).func_187315_a(1.0, 1.0).func_181675_d();
        \u26032.func_181662_b(this.field_194811_H, 0.0, -90.0).func_187315_a(1.0, 0.0).func_181675_d();
        \u26032.func_181662_b(0.0, 0.0, -90.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179132_a(true);
        GlStateManager.func_179126_j();
        GlStateManager.func_179141_d();
        GlStateManager.func_179131_c(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void func_212307_a(Entity entity) {
        if (entity == null) {
            return;
        }
        float f = MathHelper.func_76131_a(1.0f - entity.func_70013_c(), 0.0f, 1.0f);
        this.field_73843_a = (float)((double)this.field_73843_a + (double)(f - this.field_73843_a) * 0.01);
    }

    private void func_212303_b(Entity entity) {
        WorldBorder worldBorder = this.field_73839_d.field_71441_e.func_175723_af();
        float \u26032 = (float)worldBorder.func_177745_a(entity);
        double \u26033 = Math.min(worldBorder.func_177749_o() * (double)worldBorder.func_177740_p() * 1000.0, Math.abs(worldBorder.func_177751_j() - worldBorder.func_177741_h()));
        double \u26034 = Math.max((double)worldBorder.func_177748_q(), \u26033);
        \u26032 = (double)\u26032 < \u26034 ? 1.0f - (float)((double)\u26032 / \u26034) : 0.0f;
        GlStateManager.func_179097_i();
        GlStateManager.func_179132_a(false);
        GlStateManager.func_187428_a(GlStateManager.SourceFactor.ZERO, GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        if (\u26032 > 0.0f) {
            GlStateManager.func_179131_c(0.0f, \u26032, \u26032, 1.0f);
        } else {
            GlStateManager.func_179131_c(this.field_73843_a, this.field_73843_a, this.field_73843_a, 1.0f);
        }
        this.field_73839_d.func_110434_K().func_110577_a(field_110329_b);
        Tessellator \u26035 = Tessellator.func_178181_a();
        BufferBuilder \u26036 = \u26035.func_178180_c();
        \u26036.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        \u26036.func_181662_b(0.0, this.field_194812_I, -90.0).func_187315_a(0.0, 1.0).func_181675_d();
        \u26036.func_181662_b(this.field_194811_H, this.field_194812_I, -90.0).func_187315_a(1.0, 1.0).func_181675_d();
        \u26036.func_181662_b(this.field_194811_H, 0.0, -90.0).func_187315_a(1.0, 0.0).func_181675_d();
        \u26036.func_181662_b(0.0, 0.0, -90.0).func_187315_a(0.0, 0.0).func_181675_d();
        \u26035.func_78381_a();
        GlStateManager.func_179132_a(true);
        GlStateManager.func_179126_j();
        GlStateManager.func_179131_c(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.func_187428_a(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
    }

    private void func_194805_e(float f) {
        if (f < 1.0f) {
            f *= f;
            f *= f;
            f = f * 0.8f + 0.2f;
        }
        GlStateManager.func_179118_c();
        GlStateManager.func_179097_i();
        GlStateManager.func_179132_a(false);
        GlStateManager.func_187428_a(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c(1.0f, 1.0f, 1.0f, f);
        this.field_73839_d.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        TextureAtlasSprite textureAtlasSprite = this.field_73839_d.func_175602_ab().func_175023_a().func_178122_a(Blocks.field_150427_aO.func_176223_P());
        float \u26032 = textureAtlasSprite.func_94209_e();
        float \u26033 = textureAtlasSprite.func_94206_g();
        float \u26034 = textureAtlasSprite.func_94212_f();
        float \u26035 = textureAtlasSprite.func_94210_h();
        Tessellator \u26036 = Tessellator.func_178181_a();
        BufferBuilder \u26037 = \u26036.func_178180_c();
        \u26037.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        \u26037.func_181662_b(0.0, this.field_194812_I, -90.0).func_187315_a(\u26032, \u26035).func_181675_d();
        \u26037.func_181662_b(this.field_194811_H, this.field_194812_I, -90.0).func_187315_a(\u26034, \u26035).func_181675_d();
        \u26037.func_181662_b(this.field_194811_H, 0.0, -90.0).func_187315_a(\u26034, \u26033).func_181675_d();
        \u26037.func_181662_b(0.0, 0.0, -90.0).func_187315_a(\u26032, \u26033).func_181675_d();
        \u26036.func_78381_a();
        GlStateManager.func_179132_a(true);
        GlStateManager.func_179126_j();
        GlStateManager.func_179141_d();
        GlStateManager.func_179131_c(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void func_184044_a(int n, int n2, float f, EntityPlayer entityPlayer, ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return;
        }
        float f2 = (float)itemStack.func_190921_D() - f;
        if (f2 > 0.0f) {
            GlStateManager.func_179094_E();
            \u2603 = 1.0f + f2 / 5.0f;
            GlStateManager.func_179109_b(n + 8, n2 + 12, 0.0f);
            GlStateManager.func_179152_a(1.0f / \u2603, (\u2603 + 1.0f) / 2.0f, 1.0f);
            GlStateManager.func_179109_b(-(n + 8), -(n2 + 12), 0.0f);
        }
        this.field_73841_b.func_184391_a(entityPlayer, itemStack, n, n2);
        if (f2 > 0.0f) {
            GlStateManager.func_179121_F();
        }
        this.field_73841_b.func_175030_a(this.field_73839_d.field_71466_p, itemStack, n, n2);
    }

    public void func_73831_a() {
        if (this.field_73845_h > 0) {
            --this.field_73845_h;
        }
        if (this.field_175195_w > 0) {
            --this.field_175195_w;
            if (this.field_175195_w <= 0) {
                this.field_175201_x = "";
                this.field_175200_y = "";
            }
        }
        ++this.field_73837_f;
        Entity entity = this.field_73839_d.func_175606_aa();
        if (entity != null) {
            this.func_212307_a(entity);
        }
        if (this.field_73839_d.field_71439_g != null) {
            ItemStack itemStack = this.field_73839_d.field_71439_g.field_71071_by.func_70448_g();
            if (itemStack.func_190926_b()) {
                this.field_92017_k = 0;
            } else if (this.field_92016_l.func_190926_b() || itemStack.func_77973_b() != this.field_92016_l.func_77973_b() || !itemStack.func_200301_q().equals(this.field_92016_l.func_200301_q())) {
                this.field_92017_k = 40;
            } else if (this.field_92017_k > 0) {
                --this.field_92017_k;
            }
            this.field_92016_l = itemStack;
        }
    }

    public void func_73833_a(String string) {
        this.func_110326_a(I18n.func_135052_a("record.nowPlaying", string), true);
    }

    public void func_110326_a(String string, boolean bl) {
        this.field_73838_g = string;
        this.field_73845_h = 60;
        this.field_73844_j = bl;
    }

    public void func_175178_a(String string, String string2, int n, int n2, int n3) {
        if (string == null && string2 == null && n < 0 && n2 < 0 && n3 < 0) {
            this.field_175201_x = "";
            this.field_175200_y = "";
            this.field_175195_w = 0;
            return;
        }
        if (string != null) {
            this.field_175201_x = string;
            this.field_175195_w = this.field_175199_z + this.field_175192_A + this.field_175193_B;
            return;
        }
        if (string2 != null) {
            this.field_175200_y = string2;
            return;
        }
        if (n >= 0) {
            this.field_175199_z = n;
        }
        if (n2 >= 0) {
            this.field_175192_A = n2;
        }
        if (n3 >= 0) {
            this.field_175193_B = n3;
        }
        if (this.field_175195_w > 0) {
            this.field_175195_w = this.field_175199_z + this.field_175192_A + this.field_175193_B;
        }
    }

    public void func_175188_a(ITextComponent iTextComponent, boolean bl) {
        this.func_110326_a(iTextComponent.getString(), bl);
    }

    public void func_191742_a(ChatType chatType, ITextComponent iTextComponent) {
        for (IChatListener iChatListener : this.field_191743_I.get((Object)chatType)) {
            iChatListener.func_192576_a(chatType, iTextComponent);
        }
    }

    public GuiNewChat func_146158_b() {
        return this.field_73840_e;
    }

    public int func_73834_c() {
        return this.field_73837_f;
    }

    public FontRenderer func_175179_f() {
        return this.field_73839_d.field_71466_p;
    }

    public GuiSpectator func_175187_g() {
        return this.field_175197_u;
    }

    public GuiPlayerTabOverlay func_175181_h() {
        return this.field_175196_v;
    }

    public void func_181029_i() {
        this.field_175196_v.func_181030_a();
        this.field_184050_w.func_184057_b();
        this.field_73839_d.func_193033_an().func_191788_b();
    }

    public GuiBossOverlay func_184046_j() {
        return this.field_184050_w;
    }
}

