/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.hash.Hashing;
import java.io.File;
import java.io.FileInputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiConfirmBackup;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiListWorldSelection;
import net.minecraft.client.gui.GuiScreenAlert;
import net.minecraft.client.gui.GuiScreenWorking;
import net.minecraft.client.gui.GuiWorldEdit;
import net.minecraft.client.gui.GuiWorldSelection;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraft.world.storage.WorldSummary;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class GuiListWorldSelectionEntry
extends GuiListExtended.IGuiListEntry<GuiListWorldSelectionEntry>
implements AutoCloseable {
    private static final Logger field_186780_a = LogManager.getLogger();
    private static final DateFormat field_186781_b = new SimpleDateFormat();
    private static final ResourceLocation field_186782_c = new ResourceLocation("textures/misc/unknown_server.png");
    private static final ResourceLocation field_186783_d = new ResourceLocation("textures/gui/world_selection.png");
    private final Minecraft field_186784_e;
    private final GuiWorldSelection field_186785_f;
    private final WorldSummary field_186786_g;
    private final ResourceLocation field_186787_h;
    private final GuiListWorldSelection field_186788_i;
    private File field_186789_j;
    @Nullable
    private final DynamicTexture field_186790_k;
    private long field_186791_l;

    public GuiListWorldSelectionEntry(GuiListWorldSelection guiListWorldSelection, WorldSummary worldSummary, ISaveFormat iSaveFormat) {
        this.field_186788_i = guiListWorldSelection;
        this.field_186785_f = guiListWorldSelection.func_186796_g();
        this.field_186786_g = worldSummary;
        this.field_186784_e = Minecraft.func_71410_x();
        this.field_186787_h = new ResourceLocation("worlds/" + Hashing.sha1().hashUnencodedChars((CharSequence)worldSummary.func_75786_a()) + "/icon");
        this.field_186789_j = iSaveFormat.func_186352_b(worldSummary.func_75786_a(), "icon.png");
        if (!this.field_186789_j.isFile()) {
            this.field_186789_j = null;
        }
        this.field_186790_k = this.func_195033_j();
    }

    @Override
    public void func_194999_a(int n, int n2, int n3, int n4, boolean bl, float f) {
        int n5;
        int n6 = this.func_195001_c();
        n5 = this.func_195002_d();
        String \u26032 = this.field_186786_g.func_75788_b();
        String \u26033 = this.field_186786_g.func_75786_a() + " (" + field_186781_b.format(new Date(this.field_186786_g.func_75784_e())) + ")";
        String \u26034 = "";
        if (StringUtils.isEmpty((CharSequence)\u26032)) {
            \u26032 = I18n.func_135052_a("selectWorld.world", new Object[0]) + " " + (this.func_195003_b() + 1);
        }
        if (this.field_186786_g.func_75785_d()) {
            \u26034 = I18n.func_135052_a("selectWorld.conversion", new Object[0]) + " " + \u26034;
        } else {
            \u26034 = I18n.func_135052_a("gameMode." + this.field_186786_g.func_75790_f().func_77149_b(), new Object[0]);
            if (this.field_186786_g.func_75789_g()) {
                \u26034 = (Object)((Object)TextFormatting.DARK_RED) + I18n.func_135052_a("gameMode.hardcore", new Object[0]) + (Object)((Object)TextFormatting.RESET);
            }
            if (this.field_186786_g.func_75783_h()) {
                \u26034 = \u26034 + ", " + I18n.func_135052_a("selectWorld.cheats", new Object[0]);
            }
            String string = this.field_186786_g.func_200538_i().func_150254_d();
            \u26034 = this.field_186786_g.func_186355_l() ? (this.field_186786_g.func_186356_m() ? \u26034 + ", " + I18n.func_135052_a("selectWorld.version", new Object[0]) + " " + (Object)((Object)TextFormatting.RED) + string + (Object)((Object)TextFormatting.RESET) : \u26034 + ", " + I18n.func_135052_a("selectWorld.version", new Object[0]) + " " + (Object)((Object)TextFormatting.ITALIC) + string + (Object)((Object)TextFormatting.RESET)) : \u26034 + ", " + I18n.func_135052_a("selectWorld.version", new Object[0]) + " " + string;
        }
        this.field_186784_e.field_71466_p.func_211126_b(\u26032, n5 + 32 + 3, n6 + 1, 0xFFFFFF);
        this.field_186784_e.field_71466_p.func_211126_b(\u26033, n5 + 32 + 3, n6 + this.field_186784_e.field_71466_p.field_78288_b + 3, 0x808080);
        this.field_186784_e.field_71466_p.func_211126_b(\u26034, n5 + 32 + 3, n6 + this.field_186784_e.field_71466_p.field_78288_b + this.field_186784_e.field_71466_p.field_78288_b + 3, 0x808080);
        GlStateManager.func_179131_c(1.0f, 1.0f, 1.0f, 1.0f);
        this.field_186784_e.func_110434_K().func_110577_a(this.field_186790_k != null ? this.field_186787_h : field_186782_c);
        GlStateManager.func_179147_l();
        Gui.func_146110_a(n5, n6, 0.0f, 0.0f, 32, 32, 32.0f, 32.0f);
        GlStateManager.func_179084_k();
        if (this.field_186784_e.field_71474_y.field_85185_A || bl) {
            this.field_186784_e.func_110434_K().func_110577_a(field_186783_d);
            Gui.func_73734_a(n5, n6, n5 + 32, n6 + 32, -1601138544);
            GlStateManager.func_179131_c(1.0f, 1.0f, 1.0f, 1.0f);
            \u2603 = n3 - n5;
            int n7 = \u2603 = \u2603 < 32 ? 32 : 0;
            if (this.field_186786_g.func_186355_l()) {
                Gui.func_146110_a(n5, n6, 32.0f, \u2603, 32, 32, 256.0f, 256.0f);
                if (this.field_186786_g.func_202842_n()) {
                    Gui.func_146110_a(n5, n6, 96.0f, \u2603, 32, 32, 256.0f, 256.0f);
                    if (\u2603 < 32) {
                        ITextComponent iTextComponent = new TextComponentTranslation("selectWorld.tooltip.unsupported", this.field_186786_g.func_200538_i()).func_211708_a(TextFormatting.RED);
                        this.field_186785_f.func_184861_a(this.field_186784_e.field_71466_p.func_78280_d(iTextComponent.func_150254_d(), 175));
                    }
                } else if (this.field_186786_g.func_186356_m()) {
                    Gui.func_146110_a(n5, n6, 96.0f, \u2603, 32, 32, 256.0f, 256.0f);
                    if (\u2603 < 32) {
                        this.field_186785_f.func_184861_a((Object)((Object)TextFormatting.RED) + I18n.func_135052_a("selectWorld.tooltip.fromNewerVersion1", new Object[0]) + "\n" + (Object)((Object)TextFormatting.RED) + I18n.func_135052_a("selectWorld.tooltip.fromNewerVersion2", new Object[0]));
                    }
                }
            } else {
                Gui.func_146110_a(n5, n6, 0.0f, \u2603, 32, 32, 256.0f, 256.0f);
            }
        }
    }

    @Override
    public boolean mouseClicked(double d, double d2, int n) {
        this.field_186788_i.func_186792_d(this.func_195003_b());
        if (d - (double)this.func_195002_d() <= 32.0) {
            this.func_186774_a();
            return true;
        }
        if (Util.func_211177_b() - this.field_186791_l < 250L) {
            this.func_186774_a();
            return true;
        }
        this.field_186791_l = Util.func_211177_b();
        return false;
    }

    public void func_186774_a() {
        if (this.field_186786_g.func_197731_n() || this.field_186786_g.func_202842_n()) {
            String string = I18n.func_135052_a("selectWorld.backupQuestion", new Object[0]);
            \u2603 = I18n.func_135052_a("selectWorld.backupWarning", this.field_186786_g.func_200538_i().func_150254_d(), "1.13.2");
            if (this.field_186786_g.func_202842_n()) {
                string = I18n.func_135052_a("selectWorld.backupQuestion.customized", new Object[0]);
                \u2603 = I18n.func_135052_a("selectWorld.backupWarning.customized", new Object[0]);
            }
            this.field_186784_e.func_147108_a(new GuiConfirmBackup(this.field_186785_f, bl -> {
                if (bl) {
                    String string = this.field_186786_g.func_75786_a();
                    GuiWorldEdit.func_200212_a(this.field_186784_e.func_71359_d(), string);
                }
                this.func_186777_e();
            }, string, \u2603));
        } else if (this.field_186786_g.func_186356_m()) {
            this.field_186784_e.func_147108_a(new GuiYesNo((bl, n) -> {
                if (bl) {
                    try {
                        this.func_186777_e();
                    }
                    catch (Exception exception) {
                        field_186780_a.error("Failure to open 'future world'", (Throwable)exception);
                        this.field_186784_e.func_147108_a(new GuiScreenAlert(() -> this.field_186784_e.func_147108_a(this.field_186785_f), new TextComponentTranslation("selectWorld.futureworld.error.title", new Object[0]), new TextComponentTranslation("selectWorld.futureworld.error.text", new Object[0])));
                    }
                } else {
                    this.field_186784_e.func_147108_a(this.field_186785_f);
                }
            }, I18n.func_135052_a("selectWorld.versionQuestion", new Object[0]), I18n.func_135052_a("selectWorld.versionWarning", this.field_186786_g.func_200538_i().func_150254_d()), I18n.func_135052_a("selectWorld.versionJoinButton", new Object[0]), I18n.func_135052_a("gui.cancel", new Object[0]), 0));
        } else {
            this.func_186777_e();
        }
    }

    public void func_186776_b() {
        this.field_186784_e.func_147108_a(new GuiYesNo((bl, n) -> {
            if (bl) {
                this.field_186784_e.func_147108_a(new GuiScreenWorking());
                ISaveFormat iSaveFormat = this.field_186784_e.func_71359_d();
                iSaveFormat.func_75800_d();
                iSaveFormat.func_75802_e(this.field_186786_g.func_75786_a());
                this.field_186788_i.func_212330_a(() -> this.field_186785_f.field_212352_g.func_146179_b(), true);
            }
            this.field_186784_e.func_147108_a(this.field_186785_f);
        }, I18n.func_135052_a("selectWorld.deleteQuestion", new Object[0]), I18n.func_135052_a("selectWorld.deleteWarning", this.field_186786_g.func_75788_b()), I18n.func_135052_a("selectWorld.deleteButton", new Object[0]), I18n.func_135052_a("gui.cancel", new Object[0]), 0));
    }

    public void func_186778_c() {
        this.field_186784_e.func_147108_a(new GuiWorldEdit((bl, n) -> {
            if (bl) {
                this.field_186788_i.func_212330_a(() -> this.field_186785_f.field_212352_g.func_146179_b(), true);
            }
            this.field_186784_e.func_147108_a(this.field_186785_f);
        }, this.field_186786_g.func_75786_a()));
    }

    public void func_186779_d() {
        try {
            this.field_186784_e.func_147108_a(new GuiScreenWorking());
            GuiCreateWorld guiCreateWorld = new GuiCreateWorld(this.field_186785_f);
            ISaveHandler \u26032 = this.field_186784_e.func_71359_d().func_197715_a(this.field_186786_g.func_75786_a(), null);
            WorldInfo \u26033 = \u26032.func_75757_d();
            \u26032.func_75759_a();
            if (\u26033 != null) {
                guiCreateWorld.func_146318_a(\u26033);
                if (this.field_186786_g.func_202842_n()) {
                    this.field_186784_e.func_147108_a(new GuiYesNo((bl, n) -> {
                        if (bl) {
                            this.field_186784_e.func_147108_a(guiCreateWorld);
                        } else {
                            this.field_186784_e.func_147108_a(this.field_186785_f);
                        }
                    }, I18n.func_135052_a("selectWorld.recreate.customized.title", new Object[0]), I18n.func_135052_a("selectWorld.recreate.customized.text", new Object[0]), I18n.func_135052_a("gui.proceed", new Object[0]), I18n.func_135052_a("gui.cancel", new Object[0]), 0));
                } else {
                    this.field_186784_e.func_147108_a(guiCreateWorld);
                }
            }
        }
        catch (Exception exception) {
            field_186780_a.error("Unable to recreate world", (Throwable)exception);
            this.field_186784_e.func_147108_a(new GuiScreenAlert(() -> this.field_186784_e.func_147108_a(this.field_186785_f), new TextComponentTranslation("selectWorld.recreate.error.title", new Object[0]), new TextComponentTranslation("selectWorld.recreate.error.text", new Object[0])));
        }
    }

    private void func_186777_e() {
        this.field_186784_e.func_147118_V().func_147682_a(SimpleSound.func_184371_a(SoundEvents.field_187909_gi, 1.0f));
        if (this.field_186784_e.func_71359_d().func_90033_f(this.field_186786_g.func_75786_a())) {
            this.field_186784_e.func_71371_a(this.field_186786_g.func_75786_a(), this.field_186786_g.func_75788_b(), null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private DynamicTexture func_195033_j() {
        boolean bl;
        boolean bl2 = bl = this.field_186789_j != null && this.field_186789_j.isFile();
        if (!bl) {
            this.field_186784_e.func_110434_K().func_147645_c(this.field_186787_h);
            return null;
        }
        try (FileInputStream \u26032 = new FileInputStream(this.field_186789_j);){
            NativeImage \u26033 = NativeImage.func_195713_a(\u26032);
            Validate.validState((\u26033.func_195702_a() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
            Validate.validState((\u26033.func_195714_b() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
            DynamicTexture \u26034 = new DynamicTexture(\u26033);
            this.field_186784_e.func_110434_K().func_110579_a(this.field_186787_h, \u26034);
            DynamicTexture dynamicTexture = \u26034;
            return dynamicTexture;
        }
        catch (Throwable throwable6) {
            field_186780_a.error("Invalid icon for world {}", (Object)this.field_186786_g.func_75786_a(), (Object)throwable6);
            this.field_186789_j = null;
            return null;
        }
    }

    @Override
    public void close() {
        if (this.field_186790_k != null) {
            this.field_186790_k.close();
        }
    }

    @Override
    public void func_195000_a(float f) {
    }
}

