/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.network.NetworkManager;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.state.IProperty;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.FrameTimer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceFluidMode;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumLightType;
import net.minecraft.world.ForcedChunksSaveData;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.DimensionType;

public class GuiOverlayDebug
extends Gui {
    private final Minecraft field_175242_a;
    private final FontRenderer field_175241_f;
    private RayTraceResult field_211537_g;
    private RayTraceResult field_211538_h;

    public GuiOverlayDebug(Minecraft minecraft) {
        this.field_175242_a = minecraft;
        this.field_175241_f = minecraft.field_71466_p;
    }

    public void func_194818_a() {
        this.field_175242_a.field_71424_I.func_76320_a("debug");
        GlStateManager.func_179094_E();
        Entity entity = this.field_175242_a.func_175606_aa();
        this.field_211537_g = entity.func_174822_a(20.0, 0.0f, RayTraceFluidMode.NEVER);
        this.field_211538_h = entity.func_174822_a(20.0, 0.0f, RayTraceFluidMode.ALWAYS);
        this.func_180798_a();
        this.func_194819_c();
        GlStateManager.func_179121_F();
        if (this.field_175242_a.field_71474_y.field_181657_aC) {
            this.func_181554_e();
        }
        this.field_175242_a.field_71424_I.func_76319_b();
    }

    protected void func_180798_a() {
        List<String> list = this.func_209011_c();
        list.add("");
        list.add("Debug: Pie [shift]: " + (this.field_175242_a.field_71474_y.field_74329_Q ? "visible" : "hidden") + " FPS [alt]: " + (this.field_175242_a.field_71474_y.field_181657_aC ? "visible" : "hidden"));
        list.add("For help: press F3 + Q");
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (Strings.isNullOrEmpty((String)string)) continue;
            int \u26032 = this.field_175241_f.field_78288_b;
            int \u26033 = this.field_175241_f.func_78256_a(string);
            int \u26034 = 2;
            int \u26035 = 2 + \u26032 * i;
            GuiOverlayDebug.func_73734_a(1, \u26035 - 1, 2 + \u26033 + 1, \u26035 + \u26032 - 1, -1873784752);
            this.field_175241_f.func_211126_b(string, 2.0f, \u26035, 0xE0E0E0);
        }
    }

    protected void func_194819_c() {
        List<String> list = this.func_175238_c();
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (Strings.isNullOrEmpty((String)string)) continue;
            int \u26032 = this.field_175241_f.field_78288_b;
            int \u26033 = this.field_175241_f.func_78256_a(string);
            int \u26034 = this.field_175242_a.field_195558_d.func_198107_o() - 2 - \u26033;
            int \u26035 = 2 + \u26032 * i;
            GuiOverlayDebug.func_73734_a(\u26034 - 1, \u26035 - 1, \u26034 + \u26033 + 1, \u26035 + \u26032 - 1, -1873784752);
            this.field_175241_f.func_211126_b(string, \u26034, \u26035, 0xE0E0E0);
        }
    }

    protected List<String> func_209011_c() {
        Object object;
        IntegratedServer integratedServer = this.field_175242_a.func_71401_C();
        NetworkManager \u26032 = this.field_175242_a.func_147114_u().func_147298_b();
        float \u26033 = \u26032.func_211390_n();
        float \u26034 = \u26032.func_211393_m();
        String \u26035 = integratedServer != null ? String.format("Integrated server @ %.0f ms ticks, %.0f tx, %.0f rx", Float.valueOf(integratedServer.func_211149_aT()), Float.valueOf(\u26033), Float.valueOf(\u26034)) : String.format("\"%s\" server, %.0f tx, %.0f rx", this.field_175242_a.field_71439_g.func_142021_k(), Float.valueOf(\u26033), Float.valueOf(\u26034));
        BlockPos \u26036 = new BlockPos(this.field_175242_a.func_175606_aa().field_70165_t, this.field_175242_a.func_175606_aa().func_174813_aQ().field_72338_b, this.field_175242_a.func_175606_aa().field_70161_v);
        if (this.field_175242_a.func_189648_am()) {
            return Lists.newArrayList((Object[])new String[]{"Minecraft 1.13.2 (" + this.field_175242_a.func_175600_c() + "/" + ClientBrandRetriever.getClientModName() + ")", this.field_175242_a.field_71426_K, \u26035, this.field_175242_a.field_71438_f.func_72735_c(), this.field_175242_a.field_71438_f.func_72723_d(), "P: " + this.field_175242_a.field_71452_i.func_78869_b() + ". T: " + this.field_175242_a.field_71441_e.func_72981_t(), this.field_175242_a.field_71441_e.func_72827_u(), "", String.format("Chunk-relative: %d %d %d", \u26036.func_177958_n() & 0xF, \u26036.func_177956_o() & 0xF, \u26036.func_177952_p() & 0xF)});
        }
        Entity \u26037 = this.field_175242_a.func_175606_aa();
        EnumFacing \u26038 = \u26037.func_174811_aO();
        String \u26039 = "Invalid";
        switch (\u26038) {
            case NORTH: {
                \u26039 = "Towards negative Z";
                break;
            }
            case SOUTH: {
                \u26039 = "Towards positive Z";
                break;
            }
            case WEST: {
                \u26039 = "Towards negative X";
                break;
            }
            case EAST: {
                \u26039 = "Towards positive X";
            }
        }
        DimensionType \u260310 = this.field_175242_a.field_71441_e.field_73011_w.func_186058_p();
        World \u260311 = integratedServer != null && integratedServer.func_71218_a(\u260310) != null ? integratedServer.func_71218_a(\u260310) : this.field_175242_a.field_71441_e;
        ForcedChunksSaveData \u260312 = \u260311.func_212411_a(\u260310, ForcedChunksSaveData::new, "chunks");
        ArrayList \u260313 = Lists.newArrayList((Object[])new String[]{"Minecraft 1.13.2 (" + this.field_175242_a.func_175600_c() + "/" + ClientBrandRetriever.getClientModName() + ("release".equalsIgnoreCase(this.field_175242_a.func_184123_d()) ? "" : "/" + this.field_175242_a.func_184123_d()) + ")", this.field_175242_a.field_71426_K, \u26035, this.field_175242_a.field_71438_f.func_72735_c(), this.field_175242_a.field_71438_f.func_72723_d(), "P: " + this.field_175242_a.field_71452_i.func_78869_b() + ". T: " + this.field_175242_a.field_71441_e.func_72981_t(), this.field_175242_a.field_71441_e.func_72827_u(), DimensionType.func_212678_a(\u260310).toString() + " FC: " + (\u260312 == null ? "n/a" : Integer.toString(\u260312.func_212438_a().size())), "", String.format(Locale.ROOT, "XYZ: %.3f / %.5f / %.3f", this.field_175242_a.func_175606_aa().field_70165_t, this.field_175242_a.func_175606_aa().func_174813_aQ().field_72338_b, this.field_175242_a.func_175606_aa().field_70161_v), String.format("Block: %d %d %d", \u26036.func_177958_n(), \u26036.func_177956_o(), \u26036.func_177952_p()), String.format("Chunk: %d %d %d in %d %d %d", \u26036.func_177958_n() & 0xF, \u26036.func_177956_o() & 0xF, \u26036.func_177952_p() & 0xF, \u26036.func_177958_n() >> 4, \u26036.func_177956_o() >> 4, \u26036.func_177952_p() >> 4), String.format(Locale.ROOT, "Facing: %s (%s) (%.1f / %.1f)", \u26038, \u26039, Float.valueOf(MathHelper.func_76142_g(\u26037.field_70177_z)), Float.valueOf(MathHelper.func_76142_g(\u26037.field_70125_A)))});
        if (this.field_175242_a.field_71441_e != null) {
            object = this.field_175242_a.field_71441_e.func_175726_f(\u26036);
            if (!this.field_175242_a.field_71441_e.func_175667_e(\u26036) || \u26036.func_177956_o() < 0 || \u26036.func_177956_o() >= 256) {
                \u260313.add("Outside of world...");
            } else if (!((Chunk)object).func_76621_g()) {
                \u260313.add("Biome: " + IRegistry.field_212624_m.func_177774_c(((Chunk)object).func_201600_k(\u26036)));
                \u260313.add("Light: " + ((Chunk)object).func_201586_a(\u26036, 0, ((Chunk)object).func_177412_p().field_73011_w.func_191066_m()) + " (" + ((Chunk)object).func_201587_a(EnumLightType.SKY, \u26036, ((Chunk)object).func_177412_p().field_73011_w.func_191066_m()) + " sky, " + ((Chunk)object).func_201587_a(EnumLightType.BLOCK, \u26036, ((Chunk)object).func_177412_p().field_73011_w.func_191066_m()) + " block)");
                DifficultyInstance difficultyInstance = this.field_175242_a.field_71441_e.func_175649_E(\u26036);
                if (this.field_175242_a.func_71387_A() && integratedServer != null && (\u2603 = integratedServer.func_184103_al().func_177451_a(this.field_175242_a.field_71439_g.func_110124_au())) != null) {
                    difficultyInstance = \u2603.field_70170_p.func_175649_E(new BlockPos(\u2603));
                }
                \u260313.add(String.format(Locale.ROOT, "Local Difficulty: %.2f // %.2f (Day %d)", Float.valueOf(difficultyInstance.func_180168_b()), Float.valueOf(difficultyInstance.func_180170_c()), this.field_175242_a.field_71441_e.func_72820_D() / 24000L));
            } else {
                \u260313.add("Waiting for chunk...");
            }
        }
        if (this.field_175242_a.field_71460_t != null && this.field_175242_a.field_71460_t.func_147702_a()) {
            \u260313.add("Shader: " + this.field_175242_a.field_71460_t.func_147706_e().func_148022_b());
        }
        if (this.field_211537_g != null && this.field_211537_g.field_72313_a == RayTraceResult.Type.BLOCK) {
            object = this.field_211537_g.func_178782_a();
            \u260313.add(String.format("Looking at block: %d %d %d", ((Vec3i)object).func_177958_n(), ((Vec3i)object).func_177956_o(), ((Vec3i)object).func_177952_p()));
        }
        if (this.field_211538_h != null && this.field_211538_h.field_72313_a == RayTraceResult.Type.BLOCK) {
            object = this.field_211538_h.func_178782_a();
            \u260313.add(String.format("Looking at liquid: %d %d %d", ((Vec3i)object).func_177958_n(), ((Vec3i)object).func_177956_o(), ((Vec3i)object).func_177952_p()));
        }
        return \u260313;
    }

    protected List<String> func_175238_c() {
        Entity object;
        BlockPos blockPos;
        long l = Runtime.getRuntime().maxMemory();
        long l2 = Runtime.getRuntime().totalMemory();
        \u2603 = Runtime.getRuntime().freeMemory();
        \u2603 = l2 - \u2603;
        ArrayList \u26032 = Lists.newArrayList((Object[])new String[]{String.format("Java: %s %dbit", System.getProperty("java.version"), this.field_175242_a.func_147111_S() ? 64 : 32), String.format("Mem: % 2d%% %03d/%03dMB", \u2603 * 100L / l, GuiOverlayDebug.func_175240_a(\u2603), GuiOverlayDebug.func_175240_a(l)), String.format("Allocated: % 2d%% %03dMB", l2 * 100L / l, GuiOverlayDebug.func_175240_a(l2)), "", String.format("CPU: %s", OpenGlHelper.func_183029_j()), "", String.format("Display: %dx%d (%s)", Minecraft.func_71410_x().field_195558_d.func_198109_k(), Minecraft.func_71410_x().field_195558_d.func_198091_l(), GlStateManager.func_187416_u(7936)), GlStateManager.func_187416_u(7937), GlStateManager.func_187416_u(7938)});
        if (this.field_175242_a.func_189648_am()) {
            return \u26032;
        }
        if (this.field_211537_g != null && this.field_211537_g.field_72313_a == RayTraceResult.Type.BLOCK) {
            blockPos = this.field_211537_g.func_178782_a();
            IBlockState \u26033 = this.field_175242_a.field_71441_e.func_180495_p(blockPos);
            \u26032.add("");
            \u26032.add((Object)((Object)TextFormatting.UNDERLINE) + "Targeted Block");
            \u26032.add(String.valueOf(IRegistry.field_212618_g.func_177774_c(\u26033.func_177230_c())));
            for (Map.Entry entry : \u26033.func_206871_b().entrySet()) {
                \u26032.add(this.func_211534_a(entry));
            }
            for (ResourceLocation resourceLocation : this.field_175242_a.func_147114_u().func_199724_l().func_199717_a().func_199913_a(\u26033.func_177230_c())) {
                \u26032.add("#" + resourceLocation);
            }
        }
        if (this.field_211538_h != null && this.field_211538_h.field_72313_a == RayTraceResult.Type.BLOCK) {
            blockPos = this.field_211538_h.func_178782_a();
            IFluidState \u26034 = this.field_175242_a.field_71441_e.func_204610_c(blockPos);
            \u26032.add("");
            \u26032.add((Object)((Object)TextFormatting.UNDERLINE) + "Targeted Fluid");
            \u26032.add(String.valueOf(IRegistry.field_212619_h.func_177774_c(\u26034.func_206886_c())));
            for (Map.Entry entry : \u26034.func_206871_b().entrySet()) {
                \u26032.add(this.func_211534_a(entry));
            }
            for (ResourceLocation resourceLocation : this.field_175242_a.func_147114_u().func_199724_l().func_205704_c().func_199913_a(\u26034.func_206886_c())) {
                \u26032.add("#" + resourceLocation);
            }
        }
        if ((object = this.field_175242_a.field_147125_j) != null) {
            \u26032.add("");
            \u26032.add((Object)((Object)TextFormatting.UNDERLINE) + "Targeted Entity");
            \u26032.add(String.valueOf(IRegistry.field_212629_r.func_177774_c(object.func_200600_R())));
        }
        return \u26032;
    }

    private String func_211534_a(Map.Entry<IProperty<?>, Comparable<?>> entry) {
        IProperty<?> iProperty = entry.getKey();
        Comparable<?> \u26032 = entry.getValue();
        String \u26033 = Util.func_200269_a(iProperty, \u26032);
        if (Boolean.TRUE.equals(\u26032)) {
            \u26033 = (Object)((Object)TextFormatting.GREEN) + \u26033;
        } else if (Boolean.FALSE.equals(\u26032)) {
            \u26033 = (Object)((Object)TextFormatting.RED) + \u26033;
        }
        return iProperty.func_177701_a() + ": " + \u26033;
    }

    private void func_181554_e() {
        GlStateManager.func_179097_i();
        FrameTimer frameTimer = this.field_175242_a.func_181539_aj();
        int \u26032 = frameTimer.func_181749_a();
        int \u26033 = frameTimer.func_181750_b();
        long[] \u26034 = frameTimer.func_181746_c();
        int \u26035 = \u26032;
        int \u26036 = 0;
        int \u26037 = this.field_175242_a.field_195558_d.func_198087_p();
        GuiOverlayDebug.func_73734_a(0, \u26037 - 60, 240, \u26037, -1873784752);
        while (\u26035 != \u26033) {
            int n = frameTimer.func_181748_a(\u26034[\u26035], 30);
            \u2603 = this.func_181552_c(MathHelper.func_76125_a(n, 0, 60), 0, 30, 60);
            this.func_73728_b(\u26036, \u26037, \u26037 - n, \u2603);
            ++\u26036;
            \u26035 = frameTimer.func_181751_b(\u26035 + 1);
        }
        GuiOverlayDebug.func_73734_a(1, \u26037 - 30 + 1, 14, \u26037 - 30 + 10, -1873784752);
        this.field_175241_f.func_211126_b("60", 2.0f, \u26037 - 30 + 2, 0xE0E0E0);
        this.func_73730_a(0, 239, \u26037 - 30, -1);
        GuiOverlayDebug.func_73734_a(1, \u26037 - 60 + 1, 14, \u26037 - 60 + 10, -1873784752);
        this.field_175241_f.func_211126_b("30", 2.0f, \u26037 - 60 + 2, 0xE0E0E0);
        this.func_73730_a(0, 239, \u26037 - 60, -1);
        this.func_73730_a(0, 239, \u26037 - 1, -1);
        this.func_73728_b(0, \u26037 - 60, \u26037, -1);
        this.func_73728_b(239, \u26037 - 60, \u26037, -1);
        if (this.field_175242_a.field_71474_y.field_74350_i <= 120) {
            this.func_73730_a(0, 239, \u26037 - 60 + this.field_175242_a.field_71474_y.field_74350_i / 2, -16711681);
        }
        GlStateManager.func_179126_j();
    }

    private int func_181552_c(int n, int n2, int n3, int n4) {
        if (n < n3) {
            return this.func_181553_a(-16711936, -256, (float)n / (float)n3);
        }
        return this.func_181553_a(-256, -65536, (float)(n - n3) / (float)(n4 - n3));
    }

    private int func_181553_a(int n, int n2, float f) {
        int n3 = n >> 24 & 0xFF;
        \u2603 = n >> 16 & 0xFF;
        \u2603 = n >> 8 & 0xFF;
        \u2603 = n & 0xFF;
        \u2603 = n2 >> 24 & 0xFF;
        \u2603 = n2 >> 16 & 0xFF;
        \u2603 = n2 >> 8 & 0xFF;
        \u2603 = n2 & 0xFF;
        \u2603 = MathHelper.func_76125_a((int)((float)n3 + (float)(\u2603 - n3) * f), 0, 255);
        \u2603 = MathHelper.func_76125_a((int)((float)\u2603 + (float)(\u2603 - \u2603) * f), 0, 255);
        \u2603 = MathHelper.func_76125_a((int)((float)\u2603 + (float)(\u2603 - \u2603) * f), 0, 255);
        \u2603 = MathHelper.func_76125_a((int)((float)\u2603 + (float)(\u2603 - \u2603) * f), 0, 255);
        return \u2603 << 24 | \u2603 << 16 | \u2603 << 8 | \u2603;
    }

    private static long func_175240_a(long l) {
        return l / 1024L / 1024L;
    }
}

