/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiEventHandler;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.util.InputMappings;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class GuiScreen
extends GuiEventHandler
implements GuiYesNoCallback {
    private static final Logger field_175287_a = LogManager.getLogger();
    private static final Set<String> field_175284_f = Sets.newHashSet((Object[])new String[]{"http", "https"});
    protected final List<IGuiEventListener> field_195124_j = Lists.newArrayList();
    protected Minecraft field_146297_k;
    protected ItemRenderer field_146296_j;
    public int field_146294_l;
    public int field_146295_m;
    protected final List<GuiButton> field_146292_n = Lists.newArrayList();
    protected final List<GuiLabel> field_146293_o = Lists.newArrayList();
    public boolean field_146291_p;
    protected FontRenderer field_146289_q;
    private URI field_175286_t;

    public void func_73863_a(int n, int n2, float f) {
        int n3;
        for (n3 = 0; n3 < this.field_146292_n.size(); ++n3) {
            this.field_146292_n.get(n3).func_194828_a(n, n2, f);
        }
        for (n3 = 0; n3 < this.field_146293_o.size(); ++n3) {
            this.field_146293_o.get(n3).func_194997_a(n, n2, f);
        }
    }

    @Override
    public boolean keyPressed(int n, int n2, int n3) {
        if (n == 256 && this.func_195120_Y_()) {
            this.func_195122_V_();
            return true;
        }
        return super.keyPressed(n, n2, n3);
    }

    public boolean func_195120_Y_() {
        return true;
    }

    public void func_195122_V_() {
        this.field_146297_k.func_147108_a(null);
    }

    protected <T extends GuiButton> T func_189646_b(T t) {
        this.field_146292_n.add(t);
        this.field_195124_j.add(t);
        return t;
    }

    protected void func_146285_a(ItemStack itemStack, int n, int n2) {
        this.func_146283_a(this.func_191927_a(itemStack), n, n2);
    }

    public List<String> func_191927_a(ItemStack itemStack) {
        List<ITextComponent> list = itemStack.func_82840_a(this.field_146297_k.field_71439_g, this.field_146297_k.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL);
        ArrayList \u26032 = Lists.newArrayList();
        for (ITextComponent iTextComponent : list) {
            \u26032.add(iTextComponent.func_150254_d());
        }
        return \u26032;
    }

    public void func_146279_a(String string, int n, int n2) {
        this.func_146283_a(Arrays.asList(string), n, n2);
    }

    public void func_146283_a(List<String> list, int n3, int n2) {
        int n3;
        if (list.isEmpty()) {
            return;
        }
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        \u2603 = 0;
        for (String string : list) {
            int n4 = this.field_146289_q.func_78256_a(string);
            if (n4 <= \u2603) continue;
            \u2603 = n4;
        }
        \u2603 = n3 + 12;
        \u2603 = n2 - 12;
        n4 = \u2603;
        \u2603 = 8;
        if (list.size() > 1) {
            \u2603 += 2 + (list.size() - 1) * 10;
        }
        if (\u2603 + \u2603 > this.field_146294_l) {
            \u2603 -= 28 + \u2603;
        }
        if (\u2603 + \u2603 + 6 > this.field_146295_m) {
            \u2603 = this.field_146295_m - \u2603 - 6;
        }
        this.field_73735_i = 300.0f;
        this.field_146296_j.field_77023_b = 300.0f;
        \u2603 = -267386864;
        this.func_73733_a(\u2603 - 3, \u2603 - 4, \u2603 + n4 + 3, \u2603 - 3, -267386864, -267386864);
        this.func_73733_a(\u2603 - 3, \u2603 + \u2603 + 3, \u2603 + n4 + 3, \u2603 + \u2603 + 4, -267386864, -267386864);
        this.func_73733_a(\u2603 - 3, \u2603 - 3, \u2603 + n4 + 3, \u2603 + \u2603 + 3, -267386864, -267386864);
        this.func_73733_a(\u2603 - 4, \u2603 - 3, \u2603 - 3, \u2603 + \u2603 + 3, -267386864, -267386864);
        this.func_73733_a(\u2603 + n4 + 3, \u2603 - 3, \u2603 + n4 + 4, \u2603 + \u2603 + 3, -267386864, -267386864);
        \u2603 = 0x505000FF;
        \u2603 = 1344798847;
        this.func_73733_a(\u2603 - 3, \u2603 - 3 + 1, \u2603 - 3 + 1, \u2603 + \u2603 + 3 - 1, 0x505000FF, 1344798847);
        this.func_73733_a(\u2603 + n4 + 2, \u2603 - 3 + 1, \u2603 + n4 + 3, \u2603 + \u2603 + 3 - 1, 0x505000FF, 1344798847);
        this.func_73733_a(\u2603 - 3, \u2603 - 3, \u2603 + n4 + 3, \u2603 - 3 + 1, 0x505000FF, 0x505000FF);
        this.func_73733_a(\u2603 - 3, \u2603 + \u2603 + 2, \u2603 + n4 + 3, \u2603 + \u2603 + 3, 1344798847, 1344798847);
        for (\u2603 = 0; \u2603 < list.size(); ++\u2603) {
            String string = list.get(\u2603);
            this.field_146289_q.func_175063_a(string, \u2603, \u2603, -1);
            if (\u2603 == 0) {
                \u2603 += 2;
            }
            \u2603 += 10;
        }
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        RenderHelper.func_74519_b();
        GlStateManager.func_179091_B();
    }

    protected void func_175272_a(ITextComponent iTextComponent, int n, int n2) {
        if (iTextComponent == null || iTextComponent.func_150256_b().func_150210_i() == null) {
            return;
        }
        HoverEvent hoverEvent = iTextComponent.func_150256_b().func_150210_i();
        if (hoverEvent.func_150701_a() == HoverEvent.Action.SHOW_ITEM) {
            ItemStack itemStack = ItemStack.field_190927_a;
            try {
                NBTTagCompound nBTTagCompound = JsonToNBT.func_180713_a(hoverEvent.func_150702_b().getString());
                if (nBTTagCompound instanceof NBTTagCompound) {
                    itemStack = ItemStack.func_199557_a(nBTTagCompound);
                }
            }
            catch (CommandSyntaxException nBTTagCompound) {
                // empty catch block
            }
            if (itemStack.func_190926_b()) {
                this.func_146279_a((Object)((Object)TextFormatting.RED) + "Invalid Item!", n, n2);
            } else {
                this.func_146285_a(itemStack, n, n2);
            }
        } else if (hoverEvent.func_150701_a() == HoverEvent.Action.SHOW_ENTITY) {
            if (this.field_146297_k.field_71474_y.field_82882_x) {
                try {
                    NBTTagCompound nBTTagCompound = JsonToNBT.func_180713_a(hoverEvent.func_150702_b().getString());
                    ArrayList \u26032 = Lists.newArrayList();
                    ITextComponent \u26033 = ITextComponent.Serializer.func_150699_a(nBTTagCompound.func_74779_i("name"));
                    if (\u26033 != null) {
                        \u26032.add(\u26033.func_150254_d());
                    }
                    if (nBTTagCompound.func_150297_b("type", 8)) {
                        String string = nBTTagCompound.func_74779_i("type");
                        \u26032.add("Type: " + string);
                    }
                    \u26032.add(nBTTagCompound.func_74779_i("id"));
                    this.func_146283_a(\u26032, n, n2);
                }
                catch (JsonSyntaxException | CommandSyntaxException throwable) {
                    this.func_146279_a((Object)((Object)TextFormatting.RED) + "Invalid Entity!", n, n2);
                }
            }
        } else if (hoverEvent.func_150701_a() == HoverEvent.Action.SHOW_TEXT) {
            this.func_146283_a(this.field_146297_k.field_71466_p.func_78271_c(hoverEvent.func_150702_b().func_150254_d(), Math.max(this.field_146294_l / 2, 200)), n, n2);
        }
        GlStateManager.func_179140_f();
    }

    protected void func_175274_a(String string, boolean bl) {
    }

    public boolean func_175276_a(ITextComponent iTextComponent) {
        if (iTextComponent == null) {
            return false;
        }
        ClickEvent clickEvent = iTextComponent.func_150256_b().func_150235_h();
        if (GuiScreen.func_146272_n()) {
            if (iTextComponent.func_150256_b().func_179986_j() != null) {
                this.func_175274_a(iTextComponent.func_150256_b().func_179986_j(), false);
            }
        } else if (clickEvent != null) {
            block19: {
                if (clickEvent.func_150669_a() == ClickEvent.Action.OPEN_URL) {
                    if (!this.field_146297_k.field_71474_y.field_74359_p) {
                        return false;
                    }
                    try {
                        URI uRI = new URI(clickEvent.func_150668_b());
                        String \u26032 = uRI.getScheme();
                        if (\u26032 == null) {
                            throw new URISyntaxException(clickEvent.func_150668_b(), "Missing protocol");
                        }
                        if (!field_175284_f.contains(\u26032.toLowerCase(Locale.ROOT))) {
                            throw new URISyntaxException(clickEvent.func_150668_b(), "Unsupported protocol: " + \u26032.toLowerCase(Locale.ROOT));
                        }
                        if (this.field_146297_k.field_71474_y.field_74358_q) {
                            this.field_175286_t = uRI;
                            this.field_146297_k.func_147108_a(new GuiConfirmOpenLink((GuiYesNoCallback)this, clickEvent.func_150668_b(), 31102009, false));
                            break block19;
                        }
                        this.func_175282_a(uRI);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        field_175287_a.error("Can't open url for {}", (Object)clickEvent, (Object)uRISyntaxException);
                    }
                } else if (clickEvent.func_150669_a() == ClickEvent.Action.OPEN_FILE) {
                    URI uRI = new File(clickEvent.func_150668_b()).toURI();
                    this.func_175282_a(uRI);
                } else if (clickEvent.func_150669_a() == ClickEvent.Action.SUGGEST_COMMAND) {
                    this.func_175274_a(clickEvent.func_150668_b(), true);
                } else if (clickEvent.func_150669_a() == ClickEvent.Action.RUN_COMMAND) {
                    this.func_175281_b(clickEvent.func_150668_b(), false);
                } else {
                    field_175287_a.error("Don't know how to handle {}", (Object)clickEvent);
                }
            }
            return true;
        }
        return false;
    }

    public void func_175275_f(String string) {
        this.func_175281_b(string, true);
    }

    public void func_175281_b(String string, boolean bl) {
        if (bl) {
            this.field_146297_k.field_71456_v.func_146158_b().func_146239_a(string);
        }
        this.field_146297_k.field_71439_g.func_71165_d(string);
    }

    public void func_146280_a(Minecraft minecraft, int n, int n2) {
        this.field_146297_k = minecraft;
        this.field_146296_j = minecraft.func_175599_af();
        this.field_146289_q = minecraft.field_71466_p;
        this.field_146294_l = n;
        this.field_146295_m = n2;
        this.field_146292_n.clear();
        this.field_195124_j.clear();
        this.func_73866_w_();
    }

    @Override
    public List<? extends IGuiEventListener> func_195074_b() {
        return this.field_195124_j;
    }

    protected void func_73866_w_() {
        this.field_195124_j.addAll(this.field_146293_o);
    }

    public void func_73876_c() {
    }

    public void func_146281_b() {
    }

    public void func_146276_q_() {
        this.func_146270_b(0);
    }

    public void func_146270_b(int n) {
        if (this.field_146297_k.field_71441_e != null) {
            this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, -1072689136, -804253680);
        } else {
            this.func_146278_c(n);
        }
    }

    public void func_146278_c(int n) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179106_n();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder \u26032 = tessellator.func_178180_c();
        this.field_146297_k.func_110434_K().func_110577_a(field_110325_k);
        GlStateManager.func_179131_c(1.0f, 1.0f, 1.0f, 1.0f);
        float \u26033 = 32.0f;
        \u26032.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        \u26032.func_181662_b(0.0, this.field_146295_m, 0.0).func_187315_a(0.0, (float)this.field_146295_m / 32.0f + (float)n).func_181669_b(64, 64, 64, 255).func_181675_d();
        \u26032.func_181662_b(this.field_146294_l, this.field_146295_m, 0.0).func_187315_a((float)this.field_146294_l / 32.0f, (float)this.field_146295_m / 32.0f + (float)n).func_181669_b(64, 64, 64, 255).func_181675_d();
        \u26032.func_181662_b(this.field_146294_l, 0.0, 0.0).func_187315_a((float)this.field_146294_l / 32.0f, n).func_181669_b(64, 64, 64, 255).func_181675_d();
        \u26032.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, n).func_181669_b(64, 64, 64, 255).func_181675_d();
        tessellator.func_78381_a();
    }

    public boolean func_73868_f() {
        return true;
    }

    @Override
    public void confirmResult(boolean bl, int n) {
        if (n == 31102009) {
            if (bl) {
                this.func_175282_a(this.field_175286_t);
            }
            this.field_175286_t = null;
            this.field_146297_k.func_147108_a(this);
        }
    }

    private void func_175282_a(URI uRI) {
        Util.func_110647_a().func_195642_a(uRI);
    }

    public static boolean func_146271_m() {
        if (Minecraft.field_142025_a) {
            return InputMappings.func_197956_a(343) || InputMappings.func_197956_a(347);
        }
        return InputMappings.func_197956_a(341) || InputMappings.func_197956_a(345);
    }

    public static boolean func_146272_n() {
        return InputMappings.func_197956_a(340) || InputMappings.func_197956_a(344);
    }

    public static boolean func_175283_s() {
        return InputMappings.func_197956_a(342) || InputMappings.func_197956_a(346);
    }

    public static boolean func_175277_d(int n) {
        return n == 88 && GuiScreen.func_146271_m() && !GuiScreen.func_146272_n() && !GuiScreen.func_175283_s();
    }

    public static boolean func_175279_e(int n) {
        return n == 86 && GuiScreen.func_146271_m() && !GuiScreen.func_146272_n() && !GuiScreen.func_175283_s();
    }

    public static boolean func_175280_f(int n) {
        return n == 67 && GuiScreen.func_146271_m() && !GuiScreen.func_146272_n() && !GuiScreen.func_175283_s();
    }

    public static boolean func_175278_g(int n) {
        return n == 65 && GuiScreen.func_146271_m() && !GuiScreen.func_146272_n() && !GuiScreen.func_175283_s();
    }

    public void func_175273_b(Minecraft minecraft, int n, int n2) {
        this.func_146280_a(minecraft, n, n2);
    }

    public static void func_195121_a(Runnable runnable, String string, String string2) {
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, string);
            CrashReportCategory \u26032 = crashReport.func_85058_a("Affected screen");
            \u26032.func_189529_a("Screen name", () -> string2);
            throw new ReportedException(crashReport);
        }
    }
}

