/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.achievement;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IProgressMeter;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityType;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.network.play.client.CPacketClientStatus;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatList;
import net.minecraft.stats.StatType;
import net.minecraft.stats.StatisticsManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class GuiStats
extends GuiScreen
implements IProgressMeter {
    protected GuiScreen field_146549_a;
    protected String field_146542_f = "Select world";
    private StatsGeneral field_146550_h;
    private StatsItem field_146551_i;
    private StatsMobsList field_146547_s;
    private final StatisticsManager field_146546_t;
    private GuiSlot field_146545_u;
    private boolean field_146543_v = true;

    public GuiStats(GuiScreen guiScreen, StatisticsManager statisticsManager) {
        this.field_146549_a = guiScreen;
        this.field_146546_t = statisticsManager;
    }

    @Override
    public IGuiEventListener getFocused() {
        return this.field_146545_u;
    }

    @Override
    protected void func_73866_w_() {
        this.field_146542_f = I18n.func_135052_a("gui.stats", new Object[0]);
        this.field_146543_v = true;
        this.field_146297_k.func_147114_u().func_147297_a(new CPacketClientStatus(CPacketClientStatus.State.REQUEST_STATS));
    }

    public void func_193028_a() {
        this.field_146550_h = new StatsGeneral(this.field_146297_k);
        this.field_146551_i = new StatsItem(this.field_146297_k);
        this.field_146547_s = new StatsMobsList(this.field_146297_k);
    }

    public void func_193029_f() {
        this.func_189646_b(new GuiButton(0, this.field_146294_l / 2 - 100, this.field_146295_m - 28, I18n.func_135052_a("gui.done", new Object[0])){

            @Override
            public void func_194829_a(double d, double d2) {
                GuiStats.this.field_146297_k.func_147108_a(GuiStats.this.field_146549_a);
            }
        });
        this.func_189646_b(new GuiButton(1, this.field_146294_l / 2 - 120, this.field_146295_m - 52, 80, 20, I18n.func_135052_a("stat.generalButton", new Object[0])){

            @Override
            public void func_194829_a(double d, double d2) {
                GuiStats.this.field_146545_u = GuiStats.this.field_146550_h;
            }
        });
        3 \u2603 = this.func_189646_b(new GuiButton(3, this.field_146294_l / 2 - 40, this.field_146295_m - 52, 80, 20, I18n.func_135052_a("stat.itemsButton", new Object[0])){

            @Override
            public void func_194829_a(double d, double d2) {
                GuiStats.this.field_146545_u = GuiStats.this.field_146551_i;
            }
        });
        4 \u26032 = this.func_189646_b(new GuiButton(4, this.field_146294_l / 2 + 40, this.field_146295_m - 52, 80, 20, I18n.func_135052_a("stat.mobsButton", new Object[0])){

            @Override
            public void func_194829_a(double d, double d2) {
                GuiStats.this.field_146545_u = GuiStats.this.field_146547_s;
            }
        });
        if (this.field_146551_i.func_148127_b() == 0) {
            \u2603.field_146124_l = false;
        }
        if (this.field_146547_s.func_148127_b() == 0) {
            \u26032.field_146124_l = false;
        }
        this.field_195124_j.add(() -> this.field_146545_u);
    }

    @Override
    public void func_73863_a(int n, int n2, float f) {
        if (this.field_146543_v) {
            this.func_146276_q_();
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a("multiplayer.downloadingStats", new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, field_146510_b_[(int)(Util.func_211177_b() / 150L % (long)field_146510_b_.length)], this.field_146294_l / 2, this.field_146295_m / 2 + this.field_146289_q.field_78288_b * 2, 0xFFFFFF);
        } else {
            this.field_146545_u.func_148128_a(n, n2, f);
            this.func_73732_a(this.field_146289_q, this.field_146542_f, this.field_146294_l / 2, 20, 0xFFFFFF);
            super.func_73863_a(n, n2, f);
        }
    }

    @Override
    public void func_193026_g() {
        if (this.field_146543_v) {
            this.func_193028_a();
            this.func_193029_f();
            this.field_146545_u = this.field_146550_h;
            this.field_146543_v = false;
        }
    }

    @Override
    public boolean func_73868_f() {
        return !this.field_146543_v;
    }

    private int func_195224_b(int n) {
        return 115 + 40 * n;
    }

    private void func_146521_a(int n, int n2, Item item) {
        this.func_146531_b(n + 1, n2 + 1);
        GlStateManager.func_179091_B();
        RenderHelper.func_74520_c();
        this.field_146296_j.func_175042_a(item.func_190903_i(), n + 2, n2 + 2);
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
    }

    private void func_146531_b(int n, int n2) {
        this.func_146527_c(n, n2, 0, 0);
    }

    private void func_146527_c(int n, int n2, int n3, int n4) {
        GlStateManager.func_179131_c(1.0f, 1.0f, 1.0f, 1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(field_110323_l);
        float f = 0.0078125f;
        \u2603 = 0.0078125f;
        int \u26032 = 18;
        int \u26033 = 18;
        Tessellator \u26034 = Tessellator.func_178181_a();
        BufferBuilder \u26035 = \u26034.func_178180_c();
        \u26035.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        \u26035.func_181662_b(n + 0, n2 + 18, this.field_73735_i).func_187315_a((float)(n3 + 0) * 0.0078125f, (float)(n4 + 18) * 0.0078125f).func_181675_d();
        \u26035.func_181662_b(n + 18, n2 + 18, this.field_73735_i).func_187315_a((float)(n3 + 18) * 0.0078125f, (float)(n4 + 18) * 0.0078125f).func_181675_d();
        \u26035.func_181662_b(n + 18, n2 + 0, this.field_73735_i).func_187315_a((float)(n3 + 18) * 0.0078125f, (float)(n4 + 0) * 0.0078125f).func_181675_d();
        \u26035.func_181662_b(n + 0, n2 + 0, this.field_73735_i).func_187315_a((float)(n3 + 0) * 0.0078125f, (float)(n4 + 0) * 0.0078125f).func_181675_d();
        \u26034.func_78381_a();
    }

    class StatsMobsList
    extends GuiSlot {
        private final List<EntityType<?>> field_148222_l;

        public StatsMobsList(Minecraft minecraft) {
            super(minecraft, GuiStats.this.field_146294_l, GuiStats.this.field_146295_m, 32, GuiStats.this.field_146295_m - 64, ((GuiStats)GuiStats.this).field_146289_q.field_78288_b * 4);
            this.field_148222_l = Lists.newArrayList();
            this.func_193651_b(false);
            for (EntityType<?> entityType : IRegistry.field_212629_r) {
                if (GuiStats.this.field_146546_t.func_77444_a(StatList.field_199090_h.func_199076_b(entityType)) <= 0 && GuiStats.this.field_146546_t.func_77444_a(StatList.field_199091_i.func_199076_b(entityType)) <= 0) continue;
                this.field_148222_l.add(entityType);
            }
        }

        @Override
        protected int func_148127_b() {
            return this.field_148222_l.size();
        }

        @Override
        protected boolean func_148131_a(int n) {
            return false;
        }

        @Override
        protected int func_148138_e() {
            return this.func_148127_b() * ((GuiStats)GuiStats.this).field_146289_q.field_78288_b * 4;
        }

        @Override
        protected void func_148123_a() {
            GuiStats.this.func_146276_q_();
        }

        @Override
        protected void func_192637_a(int n, int n2, int n3, int n4, int n5, int n6, float f) {
            EntityType<?> entityType = this.field_148222_l.get(n);
            String \u26032 = I18n.func_135052_a(Util.func_200697_a("entity", EntityType.func_200718_a(entityType)), new Object[0]);
            int \u26033 = GuiStats.this.field_146546_t.func_77444_a(StatList.field_199090_h.func_199076_b(entityType));
            int \u26034 = GuiStats.this.field_146546_t.func_77444_a(StatList.field_199091_i.func_199076_b(entityType));
            this.func_73731_b(GuiStats.this.field_146289_q, \u26032, n2 + 2 - 10, n3 + 1, 0xFFFFFF);
            this.func_73731_b(GuiStats.this.field_146289_q, this.func_199707_a(\u26032, \u26033), n2 + 2, n3 + 1 + ((GuiStats)GuiStats.this).field_146289_q.field_78288_b, \u26033 == 0 ? 0x606060 : 0x909090);
            this.func_73731_b(GuiStats.this.field_146289_q, this.func_199706_b(\u26032, \u26034), n2 + 2, n3 + 1 + ((GuiStats)GuiStats.this).field_146289_q.field_78288_b * 2, \u26034 == 0 ? 0x606060 : 0x909090);
        }

        private String func_199707_a(String string, int n) {
            String string2 = StatList.field_199090_h.func_199078_c();
            if (n == 0) {
                return I18n.func_135052_a(string2 + ".none", string);
            }
            return I18n.func_135052_a(string2, n, string);
        }

        private String func_199706_b(String string, int n) {
            String string2 = StatList.field_199091_i.func_199078_c();
            if (n == 0) {
                return I18n.func_135052_a(string2 + ".none", string);
            }
            return I18n.func_135052_a(string2, string, n);
        }
    }

    class StatsItem
    extends GuiSlot {
        protected final List<StatType<Block>> field_195113_v;
        protected final List<StatType<Item>> field_195114_w;
        private final int[] field_195112_D;
        protected int field_195115_x;
        protected final List<Item> field_195116_y;
        protected final java.util.Comparator<Item> field_195117_z;
        @Nullable
        protected StatType<?> field_195110_A;
        protected int field_195111_B;

        public StatsItem(Minecraft minecraft) {
            boolean bl;
            super(minecraft, GuiStats.this.field_146294_l, GuiStats.this.field_146295_m, 32, GuiStats.this.field_146295_m - 64, 20);
            this.field_195112_D = new int[]{3, 4, 1, 2, 5, 6};
            this.field_195115_x = -1;
            this.field_195117_z = new Comparator();
            this.field_195113_v = Lists.newArrayList();
            this.field_195113_v.add(StatList.field_188065_ae);
            this.field_195114_w = Lists.newArrayList((Object[])new StatType[]{StatList.field_199088_e, StatList.field_188066_af, StatList.field_75929_E, StatList.field_199089_f, StatList.field_188068_aj});
            this.func_193651_b(false);
            this.func_148133_a(true, 20);
            Set set = Sets.newIdentityHashSet();
            for (IItemProvider iItemProvider : IRegistry.field_212630_s) {
                bl = false;
                for (StatType<IItemProvider> statType : this.field_195114_w) {
                    if (!statType.func_199079_a((Item)iItemProvider) || GuiStats.this.field_146546_t.func_77444_a(statType.func_199076_b((Item)iItemProvider)) <= 0) continue;
                    bl = true;
                }
                if (!bl) continue;
                set.add(iItemProvider);
            }
            for (IItemProvider iItemProvider : IRegistry.field_212618_g) {
                bl = false;
                for (StatType<IItemProvider> statType : this.field_195113_v) {
                    if (!statType.func_199079_a(iItemProvider) || GuiStats.this.field_146546_t.func_77444_a(statType.func_199076_b(iItemProvider)) <= 0) continue;
                    bl = true;
                }
                if (!bl) continue;
                set.add(((Block)iItemProvider).func_199767_j());
            }
            set.remove(Items.field_190931_a);
            this.field_195116_y = Lists.newArrayList((Iterable)set);
        }

        @Override
        protected void func_148129_a(int n, int n2, Tessellator tessellator) {
            int n3;
            if (!this.field_148161_k.field_71417_B.func_198030_b()) {
                this.field_195115_x = -1;
            }
            for (n3 = 0; n3 < this.field_195112_D.length; ++n3) {
                GuiStats.this.func_146527_c(n + GuiStats.this.func_195224_b(n3) - 18, n2 + 1, 0, this.field_195115_x == n3 ? 0 : 18);
            }
            if (this.field_195110_A != null) {
                n3 = GuiStats.this.func_195224_b(this.func_195105_b(this.field_195110_A)) - 36;
                \u2603 = this.field_195111_B == 1 ? 2 : 1;
                GuiStats.this.func_146527_c(n + n3, n2 + 1, 18 * \u2603, 0);
            }
            for (n3 = 0; n3 < this.field_195112_D.length; ++n3) {
                \u2603 = this.field_195115_x != n3 ? 0 : 1;
                GuiStats.this.func_146527_c(n + GuiStats.this.func_195224_b(n3) - 18 + \u2603, n2 + 1 + \u2603, 18 * this.field_195112_D[n3], 18);
            }
        }

        @Override
        protected void func_192637_a(int n, int n2, int n3, int n4, int n5, int n6, float f) {
            int n7;
            Item item = this.func_195106_c(n);
            GuiStats.this.func_146521_a(n2 + 40, n3, item);
            for (n7 = 0; n7 < this.field_195113_v.size(); ++n7) {
                Stat<Block> stat = item instanceof ItemBlock ? this.field_195113_v.get(n7).func_199076_b(((ItemBlock)item).func_179223_d()) : null;
                this.func_195103_a(stat, n2 + GuiStats.this.func_195224_b(n7), n3, n % 2 == 0);
            }
            for (n7 = 0; n7 < this.field_195114_w.size(); ++n7) {
                this.func_195103_a(this.field_195114_w.get(n7).func_199076_b(item), n2 + GuiStats.this.func_195224_b(n7 + this.field_195113_v.size()), n3, n % 2 == 0);
            }
        }

        @Override
        protected boolean func_148131_a(int n) {
            return false;
        }

        @Override
        public int func_148139_c() {
            return 375;
        }

        @Override
        protected int func_148137_d() {
            return this.field_148155_a / 2 + 140;
        }

        @Override
        protected void func_148123_a() {
            GuiStats.this.func_146276_q_();
        }

        @Override
        protected void func_148132_a(int n, int n2) {
            this.field_195115_x = -1;
            for (\u2603 = 0; \u2603 < this.field_195112_D.length; ++\u2603) {
                \u2603 = n - GuiStats.this.func_195224_b(\u2603);
                if (\u2603 < -36 || \u2603 > 0) continue;
                this.field_195115_x = \u2603;
                break;
            }
            if (this.field_195115_x >= 0) {
                this.func_195107_a(this.func_195108_d(this.field_195115_x));
                this.field_148161_k.func_147118_V().func_147682_a(SimpleSound.func_184371_a(SoundEvents.field_187909_gi, 1.0f));
            }
        }

        private StatType<?> func_195108_d(int n) {
            return n < this.field_195113_v.size() ? this.field_195113_v.get(n) : this.field_195114_w.get(n - this.field_195113_v.size());
        }

        private int func_195105_b(StatType<?> statType) {
            int n = this.field_195113_v.indexOf(statType);
            if (n >= 0) {
                return n;
            }
            \u2603 = this.field_195114_w.indexOf(statType);
            if (\u2603 >= 0) {
                return \u2603 + this.field_195113_v.size();
            }
            return -1;
        }

        @Override
        protected final int func_148127_b() {
            return this.field_195116_y.size();
        }

        protected final Item func_195106_c(int n) {
            return this.field_195116_y.get(n);
        }

        protected void func_195103_a(@Nullable Stat<?> stat, int n, int n2, boolean bl) {
            String string = stat == null ? "-" : stat.func_75968_a(GuiStats.this.field_146546_t.func_77444_a(stat));
            this.func_73731_b(GuiStats.this.field_146289_q, string, n - GuiStats.this.field_146289_q.func_78256_a(string), n2 + 5, bl ? 0xFFFFFF : 0x909090);
        }

        @Override
        protected void func_148142_b(int n, int n2) {
            if (n2 < this.field_148153_b || n2 > this.field_148154_c) {
                return;
            }
            \u2603 = this.func_195083_a(n, n2);
            \u2603 = (this.field_148155_a - this.func_148139_c()) / 2;
            if (\u2603 >= 0) {
                if (n < \u2603 + 40 || n > \u2603 + 40 + 20) {
                    return;
                }
                Item item = this.func_195106_c(\u2603);
                this.func_200207_a(this.func_200208_a(item), n, n2);
            } else {
                TextComponentTranslation textComponentTranslation = null;
                int \u26032 = n - \u2603;
                for (int i = 0; i < this.field_195112_D.length; ++i) {
                    \u2603 = GuiStats.this.func_195224_b(i);
                    if (\u26032 < \u2603 - 18 || \u26032 > \u2603) continue;
                    textComponentTranslation = new TextComponentTranslation(this.func_195108_d(i).func_199078_c(), new Object[0]);
                    break;
                }
                this.func_200207_a(textComponentTranslation, n, n2);
            }
        }

        protected void func_200207_a(@Nullable ITextComponent iTextComponent, int n, int n2) {
            if (iTextComponent == null) {
                return;
            }
            String string = iTextComponent.func_150254_d();
            int \u26032 = n + 12;
            int \u26033 = n2 - 12;
            int \u26034 = GuiStats.this.field_146289_q.func_78256_a(string);
            this.func_73733_a(\u26032 - 3, \u26033 - 3, \u26032 + \u26034 + 3, \u26033 + 8 + 3, -1073741824, -1073741824);
            GuiStats.this.field_146289_q.func_175063_a(string, \u26032, \u26033, -1);
        }

        protected ITextComponent func_200208_a(Item item) {
            return item.func_200296_o();
        }

        protected void func_195107_a(StatType<?> statType) {
            if (statType != this.field_195110_A) {
                this.field_195110_A = statType;
                this.field_195111_B = -1;
            } else if (this.field_195111_B == -1) {
                this.field_195111_B = 1;
            } else {
                this.field_195110_A = null;
                this.field_195111_B = 0;
            }
            this.field_195116_y.sort(this.field_195117_z);
        }

        class Comparator
        implements java.util.Comparator<Item> {
            private Comparator() {
            }

            @Override
            public int compare(Item item, Item item2) {
                int \u26033;
                int \u26032;
                if (StatsItem.this.field_195110_A == null) {
                    \u26032 = 0;
                    \u26033 = 0;
                } else if (StatsItem.this.field_195113_v.contains(StatsItem.this.field_195110_A)) {
                    StatType<?> statType = StatsItem.this.field_195110_A;
                    \u26032 = item instanceof ItemBlock ? GuiStats.this.field_146546_t.func_199060_a(statType, ((ItemBlock)item).func_179223_d()) : -1;
                    \u26033 = item2 instanceof ItemBlock ? GuiStats.this.field_146546_t.func_199060_a(statType, ((ItemBlock)item2).func_179223_d()) : -1;
                } else {
                    \u2603 = StatsItem.this.field_195110_A;
                    \u26032 = GuiStats.this.field_146546_t.func_199060_a(\u2603, item);
                    \u26033 = GuiStats.this.field_146546_t.func_199060_a(\u2603, item2);
                }
                if (\u26032 == \u26033) {
                    return StatsItem.this.field_195111_B * Integer.compare(Item.func_150891_b(item), Item.func_150891_b(item2));
                }
                return StatsItem.this.field_195111_B * Integer.compare(\u26032, \u26033);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.compare((Item)object, (Item)object2);
            }
        }
    }

    class StatsGeneral
    extends GuiSlot {
        private Iterator<Stat<ResourceLocation>> field_195102_w;

        public StatsGeneral(Minecraft minecraft) {
            super(minecraft, GuiStats.this.field_146294_l, GuiStats.this.field_146295_m, 32, GuiStats.this.field_146295_m - 64, 10);
            this.func_193651_b(false);
        }

        @Override
        protected int func_148127_b() {
            return StatList.field_199092_j.func_199081_b();
        }

        @Override
        protected boolean func_148131_a(int n) {
            return false;
        }

        @Override
        protected int func_148138_e() {
            return this.func_148127_b() * 10;
        }

        @Override
        protected void func_148123_a() {
            GuiStats.this.func_146276_q_();
        }

        @Override
        protected void func_192637_a(int n, int n2, int n3, int n4, int n5, int n6, float f) {
            if (n == 0) {
                this.field_195102_w = StatList.field_199092_j.iterator();
            }
            Stat<ResourceLocation> stat = this.field_195102_w.next();
            ITextComponent \u26032 = new TextComponentTranslation("stat." + stat.func_197920_b().toString().replace(':', '.'), new Object[0]).func_211708_a(TextFormatting.GRAY);
            this.func_73731_b(GuiStats.this.field_146289_q, \u26032.getString(), n2 + 2, n3 + 1, n % 2 == 0 ? 0xFFFFFF : 0x909090);
            String \u26033 = stat.func_75968_a(GuiStats.this.field_146546_t.func_77444_a(stat));
            this.func_73731_b(GuiStats.this.field_146289_q, \u26033, n2 + 2 + 213 - GuiStats.this.field_146289_q.func_78256_a(\u26033), n3 + 1, n % 2 == 0 ? 0xFFFFFF : 0x909090);
        }
    }
}

