/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.fonts;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.fonts.Font;
import net.minecraft.client.gui.fonts.providers.DefaultGlyphProvider;
import net.minecraft.client.gui.fonts.providers.GlyphProviderTypes;
import net.minecraft.client.gui.fonts.providers.IGlyphProvider;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FontResourceManager
implements IResourceManagerReloadListener {
    private static final Logger field_211509_a = LogManager.getLogger();
    private final Map<ResourceLocation, FontRenderer> field_211510_b = Maps.newHashMap();
    private final TextureManager field_211511_c;
    private boolean field_211826_d;

    public FontResourceManager(TextureManager textureManager, boolean bl) {
        this.field_211511_c = textureManager;
        this.field_211826_d = bl;
    }

    @Override
    public void func_195410_a(IResourceManager iResourceManager) {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        HashMap \u26032 = Maps.newHashMap();
        for (ResourceLocation resourceLocation3 : iResourceManager.func_199003_a("font", string -> string.endsWith(".json"))) {
            String string2 = resourceLocation3.func_110623_a();
            ResourceLocation \u26033 = new ResourceLocation(resourceLocation3.func_110624_b(), string2.substring("font/".length(), string2.length() - ".json".length()));
            List \u26034 = \u26032.computeIfAbsent(\u26033, resourceLocation -> Lists.newArrayList((Object[])new IGlyphProvider[]{new DefaultGlyphProvider()}));
            try {
                for (IResource iResource : iResourceManager.func_199004_b(resourceLocation3)) {
                    try {
                        InputStream inputStream = iResource.func_199027_b();
                        Throwable throwable = null;
                        try {
                            JsonArray jsonArray = JsonUtils.func_151214_t(JsonUtils.func_188178_a(gson, IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8), JsonObject.class), "providers");
                            for (int i = jsonArray.size() - 1; i >= 0; --i) {
                                JsonObject jsonObject = JsonUtils.func_151210_l(jsonArray.get(i), "providers[" + i + "]");
                                try {
                                    GlyphProviderTypes glyphProviderTypes = GlyphProviderTypes.func_211638_a(JsonUtils.func_151200_h(jsonObject, "type"));
                                    if (this.field_211826_d && glyphProviderTypes != GlyphProviderTypes.LEGACY_UNICODE && \u26033.equals(Minecraft.field_211502_b) || (\u2603 = glyphProviderTypes.func_211637_a(jsonObject).func_211246_a(iResourceManager)) == null) continue;
                                    \u26034.add(\u2603);
                                    continue;
                                }
                                catch (RuntimeException runtimeException) {
                                    field_211509_a.warn("Unable to read definition '{}' in fonts.json in resourcepack: '{}': {}", (Object)\u26033, (Object)iResource.func_199026_d(), (Object)runtimeException.getMessage());
                                }
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (inputStream == null) continue;
                            if (throwable != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            inputStream.close();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        field_211509_a.warn("Unable to load font '{}' in fonts.json in resourcepack: '{}': {}", (Object)\u26033, (Object)iResource.func_199026_d(), (Object)runtimeException.getMessage());
                    }
                }
            }
            catch (IOException iOException) {
                field_211509_a.warn("Unable to load font '{}' in fonts.json: {}", (Object)\u26033, (Object)iOException.getMessage());
            }
        }
        Stream.concat(this.field_211510_b.keySet().stream(), \u26032.keySet().stream()).distinct().forEach(resourceLocation2 -> {
            List<IGlyphProvider> list = \u26032.getOrDefault(resourceLocation2, Collections.emptyList());
            Collections.reverse(list);
            this.field_211510_b.computeIfAbsent((ResourceLocation)resourceLocation2, resourceLocation -> new FontRenderer(this.field_211511_c, new Font(this.field_211511_c, (ResourceLocation)resourceLocation))).func_211568_a(list);
        });
    }

    @Nullable
    public FontRenderer func_211504_a(ResourceLocation resourceLocation2) {
        return this.field_211510_b.computeIfAbsent(resourceLocation2, resourceLocation -> {
            FontRenderer fontRenderer = new FontRenderer(this.field_211511_c, new Font(this.field_211511_c, (ResourceLocation)resourceLocation));
            fontRenderer.func_211568_a(Lists.newArrayList((Object[])new IGlyphProvider[]{new DefaultGlyphProvider()}));
            return fontRenderer;
        });
    }

    public void func_211825_a(boolean bl) {
        if (bl == this.field_211826_d) {
            return;
        }
        this.field_211826_d = bl;
        this.func_195410_a(Minecraft.func_71410_x().func_195551_G());
    }
}

