/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.fonts.providers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.chars.CharArraySet;
import it.unimi.dsi.fastutil.chars.CharSet;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import net.minecraft.client.gui.fonts.IGlyphInfo;
import net.minecraft.client.gui.fonts.providers.IGlyphProvider;
import net.minecraft.client.gui.fonts.providers.IGlyphProviderFactory;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.stb.STBTTFontinfo;
import org.lwjgl.stb.STBTruetype;
import org.lwjgl.system.MemoryStack;

public class TrueTypeGlyphProvider
implements IGlyphProvider {
    private static final Logger field_211263_a = LogManager.getLogger();
    private final STBTTFontinfo field_211264_b;
    private final float field_211618_c;
    private final CharSet field_211619_d = new CharArraySet();
    private final float field_211620_e;
    private final float field_211621_f;
    private final float field_211266_d;
    private final float field_211622_h;

    protected TrueTypeGlyphProvider(STBTTFontinfo sTBTTFontinfo, float f, float f2, float f3, float f4, String string) {
        this.field_211264_b = sTBTTFontinfo;
        this.field_211618_c = f2;
        string.chars().forEach(n -> this.field_211619_d.add((char)(n & 0xFFFF)));
        this.field_211620_e = f3 * f2;
        this.field_211621_f = f4 * f2;
        this.field_211266_d = STBTruetype.stbtt_ScaleForPixelHeight((STBTTFontinfo)sTBTTFontinfo, (float)(f * f2));
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            IntBuffer intBuffer = memoryStack.mallocInt(1);
            \u2603 = memoryStack.mallocInt(1);
            \u2603 = memoryStack.mallocInt(1);
            STBTruetype.stbtt_GetFontVMetrics((STBTTFontinfo)sTBTTFontinfo, (IntBuffer)intBuffer, (IntBuffer)\u2603, (IntBuffer)\u2603);
            this.field_211622_h = (float)intBuffer.get(0) * this.field_211266_d;
        }
    }

    @Override
    @Nullable
    public GlpyhInfo func_212248_a(char c) {
        if (this.field_211619_d.contains(c)) {
            return null;
        }
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            IntBuffer intBuffer = memoryStack.mallocInt(1);
            \u2603 = memoryStack.mallocInt(1);
            \u2603 = memoryStack.mallocInt(1);
            \u2603 = memoryStack.mallocInt(1);
            int \u26032 = STBTruetype.stbtt_FindGlyphIndex((STBTTFontinfo)this.field_211264_b, (int)c);
            if (\u26032 == 0) {
                GlpyhInfo glpyhInfo = null;
                return glpyhInfo;
            }
            STBTruetype.stbtt_GetGlyphBitmapBoxSubpixel((STBTTFontinfo)this.field_211264_b, (int)\u26032, (float)this.field_211266_d, (float)this.field_211266_d, (float)this.field_211620_e, (float)this.field_211621_f, (IntBuffer)intBuffer, (IntBuffer)\u2603, (IntBuffer)\u2603, (IntBuffer)\u2603);
            int \u26033 = \u2603.get(0) - intBuffer.get(0);
            int \u26034 = \u2603.get(0) - \u2603.get(0);
            if (\u26033 == 0 || \u26034 == 0) {
                GlpyhInfo glpyhInfo = null;
                return glpyhInfo;
            }
            \u2603 = memoryStack.mallocInt(1);
            \u2603 = memoryStack.mallocInt(1);
            STBTruetype.stbtt_GetGlyphHMetrics((STBTTFontinfo)this.field_211264_b, (int)\u26032, (IntBuffer)\u2603, (IntBuffer)\u2603);
            GlpyhInfo glpyhInfo = new GlpyhInfo(intBuffer.get(0), \u2603.get(0), -\u2603.get(0), -\u2603.get(0), (float)\u2603.get(0) * this.field_211266_d, (float)\u2603.get(0) * this.field_211266_d, \u26032);
            return glpyhInfo;
        }
    }

    @Override
    @Nullable
    public /* synthetic */ IGlyphInfo func_212248_a(char c) {
        return this.func_212248_a(c);
    }

    public static class Factory
    implements IGlyphProviderFactory {
        private final ResourceLocation field_211249_a;
        private final float field_211250_b;
        private final float field_211625_c;
        private final float field_211626_d;
        private final float field_211627_e;
        private final String field_211628_f;

        public Factory(ResourceLocation resourceLocation, float f, float f2, float f3, float f4, String string) {
            this.field_211249_a = resourceLocation;
            this.field_211250_b = f;
            this.field_211625_c = f2;
            this.field_211626_d = f3;
            this.field_211627_e = f4;
            this.field_211628_f = string;
        }

        public static IGlyphProviderFactory func_211624_a(JsonObject jsonObject2) {
            JsonObject jsonObject2;
            float \u26033;
            Object object;
            float \u26032 = 0.0f;
            \u26033 = 0.0f;
            if (jsonObject2.has("shift")) {
                object = jsonObject2.getAsJsonArray("shift");
                if (object.size() != 2) {
                    throw new JsonParseException("Expected 2 elements in 'shift', found " + object.size());
                }
                \u26032 = JsonUtils.func_151220_d(object.get(0), "shift[0]");
                \u26033 = JsonUtils.func_151220_d(object.get(1), "shift[1]");
            }
            object = new StringBuilder();
            if (jsonObject2.has("skip")) {
                JsonElement \u26034 = jsonObject2.get("skip");
                if (\u26034.isJsonArray()) {
                    JsonArray jsonArray = JsonUtils.func_151207_m(\u26034, "skip");
                    for (int i = 0; i < jsonArray.size(); ++i) {
                        ((StringBuilder)object).append(JsonUtils.func_151206_a(jsonArray.get(i), "skip[" + i + "]"));
                    }
                } else {
                    ((StringBuilder)object).append(JsonUtils.func_151206_a(\u26034, "skip"));
                }
            }
            return new Factory(new ResourceLocation(JsonUtils.func_151200_h(jsonObject2, "file")), JsonUtils.func_151221_a(jsonObject2, "size", 11.0f), JsonUtils.func_151221_a(jsonObject2, "oversample", 1.0f), \u26032, \u26033, ((StringBuilder)object).toString());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        @Nullable
        public IGlyphProvider func_211246_a(IResourceManager iResourceManager) {
            try (IResource iResource = iResourceManager.func_199002_a(new ResourceLocation(this.field_211249_a.func_110624_b(), "font/" + this.field_211249_a.func_110623_a()));){
                field_211263_a.info("Loading font");
                ByteBuffer \u26032 = TextureUtil.func_195724_a(iResource.func_199027_b());
                \u26032.flip();
                STBTTFontinfo \u26033 = STBTTFontinfo.create();
                field_211263_a.info("Reading font");
                if (!STBTruetype.stbtt_InitFont((STBTTFontinfo)\u26033, (ByteBuffer)\u26032)) {
                    throw new IOException("Invalid ttf");
                }
                TrueTypeGlyphProvider trueTypeGlyphProvider = new TrueTypeGlyphProvider(\u26033, this.field_211250_b, this.field_211625_c, this.field_211626_d, this.field_211627_e, this.field_211628_f);
                return trueTypeGlyphProvider;
            }
            catch (IOException iOException) {
                field_211263_a.error("Couldn't load truetype font {}", (Object)this.field_211249_a, (Object)iOException);
                return null;
            }
        }
    }

    class GlpyhInfo
    implements IGlyphInfo {
        private final int field_211216_b;
        private final int field_211217_c;
        private final float field_212464_d;
        private final float field_212465_e;
        private final float field_211598_i;
        private final int field_211599_j;

        private GlpyhInfo(int n, int n2, int n3, int n4, float f, float f2, int n5) {
            this.field_211216_b = n2 - n;
            this.field_211217_c = n3 - n4;
            this.field_211598_i = f / TrueTypeGlyphProvider.this.field_211618_c;
            this.field_212464_d = (f2 + (float)n + TrueTypeGlyphProvider.this.field_211620_e) / TrueTypeGlyphProvider.this.field_211618_c;
            this.field_212465_e = (TrueTypeGlyphProvider.this.field_211622_h - (float)n3 + TrueTypeGlyphProvider.this.field_211621_f) / TrueTypeGlyphProvider.this.field_211618_c;
            this.field_211599_j = n5;
        }

        @Override
        public int func_211202_a() {
            return this.field_211216_b;
        }

        @Override
        public int func_211203_b() {
            return this.field_211217_c;
        }

        @Override
        public float func_211578_g() {
            return TrueTypeGlyphProvider.this.field_211618_c;
        }

        @Override
        public float getAdvance() {
            return this.field_211598_i;
        }

        @Override
        public float getBearingX() {
            return this.field_212464_d;
        }

        @Override
        public float getBearingY() {
            return this.field_212465_e;
        }

        @Override
        public void func_211573_a(int n, int n2) {
            try (NativeImage nativeImage = new NativeImage(NativeImage.PixelFormat.LUMINANCE, this.field_211216_b, this.field_211217_c, false);){
                nativeImage.func_211676_a(TrueTypeGlyphProvider.this.field_211264_b, this.field_211599_j, this.field_211216_b, this.field_211217_c, TrueTypeGlyphProvider.this.field_211266_d, TrueTypeGlyphProvider.this.field_211266_d, TrueTypeGlyphProvider.this.field_211620_e, TrueTypeGlyphProvider.this.field_211621_f, 0, 0);
                nativeImage.func_195706_a(0, n, n2, 0, 0, this.field_211216_b, this.field_211217_c, false);
            }
        }

        @Override
        public boolean func_211579_f() {
            return false;
        }
    }
}

