/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Util;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkProviderClient
implements IChunkProvider {
    private static final Logger field_147436_a = LogManager.getLogger();
    private final Chunk field_73238_a;
    private final Long2ObjectMap<Chunk> field_73236_b = Long2ObjectMaps.synchronize((Long2ObjectMap)new Long2ObjectOpenHashMap<Chunk>(8192){

        protected void rehash(int n) {
            if (n > this.key.length) {
                super.rehash(n);
            }
        }
    });
    private final World field_73235_d;

    public ChunkProviderClient(World world) {
        this.field_73238_a = new EmptyChunk(world, 0, 0);
        this.field_73235_d = world;
    }

    public void func_73234_b(int n, int n2) {
        Chunk chunk = (Chunk)this.field_73236_b.remove(ChunkPos.func_77272_a(n, n2));
        if (chunk != null) {
            chunk.func_76623_d();
        }
    }

    @Override
    @Nullable
    public Chunk func_186025_d(int n, int n2, boolean bl, boolean bl2) {
        Chunk chunk = (Chunk)this.field_73236_b.get(ChunkPos.func_77272_a(n, n2));
        if (bl2 && chunk == null) {
            return this.field_73238_a;
        }
        return chunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chunk func_212474_a(int n, int n2, PacketBuffer packetBuffer, int n3, boolean bl) {
        Long2ObjectMap<Chunk> long2ObjectMap = this.field_73236_b;
        synchronized (long2ObjectMap) {
            long l2 = ChunkPos.func_77272_a(n, n2);
            Chunk \u26032 = (Chunk)this.field_73236_b.computeIfAbsent(l2, l -> new Chunk(this.field_73235_d, n, n2, new Biome[256]));
            \u26032.func_186033_a(packetBuffer, n3, bl);
            \u26032.func_177417_c(true);
            return \u26032;
        }
    }

    @Override
    public boolean func_73156_b(BooleanSupplier booleanSupplier) {
        long l = Util.func_211177_b();
        for (Chunk chunk : this.field_73236_b.values()) {
            chunk.func_150804_b(Util.func_211177_b() - l > 5L);
        }
        if (Util.func_211177_b() - l > 100L) {
            field_147436_a.info("Warning: Clientside chunk ticking took {} ms", (Object)(Util.func_211177_b() - l));
        }
        return false;
    }

    @Override
    public String func_73148_d() {
        return "MultiplayerChunkCache: " + this.field_73236_b.size() + ", " + this.field_73236_b.size();
    }

    @Override
    public IChunkGenerator<?> func_201711_g() {
        return null;
    }
}

