/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.network;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.multiplayer.ThreadLanServerPing;
import net.minecraft.client.network.LanServerInfo;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LanServerDetector {
    private static final AtomicInteger field_148551_a = new AtomicInteger(0);
    private static final Logger field_148550_b = LogManager.getLogger();

    public static class ThreadLanServerFind
    extends Thread {
        private final LanServerList field_77500_a;
        private final InetAddress field_77498_b;
        private final MulticastSocket field_77499_c;

        public ThreadLanServerFind(LanServerList lanServerList) throws IOException {
            super("LanServerDetector #" + field_148551_a.incrementAndGet());
            this.field_77500_a = lanServerList;
            this.setDaemon(true);
            this.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(field_148550_b));
            this.field_77499_c = new MulticastSocket(4445);
            this.field_77498_b = InetAddress.getByName("224.0.2.60");
            this.field_77499_c.setSoTimeout(5000);
            this.field_77499_c.joinGroup(this.field_77498_b);
        }

        @Override
        public void run() {
            byte[] byArray = new byte[1024];
            while (!this.isInterrupted()) {
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                try {
                    this.field_77499_c.receive(datagramPacket);
                }
                catch (SocketTimeoutException \u26032) {
                    continue;
                }
                catch (IOException \u26033) {
                    field_148550_b.error("Couldn't ping server", (Throwable)\u26033);
                    break;
                }
                String \u26034 = new String(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getLength(), StandardCharsets.UTF_8);
                field_148550_b.debug("{}: {}", (Object)datagramPacket.getAddress(), (Object)\u26034);
                this.field_77500_a.func_77551_a(\u26034, datagramPacket.getAddress());
            }
            try {
                this.field_77499_c.leaveGroup(this.field_77498_b);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.field_77499_c.close();
        }
    }

    public static class LanServerList {
        private final List<LanServerInfo> field_77555_b = Lists.newArrayList();
        private boolean field_77556_a;

        public synchronized boolean func_77553_a() {
            return this.field_77556_a;
        }

        public synchronized void func_77552_b() {
            this.field_77556_a = false;
        }

        public synchronized List<LanServerInfo> func_77554_c() {
            return Collections.unmodifiableList(this.field_77555_b);
        }

        public synchronized void func_77551_a(String string, InetAddress inetAddress) {
            String string2 = ThreadLanServerPing.func_77524_a(string);
            \u2603 = ThreadLanServerPing.func_77523_b(string);
            if (\u2603 == null) {
                return;
            }
            \u2603 = inetAddress.getHostAddress() + ":" + \u2603;
            boolean \u26032 = false;
            for (LanServerInfo lanServerInfo : this.field_77555_b) {
                if (!lanServerInfo.func_77488_b().equals(\u2603)) continue;
                lanServerInfo.func_77489_c();
                \u26032 = true;
                break;
            }
            if (!\u26032) {
                this.field_77555_b.add(new LanServerInfo(string2, \u2603));
                this.field_77556_a = true;
            }
        }
    }
}

