/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.network;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.exceptions.InvalidCredentialsException;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiDisconnected;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenRealmsProxy;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.network.EnumConnectionState;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.login.INetHandlerLoginClient;
import net.minecraft.network.login.client.CPacketCustomPayloadLogin;
import net.minecraft.network.login.client.CPacketEncryptionResponse;
import net.minecraft.network.login.server.SPacketCustomPayloadLogin;
import net.minecraft.network.login.server.SPacketDisconnectLogin;
import net.minecraft.network.login.server.SPacketEnableCompression;
import net.minecraft.network.login.server.SPacketEncryptionRequest;
import net.minecraft.network.login.server.SPacketLoginSuccess;
import net.minecraft.realms.DisconnectedRealmsScreen;
import net.minecraft.util.CryptManager;
import net.minecraft.util.HttpUtil;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetHandlerLoginClient
implements INetHandlerLoginClient {
    private static final Logger field_147396_a = LogManager.getLogger();
    private final Minecraft field_147394_b;
    @Nullable
    private final GuiScreen field_147395_c;
    private final Consumer<ITextComponent> field_209525_d;
    private final NetworkManager field_147393_d;
    private GameProfile field_175091_e;

    public NetHandlerLoginClient(NetworkManager networkManager, Minecraft minecraft, @Nullable GuiScreen guiScreen, Consumer<ITextComponent> consumer) {
        this.field_147393_d = networkManager;
        this.field_147394_b = minecraft;
        this.field_147395_c = guiScreen;
        this.field_209525_d = consumer;
    }

    @Override
    public void func_147389_a(SPacketEncryptionRequest sPacketEncryptionRequest) {
        SecretKey secretKey = CryptManager.func_75890_a();
        PublicKey \u26032 = sPacketEncryptionRequest.func_149608_d();
        String \u26033 = new BigInteger(CryptManager.func_75895_a(sPacketEncryptionRequest.func_149609_c(), \u26032, secretKey)).toString(16);
        CPacketEncryptionResponse \u26034 = new CPacketEncryptionResponse(secretKey, \u26032, sPacketEncryptionRequest.func_149607_e());
        this.field_209525_d.accept(new TextComponentTranslation("connect.authorizing", new Object[0]));
        HttpUtil.field_180193_a.submit(() -> {
            ITextComponent iTextComponent = this.func_209522_a(\u26033);
            if (iTextComponent != null) {
                if (this.field_147394_b.func_147104_D() != null && this.field_147394_b.func_147104_D().func_181041_d()) {
                    field_147396_a.warn(iTextComponent.getString());
                } else {
                    this.field_147393_d.func_150718_a(iTextComponent);
                    return;
                }
            }
            this.field_209525_d.accept(new TextComponentTranslation("connect.encrypting", new Object[0]));
            this.field_147393_d.func_201058_a(\u26034, (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)future -> this.field_147393_d.func_150727_a(secretKey)));
        });
    }

    @Nullable
    private ITextComponent func_209522_a(String string) {
        try {
            this.func_147391_c().joinServer(this.field_147394_b.func_110432_I().func_148256_e(), this.field_147394_b.func_110432_I().func_148254_d(), string);
        }
        catch (AuthenticationUnavailableException authenticationUnavailableException) {
            return new TextComponentTranslation("disconnect.loginFailedInfo", new TextComponentTranslation("disconnect.loginFailedInfo.serversUnavailable", new Object[0]));
        }
        catch (InvalidCredentialsException invalidCredentialsException) {
            return new TextComponentTranslation("disconnect.loginFailedInfo", new TextComponentTranslation("disconnect.loginFailedInfo.invalidSession", new Object[0]));
        }
        catch (AuthenticationException authenticationException) {
            return new TextComponentTranslation("disconnect.loginFailedInfo", authenticationException.getMessage());
        }
        return null;
    }

    private MinecraftSessionService func_147391_c() {
        return this.field_147394_b.func_152347_ac();
    }

    @Override
    public void func_147390_a(SPacketLoginSuccess sPacketLoginSuccess) {
        this.field_209525_d.accept(new TextComponentTranslation("connect.joining", new Object[0]));
        this.field_175091_e = sPacketLoginSuccess.func_179730_a();
        this.field_147393_d.func_150723_a(EnumConnectionState.PLAY);
        this.field_147393_d.func_150719_a(new NetHandlerPlayClient(this.field_147394_b, this.field_147395_c, this.field_147393_d, this.field_175091_e));
    }

    @Override
    public void func_147231_a(ITextComponent iTextComponent) {
        if (this.field_147395_c != null && this.field_147395_c instanceof GuiScreenRealmsProxy) {
            this.field_147394_b.func_147108_a(new DisconnectedRealmsScreen(((GuiScreenRealmsProxy)this.field_147395_c).func_154321_a(), "connect.failed", iTextComponent).getProxy());
        } else {
            this.field_147394_b.func_147108_a(new GuiDisconnected(this.field_147395_c, "connect.failed", iTextComponent));
        }
    }

    @Override
    public void func_147388_a(SPacketDisconnectLogin sPacketDisconnectLogin) {
        this.field_147393_d.func_150718_a(sPacketDisconnectLogin.func_149603_c());
    }

    @Override
    public void func_180464_a(SPacketEnableCompression sPacketEnableCompression) {
        if (!this.field_147393_d.func_150731_c()) {
            this.field_147393_d.func_179289_a(sPacketEnableCompression.func_179731_a());
        }
    }

    @Override
    public void func_209521_a(SPacketCustomPayloadLogin sPacketCustomPayloadLogin) {
        this.field_209525_d.accept(new TextComponentTranslation("connect.negotiating", new Object[0]));
        this.field_147393_d.func_179290_a(new CPacketCustomPayloadLogin(sPacketCustomPayloadLogin.func_209918_a(), null));
    }
}

