/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorldReader;

public class BlockModelRenderer {
    private final BlockColors field_187499_a;
    private static final ThreadLocal<Object2IntLinkedOpenHashMap<BlockPos>> field_210267_b = ThreadLocal.withInitial(() -> {
        Object2IntLinkedOpenHashMap<BlockPos> object2IntLinkedOpenHashMap = new Object2IntLinkedOpenHashMap<BlockPos>(50){

            protected void rehash(int n) {
            }
        };
        object2IntLinkedOpenHashMap.defaultReturnValue(Integer.MAX_VALUE);
        return object2IntLinkedOpenHashMap;
    });
    private static final ThreadLocal<Boolean> field_211848_c = ThreadLocal.withInitial(() -> false);

    public BlockModelRenderer(BlockColors blockColors) {
        this.field_187499_a = blockColors;
    }

    public boolean func_199324_a(IWorldReader iWorldReader, IBakedModel iBakedModel, IBlockState iBlockState, BlockPos blockPos, BufferBuilder bufferBuilder, boolean bl, Random random, long l) {
        boolean bl2 = Minecraft.func_71379_u() && iBlockState.func_185906_d() == 0 && iBakedModel.func_177555_b();
        try {
            if (bl2) {
                return this.func_199326_b(iWorldReader, iBakedModel, iBlockState, blockPos, bufferBuilder, bl, random, l);
            }
            return this.func_199325_c(iWorldReader, iBakedModel, iBlockState, blockPos, bufferBuilder, bl, random, l);
        }
        catch (Throwable \u26032) {
            CrashReport crashReport = CrashReport.func_85055_a(\u26032, "Tesselating block model");
            CrashReportCategory \u26033 = crashReport.func_85058_a("Block model being tesselated");
            CrashReportCategory.func_175750_a(\u26033, blockPos, iBlockState);
            \u26033.func_71507_a("Using AO", bl2);
            throw new ReportedException(crashReport);
        }
    }

    public boolean func_199326_b(IWorldReader iWorldReader, IBakedModel iBakedModel, IBlockState iBlockState, BlockPos blockPos, BufferBuilder bufferBuilder, boolean bl, Random random, long l) {
        boolean \u26035 = false;
        float[] \u26032 = new float[EnumFacing.values().length * 2];
        BitSet \u26033 = new BitSet(3);
        AmbientOcclusionFace \u26034 = new AmbientOcclusionFace();
        for (EnumFacing enumFacing : EnumFacing.values()) {
            random.setSeed(l);
            List<BakedQuad> list = iBakedModel.func_200117_a(iBlockState, enumFacing, random);
            if (list.isEmpty() || bl && !Block.func_176225_a(iBlockState, iWorldReader, blockPos, enumFacing)) continue;
            this.func_187492_a(iWorldReader, iBlockState, blockPos, bufferBuilder, list, \u26032, \u26033, \u26034);
            \u26035 = true;
        }
        random.setSeed(l);
        \u2603 = iBakedModel.func_200117_a(iBlockState, null, random);
        if (!\u2603.isEmpty()) {
            this.func_187492_a(iWorldReader, iBlockState, blockPos, bufferBuilder, \u2603, \u26032, \u26033, \u26034);
            \u26035 = true;
        }
        return \u26035;
    }

    public boolean func_199325_c(IWorldReader iWorldReader, IBakedModel iBakedModel, IBlockState iBlockState, BlockPos blockPos, BufferBuilder bufferBuilder, boolean bl, Random random, long l) {
        boolean \u26034 = false;
        BitSet \u26032 = new BitSet(3);
        for (EnumFacing enumFacing : EnumFacing.values()) {
            random.setSeed(l);
            List<BakedQuad> list = iBakedModel.func_200117_a(iBlockState, enumFacing, random);
            if (list.isEmpty() || bl && !Block.func_176225_a(iBlockState, iWorldReader, blockPos, enumFacing)) continue;
            int \u26033 = iBlockState.func_185889_a(iWorldReader, blockPos.func_177972_a(enumFacing));
            this.func_187496_a(iWorldReader, iBlockState, blockPos, \u26033, false, bufferBuilder, list, \u26032);
            \u26034 = true;
        }
        random.setSeed(l);
        \u2603 = iBakedModel.func_200117_a(iBlockState, null, random);
        if (!\u2603.isEmpty()) {
            this.func_187496_a(iWorldReader, iBlockState, blockPos, -1, true, bufferBuilder, \u2603, \u26032);
            \u26034 = true;
        }
        return \u26034;
    }

    private void func_187492_a(IWorldReader iWorldReader, IBlockState iBlockState, BlockPos blockPos, BufferBuilder bufferBuilder, List<BakedQuad> list, float[] fArray, BitSet bitSet, AmbientOcclusionFace ambientOcclusionFace) {
        Vec3d vec3d = iBlockState.func_191059_e(iWorldReader, blockPos);
        double \u26032 = (double)blockPos.func_177958_n() + vec3d.field_72450_a;
        double \u26033 = (double)blockPos.func_177956_o() + vec3d.field_72448_b;
        double \u26034 = (double)blockPos.func_177952_p() + vec3d.field_72449_c;
        int \u26035 = list.size();
        for (int i = 0; i < \u26035; ++i) {
            BakedQuad bakedQuad = list.get(i);
            this.func_187494_a(iBlockState, bakedQuad.func_178209_a(), bakedQuad.func_178210_d(), fArray, bitSet);
            ambientOcclusionFace.func_187491_a(iWorldReader, iBlockState, blockPos, bakedQuad.func_178210_d(), fArray, bitSet);
            bufferBuilder.func_178981_a(bakedQuad.func_178209_a());
            bufferBuilder.func_178962_a(ambientOcclusionFace.field_178207_c[0], ambientOcclusionFace.field_178207_c[1], ambientOcclusionFace.field_178207_c[2], ambientOcclusionFace.field_178207_c[3]);
            if (bakedQuad.func_178212_b()) {
                int n = this.field_187499_a.func_186724_a(iBlockState, iWorldReader, blockPos, bakedQuad.func_178211_c());
                float \u26036 = (float)(n >> 16 & 0xFF) / 255.0f;
                float \u26037 = (float)(n >> 8 & 0xFF) / 255.0f;
                float \u26038 = (float)(n & 0xFF) / 255.0f;
                bufferBuilder.func_178978_a(ambientOcclusionFace.field_178206_b[0] * \u26036, ambientOcclusionFace.field_178206_b[0] * \u26037, ambientOcclusionFace.field_178206_b[0] * \u26038, 4);
                bufferBuilder.func_178978_a(ambientOcclusionFace.field_178206_b[1] * \u26036, ambientOcclusionFace.field_178206_b[1] * \u26037, ambientOcclusionFace.field_178206_b[1] * \u26038, 3);
                bufferBuilder.func_178978_a(ambientOcclusionFace.field_178206_b[2] * \u26036, ambientOcclusionFace.field_178206_b[2] * \u26037, ambientOcclusionFace.field_178206_b[2] * \u26038, 2);
                bufferBuilder.func_178978_a(ambientOcclusionFace.field_178206_b[3] * \u26036, ambientOcclusionFace.field_178206_b[3] * \u26037, ambientOcclusionFace.field_178206_b[3] * \u26038, 1);
            } else {
                bufferBuilder.func_178978_a(ambientOcclusionFace.field_178206_b[0], ambientOcclusionFace.field_178206_b[0], ambientOcclusionFace.field_178206_b[0], 4);
                bufferBuilder.func_178978_a(ambientOcclusionFace.field_178206_b[1], ambientOcclusionFace.field_178206_b[1], ambientOcclusionFace.field_178206_b[1], 3);
                bufferBuilder.func_178978_a(ambientOcclusionFace.field_178206_b[2], ambientOcclusionFace.field_178206_b[2], ambientOcclusionFace.field_178206_b[2], 2);
                bufferBuilder.func_178978_a(ambientOcclusionFace.field_178206_b[3], ambientOcclusionFace.field_178206_b[3], ambientOcclusionFace.field_178206_b[3], 1);
            }
            bufferBuilder.func_178987_a(\u26032, \u26033, \u26034);
        }
    }

    private void func_187494_a(IBlockState iBlockState, int[] nArray, EnumFacing enumFacing, @Nullable float[] fArray2, BitSet bitSet) {
        float[] fArray2;
        int n;
        float f = 32.0f;
        \u2603 = 32.0f;
        \u2603 = 32.0f;
        \u2603 = -32.0f;
        \u2603 = -32.0f;
        \u2603 = -32.0f;
        for (n = 0; n < 4; ++n) {
            float f2 = Float.intBitsToFloat(nArray[n * 7]);
            \u2603 = Float.intBitsToFloat(nArray[n * 7 + 1]);
            \u2603 = Float.intBitsToFloat(nArray[n * 7 + 2]);
            f = Math.min(f, f2);
            \u2603 = Math.min(\u2603, \u2603);
            \u2603 = Math.min(\u2603, \u2603);
            \u2603 = Math.max(\u2603, f2);
            \u2603 = Math.max(\u2603, \u2603);
            \u2603 = Math.max(\u2603, \u2603);
        }
        if (fArray2 != null) {
            fArray2[EnumFacing.WEST.func_176745_a()] = f;
            fArray2[EnumFacing.EAST.func_176745_a()] = \u2603;
            fArray2[EnumFacing.DOWN.func_176745_a()] = \u2603;
            fArray2[EnumFacing.UP.func_176745_a()] = \u2603;
            fArray2[EnumFacing.NORTH.func_176745_a()] = \u2603;
            fArray2[EnumFacing.SOUTH.func_176745_a()] = \u2603;
            n = EnumFacing.values().length;
            fArray2[EnumFacing.WEST.func_176745_a() + n] = 1.0f - f;
            fArray2[EnumFacing.EAST.func_176745_a() + n] = 1.0f - \u2603;
            fArray2[EnumFacing.DOWN.func_176745_a() + n] = 1.0f - \u2603;
            fArray2[EnumFacing.UP.func_176745_a() + n] = 1.0f - \u2603;
            fArray2[EnumFacing.NORTH.func_176745_a() + n] = 1.0f - \u2603;
            fArray2[EnumFacing.SOUTH.func_176745_a() + n] = 1.0f - \u2603;
        }
        float f3 = 1.0E-4f;
        f2 = 0.9999f;
        switch (enumFacing) {
            case DOWN: {
                bitSet.set(1, f >= 1.0E-4f || \u2603 >= 1.0E-4f || \u2603 <= 0.9999f || \u2603 <= 0.9999f);
                bitSet.set(0, (\u2603 < 1.0E-4f || iBlockState.func_185917_h()) && \u2603 == \u2603);
                break;
            }
            case UP: {
                bitSet.set(1, f >= 1.0E-4f || \u2603 >= 1.0E-4f || \u2603 <= 0.9999f || \u2603 <= 0.9999f);
                bitSet.set(0, (\u2603 > 0.9999f || iBlockState.func_185917_h()) && \u2603 == \u2603);
                break;
            }
            case NORTH: {
                bitSet.set(1, f >= 1.0E-4f || \u2603 >= 1.0E-4f || \u2603 <= 0.9999f || \u2603 <= 0.9999f);
                bitSet.set(0, (\u2603 < 1.0E-4f || iBlockState.func_185917_h()) && \u2603 == \u2603);
                break;
            }
            case SOUTH: {
                bitSet.set(1, f >= 1.0E-4f || \u2603 >= 1.0E-4f || \u2603 <= 0.9999f || \u2603 <= 0.9999f);
                bitSet.set(0, (\u2603 > 0.9999f || iBlockState.func_185917_h()) && \u2603 == \u2603);
                break;
            }
            case WEST: {
                bitSet.set(1, \u2603 >= 1.0E-4f || \u2603 >= 1.0E-4f || \u2603 <= 0.9999f || \u2603 <= 0.9999f);
                bitSet.set(0, (f < 1.0E-4f || iBlockState.func_185917_h()) && f == \u2603);
                break;
            }
            case EAST: {
                bitSet.set(1, \u2603 >= 1.0E-4f || \u2603 >= 1.0E-4f || \u2603 <= 0.9999f || \u2603 <= 0.9999f);
                bitSet.set(0, (\u2603 > 0.9999f || iBlockState.func_185917_h()) && f == \u2603);
            }
        }
    }

    private void func_187496_a(IWorldReader iWorldReader, IBlockState iBlockState, BlockPos blockPos, int \u260362, boolean bl, BufferBuilder bufferBuilder, List<BakedQuad> list, BitSet bitSet) {
        Vec3d vec3d = iBlockState.func_191059_e(iWorldReader, blockPos);
        double \u26032 = (double)blockPos.func_177958_n() + vec3d.field_72450_a;
        double \u26033 = (double)blockPos.func_177956_o() + vec3d.field_72448_b;
        double \u26034 = (double)blockPos.func_177952_p() + vec3d.field_72449_c;
        int \u26035 = list.size();
        for (int i = 0; i < \u26035; ++i) {
            int \u260362;
            BakedQuad bakedQuad = list.get(i);
            if (bl) {
                this.func_187494_a(iBlockState, bakedQuad.func_178209_a(), bakedQuad.func_178210_d(), null, bitSet);
                BlockPos blockPos2 = bitSet.get(0) ? blockPos.func_177972_a(bakedQuad.func_178210_d()) : blockPos;
                \u260362 = iBlockState.func_185889_a(iWorldReader, blockPos2);
            }
            bufferBuilder.func_178981_a(bakedQuad.func_178209_a());
            bufferBuilder.func_178962_a(\u260362, \u260362, \u260362, \u260362);
            if (bakedQuad.func_178212_b()) {
                int \u26037 = this.field_187499_a.func_186724_a(iBlockState, iWorldReader, blockPos, bakedQuad.func_178211_c());
                float \u26038 = (float)(\u26037 >> 16 & 0xFF) / 255.0f;
                float \u26039 = (float)(\u26037 >> 8 & 0xFF) / 255.0f;
                float \u260310 = (float)(\u26037 & 0xFF) / 255.0f;
                bufferBuilder.func_178978_a(\u26038, \u26039, \u260310, 4);
                bufferBuilder.func_178978_a(\u26038, \u26039, \u260310, 3);
                bufferBuilder.func_178978_a(\u26038, \u26039, \u260310, 2);
                bufferBuilder.func_178978_a(\u26038, \u26039, \u260310, 1);
            }
            bufferBuilder.func_178987_a(\u26032, \u26033, \u26034);
        }
    }

    public void func_178262_a(IBakedModel iBakedModel, float f, float f2, float f3, float f4) {
        this.func_187495_a(null, iBakedModel, f, f2, f3, f4);
    }

    public void func_187495_a(@Nullable IBlockState iBlockState, IBakedModel iBakedModel, float f, float f2, float f3, float f4) {
        Random random = new Random();
        long \u26032 = 42L;
        for (EnumFacing enumFacing : EnumFacing.values()) {
            random.setSeed(42L);
            this.func_178264_a(f, f2, f3, f4, iBakedModel.func_200117_a(iBlockState, enumFacing, random));
        }
        random.setSeed(42L);
        this.func_178264_a(f, f2, f3, f4, iBakedModel.func_200117_a(iBlockState, null, random));
    }

    public void func_178266_a(IBakedModel iBakedModel, IBlockState iBlockState, float f, boolean bl) {
        GlStateManager.func_179114_b(90.0f, 0.0f, 1.0f, 0.0f);
        int n = this.field_187499_a.func_186724_a(iBlockState, null, null, 0);
        float \u26032 = (float)(n >> 16 & 0xFF) / 255.0f;
        float \u26033 = (float)(n >> 8 & 0xFF) / 255.0f;
        float \u26034 = (float)(n & 0xFF) / 255.0f;
        if (!bl) {
            GlStateManager.func_179131_c(f, f, f, 1.0f);
        }
        this.func_187495_a(iBlockState, iBakedModel, f, \u26032, \u26033, \u26034);
    }

    private void func_178264_a(float f, float f2, float f3, float f4, List<BakedQuad> list) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder \u26032 = tessellator.func_178180_c();
        int \u26033 = list.size();
        for (int i = 0; i < \u26033; ++i) {
            BakedQuad bakedQuad = list.get(i);
            \u26032.func_181668_a(7, DefaultVertexFormats.field_176599_b);
            \u26032.func_178981_a(bakedQuad.func_178209_a());
            if (bakedQuad.func_178212_b()) {
                \u26032.func_178990_f(f2 * f, f3 * f, f4 * f);
            } else {
                \u26032.func_178990_f(f, f, f);
            }
            Vec3i \u26034 = bakedQuad.func_178210_d().func_176730_m();
            \u26032.func_178975_e(\u26034.func_177958_n(), \u26034.func_177956_o(), \u26034.func_177952_p());
            tessellator.func_78381_a();
        }
    }

    public static void func_211847_a() {
        field_211848_c.set(true);
    }

    public static void func_210266_a() {
        field_210267_b.get().clear();
        field_211848_c.set(false);
    }

    private static int func_210264_b(IBlockState iBlockState, IWorldReader iWorldReader, BlockPos blockPos) {
        Boolean bl = field_211848_c.get();
        Object2IntLinkedOpenHashMap<BlockPos> \u26032 = null;
        if (bl.booleanValue() && (\u26033 = (\u26032 = field_210267_b.get()).getInt((Object)blockPos)) != Integer.MAX_VALUE) {
            return \u26033;
        }
        int \u26033 = iBlockState.func_185889_a(iWorldReader, blockPos);
        if (\u26032 != null) {
            if (\u26032.size() == 50) {
                \u26032.removeFirstInt();
            }
            \u26032.put((Object)blockPos.func_185334_h(), \u26033);
        }
        return \u26033;
    }

    public static enum EnumNeighborInfo {
        DOWN(new EnumFacing[]{EnumFacing.WEST, EnumFacing.EAST, EnumFacing.NORTH, EnumFacing.SOUTH}, 0.5f, true, new Orientation[]{Orientation.FLIP_WEST, Orientation.SOUTH, Orientation.FLIP_WEST, Orientation.FLIP_SOUTH, Orientation.WEST, Orientation.FLIP_SOUTH, Orientation.WEST, Orientation.SOUTH}, new Orientation[]{Orientation.FLIP_WEST, Orientation.NORTH, Orientation.FLIP_WEST, Orientation.FLIP_NORTH, Orientation.WEST, Orientation.FLIP_NORTH, Orientation.WEST, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_EAST, Orientation.NORTH, Orientation.FLIP_EAST, Orientation.FLIP_NORTH, Orientation.EAST, Orientation.FLIP_NORTH, Orientation.EAST, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_EAST, Orientation.SOUTH, Orientation.FLIP_EAST, Orientation.FLIP_SOUTH, Orientation.EAST, Orientation.FLIP_SOUTH, Orientation.EAST, Orientation.SOUTH}),
        UP(new EnumFacing[]{EnumFacing.EAST, EnumFacing.WEST, EnumFacing.NORTH, EnumFacing.SOUTH}, 1.0f, true, new Orientation[]{Orientation.EAST, Orientation.SOUTH, Orientation.EAST, Orientation.FLIP_SOUTH, Orientation.FLIP_EAST, Orientation.FLIP_SOUTH, Orientation.FLIP_EAST, Orientation.SOUTH}, new Orientation[]{Orientation.EAST, Orientation.NORTH, Orientation.EAST, Orientation.FLIP_NORTH, Orientation.FLIP_EAST, Orientation.FLIP_NORTH, Orientation.FLIP_EAST, Orientation.NORTH}, new Orientation[]{Orientation.WEST, Orientation.NORTH, Orientation.WEST, Orientation.FLIP_NORTH, Orientation.FLIP_WEST, Orientation.FLIP_NORTH, Orientation.FLIP_WEST, Orientation.NORTH}, new Orientation[]{Orientation.WEST, Orientation.SOUTH, Orientation.WEST, Orientation.FLIP_SOUTH, Orientation.FLIP_WEST, Orientation.FLIP_SOUTH, Orientation.FLIP_WEST, Orientation.SOUTH}),
        NORTH(new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN, EnumFacing.EAST, EnumFacing.WEST}, 0.8f, true, new Orientation[]{Orientation.UP, Orientation.FLIP_WEST, Orientation.UP, Orientation.WEST, Orientation.FLIP_UP, Orientation.WEST, Orientation.FLIP_UP, Orientation.FLIP_WEST}, new Orientation[]{Orientation.UP, Orientation.FLIP_EAST, Orientation.UP, Orientation.EAST, Orientation.FLIP_UP, Orientation.EAST, Orientation.FLIP_UP, Orientation.FLIP_EAST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_EAST, Orientation.DOWN, Orientation.EAST, Orientation.FLIP_DOWN, Orientation.EAST, Orientation.FLIP_DOWN, Orientation.FLIP_EAST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_WEST, Orientation.DOWN, Orientation.WEST, Orientation.FLIP_DOWN, Orientation.WEST, Orientation.FLIP_DOWN, Orientation.FLIP_WEST}),
        SOUTH(new EnumFacing[]{EnumFacing.WEST, EnumFacing.EAST, EnumFacing.DOWN, EnumFacing.UP}, 0.8f, true, new Orientation[]{Orientation.UP, Orientation.FLIP_WEST, Orientation.FLIP_UP, Orientation.FLIP_WEST, Orientation.FLIP_UP, Orientation.WEST, Orientation.UP, Orientation.WEST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_WEST, Orientation.FLIP_DOWN, Orientation.FLIP_WEST, Orientation.FLIP_DOWN, Orientation.WEST, Orientation.DOWN, Orientation.WEST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_EAST, Orientation.FLIP_DOWN, Orientation.FLIP_EAST, Orientation.FLIP_DOWN, Orientation.EAST, Orientation.DOWN, Orientation.EAST}, new Orientation[]{Orientation.UP, Orientation.FLIP_EAST, Orientation.FLIP_UP, Orientation.FLIP_EAST, Orientation.FLIP_UP, Orientation.EAST, Orientation.UP, Orientation.EAST}),
        WEST(new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.SOUTH}, 0.6f, true, new Orientation[]{Orientation.UP, Orientation.SOUTH, Orientation.UP, Orientation.FLIP_SOUTH, Orientation.FLIP_UP, Orientation.FLIP_SOUTH, Orientation.FLIP_UP, Orientation.SOUTH}, new Orientation[]{Orientation.UP, Orientation.NORTH, Orientation.UP, Orientation.FLIP_NORTH, Orientation.FLIP_UP, Orientation.FLIP_NORTH, Orientation.FLIP_UP, Orientation.NORTH}, new Orientation[]{Orientation.DOWN, Orientation.NORTH, Orientation.DOWN, Orientation.FLIP_NORTH, Orientation.FLIP_DOWN, Orientation.FLIP_NORTH, Orientation.FLIP_DOWN, Orientation.NORTH}, new Orientation[]{Orientation.DOWN, Orientation.SOUTH, Orientation.DOWN, Orientation.FLIP_SOUTH, Orientation.FLIP_DOWN, Orientation.FLIP_SOUTH, Orientation.FLIP_DOWN, Orientation.SOUTH}),
        EAST(new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH}, 0.6f, true, new Orientation[]{Orientation.FLIP_DOWN, Orientation.SOUTH, Orientation.FLIP_DOWN, Orientation.FLIP_SOUTH, Orientation.DOWN, Orientation.FLIP_SOUTH, Orientation.DOWN, Orientation.SOUTH}, new Orientation[]{Orientation.FLIP_DOWN, Orientation.NORTH, Orientation.FLIP_DOWN, Orientation.FLIP_NORTH, Orientation.DOWN, Orientation.FLIP_NORTH, Orientation.DOWN, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_UP, Orientation.NORTH, Orientation.FLIP_UP, Orientation.FLIP_NORTH, Orientation.UP, Orientation.FLIP_NORTH, Orientation.UP, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_UP, Orientation.SOUTH, Orientation.FLIP_UP, Orientation.FLIP_SOUTH, Orientation.UP, Orientation.FLIP_SOUTH, Orientation.UP, Orientation.SOUTH});

        private final EnumFacing[] field_178276_g;
        private final boolean field_178289_i;
        private final Orientation[] field_178286_j;
        private final Orientation[] field_178287_k;
        private final Orientation[] field_178284_l;
        private final Orientation[] field_178285_m;
        private static final EnumNeighborInfo[] field_178282_n;

        private EnumNeighborInfo(EnumFacing[] enumFacingArray, float f, boolean bl, Orientation[] orientationArray, Orientation[] orientationArray2, Orientation[] orientationArray3, Orientation[] orientationArray4) {
            this.field_178276_g = enumFacingArray;
            this.field_178289_i = bl;
            this.field_178286_j = orientationArray;
            this.field_178287_k = orientationArray2;
            this.field_178284_l = orientationArray3;
            this.field_178285_m = orientationArray4;
        }

        public static EnumNeighborInfo func_178273_a(EnumFacing enumFacing) {
            return field_178282_n[enumFacing.func_176745_a()];
        }

        static {
            field_178282_n = Util.func_200696_a(new EnumNeighborInfo[6], enumNeighborInfoArray -> {
                enumNeighborInfoArray[EnumFacing.DOWN.func_176745_a()] = DOWN;
                enumNeighborInfoArray[EnumFacing.UP.func_176745_a()] = UP;
                enumNeighborInfoArray[EnumFacing.NORTH.func_176745_a()] = NORTH;
                enumNeighborInfoArray[EnumFacing.SOUTH.func_176745_a()] = SOUTH;
                enumNeighborInfoArray[EnumFacing.WEST.func_176745_a()] = WEST;
                enumNeighborInfoArray[EnumFacing.EAST.func_176745_a()] = EAST;
            });
        }
    }

    public static enum Orientation {
        DOWN(EnumFacing.DOWN, false),
        UP(EnumFacing.UP, false),
        NORTH(EnumFacing.NORTH, false),
        SOUTH(EnumFacing.SOUTH, false),
        WEST(EnumFacing.WEST, false),
        EAST(EnumFacing.EAST, false),
        FLIP_DOWN(EnumFacing.DOWN, true),
        FLIP_UP(EnumFacing.UP, true),
        FLIP_NORTH(EnumFacing.NORTH, true),
        FLIP_SOUTH(EnumFacing.SOUTH, true),
        FLIP_WEST(EnumFacing.WEST, true),
        FLIP_EAST(EnumFacing.EAST, true);

        private final int field_178229_m;

        private Orientation(EnumFacing enumFacing, boolean bl) {
            this.field_178229_m = enumFacing.func_176745_a() + (bl ? EnumFacing.values().length : 0);
        }
    }

    class AmbientOcclusionFace {
        private final float[] field_178206_b = new float[4];
        private final int[] field_178207_c = new int[4];

        public void func_187491_a(IWorldReader iWorldReader, IBlockState iBlockState, BlockPos blockPos, EnumFacing enumFacing, float[] fArray, BitSet bitSet) {
            int \u260318;
            int \u260317;
            int \u260316;
            int \u260315;
            BlockPos blockPos2 = bitSet.get(0) ? blockPos.func_177972_a(enumFacing) : blockPos;
            EnumNeighborInfo \u26032 = EnumNeighborInfo.func_178273_a(enumFacing);
            BlockPos.MutableBlockPos \u26033 = new BlockPos.MutableBlockPos();
            \u26033.func_189533_g(blockPos2).func_189536_c(\u26032.field_178276_g[0]);
            int \u26034 = BlockModelRenderer.func_210264_b(iBlockState, iWorldReader, \u26033);
            float \u26035 = iWorldReader.func_180495_p(\u26033).func_185892_j();
            \u26033.func_189533_g(blockPos2).func_189536_c(\u26032.field_178276_g[1]);
            int \u26036 = BlockModelRenderer.func_210264_b(iBlockState, iWorldReader, \u26033);
            float \u26037 = iWorldReader.func_180495_p(\u26033).func_185892_j();
            \u26033.func_189533_g(blockPos2).func_189536_c(\u26032.field_178276_g[2]);
            int \u26038 = BlockModelRenderer.func_210264_b(iBlockState, iWorldReader, \u26033);
            float \u26039 = iWorldReader.func_180495_p(\u26033).func_185892_j();
            \u26033.func_189533_g(blockPos2).func_189536_c(\u26032.field_178276_g[3]);
            int \u260310 = BlockModelRenderer.func_210264_b(iBlockState, iWorldReader, \u26033);
            float \u260311 = iWorldReader.func_180495_p(\u26033).func_185892_j();
            \u26033.func_189533_g(blockPos2).func_189536_c(\u26032.field_178276_g[0]).func_189536_c(enumFacing);
            boolean \u260312 = iWorldReader.func_180495_p(\u26033).func_200016_a(iWorldReader, \u26033) == 0;
            \u26033.func_189533_g(blockPos2).func_189536_c(\u26032.field_178276_g[1]).func_189536_c(enumFacing);
            boolean \u260313 = iWorldReader.func_180495_p(\u26033).func_200016_a(iWorldReader, \u26033) == 0;
            \u26033.func_189533_g(blockPos2).func_189536_c(\u26032.field_178276_g[2]).func_189536_c(enumFacing);
            boolean \u260314 = iWorldReader.func_180495_p(\u26033).func_200016_a(iWorldReader, \u26033) == 0;
            \u26033.func_189533_g(blockPos2).func_189536_c(\u26032.field_178276_g[3]).func_189536_c(enumFacing);
            boolean bl = \u2603 = iWorldReader.func_180495_p(\u26033).func_200016_a(iWorldReader, \u26033) == 0;
            if (\u260314 || \u260312) {
                \u26033.func_189533_g(blockPos2).func_189536_c(\u26032.field_178276_g[0]).func_189536_c(\u26032.field_178276_g[2]);
                float f = iWorldReader.func_180495_p(\u26033).func_185892_j();
                \u260315 = BlockModelRenderer.func_210264_b(iBlockState, iWorldReader, \u26033);
            } else {
                f = \u26035;
                \u260315 = \u26034;
            }
            if (\u2603 || \u260312) {
                \u26033.func_189533_g(blockPos2).func_189536_c(\u26032.field_178276_g[0]).func_189536_c(\u26032.field_178276_g[3]);
                f = iWorldReader.func_180495_p(\u26033).func_185892_j();
                \u260316 = BlockModelRenderer.func_210264_b(iBlockState, iWorldReader, \u26033);
            } else {
                f = \u26035;
                \u260316 = \u26034;
            }
            if (\u260314 || \u260313) {
                \u26033.func_189533_g(blockPos2).func_189536_c(\u26032.field_178276_g[1]).func_189536_c(\u26032.field_178276_g[2]);
                \u2603 = iWorldReader.func_180495_p(\u26033).func_185892_j();
                \u260317 = BlockModelRenderer.func_210264_b(iBlockState, iWorldReader, \u26033);
            } else {
                \u2603 = \u26037;
                \u260317 = \u26036;
            }
            if (\u2603 || \u260313) {
                \u26033.func_189533_g(blockPos2).func_189536_c(\u26032.field_178276_g[1]).func_189536_c(\u26032.field_178276_g[3]);
                \u2603 = iWorldReader.func_180495_p(\u26033).func_185892_j();
                \u260318 = BlockModelRenderer.func_210264_b(iBlockState, iWorldReader, \u26033);
            } else {
                \u2603 = \u26037;
                \u260318 = \u26036;
            }
            int n = BlockModelRenderer.func_210264_b(iBlockState, iWorldReader, blockPos);
            \u26033.func_189533_g(blockPos).func_189536_c(enumFacing);
            if (bitSet.get(0) || !iWorldReader.func_180495_p(\u26033).func_200015_d(iWorldReader, \u26033)) {
                n = BlockModelRenderer.func_210264_b(iBlockState, iWorldReader, \u26033);
            }
            float \u260319 = bitSet.get(0) ? iWorldReader.func_180495_p(blockPos2).func_185892_j() : iWorldReader.func_180495_p(blockPos).func_185892_j();
            VertexTranslations \u260320 = VertexTranslations.func_178184_a(enumFacing);
            if (!bitSet.get(1) || !\u26032.field_178289_i) {
                float f = (\u260311 + \u26035 + f + \u260319) * 0.25f;
                \u2603 = (\u26039 + \u26035 + f + \u260319) * 0.25f;
                \u2603 = (\u26039 + \u26037 + \u2603 + \u260319) * 0.25f;
                \u2603 = (\u260311 + \u26037 + \u2603 + \u260319) * 0.25f;
                this.field_178207_c[((VertexTranslations)\u260320).field_178191_g] = this.func_147778_a(\u260310, \u26034, \u260316, n);
                this.field_178207_c[((VertexTranslations)\u260320).field_178200_h] = this.func_147778_a(\u26038, \u26034, \u260315, n);
                this.field_178207_c[((VertexTranslations)\u260320).field_178201_i] = this.func_147778_a(\u26038, \u26036, \u260317, n);
                this.field_178207_c[((VertexTranslations)\u260320).field_178198_j] = this.func_147778_a(\u260310, \u26036, \u260318, n);
                this.field_178206_b[((VertexTranslations)\u260320).field_178191_g] = f;
                this.field_178206_b[((VertexTranslations)\u260320).field_178200_h] = \u2603;
                this.field_178206_b[((VertexTranslations)\u260320).field_178201_i] = \u2603;
                this.field_178206_b[((VertexTranslations)\u260320).field_178198_j] = \u2603;
            } else {
                float f;
                \u2603 = (\u260311 + \u26035 + f + \u260319) * 0.25f;
                \u2603 = (\u26039 + \u26035 + f + \u260319) * 0.25f;
                \u2603 = (\u26039 + \u26037 + \u2603 + \u260319) * 0.25f;
                \u2603 = (\u260311 + \u26037 + \u2603 + \u260319) * 0.25f;
                \u2603 = fArray[\u26032.field_178286_j[0].field_178229_m] * fArray[\u26032.field_178286_j[1].field_178229_m];
                \u2603 = fArray[\u26032.field_178286_j[2].field_178229_m] * fArray[\u26032.field_178286_j[3].field_178229_m];
                \u2603 = fArray[\u26032.field_178286_j[4].field_178229_m] * fArray[\u26032.field_178286_j[5].field_178229_m];
                \u2603 = fArray[\u26032.field_178286_j[6].field_178229_m] * fArray[\u26032.field_178286_j[7].field_178229_m];
                \u2603 = fArray[\u26032.field_178287_k[0].field_178229_m] * fArray[\u26032.field_178287_k[1].field_178229_m];
                \u2603 = fArray[\u26032.field_178287_k[2].field_178229_m] * fArray[\u26032.field_178287_k[3].field_178229_m];
                \u2603 = fArray[\u26032.field_178287_k[4].field_178229_m] * fArray[\u26032.field_178287_k[5].field_178229_m];
                \u2603 = fArray[\u26032.field_178287_k[6].field_178229_m] * fArray[\u26032.field_178287_k[7].field_178229_m];
                \u2603 = fArray[\u26032.field_178284_l[0].field_178229_m] * fArray[\u26032.field_178284_l[1].field_178229_m];
                \u2603 = fArray[\u26032.field_178284_l[2].field_178229_m] * fArray[\u26032.field_178284_l[3].field_178229_m];
                \u2603 = fArray[\u26032.field_178284_l[4].field_178229_m] * fArray[\u26032.field_178284_l[5].field_178229_m];
                \u2603 = fArray[\u26032.field_178284_l[6].field_178229_m] * fArray[\u26032.field_178284_l[7].field_178229_m];
                \u2603 = fArray[\u26032.field_178285_m[0].field_178229_m] * fArray[\u26032.field_178285_m[1].field_178229_m];
                \u2603 = fArray[\u26032.field_178285_m[2].field_178229_m] * fArray[\u26032.field_178285_m[3].field_178229_m];
                \u2603 = fArray[\u26032.field_178285_m[4].field_178229_m] * fArray[\u26032.field_178285_m[5].field_178229_m];
                \u2603 = fArray[\u26032.field_178285_m[6].field_178229_m] * fArray[\u26032.field_178285_m[7].field_178229_m];
                this.field_178206_b[((VertexTranslations)\u260320).field_178191_g] = \u2603 * \u2603 + \u2603 * \u2603 + \u2603 * \u2603 + \u2603 * \u2603;
                this.field_178206_b[((VertexTranslations)\u260320).field_178200_h] = \u2603 * \u2603 + \u2603 * \u2603 + \u2603 * \u2603 + \u2603 * \u2603;
                this.field_178206_b[((VertexTranslations)\u260320).field_178201_i] = \u2603 * \u2603 + \u2603 * \u2603 + \u2603 * \u2603 + \u2603 * \u2603;
                this.field_178206_b[((VertexTranslations)\u260320).field_178198_j] = \u2603 * \u2603 + \u2603 * \u2603 + \u2603 * \u2603 + \u2603 * \u2603;
                int \u260321 = this.func_147778_a(\u260310, \u26034, \u260316, n);
                int \u260322 = this.func_147778_a(\u26038, \u26034, \u260315, n);
                int \u260323 = this.func_147778_a(\u26038, \u26036, \u260317, n);
                int \u260324 = this.func_147778_a(\u260310, \u26036, \u260318, n);
                this.field_178207_c[((VertexTranslations)\u260320).field_178191_g] = this.func_178203_a(\u260321, \u260322, \u260323, \u260324, \u2603, \u2603, \u2603, \u2603);
                this.field_178207_c[((VertexTranslations)\u260320).field_178200_h] = this.func_178203_a(\u260321, \u260322, \u260323, \u260324, \u2603, \u2603, \u2603, \u2603);
                this.field_178207_c[((VertexTranslations)\u260320).field_178201_i] = this.func_178203_a(\u260321, \u260322, \u260323, \u260324, \u2603, \u2603, \u2603, \u2603);
                this.field_178207_c[((VertexTranslations)\u260320).field_178198_j] = this.func_178203_a(\u260321, \u260322, \u260323, \u260324, \u2603, \u2603, \u2603, \u2603);
            }
        }

        private int func_147778_a(int n, int n2, int n3, int n4) {
            if (n == 0) {
                n = n4;
            }
            if (n2 == 0) {
                n2 = n4;
            }
            if (n3 == 0) {
                n3 = n4;
            }
            return n + n2 + n3 + n4 >> 2 & 0xFF00FF;
        }

        private int func_178203_a(int n, int n2, int n3, int n4, float f, float f2, float f3, float f4) {
            int n5 = (int)((float)(n >> 16 & 0xFF) * f + (float)(n2 >> 16 & 0xFF) * f2 + (float)(n3 >> 16 & 0xFF) * f3 + (float)(n4 >> 16 & 0xFF) * f4) & 0xFF;
            \u2603 = (int)((float)(n & 0xFF) * f + (float)(n2 & 0xFF) * f2 + (float)(n3 & 0xFF) * f3 + (float)(n4 & 0xFF) * f4) & 0xFF;
            return n5 << 16 | \u2603;
        }
    }

    static enum VertexTranslations {
        DOWN(0, 1, 2, 3),
        UP(2, 3, 0, 1),
        NORTH(3, 0, 1, 2),
        SOUTH(0, 1, 2, 3),
        WEST(3, 0, 1, 2),
        EAST(1, 2, 3, 0);

        private final int field_178191_g;
        private final int field_178200_h;
        private final int field_178201_i;
        private final int field_178198_j;
        private static final VertexTranslations[] field_178199_k;

        private VertexTranslations(int n2, int n3, int n4, int n5) {
            this.field_178191_g = n2;
            this.field_178200_h = n3;
            this.field_178201_i = n4;
            this.field_178198_j = n5;
        }

        public static VertexTranslations func_178184_a(EnumFacing enumFacing) {
            return field_178199_k[enumFacing.func_176745_a()];
        }

        static {
            field_178199_k = Util.func_200696_a(new VertexTranslations[6], vertexTranslationsArray -> {
                vertexTranslationsArray[EnumFacing.DOWN.func_176745_a()] = DOWN;
                vertexTranslationsArray[EnumFacing.UP.func_176745_a()] = UP;
                vertexTranslationsArray[EnumFacing.NORTH.func_176745_a()] = NORTH;
                vertexTranslationsArray[EnumFacing.SOUTH.func_176745_a()] = SOUTH;
                vertexTranslationsArray[EnumFacing.WEST.func_176745_a()] = WEST;
                vertexTranslationsArray[EnumFacing.EAST.func_176745_a()] = EAST;
            });
        }
    }
}

